/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.xfer;

import java.io.IOException;
import net.schmizz.sshj.common.StreamCopier;
import net.schmizz.sshj.xfer.TransferListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingTransferListener
implements TransferListener {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String relPath;

    public LoggingTransferListener() {
        this("");
    }

    private LoggingTransferListener(String relPath) {
        this.relPath = relPath;
    }

    @Override
    public TransferListener directory(String name) {
        this.log.debug("started transferring directory `{}`", (Object)name);
        return new LoggingTransferListener(String.valueOf(this.relPath) + name + "/");
    }

    @Override
    public StreamCopier.Listener file(String name, final long size) {
        final String path = String.valueOf(this.relPath) + name;
        this.log.debug("started transferring file `{}` ({} bytes)", (Object)path, (Object)size);
        return new StreamCopier.Listener(){

            @Override
            public void reportProgress(long transferred) throws IOException {
                if (LoggingTransferListener.this.log.isTraceEnabled()) {
                    LoggingTransferListener.this.log.trace("transferred {}% of `{}`", (Object)(transferred * 100L / size), (Object)path);
                }
            }
        };
    }
}

