/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.sftp;

import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.sftp.FileAttributes;
import net.schmizz.sshj.sftp.PacketType;
import net.schmizz.sshj.sftp.SFTPException;

public class SFTPPacket<T extends SFTPPacket<T>>
extends Buffer<T> {
    public SFTPPacket() {
    }

    public SFTPPacket(Buffer<T> buf) {
        super(buf);
    }

    public SFTPPacket(PacketType pt) {
        this.putByte(pt.toByte());
    }

    public FileAttributes readFileAttributes() throws SFTPException {
        FileAttributes.Builder builder = new FileAttributes.Builder();
        try {
            int mask = this.readUInt32AsInt();
            if (FileAttributes.Flag.SIZE.isSet(mask)) {
                builder.withSize(this.readUInt64());
            }
            if (FileAttributes.Flag.UIDGID.isSet(mask)) {
                builder.withUIDGID(this.readUInt32AsInt(), this.readUInt32AsInt());
            }
            if (FileAttributes.Flag.MODE.isSet(mask)) {
                builder.withPermissions(this.readUInt32AsInt());
            }
            if (FileAttributes.Flag.ACMODTIME.isSet(mask)) {
                builder.withAtimeMtime(this.readUInt32AsInt(), this.readUInt32AsInt());
            }
            if (FileAttributes.Flag.EXTENDED.isSet(mask)) {
                int extCount = this.readUInt32AsInt();
                int i = 0;
                while (i < extCount) {
                    builder.withExtended(this.readString(), this.readString());
                    ++i;
                }
            }
        }
        catch (Buffer.BufferException be) {
            throw new SFTPException(be);
        }
        return builder.build();
    }

    public PacketType readType() throws SFTPException {
        try {
            return PacketType.fromByte(this.readByte());
        }
        catch (Buffer.BufferException be) {
            throw new SFTPException(be);
        }
    }

    public T putFileAttributes(FileAttributes fa) {
        return (T)((SFTPPacket)this.putRawBytes(fa.toBytes()));
    }

    public T putType(PacketType type) {
        return (T)((SFTPPacket)this.putByte(type.toByte()));
    }
}

