/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.common;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import net.schmizz.sshj.common.StreamCopier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOUtils {
    private static final Logger LOG = LoggerFactory.getLogger(IOUtils.class);
    public static final Charset UTF8 = Charset.forName("UTF-8");

    public static void closeQuietly(Closeable ... closeables) {
        Closeable[] closeableArray = closeables;
        int n = closeables.length;
        int n2 = 0;
        while (n2 < n) {
            Closeable c = closeableArray[n2];
            try {
                if (c != null) {
                    c.close();
                }
            }
            catch (IOException logged) {
                LOG.warn("Error closing {} - {}", (Object)c, (Object)logged);
            }
            ++n2;
        }
    }

    public static ByteArrayOutputStream readFully(InputStream stream) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        new StreamCopier(stream, baos).copy();
        return baos;
    }
}

