/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.updphotos;

import com.geolocsystems.deepcopyutil.DeepCopy;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.Situation;
import com.geolocsystems.prismcentral.DAO.DAOFactory;
import com.geolocsystems.prismcentral.DAO.DAOUtil;
import com.geolocsystems.prismcentral.DAO.exception.DAOException;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.geolocsystems.prismcentral.service.BusinessServiceDAO;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import com.geolocsystems.updphotos.TextUi;
import com.google.common.hash.Hashing;
import gls.outils.GLSDate;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;

public class PhotoToDatabase {
    private boolean deletePhotos = false;
    private List<File> photosASupprimer = new ArrayList<File>();
    private static GregorianCalendar gc;
    private static GregorianCalendar gcEnd;
    private static int cpt;
    private static boolean isDateFin;
    private IBusinessService serv;

    static {
        cpt = 0;
        isDateFin = false;
    }

    public static void main(String[] args) throws IOException {
        gc = new GregorianCalendar();
        gc.set(2012, 0, 1, 0, 0, 0);
        gcEnd = new GregorianCalendar();
        if (args != null && args.length > 0) {
            gc.setTime(GLSDate.toDate((String)args[0], (DateFormat)GLSDate.formatDateJour).getTime());
            if (args.length > 1) {
                gcEnd = new GregorianCalendar();
                gcEnd.setTime(GLSDate.toDate((String)args[1], (DateFormat)GLSDate.formatDateJour).getTime());
                isDateFin = true;
            }
        }
        System.out.println("date d\u00e9marrage : " + GLSDate.toDate((Date)gc.getTime(), (DateFormat)GLSDate.formatDateComplete));
        System.out.println("date de fin : " + GLSDate.toDate((Date)gcEnd.getTime(), (DateFormat)GLSDate.formatDateComplete));
        TextUi ui = new TextUi();
        ui.printTitle("P\u00e9riode \u00e0 traiter.");
        if (!ui.askBoolean("C'est OK ?", false).booleanValue()) {
            System.out.println("Aucun traitement effectu\u00e9");
        } else {
            long tref = System.currentTimeMillis();
            new PhotoToDatabase().run();
            long t = System.currentTimeMillis() - tref;
            System.out.println("nb evt = " + cpt);
            System.out.println("Termin\u00e9 en " + t + "ms.");
        }
    }

    public void run() throws IOException {
        this.deletePhotos = Boolean.parseBoolean(ConfigurationFactory.getInstance().get("photos.delete", false));
        System.out.println("delete photos = " + this.deletePhotos);
        this.serv = new BusinessServiceDAO();
        IBusinessService.EvenementFiltre filtre = IBusinessService.EvenementFiltre.byDelegation(null, null);
        filtre.termines = -1;
        filtre.etat = -1;
        filtre.avecPhotos = true;
        if (isDateFin) {
            filtre.dateMin = filtre.dateMax = new Timestamp(gc.getTimeInMillis());
            gc.add(2, 1);
            filtre.dateMax = new Timestamp(gc.getTimeInMillis());
        } else {
            filtre.dateMin = null;
            filtre.dateMax = new Timestamp(gc.getTimeInMillis());
        }
        filtre.filtreSurDateSta = true;
        while (gc.getTime().before(gcEnd.getTime()) || gc.getTime().equals(gcEnd.getTime())) {
            if (filtre.dateMin == null) {
                System.out.println("date < " + GLSDate.toDate((Date)filtre.dateMax, (DateFormat)GLSDate.formatDateComplete));
            } else {
                System.out.println(String.valueOf(GLSDate.toDate((Date)filtre.dateMin, (DateFormat)GLSDate.formatDateComplete)) + " < date < " + GLSDate.toDate((Date)filtre.dateMax, (DateFormat)GLSDate.formatDateComplete));
            }
            this.traiterUnMois(filtre);
            filtre.dateMin = filtre.dateMax;
            gc.add(2, 1);
            filtre.dateMax = new Timestamp(gc.getTimeInMillis());
        }
    }

    private void traiterUnMois(IBusinessService.EvenementFiltre filtre) throws IOException {
        ArrayList situations = new ArrayList();
        IBusinessService.EvenementFiltre filtreSituation = (IBusinessService.EvenementFiltre)DeepCopy.copy((Object)filtre);
        filtreSituation.dateMin = null;
        filtreSituation.dateMax = null;
        filtreSituation.etat = -1;
        filtreSituation.photos = true;
        filtre.etat = 1;
        filtre.photos = false;
        List situationsEncours = this.serv.getEvenements(filtre, null);
        for (Situation situation : situationsEncours) {
            filtreSituation.sid = situation.getSid();
            situations.addAll(this.serv.getEvenements(filtreSituation, null));
        }
        Iterator iterator = situations.iterator();
        while (iterator.hasNext()) {
            ArrayList<File> photosFiles = new ArrayList<File>();
            Situation situation = (Situation)iterator.next();
            for (Evenement e : situation.getEvenements()) {
                photosFiles.addAll(this.traiterEvenement(e));
                ++cpt;
            }
            if (!this.deletePhotos) continue;
            this.deletePhotosEvenement(photosFiles);
        }
    }

    private List<File> traiterEvenement(Evenement e) throws IOException {
        ArrayList<String> hashes = new ArrayList<String>();
        ArrayList<File> photosFiles = new ArrayList<File>();
        if (e.getPhotos() != null && e.getPhotos().size() > 0) {
            File globalDir = new File(ConfigurationFactory.getInstance().get("photo.repertoire"));
            File situationDir = new File(globalDir, e.getIdSituation());
            File evtDir = new File(situationDir, e.getIdReference());
            System.out.println("dir = " + evtDir.getPath());
            if (!evtDir.exists()) {
                System.out.println(String.valueOf(evtDir.getPath()) + " n'existe pas ! Evenement non modifi\u00e9");
                return photosFiles;
            }
            for (String photoname : e.getPhotos()) {
                File photoFile = new File(evtDir, photoname);
                if (!photoFile.exists()) {
                    System.out.println("la photo " + photoFile.getPath() + " n'existe pas, elle sera abandonn\u00e9e !");
                    continue;
                }
                byte[] data = Files.readAllBytes(photoFile.toPath());
                String hash = Hashing.md5().hashBytes(data).toString();
                this.serv.sauvegarderPhoto(hash, data);
                hashes.add(hash);
                photosFiles.add(photoFile);
            }
            photosFiles.add(evtDir);
            photosFiles.add(situationDir);
            if (hashes.size() > 0) {
                this.updatePhotosEvenement(e.getkEventid(), hashes);
            } else {
                System.out.println(String.valueOf(evtDir.getPath()) + " aucune photo \u00e0 traiter ! Evenement non modifi\u00e9");
            }
        }
        return photosFiles;
    }

    private void updatePhotosEvenement(int kEventid, List hashes) {
        System.out.println("Mise \u00e0 jour de " + kEventid);
        System.out.println("Photos : " + hashes.toString());
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = DAOFactory.getInstance().getConnection();
                pstm = connection.prepareStatement("UPDATE prism.evenement SET photos=? WHERE k_eventid=?");
                pstm.setArray(1, connection.createArrayOf("text", hashes.toArray(new String[0])));
                pstm.setInt(2, kEventid);
                pstm.execute();
            }
            catch (SQLException e) {
                throw new DAOException((Throwable)e);
            }
            catch (Exception e) {
                throw e;
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close((Connection)connection, pstm);
            throw throwable;
        }
        DAOUtil.close((Connection)connection, (Statement)pstm);
    }

    private void deletePhotosEvenement(List<File> photos) {
        for (File photo : photos) {
            if (!photo.exists()) continue;
            if (photo.isDirectory()) {
                try {
                    photo.delete();
                    System.out.println("Suppression du r\u00e9pertoire : " + photo.getName());
                }
                catch (Exception e) {
                    System.out.println("Suppression impossible du r\u00e9pertoire : " + photo.getName());
                }
                continue;
            }
            try {
                System.out.println("Suppression de la photo : " + photo.getName());
                photo.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

