/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismbatch;

import com.geolocsystems.prismbatch.BusinessServiceFactory;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.beans.IFileAttachment;
import com.geolocsystems.prismcentral.mail.Mail;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import com.geolocsystems.prismcentralvaadin.config.IConfiguration;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class ServiceTransmissionTipi {
    public static void main(String[] args) {
        Date iterationCourante = GregorianCalendar.getInstance().getTime();
        Log.info((Object)("Lancement \u00e0 " + iterationCourante));
        boolean selectionBarreauxParDelegation = false;
        boolean force = false;
        try {
            selectionBarreauxParDelegation = ConfigurationFactory.getInstance().getBoolean("vh.barreauxvh.exporttipi.delegation", false);
        }
        catch (Exception e) {
            selectionBarreauxParDelegation = false;
        }
        try {
            force = ConfigurationFactory.getInstance().getBoolean("vh.barreauxvh.exporttipi.force", false);
        }
        catch (Exception e) {
            force = false;
        }
        try {
            if (!BusinessServiceFactory.getBusinessService().transmettreBarreauxSerpeVH(selectionBarreauxParDelegation, force)) {
                ServiceTransmissionTipi.envoiMail("BATCH ServiceTransmissionTipi : Erreur envoi \u00e0 TIPI VH");
            }
        }
        catch (Throwable t) {
            Log.error((Object)"Erreur de lancement de la transmission des barreaux tipi", (Throwable)t);
            ServiceTransmissionTipi.envoiMail("BATCH ServiceTransmissionTipi : Erreur envoi \u00e0 TIPI VH");
        }
    }

    public static void envoiMail(String error) {
        try {
            String mailAdmin = null;
            String zoneRoutiere = "inconnu";
            try {
                zoneRoutiere = ConfigurationFactory.getInstance().get("zoneroutiere");
            }
            catch (Exception e) {
                Log.error((Object)"Erreur lors de la r\u00e9cup\u00e9ration de la zone routiere", (Throwable)e);
            }
            try {
                mailAdmin = ConfigurationFactory.getInstance().get("mail.admin", true);
            }
            catch (Exception e) {
                Log.error((Object)"Cl\u00e9 non trouv\u00e9e :mail.admin", (Throwable)e);
                mailAdmin = "thierry.daguinos@neogls.com,frederic.lambard@neogls.com";
            }
            try {
                Mail mail = new Mail(mailAdmin, "Erreur Batch : " + zoneRoutiere, String.valueOf(zoneRoutiere) + " -- " + error);
                ServiceTransmissionTipi.doSendMail(mail);
            }
            catch (Throwable e) {
                Log.error((Object)("Erreur dans l'envoi a " + mailAdmin), (Throwable)e);
            }
        }
        catch (Throwable e) {
            Log.error((Object)"Erreur de d\u00e9amrrage envoi mail", (Throwable)e);
        }
    }

    private static void doSendMail(Mail o) {
        try {
            IConfiguration config = ConfigurationFactory.getInstance();
            final String username = config.get("mail.smtp.username");
            final String password = config.get("mail.smtp.password");
            Properties props = new Properties();
            props.put("mail.smtp.auth", config.get("mail.smtp.auth"));
            props.put("mail.smtp.starttls.enable", config.get("mail.smtp.starttls.enable"));
            props.put("mail.smtp.ssl.trust", config.get("mail.smtp.ssl.trust"));
            props.put("mail.smtp.ssl.enable", config.get("mail.smtp.ssl"));
            props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            props.put("mail.smtp.host", config.get("mail.smtp.host"));
            props.put("mail.smtp.port", config.get("mail.smtp.port"));
            Session session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(username, password);
                }
            });
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(config.get("mail.smtp.from")));
            message.setSender((Address)new InternetAddress(config.get("mail.smtp.from")));
            message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)o.getTo()));
            message.setSubject(o.getObject(), "utf-8");
            message.setHeader("Content-Type", "text/plain; charset=UTF-8");
            MimeBodyPart body = new MimeBodyPart();
            body.setContent((Object)o.getBody(), "text/html; charset=utf-8");
            MimeMultipart mp = new MimeMultipart();
            mp.addBodyPart((BodyPart)body);
            for (IFileAttachment attachment : o.getAttachments()) {
                MimeBodyPart part = new MimeBodyPart();
                part.setDataHandler(new DataHandler((DataSource)new FileDataSource(attachment.getFile())));
                part.setFileName(attachment.getFileName());
                mp.addBodyPart((BodyPart)part);
            }
            message.setContent((Multipart)mp);
            Transport transport = session.getTransport("smtp");
            transport.connect(config.get("mail.smtp.host"), username, password);
            transport.sendMessage((Message)message, message.getAllRecipients());
            transport.close();
        }
        catch (Throwable t) {
            Log.error((Object)"Erreur envoi mail", (Throwable)t);
            throw new RuntimeException(t);
        }
    }
}

