/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismbatch;

import com.geolocsystems.prism.webservices.datex2.client.ClientServices;
import com.geolocsystems.prism.webservices.datex2.exception.ClientPullException;
import com.geolocsystems.prism.webservices.datex2.exception.ClientPushException;
import com.geolocsystems.prism.webservices.datex2.fournisseur.FournisseurServices;
import com.geolocsystems.prismandroid.model.MainCourante;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.Situation;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampLocalisation;
import com.geolocsystems.prismbatch.BusinessServiceFactory;
import com.geolocsystems.prismcentral.beans.ClientVO;
import com.geolocsystems.prismcentral.beans.CorrespondanceDatex2;
import com.geolocsystems.prismcentral.beans.FournisseurVO;
import com.geolocsystems.prismcentral.beans.LocalisationPr;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.geolocsystems.prismcentral.data.IDatex2Service;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import com.geolocsystems.prismcentralvaadin.config.IConfiguration;
import gls.geometry.Geometry;
import gls.localisation.Localisation;
import gls.outils.GLS;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ServiceSynchronisationDatex2 {
    private static final Logger log = Logger.getLogger(ServiceSynchronisationDatex2.class);
    private static IConfiguration myConfig;
    private static IDatex2Service metierDatex2;
    private static MainCourante mc;

    static {
        mc = null;
    }

    public void renseignerLocalisation(ValeurChampLocalisation locEvt, Localisation localisation) {
        if (localisation != null && localisation.estInitialisee() && localisation.estPositionnee()) {
            locEvt.setLongueur((int)localisation.getLongueur());
            locEvt.setX(new float[]{(float)localisation.getPoint().getX()});
            locEvt.setY(new float[]{(float)localisation.getPoint().getY()});
            if (localisation.getPrDebut() != null) {
                locEvt.setDeptDebut(String.valueOf(localisation.getPrDebut().getDepartement()));
                locEvt.setPrDebut(localisation.getPrDebut().getPr());
                locEvt.setAbsPrDebut((int)localisation.getPrDebut().getDistancePr());
            } else {
                locEvt.setDeptDebut(null);
                locEvt.setPrDebut(-1);
                locEvt.setAbsPrDebut(-1);
            }
            if (localisation.getPrFin() != null) {
                locEvt.setDeptFin(String.valueOf(localisation.getPrFin().getDepartement()));
                locEvt.setPrFin(localisation.getPrFin().getPr());
                locEvt.setAbsPrFin((int)localisation.getPrFin().getDistancePr());
            } else {
                locEvt.setDeptFin(null);
                locEvt.setPrFin(-1);
                locEvt.setAbsPrFin(-1);
            }
            try {
                if (locEvt.getSensPr() <= 0) {
                    locEvt.setSensPr(localisation.getSens().getSensEvenement());
                }
            }
            catch (Exception e) {
                log.error((Object)"ERREUR SENS EVENEMENT", (Throwable)e);
            }
            float[][] listePoints = Geometry.toFloatLL((Vector)localisation.getListePoints());
            locEvt.setX(listePoints[0]);
            locEvt.setY(listePoints[1]);
            locEvt.setAxe(localisation.getRoute());
            locEvt.setCommune(localisation.getCommune());
        } else {
            locEvt.setX(null);
            locEvt.setX(null);
        }
    }

    public void calculerLocalisationPr(Evenement evenement) {
        ValeurChampLocalisation locEvt = evenement.getValeurNature().getLocalisation();
        String axe = locEvt.getAxe();
        if (!GLS.estVide((String)axe) && axe.length() > 0) {
            if (GLS.estNumerique((char)axe.charAt(0))) {
                axe = "D" + axe;
                locEvt.setAxe(axe);
            } else if (axe.charAt(0) == 'd') {
                axe = "D" + axe.substring(1);
                locEvt.setAxe(axe);
            }
        }
        LocalisationPr prDebut = new LocalisationPr(axe, locEvt.getPrDebut(), locEvt.getAbsPrDebut());
        LocalisationPr prFin = new LocalisationPr(axe, locEvt.getPrFin(), locEvt.getAbsPrFin());
        try {
            log.debug((Object)("LOC PR " + axe + " -- " + prDebut + " -- " + prFin));
            BusinessServiceFactory.getCartoService().setPrDebut(locEvt, prDebut);
            BusinessServiceFactory.getCartoService().setPrFin(locEvt, prFin);
        }
        catch (Exception e) {
            log.debug((Object)("Localisation PR impossible " + evenement.getIdReference()), (Throwable)e);
            locEvt.setX(null);
            locEvt.setY(null);
        }
    }

    public void calculerLocalisation(Evenement evenement) {
        this.calculerLocalisationPr(evenement);
    }

    public void lancerSynchronisationPull(ClientVO client, Map<String, CorrespondanceDatex2> corresDatex2) {
        try {
            ClientServices clientSer = new ClientServices(client);
            clientSer.initialisationConvertisseur(corresDatex2);
            throw new Exception();
        }
        catch (ClientPullException cpe) {
            log.error((Object)("Erreur lors de la r\u00e9ception en Pull pour " + client.getIdentifiant()), (Throwable)cpe);
        }
        catch (Exception e) {
            log.error((Object)("Erreur lors de la synchronisation Pull pour " + client.getIdentifiant()), (Throwable)e);
        }
    }

    public void lancerSynchronisationPush(FournisseurVO fournisseur, Map<String, CorrespondanceDatex2> corresDatex2) {
        try {
            IBusinessService service = BusinessServiceFactory.getBusinessService();
            IBusinessService.EvenementFiltre filtreSql = IBusinessService.EvenementFiltre.getVersionActive(null, null);
            try {
                IConfiguration myConfig = ConfigurationFactory.getInstance();
                filtreSql.delegation = myConfig.get("datex2.district");
            }
            catch (Exception myConfig) {
                // empty catch block
            }
            List listeSituations = service.getEvenementsASynchroniserDatex2(filtreSql, null);
            if (listeSituations.size() > 0) {
                FournisseurServices fourSer = new FournisseurServices(fournisseur);
                fourSer.initialisationConvertisseur(corresDatex2);
                ArrayList<Evenement> arrayListEvenements = new ArrayList<Evenement>();
                for (Situation situation : listeSituations) {
                    arrayListEvenements.addAll(situation.getEvenements());
                }
                if (log.isInfoEnabled()) {
                    fourSer.convertEvenements(arrayListEvenements);
                }
                fourSer.pushEvenements(arrayListEvenements);
                ArrayList<Integer> listeEvts = new ArrayList<Integer>();
                for (Evenement evt : arrayListEvenements) {
                    listeEvts.add(evt.getkEventid());
                }
                metierDatex2.deleteListeEvtsASynchroniser(listeEvts);
            }
            metierDatex2.deleteListeEvtsASynchroniserInactif();
        }
        catch (ClientPushException cpe) {
            log.error((Object)("Erreur lors de l'envoi en Push pour " + fournisseur.getIdentifiant()), (Throwable)cpe);
        }
        catch (Exception e) {
            log.error((Object)("Erreur lors de la synchronisation Push pour " + fournisseur.getIdentifiant()), (Throwable)e);
        }
    }

    public void lancerSynchronisationPushDegrade(FournisseurVO fournisseur, Map<String, CorrespondanceDatex2> corresDatex2) {
        try {
            IBusinessService service = BusinessServiceFactory.getBusinessService();
            IBusinessService.EvenementFiltre filtreSql = IBusinessService.EvenementFiltre.getVersionActive(null, null);
            List listeSituations = service.getEvenementsASynchroniserDatex2(filtreSql, null);
            if (listeSituations.size() > 0) {
                FournisseurServices fourSer = new FournisseurServices(fournisseur);
                fourSer.initialisationConvertisseur(corresDatex2);
                ArrayList<Evenement> arrayListEvenements = new ArrayList<Evenement>();
                for (Situation situation : listeSituations) {
                    arrayListEvenements.addAll(situation.getEvenements());
                }
                ArrayList<Evenement> listeEvenementsPcrd = new ArrayList<Evenement>();
                for (Evenement evt : arrayListEvenements) {
                    if (evt.getIdReference().toLowerCase().indexOf("pcrd") < 0) continue;
                    listeEvenementsPcrd.add(evt);
                }
                if (listeEvenementsPcrd.size() > 0) {
                    arrayListEvenements = new ArrayList(listeEvenementsPcrd);
                    if (log.isInfoEnabled()) {
                        fourSer.convertEvenements(arrayListEvenements);
                    }
                    fourSer.pushEvenements(arrayListEvenements);
                }
                ArrayList<Integer> listeEvts = new ArrayList<Integer>();
                for (Evenement evt : arrayListEvenements) {
                    listeEvts.add(evt.getkEventid());
                }
                metierDatex2.deleteListeEvtsASynchroniser(listeEvts);
            }
        }
        catch (ClientPushException cpe) {
            log.error((Object)("Erreur lors de l'envoi en Push pour " + fournisseur.getIdentifiant()), (Throwable)cpe);
        }
        catch (Exception e) {
            log.error((Object)("Erreur lors de la synchronisation Push pour " + fournisseur.getIdentifiant()), (Throwable)e);
        }
    }

    private boolean estTempoOk(long dateDerniereSynchro, Calendar maintenant, long tempoScrutation) {
        return dateDerniereSynchro + tempoScrutation * 1000L < maintenant.getTimeInMillis();
    }

    public int lancer() {
        String zone;
        try {
            zone = myConfig.get("zoneroutiere");
        }
        catch (Exception e) {
            log.error((Object)"Erreur plors de la r\u00e9cup\u00e9ration de la zone routiere", (Throwable)e);
            return 1;
        }
        if (GLS.estVide((String)zone)) {
            log.error((Object)"Zone routi\u00e8re vide");
            return 0;
        }
        Object dateDerniereSynchro = null;
        Calendar maintenant = GregorianCalendar.getInstance();
        List fournisseurs = null;
        List clients = null;
        Map corresDatex2 = null;
        Map corresPrism = null;
        metierDatex2 = BusinessServiceFactory.getDatex2Service();
        try {
            fournisseurs = metierDatex2.getFournisseurs(zone);
        }
        catch (Exception e) {
            log.error((Object)"Erreur lors de la lecture des fournisseurs", (Throwable)e);
            return 1;
        }
        try {
            clients = metierDatex2.getClients(zone);
        }
        catch (Exception e) {
            log.error((Object)"Erreur lors de la lecture des clients", (Throwable)e);
            return 1;
        }
        try {
            corresDatex2 = metierDatex2.getMapDescriptionPrismDatex2(zone);
        }
        catch (Exception e) {
            log.error((Object)"Erreur lors de la lecture de la table de correspondance Datex2", (Throwable)e);
            return 1;
        }
        try {
            corresPrism = metierDatex2.getMapDescriptionDatex2Prism(zone);
        }
        catch (Exception e) {
            log.error((Object)"Erreur lors de la lecture de la table de correspondance Datex2", (Throwable)e);
            return 1;
        }
        if (GLS.estVide((List)fournisseurs)) {
            log.info((Object)"Pas de fournisseur Datex2");
        } else {
            log.info((Object)"Synchronisation Push");
            for (FournisseurVO fournisseur : fournisseurs) {
                if (!fournisseur.getEtatClient() || !this.estTempoOk(fournisseur.getDateSynchro(), maintenant, fournisseur.getTempo())) continue;
                this.lancerSynchronisationPush(fournisseur, corresDatex2);
                try {
                    metierDatex2.miseAJourDateSynchro(fournisseur);
                }
                catch (Exception e) {
                    log.error((Object)("Erreur mise \u00e0 jour derni\u00e8re date synchro client " + fournisseur.getIdentifiant() + " - " + fournisseur.getZoneRoutiere()), (Throwable)e);
                }
            }
        }
        if (GLS.estVide((List)clients)) {
            log.info((Object)"Pas de client Datex2");
        } else {
            log.info((Object)"Synchronisation Pull");
            for (ClientVO client : clients) {
                if (!client.getEtatClient() || !this.estTempoOk(client.getDateSynchro(), maintenant, client.getTempo())) continue;
                try {
                    this.lancerSynchronisationPull(client, corresPrism);
                }
                catch (Exception e) {
                    log.error((Object)("Erreur synchro pull " + client.getIdentifiant() + " - " + client.getZoneRoutiere()), (Throwable)e);
                }
                try {
                    metierDatex2.miseAJourDateSynchro(client);
                }
                catch (Exception e) {
                    log.error((Object)("Erreur mise \u00e0 jour derni\u00e8re date synchro client " + client.getIdentifiant() + " - " + client.getZoneRoutiere()), (Throwable)e);
                }
            }
        }
        return 0;
    }

    public ServiceSynchronisationDatex2() {
        try {
            log.info((Object)"Initialisation du fichier de configuration");
            myConfig = ConfigurationFactory.getInstance();
        }
        catch (Exception e) {
            log.error((Object)"ERREUR FICHIER CONFIG ", (Throwable)e);
            myConfig = null;
        }
        if (myConfig == null) {
            log.error((Object)"Erreur dans l'initialisation de la configuration");
            System.exit(1);
        }
    }

    public static void main(String ... strings) {
        log.info((Object)"D\u00e9but Batch");
        ServiceSynchronisationDatex2 service = new ServiceSynchronisationDatex2();
        int codeErreur = service.lancer();
        log.info((Object)"Fin Batch");
        System.exit(codeErreur);
    }
}

