/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismbatch;

import com.geolocsystems.prism.webservices.datex2.exception.ClientPushException;
import com.geolocsystems.prism.webservices.datex2.fournisseur.FournisseurServices;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.Situation;
import com.geolocsystems.prismbatch.BusinessServiceFactory;
import com.geolocsystems.prismcentral.beans.CorrespondanceDatex2;
import com.geolocsystems.prismcentral.beans.FournisseurVO;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.geolocsystems.prismcentral.data.IDatex2Service;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import com.geolocsystems.prismcentralvaadin.config.IConfiguration;
import gls.outils.GLS;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ServicePush {
    private static final Logger log = Logger.getLogger(ServicePush.class);
    private static IConfiguration myConfig;
    private static IDatex2Service metierDatex2;

    public void lancerSynchronisationPush(FournisseurVO fournisseur, Map<String, CorrespondanceDatex2> corresDatex2) {
        String district = null;
        try {
            IConfiguration myConfig = ConfigurationFactory.getInstance();
            district = myConfig.get("datex2.district");
        }
        catch (Exception e) {
            district = null;
        }
        try {
            IBusinessService service = BusinessServiceFactory.getBusinessService();
            IBusinessService.EvenementFiltre filtreSql = IBusinessService.EvenementFiltre.getVersionActive(null, null);
            List listeSituations = service.getEvenementsASynchroniserDatex2(filtreSql, null);
            if (listeSituations.size() > 0) {
                FournisseurServices fourSer = new FournisseurServices(fournisseur);
                fourSer.initialisationConvertisseur(corresDatex2);
                ArrayList<Evenement> arrayListEvenementsInitial = new ArrayList<Evenement>();
                ArrayList<Evenement> arrayListEvenements = new ArrayList<Evenement>();
                for (Situation situation : listeSituations) {
                    for (Evenement evenement : situation.getEvenements()) {
                        if (district != null) {
                            if (district.equals(evenement.getDistrict())) {
                                arrayListEvenements.add(evenement);
                            }
                        } else {
                            arrayListEvenements.add(evenement);
                        }
                        arrayListEvenementsInitial.add(evenement);
                    }
                }
                if (log.isInfoEnabled()) {
                    fourSer.convertEvenements(arrayListEvenements);
                }
                if (arrayListEvenements.size() > 0) {
                    fourSer.pushEvenements(arrayListEvenements);
                }
                ArrayList<Integer> listeEvts = new ArrayList<Integer>();
                for (Evenement evt : arrayListEvenementsInitial) {
                    listeEvts.add(evt.getkEventid());
                }
                metierDatex2.deleteListeEvtsASynchroniser(listeEvts);
                metierDatex2.deleteListeEvtsASynchroniserInactif();
            }
        }
        catch (ClientPushException cpe) {
            log.error((Object)("Erreur lors de l'envoi en Push pour " + fournisseur.getIdentifiant()), (Throwable)cpe);
        }
        catch (Exception e) {
            log.error((Object)("Erreur lors de la synchronisation Push pour " + fournisseur.getIdentifiant()), (Throwable)e);
        }
    }

    public void lancerSynchronisationPushDegrade(FournisseurVO fournisseur, Map<String, CorrespondanceDatex2> corresDatex2) {
        try {
            IBusinessService service = BusinessServiceFactory.getBusinessService();
            IBusinessService.EvenementFiltre filtreSql = IBusinessService.EvenementFiltre.getVersionActive(null, null);
            List listeSituations = service.getEvenementsASynchroniserDatex2(filtreSql, null);
            if (listeSituations.size() > 0) {
                FournisseurServices fourSer = new FournisseurServices(fournisseur);
                fourSer.initialisationConvertisseur(corresDatex2);
                ArrayList<Evenement> arrayListEvenements = new ArrayList<Evenement>();
                for (Situation situation : listeSituations) {
                    arrayListEvenements.addAll(situation.getEvenements());
                }
                ArrayList<Evenement> listeEvenementsPcrd = new ArrayList<Evenement>();
                for (Evenement evt : arrayListEvenements) {
                    if (evt.getIdReference().toLowerCase().indexOf("pcrd") < 0) continue;
                    listeEvenementsPcrd.add(evt);
                }
                if (listeEvenementsPcrd.size() > 0) {
                    arrayListEvenements = new ArrayList(listeEvenementsPcrd);
                    if (log.isInfoEnabled()) {
                        fourSer.convertEvenements(arrayListEvenements);
                    }
                    fourSer.pushEvenements(arrayListEvenements);
                }
                ArrayList<Integer> listeEvts = new ArrayList<Integer>();
                for (Evenement evt : arrayListEvenements) {
                    listeEvts.add(evt.getkEventid());
                }
                metierDatex2.deleteListeEvtsASynchroniser(listeEvts);
            }
        }
        catch (ClientPushException cpe) {
            log.error((Object)("Erreur lors de l'envoi en Push pour " + fournisseur.getIdentifiant()), (Throwable)cpe);
        }
        catch (Exception e) {
            log.error((Object)("Erreur lors de la synchronisation Push pour " + fournisseur.getIdentifiant()), (Throwable)e);
        }
    }

    private boolean estTempoOk(long dateDerniereSynchro, Calendar maintenant, long tempoScrutation) {
        return dateDerniereSynchro + tempoScrutation * 1000L < maintenant.getTimeInMillis();
    }

    public int lancer() {
        String zone;
        try {
            zone = myConfig.get("zoneroutiere");
        }
        catch (Exception e) {
            log.error((Object)"Erreur plors de la r\u00e9cup\u00e9ration de la zone routiere", (Throwable)e);
            return 1;
        }
        if (GLS.estVide((String)zone)) {
            log.error((Object)"Zone routi\u00e8re vide");
            return 0;
        }
        Object dateDerniereSynchro = null;
        Calendar maintenant = GregorianCalendar.getInstance();
        List fournisseurs = null;
        Map corresDatex2 = null;
        metierDatex2 = BusinessServiceFactory.getDatex2Service();
        try {
            fournisseurs = metierDatex2.getFournisseurs(zone);
        }
        catch (Exception e) {
            log.error((Object)"Erreur lors de la lecture des fournisseurs", (Throwable)e);
            return 1;
        }
        try {
            corresDatex2 = metierDatex2.getMapDescriptionPrismDatex2(zone);
        }
        catch (Exception e) {
            log.error((Object)"Erreur lors de la lecture de la table de correspondance Datex2", (Throwable)e);
            return 1;
        }
        if (GLS.estVide((List)fournisseurs)) {
            log.info((Object)"Pas de fournisseur Datex2");
        } else {
            log.info((Object)"Synchronisation Push");
            for (FournisseurVO fournisseur : fournisseurs) {
                if (!fournisseur.getEtatClient() || !this.estTempoOk(fournisseur.getDateSynchro(), maintenant, fournisseur.getTempo())) continue;
                this.lancerSynchronisationPush(fournisseur, corresDatex2);
                try {
                    metierDatex2.miseAJourDateSynchro(fournisseur);
                }
                catch (Exception e) {
                    log.error((Object)("Erreur mise \u00e0 jour derni\u00e8re date synchro client " + fournisseur.getIdentifiant() + " - " + fournisseur.getZoneRoutiere()), (Throwable)e);
                }
            }
        }
        return 0;
    }

    public ServicePush() {
        try {
            log.info((Object)"Initialisation du fichier de configuration");
            myConfig = ConfigurationFactory.getInstance();
        }
        catch (Exception e) {
            log.error((Object)"ERREUR FICHIER CONFIG ", (Throwable)e);
            myConfig = null;
        }
        if (myConfig == null) {
            log.error((Object)"Erreur dans l'initialisation de la configuration");
            System.exit(1);
        }
    }

    public static void main(String ... strings) {
        log.info((Object)"D\u00e9but Batch");
        ServicePush service = new ServicePush();
        int codeErreur = service.lancer();
        log.info((Object)"Fin Batch");
        System.exit(codeErreur);
    }
}

