/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prism.webservices.datex2.metier.pushpull;

import com.geolocsystems.prism.webservices.datex2.Datex2V2Util;
import com.geolocsystems.prism.webservices.datex2.fournisseur.FournisseurServices;
import com.geolocsystems.prism.webservices.datex2.metier.pushpull.DatasProperties;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.Situation;
import com.geolocsystems.prismbatch.BusinessServiceFactory;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.geolocsystems.prismcentral.data.IDatex2Service;
import eu.datex2.schema._2._2_0.D2LogicalModel;
import gls.outils.GLSDate;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public final class PushPullServices {
    private static final Logger LOGGER = Logger.getLogger(PushPullServices.class);
    private static PushPullServices singleton = null;
    private static final String NUMERO_FICHIER = "numero.fichier";
    private static final String NUMERO_JOUR = "numero.jour";
    private static final int TAILLE_NUMERO = 6;
    IDatex2Service metierDatex2;
    IBusinessService service = BusinessServiceFactory.getBusinessService();

    private PushPullServices() {
        this.metierDatex2 = BusinessServiceFactory.getDatex2Service();
    }

    public static PushPullServices getInstance() {
        if (singleton == null) {
            singleton = new PushPullServices();
        }
        return singleton;
    }

    public void traitementFichiersPush(FournisseurServices fourSer, String repApache, boolean soap) throws Exception {
        IBusinessService.EvenementFiltre filtreSql;
        List listeSituations;
        D2LogicalModel logicalModel = null;
        Object listeFile = null;
        File[] listeFileTemp = new File[1];
        int numeroFichier = 0;
        int numeroJour = -1;
        try {
            LOGGER.debug((Object)"Lecture fichier donn\u00e9es");
            numeroFichier = Integer.parseInt(DatasProperties.getString(NUMERO_FICHIER));
            numeroJour = Integer.parseInt(DatasProperties.getString(NUMERO_JOUR));
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            throw new Exception("Probl\u00e8me de chargement donn\u00e9es", e);
        }
        Calendar cal = Calendar.getInstance(Locale.FRANCE);
        int numJour = cal.get(5);
        if (numeroJour != numJour) {
            numeroJour = numJour;
            numeroFichier = 0;
        }
        if ((listeSituations = this.service.getEvenementsASynchroniserDatex2(filtreSql = IBusinessService.EvenementFiltre.getVersionActive(null, null), null)).size() > 0) {
            ArrayList<Evenement> arrayListEvenements = new ArrayList<Evenement>();
            ArrayList<Integer> listeEvts = new ArrayList<Integer>();
            for (Situation situation : listeSituations) {
                for (Evenement evenement : situation.getEvenements()) {
                    arrayListEvenements.clear();
                    arrayListEvenements.add(evenement);
                    logicalModel = fourSer.convertEvenements(arrayListEvenements);
                    logicalModel.setExchange(fourSer.prepareRequeteKeepAlive(fourSer.getFournisseur().getIdentifiant(), null));
                    logicalModel.getExchange().setHistoricalStartDate(cal);
                    this.serialiser(this.nomFichierDatex2(repApache, ++numeroFichier), logicalModel, soap);
                    listeEvts.clear();
                    for (Evenement evt : arrayListEvenements) {
                        listeEvts.add(evt.getkEventid());
                    }
                    this.metierDatex2.deleteListeEvtsASynchroniser(listeEvts);
                    this.metierDatex2.deleteListeEvtsASynchroniserInactif();
                }
            }
        }
        try {
            LOGGER.debug((Object)"Sauvegarde fichier donn\u00e9es");
            DatasProperties.setString(NUMERO_FICHIER, Integer.toString(numeroFichier));
            DatasProperties.setString(NUMERO_JOUR, Integer.toString(numeroJour));
            DatasProperties.save();
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            throw new Exception("Probl\u00e8me de sauvegarde donn\u00e9es", e);
        }
    }

    protected boolean isHeureSnapshot(Calendar calStart, int intervalePublication) {
        int numMinute;
        int numHeure = calStart.get(11);
        int minute = numHeure * 60 + (numMinute = calStart.get(12));
        return minute % intervalePublication == 0;
    }

    public void traitementSnapshot(FournisseurServices fourSer, String repApache, boolean soap, String nomFichier) throws Exception {
        int numeroFichier = 0;
        Calendar calStart = Calendar.getInstance(Locale.FRANCE);
        Calendar calStop = Calendar.getInstance(Locale.FRANCE);
        calStop.add(12, (int)fourSer.getFournisseur().getTempo());
        try {
            LOGGER.debug((Object)"Lecture fichier donn\u00e9es");
            numeroFichier = Integer.parseInt(DatasProperties.getString(NUMERO_FICHIER));
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            throw new Exception("Probl\u00e8me de chargement donn\u00e9es", e);
        }
        IBusinessService.EvenementFiltre filtreSql = IBusinessService.EvenementFiltre.getVersionActive(null, null);
        List listeSituation = this.service.getEvenements(filtreSql, null);
        ArrayList<Evenement> arrayListEvenements = new ArrayList<Evenement>();
        for (Situation situation : listeSituation) {
            arrayListEvenements.addAll(situation.getEvenements());
        }
        try {
            D2LogicalModel d2Model = null;
            d2Model = fourSer.convertEvenements(arrayListEvenements);
            d2Model.setExchange(fourSer.prepareRequeteKeepAlive(fourSer.getFournisseur().getIdentifiant(), null));
            d2Model.getPayloadPublication().setFeedType(this.nomFichierDatex2Simple(numeroFichier));
            d2Model.getExchange().setHistoricalStartDate(calStart);
            d2Model.getExchange().setHistoricalStopDate(calStop);
            this.serialiser(this.nomFichierSnapshot(repApache, nomFichier), d2Model, soap);
            d2Model = null;
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            throw new Exception("Erreur de conversion", e);
        }
    }

    protected void serialiser(String fichierEntree, D2LogicalModel sitRec, boolean soap) throws Exception {
        try {
            LOGGER.debug((Object)"D\u00e9but \u00e9criture fichier ");
            File monFic = new File(fichierEntree);
            monFic.createNewFile();
            FileOutputStream fos = new FileOutputStream(monFic);
            PrintWriter ecrivain = new PrintWriter(fos);
            String xml = Datex2V2Util.serialiserHelper(sitRec, soap);
            ecrivain.write(xml);
            ecrivain.flush();
            ecrivain.close();
            fos.close();
            ecrivain = null;
            fos = null;
            LOGGER.debug((Object)"Fin \u00e9criture fichier");
        }
        catch (IOException e) {
            LOGGER.error((Object)("Probl\u00e8me de sauvegarde du fichier " + fichierEntree), (Throwable)e);
            throw new Exception("Probl\u00e8me de sauvegarde du fichier " + fichierEntree, e);
        }
        catch (Exception e1) {
            LOGGER.error((Object)("Probl\u00e8me de sauvegarde du fichier " + fichierEntree), (Throwable)e1);
            throw new Exception("Probl\u00e8me de sauvegarde du fichier " + fichierEntree, e1);
        }
    }

    public String nomFichierDatex2(String nomRep, int numeroFichier) {
        StringBuffer nomFichier = new StringBuffer(nomRep);
        nomFichier.append(System.getProperty("file.separator"));
        nomFichier.append(this.nomFichierDatex2Simple(numeroFichier));
        return nomFichier.toString();
    }

    public String nomFichierDatex2Simple(int numeroFichier) {
        StringBuffer nomFichier = new StringBuffer(GLSDate.formatDateDatexJour.format(GregorianCalendar.getInstance().getTime()));
        String numero = Integer.toString(numeroFichier);
        int taille = 6 - numero.length();
        int i = 0;
        while (i < taille) {
            nomFichier.append("0");
            ++i;
        }
        nomFichier.append(numero);
        nomFichier.append(".xml");
        return nomFichier.toString();
    }

    public String nomFichierSnapshot(String nomRep, String nomFichierCourt) {
        StringBuffer nomFichier = new StringBuffer(nomRep);
        nomFichier.append(System.getProperty("file.separator"));
        nomFichier.append(nomFichierCourt);
        return nomFichier.toString();
    }
}

