/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prism.webservices.datex2;

import com.geolocsystems.deepcopyutil.DeepCopy;
import com.geolocsystems.prism.webservices.datex2.ConvertisseurDatex2V2;
import com.geolocsystems.prism.webservices.datex2.ConvertisseurDatex2V2Inverse;
import com.geolocsystems.prism.webservices.datex2.D2LogicalModelServices;
import com.geolocsystems.prism.webservices.datex2.Datex2V2Factory;
import com.geolocsystems.prism.webservices.datex2.exception.ClientPullException;
import com.geolocsystems.prism.webservices.datex2.exception.ClientPushException;
import com.geolocsystems.prism.webservices.datex2.exception.ServerPushException;
import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.MainCourante;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismandroid.model.evenements.Situation;
import com.geolocsystems.prismandroid.model.evenements.champs.Champ;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChamp;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampLocalisation;
import com.geolocsystems.prismbatch.BusinessServiceFactory;
import com.geolocsystems.prismcentral.PrismI18n;
import com.geolocsystems.prismcentral.beans.CorrespondanceDatex2;
import com.geolocsystems.prismcentral.beans.EvenementASauvegarder;
import com.geolocsystems.prismcentral.beans.Extension;
import com.geolocsystems.prismcentral.beans.FournisseurVO;
import com.geolocsystems.prismcentral.beans.IEvenementASauvegarder;
import com.geolocsystems.prismcentral.beans.PrismCentralUser;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.geolocsystems.prismcentral.data.ICartoService;
import com.geolocsystems.prismcentral.data.IDatex2Service;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import com.geolocsystems.prismcentralvaadin.config.IConfiguration;
import eu.datex2.schema._2._2_0.D2LogicalModel;
import eu.datex2.schema._2._2_0.ResponseEnum;
import eu.datex2.schema._2._2_0.holders.D2LogicalModelHolder;
import eu.datex2.wsdl.clientPull._2_0.ClientPullServiceLocator;
import eu.datex2.wsdl.clientPull._2_0.ClientPullSoapBindingStub;
import eu.datex2.wsdl.supplierPush._2_0.AuthSSLProtocolSocketFactory;
import eu.datex2.wsdl.supplierPush._2_0.SupplierPushServiceLocator;
import eu.datex2.wsdl.supplierPush._2_0.SupplierPushSoapBindingStub;
import gls.outils.GLS;
import gls.outils.Util;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.rpc.ServiceException;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Handler;
import org.apache.axis.SimpleChain;
import org.apache.axis.configuration.BasicClientConfig;
import org.apache.axis.transport.http.CommonsHTTPSender;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.log4j.Logger;

public class D2LogicalModelServicesImpl
implements D2LogicalModelServices {
    private static final Logger LOGGER = Logger.getLogger(D2LogicalModelServicesImpl.class);
    private Map<String, CorrespondanceDatex2> mapCorresDatex2 = null;
    private Map<String, CorrespondanceDatex2> mapCorresPrism = null;
    private Extension config;
    private IBusinessService service;
    private IConfiguration myConfig = ConfigurationFactory.getInstance();
    private FournisseurVO fournisseur = null;

    public D2LogicalModelServicesImpl() {
        this.service = BusinessServiceFactory.getBusinessService();
        this.config = this.service.getConfiguration();
        this.lancer();
    }

    @Override
    public boolean analyseReponse(D2LogicalModel model) {
        LOGGER.debug((Object)("D\u00e9but analyseReponseKeepAlive:" + model));
        try {
            if (model == null || model.getExchange() == null) {
                return false;
            }
            if (model.getExchange().getResponse() == null || model.getExchange().getResponse().getValue() == null) {
                return false;
            }
            return model.getExchange().getResponse().getValue().equals("acknowledge");
            {
            }
        }
        catch (Exception e) {
            return false;
        }
        finally {
            LOGGER.debug((Object)("Fin analyseReponseKeepAlive:" + model));
        }
    }

    @Override
    public boolean analyseKeepAlive(D2LogicalModel model) {
        LOGGER.debug((Object)("D\u00e9but analyseReponseKeepAlive:" + model));
        try {
            if (model == null || model.getExchange() == null) {
                return false;
            }
            if (model.getExchange().getKeepAlive() != null) {
                boolean bl = model.getExchange().getKeepAlive();
                return bl;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
        finally {
            LOGGER.debug((Object)("Fin analyseReponseKeepAlive:" + model));
        }
    }

    @Override
    public void envoiKeepAlive(D2LogicalModelHolder holder, String url, int timeOut, String user, String password) throws ClientPushException {
        SupplierPushSoapBindingStub binding = null;
        SupplierPushServiceLocator supplierLocator = new SupplierPushServiceLocator();
        try {
            supplierLocator.setsupplierPushSoapEndPointEndpointAddress(url);
            binding = (SupplierPushSoapBindingStub)supplierLocator.getsupplierPushSoapEndPoint();
        }
        catch (ServiceException jre) {
            if (jre.getLinkedCause() != null) {
                jre.getLinkedCause().printStackTrace();
            }
            throw new ClientPushException("JAX-RPC ServiceException caught ", jre);
        }
        if (binding == null) {
            throw new ClientPushException("binding = null ");
        }
        binding.setUsername(user);
        binding.setPassword(password);
        binding.setTimeout(timeOut);
        try {
            binding.putDatex2Data(holder);
        }
        catch (Exception e) {
            LOGGER.debug((Object)e);
            e.printStackTrace();
            throw new ClientPushException("Exception sur setDatex2Data ", e);
        }
        binding = null;
        supplierLocator = null;
    }

    @Override
    public void appelRealTimeDatex2Data(D2LogicalModelHolder holder, String url, int timeOut, String user, String password) throws ClientPushException {
        this.appelRealTimeDatex2Data(holder, url, null, timeOut, user, password);
    }

    @Override
    public void appelRealTimeDatex2Data(D2LogicalModelHolder holder, String urlInit, String WSDDServiceName, int timeOut, String user, String password) throws ClientPushException {
        boolean connexionSSLActive;
        BasicClientConfig basicClientConfig = new BasicClientConfig();
        IConfiguration properties = ConfigurationFactory.getInstance();
        boolean bl = connexionSSLActive = properties.getInt("connexion.ssl.active") == 1;
        if (connexionSSLActive) {
            String keystore = properties.get("connexion.ssl.keystore.file");
            String keystoreURL = "file:" + keystore;
            String keystorePassword = properties.get("connexion.ssl.keystore.password");
            String truststore = properties.get("connexion.ssl.truststore.file");
            String truststoreURL = "file:" + truststore;
            String truststorePassword = properties.get("connexion.ssl.truststore.password");
            try {
                AuthSSLProtocolSocketFactory factory = new AuthSSLProtocolSocketFactory(new URL(keystoreURL), keystorePassword, new URL(truststoreURL), truststorePassword);
                Protocol authhttp = new Protocol("https", (ProtocolSocketFactory)factory, 443);
                Protocol.registerProtocol((String)"https", (Protocol)authhttp);
            }
            catch (Exception e) {
                LOGGER.debug((Object)e);
                throw new ClientPushException("Exception sur ProtocolSocketFactory ", e);
            }
        }
        SimpleChain simpleChain = new SimpleChain();
        simpleChain.addHandler((Handler)new CommonsHTTPSender());
        basicClientConfig.deployTransport("http", (Handler)simpleChain);
        basicClientConfig.deployTransport("https", (Handler)simpleChain);
        SupplierPushSoapBindingStub binding = null;
        SupplierPushServiceLocator clientLocator = new SupplierPushServiceLocator((EngineConfiguration)basicClientConfig);
        String url = urlInit;
        if (url == null || url.length() == 0) {
            url = clientLocator.getsupplierPushSoapEndPointAddress();
        }
        try {
            if (WSDDServiceName != null) {
                clientLocator.setsupplierPushSoapEndPointWSDDServiceName(WSDDServiceName);
            }
            binding = (SupplierPushSoapBindingStub)clientLocator.getsupplierPushSoapEndPoint(new URL(url));
        }
        catch (MalformedURLException mue) {
            throw new ClientPushException("MalformedURLException ", mue);
        }
        catch (ServiceException jre) {
            if (jre.getLinkedCause() != null) {
                jre.getLinkedCause().printStackTrace();
            }
            throw new ClientPushException("JAX-RPC ServiceException caught ", jre);
        }
        if (binding == null) {
            throw new ClientPushException("binding = null ");
        }
        binding.setUsername(user);
        binding.setPassword(password);
        binding.setTimeout(timeOut);
        try {
            binding.putDatex2Data(holder);
        }
        catch (Exception e) {
            LOGGER.debug((Object)e);
            throw new ClientPushException("Exception sur putDatex2Data ", e);
        }
        binding = null;
        clientLocator = null;
    }

    @Override
    public final D2LogicalModel clientPullSoapEndPointGetDatex2Data(String identifiant, String urlClient, String user, String password, int timeout) throws ClientPullException {
        return this.clientPullSoapEndPointGetDatex2Data(identifiant, urlClient, null, user, password, timeout);
    }

    @Override
    public D2LogicalModel clientPullSoapEndPointGetDatex2Data(String identifiant, String urlClient, String WSDDServiceName, String user, String password, int timeout) throws ClientPullException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(String.valueOf(identifiant) + ":Debut URL ->" + urlClient));
        }
        ClientPullSoapBindingStub binding = null;
        ClientPullServiceLocator clientLocator = new ClientPullServiceLocator();
        try {
            clientLocator.setclientPullSoapEndPointEndpointAddress(urlClient);
            if (WSDDServiceName != null) {
                clientLocator.setclientPullSoapEndPointWSDDServiceName(WSDDServiceName);
            }
            binding = (ClientPullSoapBindingStub)clientLocator.getclientPullSoapEndPoint();
        }
        catch (ServiceException jre) {
            if (jre.getLinkedCause() != null) {
                jre.getLinkedCause().printStackTrace();
            }
            throw new ClientPullException("JAX-RPC ServiceException caught ", jre);
        }
        if (binding == null) {
            throw new ClientPullException("binding = null ");
        }
        try {
            binding.setTimeout(this.myConfig.getInt("datex2.timeOutUrl"));
        }
        catch (Exception e1) {
            binding.setTimeout(240000);
            String m = "param\u00e8tre datex2.timeOutUrl non trouv\u00e9";
            LOGGER.debug((Object)m);
        }
        binding.setUsername(user);
        binding.setPassword(password);
        D2LogicalModel value = null;
        try {
            value = binding.getDatex2Data();
        }
        catch (Exception e) {
            throw new ClientPullException("Exception sur getDatex2Data ", e);
        }
        binding = null;
        clientLocator = null;
        return value;
    }

    @Override
    public D2LogicalModel clientHttpGetDatex2Data(String identifiant, String urlClient, String user, String password, int timeout) throws ClientPullException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(String.valueOf(identifiant) + ":Debut URL ->" + urlClient));
        }
        ClientPullSoapBindingStub binding = null;
        ClientPullServiceLocator clientLocator = new ClientPullServiceLocator();
        try {
            clientLocator.setclientPullSoapEndPointEndpointAddress(urlClient);
            binding = (ClientPullSoapBindingStub)clientLocator.getclientPullSoapEndPoint();
        }
        catch (ServiceException jre) {
            if (jre.getLinkedCause() != null) {
                jre.getLinkedCause().printStackTrace();
            }
            throw new ClientPullException("JAX-RPC ServiceException caught ", jre);
        }
        if (binding == null) {
            throw new ClientPullException("binding = null ");
        }
        binding.setUsername(user);
        binding.setPassword(password);
        try {
            binding.setTimeout(this.myConfig.getInt("datex2.timeOutUrl"));
        }
        catch (Exception e1) {
            binding.setTimeout(240000);
            String m = "param\u00e8tre datex2.timeOutUrl non trouv\u00e9";
            LOGGER.debug((Object)m);
        }
        D2LogicalModel value = null;
        try {
            value = binding.getDatex2DataHttp();
        }
        catch (Exception e) {
            throw new ClientPullException("Exception sur getDatex2Data ", e);
        }
        binding = null;
        clientLocator = null;
        return value;
    }

    @Override
    public void pushDatex2Data(D2LogicalModelHolder holder) throws ServerPushException {
        LOGGER.debug((Object)"Debut");
        try {
            ConvertisseurDatex2V2 convertisseur2 = null;
            try {
                convertisseur2 = Datex2V2Factory.getConvertisseurDatex2V2();
                convertisseur2.initMapPrism(this.mapCorresPrism);
                convertisseur2.setNationalIdentifier(this.fournisseur.getIdentifiant());
            }
            catch (Exception e) {
                LOGGER.error((Object)"Erreur initialisation convertisseur", (Throwable)e);
            }
            if (this.analyseKeepAlive(holder.value)) {
                if (convertisseur2 != null) {
                    holder.value = convertisseur2.genererModelDatex2KeepAlive(true, ResponseEnum.acknowledge);
                }
            } else {
                ConvertisseurDatex2V2Inverse convertisseur = Datex2V2Factory.getConvertisseurDatex2V2Inverse();
                convertisseur.initMapDatex2(this.mapCorresDatex2);
                ArrayList<Evenement> listeEvts = convertisseur.genererEvenements(holder.value);
                if (listeEvts != null && listeEvts.size() > 0) {
                    String codeUtilisateur = this.config.getString("codeUtilisateurDatex2");
                    PrismCentralUser utilisateur = this.service.rechercheUtilisateurParLogin(codeUtilisateur);
                    MainCourante mc = this.service.creerMainCouranteCentral(utilisateur);
                    for (Evenement evenement : listeEvts) {
                        this.sauvegarderPush(evenement, utilisateur, mc);
                    }
                    this.service.deconnexion(mc);
                } else {
                    LOGGER.debug((Object)"Pas d'\u00e9v\u00e9nement \u00e0 synchroniser");
                }
                if (convertisseur2 != null) {
                    holder.value = convertisseur2.genererModelDatex2KeepAlive(true, ResponseEnum.acknowledge);
                }
            }
        }
        catch (Exception e) {
            throw new ServerPushException(e.getMessage(), e);
        }
    }

    public void traitementEvenement(EvenementASauvegarder eas) {
        Evenement evenement = eas.getEvenement();
        LOGGER.debug((Object)("R\u00e9ception d'un \u00e9v\u00e8nement " + evenement.getIdSituation() + " -- " + evenement.getIdReference()));
        if (evenement.getEtat() != 2) {
            try {
                ValeurChampLocalisation vcl = evenement.getLocalisation();
                boolean ponctuel = true;
                if (vcl.getPrFin() != -1 && vcl.getAbsPrFin() != -1) {
                    ponctuel = false;
                }
                BusinessServiceFactory.getCartoService().localisation(vcl);
                if (ponctuel) {
                    vcl.setAbsAdresseFin(-1);
                    vcl.setPrFin(-1);
                }
                evenement.setErreur(null);
            }
            catch (ICartoService.LocalisationException e) {
                LOGGER.error((Object)"", (Throwable)e);
                evenement.setErreur(PrismI18n.getString((String)e.getErreurI18n()));
            }
            catch (Throwable e) {
                LOGGER.error((Object)"", e);
                evenement.setErreur("ERREUR INCONNUE LOCALISATION");
            }
        }
        LOGGER.debug((Object)"#--> Save evt");
        BusinessServiceFactory.getBusinessService().sauvegarderEvenement((IEvenementASauvegarder)eas);
    }

    public void sauvegarderPush(Evenement evenement, PrismCentralUser utilisateur, MainCourante mc) {
        try {
            EvenementASauvegarder eas;
            Evenement evtBDD = null;
            if (!Util.isNullOrEmpty((String)evenement.getIdReference())) {
                IBusinessService.EvenementFiltre filtreSql = IBusinessService.EvenementFiltre.getVersionActive(null, (String)evenement.getIdReference());
                List listeSituation = this.service.getEvenements(filtreSql, null);
                for (Situation situation : listeSituation) {
                    Iterator<Object> iterator = situation.getEvenements().iterator();
                    while (iterator.hasNext()) {
                        Evenement evtTemp;
                        evtBDD = evtTemp = (Evenement)iterator.next();
                    }
                }
            }
            if (evtBDD == null) {
                evenement.setCodeUtilisateur(utilisateur.getCode());
                evenement.setMainCourante(mc);
                eas = (EvenementASauvegarder)EvenementASauvegarder.aSauvegarder((Evenement)evenement, null, null, (boolean)this.config.getBoolean("envoyerParMail", true), (boolean)false, (boolean)true, (boolean)true);
            } else {
                boolean pushPrioritaire = true;
                try {
                    pushPrioritaire = this.myConfig.getBoolean("datex2.pushprioritaire", true);
                }
                catch (Exception e) {
                    pushPrioritaire = true;
                }
                if (pushPrioritaire) {
                    ArrayList<Integer> listeEvts = new ArrayList<Integer>();
                    listeEvts.add(evtBDD.getkEventid());
                    BusinessServiceFactory.getDatex2Service().deleteListeEvtsASynchroniser(listeEvts);
                }
                if (this.config.getString("listeChampsMajDatex2") != null) {
                    String[] infosMaj;
                    Nature versionActive = (Nature)DeepCopy.copy((Object)((Nature)BusinessServiceFactory.getBusinessService().getNatures().get(evenement.getValeurNature().getCode())));
                    for (Champ champ : versionActive.getChamps()) {
                        LOGGER.error((Object)(String.valueOf(champ.getNom()) + " - " + champ.getLibelle()));
                    }
                    versionActive.chargerValeurs(evtBDD.getValeurNature());
                    Nature nouvelleVersion = (Nature)DeepCopy.copy((Object)((Nature)BusinessServiceFactory.getBusinessService().getNatures().get(evenement.getValeurNature().getCode())));
                    nouvelleVersion.chargerValeurs(evenement.getValeurNature());
                    Map champsNouvelleVersion = MetierCommun.getChamps((Nature)nouvelleVersion);
                    Map champsVersionActive = MetierCommun.getChamps((Nature)versionActive);
                    String[] stringArray = infosMaj = this.config.getString("listeChampsMajDatex2").split(";");
                    int n = infosMaj.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String champAModifier = stringArray[n2];
                        if (champsNouvelleVersion.containsKey(champAModifier) && champsVersionActive.containsKey(champAModifier)) {
                            Champ c = (Champ)champsVersionActive.get(champAModifier);
                            ValeurChamp v = ((Champ)champsNouvelleVersion.get(champAModifier)).getValeurChamp();
                            c.setValeurChamp(v);
                        }
                        ++n2;
                    }
                    evtBDD.setValeurNature(versionActive.extraireValeurs());
                    evtBDD.setTermine(evenement.isTermine());
                    evtBDD.setNumVersion(evenement.getNumVersion());
                    evtBDD.setDateFin(evenement.getDateFin());
                    evtBDD.setDateMaj(evenement.getDateMaj());
                } else {
                    evtBDD = evenement;
                }
                evtBDD.setCodeUtilisateur(utilisateur.getCode());
                evtBDD.setMainCourante(mc);
                evtBDD.setEtat(1);
                eas = (EvenementASauvegarder)EvenementASauvegarder.aSauvegarder((Evenement)evtBDD, null, null, (boolean)this.config.getBoolean("envoyerParMail", true), (boolean)false, (boolean)true, (boolean)false);
            }
            if (LOGGER.isDebugEnabled()) {
                try {
                    LOGGER.debug((Object)("Evt sauvegard\u00e9 : " + eas.getEvenement().toString()));
                    Nature n = (Nature)DeepCopy.copy((Object)((Nature)BusinessServiceFactory.getBusinessService().getNatures().get(evenement.getValeurNature().getCode())));
                    n.chargerValeurs(evenement.getValeurNature());
                    HashMap attributsEvenements = MetierCommun.convertirAttributs((Nature)n, (Evenement)evenement);
                    StringBuffer sb = new StringBuffer();
                    for (String cle : attributsEvenements.keySet()) {
                        sb.append(cle);
                        sb.append("=");
                        sb.append((String)attributsEvenements.get(cle));
                        sb.append(";");
                    }
                    LOGGER.debug((Object)sb.toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.traitementEvenement(eas);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Erreur lors de la synchronisation ", (Throwable)e);
        }
    }

    public int lancer() {
        String zone;
        try {
            zone = this.myConfig.get("zoneroutiere");
        }
        catch (Exception e) {
            LOGGER.error((Object)"Erreur plors de la r\u00e9cup\u00e9ration de la zone routiere", (Throwable)e);
            return 1;
        }
        if (GLS.estVide((String)zone)) {
            LOGGER.error((Object)"Zone routi\u00e8re vide");
            return 0;
        }
        Object dateDerniereSynchro = null;
        Calendar maintenant = GregorianCalendar.getInstance();
        List fournisseurs = null;
        Object clients = null;
        IDatex2Service metierDatex2 = BusinessServiceFactory.getDatex2Service();
        try {
            fournisseurs = metierDatex2.getFournisseurs(zone);
            this.fournisseur = (FournisseurVO)fournisseurs.get(0);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Erreur lors de la lecture des fournisseurs", (Throwable)e);
            return 1;
        }
        try {
            this.mapCorresDatex2 = metierDatex2.getMapDescriptionDatex2Prism(zone);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Erreur lors de la lecture de la table de correspondance Datex2", (Throwable)e);
            return 1;
        }
        try {
            this.mapCorresPrism = metierDatex2.getMapDescriptionPrismDatex2(zone);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Erreur lors de la lecture de la table de correspondance Datex2", (Throwable)e);
            return 1;
        }
        return 0;
    }
}

