/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prism.webservices.datex2;

import com.geolocsystems.deepcopyutil.DeepCopy;
import com.geolocsystems.prism.webservices.datex2.ConstantesDatex2v2;
import com.geolocsystems.prism.webservices.datex2.ConvertisseurDatex2V2Inverse;
import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.Position;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.IDescription;
import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampCollectionChoixUnique;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampCollectionChoixUnique;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampEntier;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampLocalisation;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampMultiCheckBox;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampTexte;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampVehiculeEnCause;
import com.geolocsystems.prismbatch.BusinessServiceFactory;
import com.geolocsystems.prismcentral.beans.CorrespondanceDatex2;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import com.geolocsystems.prismcentralvaadin.config.IConfiguration;
import eu.datex2.schema._2._2_0.AbnormalTraffic;
import eu.datex2.schema._2._2_0.AbnormalTrafficTypeEnum;
import eu.datex2.schema._2._2_0.Accident;
import eu.datex2.schema._2._2_0.AccidentTypeEnum;
import eu.datex2.schema._2._2_0.AffectedCarriagewayAndLanes;
import eu.datex2.schema._2._2_0.AlertCDirection;
import eu.datex2.schema._2._2_0.AlertCLocation;
import eu.datex2.schema._2._2_0.AlertCMethod4Linear;
import eu.datex2.schema._2._2_0.AlertCMethod4Point;
import eu.datex2.schema._2._2_0.AlertCMethod4PrimaryPointLocation;
import eu.datex2.schema._2._2_0.AlertCMethod4SecondaryPointLocation;
import eu.datex2.schema._2._2_0.AnimalPresenceObstruction;
import eu.datex2.schema._2._2_0.Area;
import eu.datex2.schema._2._2_0.AreaDestination;
import eu.datex2.schema._2._2_0.Comment;
import eu.datex2.schema._2._2_0.CommentTypeEnum;
import eu.datex2.schema._2._2_0.ComparisonOperatorEnum;
import eu.datex2.schema._2._2_0.D2LogicalModel;
import eu.datex2.schema._2._2_0.DelayBandEnum;
import eu.datex2.schema._2._2_0.Delays;
import eu.datex2.schema._2._2_0.DelaysTypeEnum;
import eu.datex2.schema._2._2_0.DistanceFromLinearElementReferent;
import eu.datex2.schema._2._2_0.DistanceFromLinearElementStart;
import eu.datex2.schema._2._2_0.EnvironmentalObstruction;
import eu.datex2.schema._2._2_0.EquipmentOrSystemFault;
import eu.datex2.schema._2._2_0.Exchange;
import eu.datex2.schema._2._2_0.GeneralObstruction;
import eu.datex2.schema._2._2_0.GrossWeightCharacteristic;
import eu.datex2.schema._2._2_0.GroupOfPeopleInvolved;
import eu.datex2.schema._2._2_0.GroupOfVehiclesInvolved;
import eu.datex2.schema._2._2_0.HeaderInformation;
import eu.datex2.schema._2._2_0.Impact;
import eu.datex2.schema._2._2_0.InfrastructureDamageObstruction;
import eu.datex2.schema._2._2_0.InjuryStatusTypeEnum;
import eu.datex2.schema._2._2_0.InternationalIdentifier;
import eu.datex2.schema._2._2_0.InvolvementRolesEnum;
import eu.datex2.schema._2._2_0.LaneEnum;
import eu.datex2.schema._2._2_0.LifeCycleManagement;
import eu.datex2.schema._2._2_0.Linear;
import eu.datex2.schema._2._2_0.LinearElement;
import eu.datex2.schema._2._2_0.LinearElementByPoints;
import eu.datex2.schema._2._2_0.LinearReferencingDirectionEnum;
import eu.datex2.schema._2._2_0.LinearWithinLinearElement;
import eu.datex2.schema._2._2_0.LoadTypeEnum;
import eu.datex2.schema._2._2_0.Location;
import eu.datex2.schema._2._2_0.LocationByReference;
import eu.datex2.schema._2._2_0.MaintenanceWorks;
import eu.datex2.schema._2._2_0.Management;
import eu.datex2.schema._2._2_0.MobilityEnum;
import eu.datex2.schema._2._2_0.MultilingualString;
import eu.datex2.schema._2._2_0.MultilingualStringValue;
import eu.datex2.schema._2._2_0.NetworkLocation;
import eu.datex2.schema._2._2_0.NetworkManagement;
import eu.datex2.schema._2._2_0.NonOrderedLocationGroupByList;
import eu.datex2.schema._2._2_0.NonWeatherRelatedRoadConditionTypeEnum;
import eu.datex2.schema._2._2_0.NonWeatherRelatedRoadConditions;
import eu.datex2.schema._2._2_0.Obstruction;
import eu.datex2.schema._2._2_0.ObstructionTypeEnum;
import eu.datex2.schema._2._2_0.OverallPeriod;
import eu.datex2.schema._2._2_0.PersonCategoryEnum;
import eu.datex2.schema._2._2_0.Point;
import eu.datex2.schema._2._2_0.PointAlongLinearElement;
import eu.datex2.schema._2._2_0.PointCoordinates;
import eu.datex2.schema._2._2_0.PoorEnvironmentConditions;
import eu.datex2.schema._2._2_0.PoorEnvironmentTypeEnum;
import eu.datex2.schema._2._2_0.Referent;
import eu.datex2.schema._2._2_0.RelativeTrafficFlowEnum;
import eu.datex2.schema._2._2_0.ReroutingManagement;
import eu.datex2.schema._2._2_0.RoadOrCarriagewayOrLaneManagement;
import eu.datex2.schema._2._2_0.Situation;
import eu.datex2.schema._2._2_0.SituationPublication;
import eu.datex2.schema._2._2_0.SituationRecord;
import eu.datex2.schema._2._2_0.Source;
import eu.datex2.schema._2._2_0.SpeedManagement;
import eu.datex2.schema._2._2_0.Subscription;
import eu.datex2.schema._2._2_0.SupplementaryPositionalDescription;
import eu.datex2.schema._2._2_0.Target;
import eu.datex2.schema._2._2_0.TpegAreaDescriptor;
import eu.datex2.schema._2._2_0.TpegLinearLocation;
import eu.datex2.schema._2._2_0.TpegLoc01SimplePointLocationSubtypeEnum;
import eu.datex2.schema._2._2_0.TpegLoc03AreaDescriptorSubtypeEnum;
import eu.datex2.schema._2._2_0.TpegLoc03OtherPointDescriptorSubtypeEnum;
import eu.datex2.schema._2._2_0.TpegNamedOnlyArea;
import eu.datex2.schema._2._2_0.TpegNonJunctionPoint;
import eu.datex2.schema._2._2_0.TpegOtherPointDescriptor;
import eu.datex2.schema._2._2_0.TpegSimplePoint;
import eu.datex2.schema._2._2_0.TrafficConstrictionTypeEnum;
import eu.datex2.schema._2._2_0.TrafficFlowCharacteristicsEnum;
import eu.datex2.schema._2._2_0.TrafficTrendTypeEnum;
import eu.datex2.schema._2._2_0.Validity;
import eu.datex2.schema._2._2_0.Vehicle;
import eu.datex2.schema._2._2_0.VehicleCharacteristics;
import eu.datex2.schema._2._2_0.VehicleObstruction;
import eu.datex2.schema._2._2_0.VehicleTypeEnum;
import eu.datex2.schema._2._2_0.VmsPictogramDisplayCharacteristics;
import eu.datex2.schema._2._2_0.VmsTextDisplayCharacteristics;
import eu.datex2.schema._2._2_0.WeatherRelatedRoadConditions;
import eu.datex2.schema._2._2_0._ExtensionType;
import eu.datex2.schema._2._2_0._PredefinedLocationVersionedReference;
import eu.datex2.schema._2._2_0._VmsRecordPictogramDisplayAreaIndexVmsPictogramDisplayCharacteristics;
import gls.geometry.GeoPoint;
import gls.outils.Extension;
import gls.outils.GLS;
import gls.outils.GLSDate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import org.apache.axis.Constants;
import org.apache.axis.encoding.ser.CalendarDeserializer;
import org.apache.axis.message.MessageElement;
import org.apache.axis.types.Id;
import org.apache.axis.types.Language;
import org.apache.axis.types.NonNegativeInteger;
import org.apache.axis.utils.XMLChar;
import org.apache.log4j.Logger;

public class ConvertisseurDatex2V2InverseImpl
implements ConstantesDatex2v2,
ConvertisseurDatex2V2Inverse {
    private Logger LOGGER = Logger.getLogger(ConvertisseurDatex2V2InverseImpl.class);
    protected String nationalIdentifier = "PRISM";
    protected Map<String, CorrespondanceDatex2> mapDatex2Prism = null;

    @Override
    public Id convertStringToId(String id) {
        Id monId = null;
        if (id != null && Id.isValid((String)id)) {
            monId = new Id(id);
        } else {
            StringBuffer strBuff = new StringBuffer();
            int i = 0;
            while (i < id.length()) {
                if (i == 0) {
                    if (!XMLChar.isNCNameStart((int)id.charAt(i))) {
                        strBuff.append("X");
                        if (!XMLChar.isNCName((int)id.charAt(i))) {
                            strBuff.append("_");
                        } else {
                            strBuff.append(id.charAt(i));
                        }
                    } else {
                        strBuff.append(id.charAt(i));
                    }
                }
                if (i != 0) {
                    if (!XMLChar.isNCName((int)id.charAt(i))) {
                        strBuff.append("_");
                    } else {
                        strBuff.append(id.charAt(i));
                    }
                }
                ++i;
            }
            monId = new Id(strBuff.toString());
        }
        return monId;
    }

    @Override
    public void genererSubscription(Extension parametresDatex2, Subscription subscription) throws Exception {
        parametresDatex2.setValeur("SUBSCRIPTION_START", (Object)subscription.getSubscriptionStartTime().getTimeInMillis());
        Target[] t = new Target[]{new Target()};
        t[0].setAddress(parametresDatex2.getString("TARGET_ADDRESS"));
        t[0].setProtocol(parametresDatex2.getString("TARGET_PROTOCOL"));
        if (subscription.getTarget() != null) {
            parametresDatex2.setValeur("TARGET_ADDRESS", (Object)subscription.getTarget()[0].getAddress());
            parametresDatex2.setValeur("TARGET_PROTOCOL", (Object)subscription.getTarget()[0].getProtocol());
        }
    }

    @Override
    public void genererInternationalIdentifier(Extension parametresDatex2, InternationalIdentifier internationalIdentifier) throws Exception {
        parametresDatex2.setValeur(COUNTRY_ENUM, (Object)internationalIdentifier.getCountry());
        parametresDatex2.setValeur("fournisseur", (Object)internationalIdentifier.getNationalIdentifier());
    }

    @Override
    public void genererExchange(Extension parametresDatex2, Exchange exchange) throws Exception {
        block7: {
            this.LOGGER.debug((Object)"<defineExchange>");
            try {
                try {
                    this.genererInternationalIdentifier(parametresDatex2, exchange.getSupplierIdentification());
                    this.LOGGER.debug((Object)("SupplierIdentification --> " + parametresDatex2.getString("fournisseur")));
                    this.genererSubscription(parametresDatex2, exchange.getSubscription());
                }
                catch (Exception e) {
                    this.LOGGER.debug((Object)e);
                    this.LOGGER.debug((Object)"</defineExchange>");
                    break block7;
                }
            }
            catch (Throwable throwable) {
                this.LOGGER.debug((Object)"</defineExchange>");
                throw throwable;
            }
            this.LOGGER.debug((Object)"</defineExchange>");
        }
        try {
            parametresDatex2.setValeur(RESPONSE, (Object)exchange.getResponse());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void genererLanguage(Extension parametresDatex2, Language language) throws Exception {
        parametresDatex2.setValeur("COUNTRY", (Object)language.toString());
    }

    @Override
    public void genererSituationPublication(Extension parametresDatex2, SituationPublication situationPublication) throws Exception {
        this.LOGGER.debug((Object)"<SituationPublication>");
        this.genererLanguage(parametresDatex2, situationPublication.getLang());
        this.genererInternationalIdentifier(parametresDatex2, situationPublication.getPublicationCreator());
        this.LOGGER.debug((Object)"</SituationPublication>");
    }

    @Override
    public String genererIdSituation(Extension parametresDatex2) throws Exception {
        return this.genererId(parametresDatex2.getString("fournisseur").concat("_"));
    }

    @Override
    public String genererId(String prefix) {
        return GLS.genererNumeroUnique((String)prefix);
    }

    @Override
    public void genererValidity(Extension parametresDatex2, Validity validity) throws Exception {
        this.LOGGER.debug((Object)"<validity>");
        if (validity.getValidityTimeSpecification() != null) {
            this.getOverallPeriod(parametresDatex2, validity.getValidityTimeSpecification());
        }
        parametresDatex2.setValeur(VALIDITY_STATUS, (Object)validity.getValidityStatus());
        this.LOGGER.debug((Object)"</validity>");
    }

    @Override
    public void getOverallPeriod(Extension parametresDatex2, OverallPeriod overallPeriod) throws Exception {
        this.LOGGER.debug((Object)"<overallPeriod>");
        if (overallPeriod.getOverallStartTime() != null) {
            parametresDatex2.setValeur("validityTimeSpecificationStart", (Object)overallPeriod.getOverallStartTime().getTimeInMillis());
        }
        if (overallPeriod.getOverallEndTime() != null) {
            parametresDatex2.setValeur("validityTimeSpecificationStop", (Object)overallPeriod.getOverallEndTime().getTimeInMillis());
        }
        this.LOGGER.debug((Object)"</overallPeriod>");
    }

    @Override
    public Calendar getDateTime() {
        return GLSDate.maintenant();
    }

    public Calendar getDateTime(String date) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        try {
            String temp = String.valueOf(date.substring(0, 22)) + date.substring(23);
            Date d1 = sdf.parse(temp);
            Calendar cal = Calendar.getInstance(Locale.FRANCE);
            cal.setTime(d1);
            int offset = cal.get(15) + cal.get(16);
            cal.setTimeInMillis(cal.getTimeInMillis() - (long)offset);
            return cal;
        }
        catch (ParseException e) {
            Calendar cal = (Calendar)new CalendarDeserializer(String.class, Constants.XSD_STRING).makeValue(date);
            int offset = cal.get(15) + cal.get(16);
            cal.setTimeInMillis(cal.getTimeInMillis() - (long)offset);
            return cal;
        }
    }

    @Override
    public Delays genererDelays(Extension parametresDatex2) throws Exception {
        Delays delays = new Delays();
        if (!parametresDatex2.existe(IMPACT_DELAYS_BAND)) {
            delays.setDelayBand(DelayBandEnum.fromString(parametresDatex2.getString(IMPACT_DELAYS_BAND)));
        }
        if (!parametresDatex2.existe(IMPACT_DELAYS_TYPE)) {
            delays.setDelaysType(DelaysTypeEnum.fromString(parametresDatex2.getString(IMPACT_DELAYS_TYPE)));
        }
        if (!parametresDatex2.existe("delaysValue")) {
            delays.setDelayTimeValue(Float.valueOf(parametresDatex2.getFloat("delaysValue", 60.0f)));
        }
        return delays;
    }

    @Override
    public Impact genererImpact(Extension parametresDatex2) throws Exception {
        Impact impact = new Impact();
        if (!parametresDatex2.estIntVide("numberOfLanesRestricted")) {
            impact.setNumberOfLanesRestricted(new NonNegativeInteger(parametresDatex2.getString("numberOfLanesRestricted")));
        }
        if (!parametresDatex2.estIntVide("numberOfOperationalLanes")) {
            impact.setNumberOfOperationalLanes(new NonNegativeInteger(parametresDatex2.getString("numberOfOperationalLanes")));
        }
        if (!parametresDatex2.estIntVide("originalNumberOfLanes")) {
            impact.setOriginalNumberOfLanes(new NonNegativeInteger(parametresDatex2.getString("originalNumberOfLanes")));
        }
        if (!parametresDatex2.estStringVide(IMPACT_DETAILS_TRAFFIC_RESTRICTION_TYPE)) {
            impact.setTrafficConstrictionType(TrafficConstrictionTypeEnum.fromString(parametresDatex2.getString(IMPACT_DETAILS_TRAFFIC_RESTRICTION_TYPE)));
        }
        impact.setDelays(this.genererDelays(parametresDatex2));
        return impact;
    }

    public Source genererSourceInformation(Extension parametresDatex2, Source sourceInformation) throws Exception {
        if (sourceInformation.getSourceIdentification() != null) {
            parametresDatex2.setValeur("sourceIdentification", (Object)sourceInformation.getSourceIdentification());
        }
        if (sourceInformation.getSourceType() != null) {
            parametresDatex2.setValeur("sourceIdentificationSourceType", (Object)sourceInformation.getSourceType().toString());
        }
        if (sourceInformation.getSourceName() != null) {
            parametresDatex2.setValeur("sourceInformationSourceName", (Object)this.recupererMultiLang(sourceInformation.getSourceName(), new Language("fr")));
        }
        return sourceInformation;
    }

    @Override
    public Comment[] genererCommentaire(String[] commentaires) throws Exception {
        Comment[] comment;
        if (!GLS.estVide((String[])commentaires)) {
            comment = new Comment[commentaires.length];
            int i = 0;
            while (i < commentaires.length) {
                comment[i] = new Comment();
                MultilingualString commentComment = new MultilingualString();
                MultilingualStringValue[] commentValues = new MultilingualStringValue[]{new MultilingualStringValue(GLS.getString((String)commentaires[i], (String)""))};
                commentComment.setValues(commentValues);
                comment[i].setComment(commentComment);
                ++i;
            }
        } else {
            comment = null;
        }
        return comment;
    }

    @Override
    public void genererManagement(Extension parametresDatex2, Management management) throws Exception {
        if (management == null) {
            return;
        }
        LifeCycleManagement lifeCycleManagement = management.getLifeCycleManagement();
        if (lifeCycleManagement.getEnd() != null) {
            parametresDatex2.setValeur("lifeCycleManagementEnd", (Object)lifeCycleManagement.getEnd());
        }
        if (lifeCycleManagement.getCancel() != null) {
            parametresDatex2.getBoolean("lifeCycleManagementCancel", lifeCycleManagement.getCancel().booleanValue());
        }
    }

    @Override
    public String recupererCommentaireMultiLang(Comment[] comments, Language lang) {
        if (comments != null && comments.length > 0) {
            Comment[] commentArray = comments;
            int n = comments.length;
            int n2 = 0;
            while (n2 < n) {
                Comment comment = commentArray[n2];
                MultilingualStringValue[] multilingualStringValueArray = comment.getComment().getValues();
                int n3 = multilingualStringValueArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    MultilingualStringValue multiStr = multilingualStringValueArray[n4];
                    if (multiStr.getLang() == null || lang.equals((Object)multiStr.getLang())) {
                        return multiStr.toString();
                    }
                    ++n4;
                }
                ++n2;
            }
            return null;
        }
        return null;
    }

    @Override
    public String recupererMultiLang(MultilingualString multilingualString, Language lang) {
        if (multilingualString != null && multilingualString.getValues().length > 0) {
            MultilingualStringValue[] multilingualStringValueArray = multilingualString.getValues();
            int n = multilingualStringValueArray.length;
            int n2 = 0;
            while (n2 < n) {
                MultilingualStringValue multiStr = multilingualStringValueArray[n2];
                if (multiStr.getLang() == null || lang.equals((Object)multiStr.getLang())) {
                    return multiStr.toString();
                }
                ++n2;
            }
            return null;
        }
        return null;
    }

    @Override
    public void genererSituationRecord(Extension parametresDatex2, SituationRecord situationRecord) throws Exception {
        this.LOGGER.debug((Object)"<situationRecord>");
        parametresDatex2.setValeur("situationRecordVersion", (Object)situationRecord.getVersion());
        parametresDatex2.setValeur("creationTime", (Object)situationRecord.getSituationRecordCreationTime().getTimeInMillis());
        parametresDatex2.setValeur("versionTime", (Object)situationRecord.getSituationRecordVersionTime().getTimeInMillis());
        parametresDatex2.setValeur("firstSupplierVersionTime", (Object)situationRecord.getSituationRecordFirstSupplierVersionTime().getTimeInMillis());
        parametresDatex2.setValeur("idSituationRecord", (Object)situationRecord.getId());
        parametresDatex2.setValeur(PROBABILITY_OF_OCCURRENCE, (Object)situationRecord.getProbabilityOfOccurrence());
        this.genererValidity(parametresDatex2, situationRecord.getValidity());
        if (situationRecord.getGeneralPublicComment() != null) {
            parametresDatex2.setValeur("commentaireMultiLang", (Object)"O");
            parametresDatex2.setValeur("commentaireMultiLangFr", (Object)this.recupererCommentaireMultiLang(situationRecord.getGeneralPublicComment(), new Language("fr")));
            parametresDatex2.setValeur("commentaireMultiLangEn", (Object)this.recupererCommentaireMultiLang(situationRecord.getGeneralPublicComment(), new Language("en")));
        }
        if (situationRecord.getNonGeneralPublicComment() != null) {
            parametresDatex2.setValeur("priveCommentaireMultiLang", (Object)"O");
            parametresDatex2.setValeur("priveeCommentaireMultiLangFr", (Object)this.recupererCommentaireMultiLang(situationRecord.getNonGeneralPublicComment(), new Language("fr")));
            parametresDatex2.setValeur("priveeCommentaireMultiLangEn", (Object)this.recupererCommentaireMultiLang(situationRecord.getNonGeneralPublicComment(), new Language("en")));
        }
        if (situationRecord.getSource() != null) {
            this.genererSourceInformation(parametresDatex2, situationRecord.getSource());
        }
        if (situationRecord.getGroupOfLocations() instanceof NonOrderedLocationGroupByList) {
            this.genererLocationList(parametresDatex2, (NonOrderedLocationGroupByList)situationRecord.getGroupOfLocations());
        } else if (situationRecord.getGroupOfLocations() instanceof Point) {
            this.genererLocation(parametresDatex2, (Point)situationRecord.getGroupOfLocations());
        } else if (situationRecord.getGroupOfLocations() instanceof Linear) {
            this.genererLocation(parametresDatex2, (Linear)situationRecord.getGroupOfLocations());
        } else {
            this.LOGGER.warn((Object)("Localisation non trait\u00e9e : " + situationRecord.getGroupOfLocations()));
        }
        this.genererSituationRecordType(parametresDatex2, situationRecord);
        this.genererManagement(parametresDatex2, situationRecord.getManagement());
        this.LOGGER.debug((Object)"</situationRecord>");
    }

    @Override
    public void defineVehicles(Extension parametresDatex2, Vehicle[] vehicles, Comment[] generalPublicComment) {
        this.LOGGER.debug((Object)"<obstructingVehicle>");
        Vehicle[] vehicleArray = vehicles;
        int n = vehicles.length;
        int n2 = 0;
        while (n2 < n) {
            Vehicle vehicle = vehicleArray[n2];
            VehicleCharacteristics vehicleCharacteristics = vehicle.getVehicleCharacteristics();
            if (VehicleTypeEnum.car.equals(vehicleCharacteristics.getVehicleType(0))) {
                parametresDatex2.setValeur("ACCIDENT_NB_VEHICULES", (Object)"1");
            } else if (VehicleTypeEnum.carOrLightVehicle.equals(vehicleCharacteristics.getVehicleType(0))) {
                parametresDatex2.setValeur("ACCIDENT_NB_VEHICULES", (Object)"1");
            } else if (VehicleTypeEnum.fourWheelDrive.equals(vehicleCharacteristics.getVehicleType(0))) {
                parametresDatex2.setValeur("ACCIDENT_NB_VEHICULES", (Object)"1");
            } else if (VehicleTypeEnum.van.equals(vehicleCharacteristics.getVehicleType(0))) {
                parametresDatex2.setValeur("ACCIDENT_NB_VEHICULES", (Object)"1");
            } else if (VehicleTypeEnum.vehicleWithTrailer.equals(vehicleCharacteristics.getVehicleType(0))) {
                parametresDatex2.setValeur("ACCIDENT_NB_VEHICULES", (Object)"1");
            } else if (VehicleTypeEnum.carWithTrailer.equals(vehicleCharacteristics.getVehicleType(0))) {
                parametresDatex2.setValeur("ACCIDENT_NB_VEHICULES", (Object)"1");
            } else if (VehicleTypeEnum.carWithCaravan.equals(vehicleCharacteristics.getVehicleType(0))) {
                parametresDatex2.setValeur("ACCIDENT_NB_CARAVANES", (Object)"1");
            } else if (VehicleTypeEnum.vehicleWithCaravan.equals(vehicleCharacteristics.getVehicleType(0))) {
                parametresDatex2.setValeur("ACCIDENT_NB_CARAVANES", (Object)"1");
            } else if (VehicleTypeEnum.caravan.equals(vehicleCharacteristics.getVehicleType(0))) {
                parametresDatex2.setValeur("ACCIDENT_NB_CARAVANES", (Object)"1");
            } else if (VehicleTypeEnum.agriculturalVehicle.equals(vehicleCharacteristics.getVehicleType(0))) {
                parametresDatex2.setValeur("ACCIDENT_NB_AUTRES", (Object)"1");
            } else if (VehicleTypeEnum.lorry.equals(vehicleCharacteristics.getVehicleType(0))) {
                parametresDatex2.setValeur("ACCIDENT_NB_PL", (Object)"1");
                if (LoadTypeEnum.hazardousMaterials.equals(vehicleCharacteristics.getLoadType())) {
                    parametresDatex2.setValeur("ACCIDENT_TMD", (Object)"1");
                }
            } else if (VehicleTypeEnum.articulatedVehicle.equals(vehicleCharacteristics.getVehicleType(0))) {
                parametresDatex2.setValeur("ACCIDENT_NB_PL", (Object)"1");
                if (LoadTypeEnum.hazardousMaterials.equals(vehicleCharacteristics.getLoadType())) {
                    parametresDatex2.setValeur("ACCIDENT_TMD", (Object)"1");
                }
            } else if (VehicleTypeEnum.constructionOrMaintenanceVehicle.equals(vehicleCharacteristics.getVehicleType(0))) {
                parametresDatex2.setValeur("ACCIDENT_NB_PL", (Object)"1");
                if (LoadTypeEnum.hazardousMaterials.equals(vehicleCharacteristics.getLoadType())) {
                    parametresDatex2.setValeur("ACCIDENT_TMD", (Object)"1");
                }
            } else if (VehicleTypeEnum.tanker.equals(vehicleCharacteristics.getVehicleType(0))) {
                parametresDatex2.setValeur("ACCIDENT_NB_PL", (Object)"1");
                if (LoadTypeEnum.hazardousMaterials.equals(vehicleCharacteristics.getLoadType())) {
                    parametresDatex2.setValeur("ACCIDENT_TMD", (Object)"1");
                }
            } else if (VehicleTypeEnum.highSidedVehicle.equals(vehicleCharacteristics.getVehicleType(0))) {
                parametresDatex2.setValeur("ACCIDENT_NB_PL", (Object)"1");
                if (LoadTypeEnum.hazardousMaterials.equals(vehicleCharacteristics.getLoadType())) {
                    parametresDatex2.setValeur("ACCIDENT_TMD", (Object)"1");
                }
            } else if (VehicleTypeEnum.bus.equals(vehicleCharacteristics.getVehicleType(0))) {
                parametresDatex2.setValeur("ACCIDENT_NB_BUS", (Object)"1");
            } else if (VehicleTypeEnum.twoWheeledVehicle.equals(vehicleCharacteristics.getVehicleType(0))) {
                parametresDatex2.setValeur("ACCIDENT_NB_MOTOS", (Object)"1");
                parametresDatex2.setValeur("ACCIDENT_NB_VELOS", (Object)"1");
            } else if (VehicleTypeEnum.bicycle.equals(vehicleCharacteristics.getVehicleType(0))) {
                parametresDatex2.setValeur("ACCIDENT_NB_VELOS", (Object)"1");
            } else if (VehicleTypeEnum.moped.equals(vehicleCharacteristics.getVehicleType(0))) {
                parametresDatex2.setValeur("ACCIDENT_NB_MOTOS", (Object)"1");
            } else if (VehicleTypeEnum.motorcycle.equals(vehicleCharacteristics.getVehicleType(0))) {
                parametresDatex2.setValeur("ACCIDENT_NB_MOTOS", (Object)"1");
            } else if (VehicleTypeEnum.motorcycleWithSideCar.equals(vehicleCharacteristics.getVehicleType(0))) {
                parametresDatex2.setValeur("ACCIDENT_NB_MOTOS", (Object)"1");
            } else if (VehicleTypeEnum.motorscooter.equals(vehicleCharacteristics.getVehicleType(0))) {
                parametresDatex2.setValeur("ACCIDENT_NB_MOTOS", (Object)"1");
            } else if (VehicleTypeEnum.threeWheeledVehicle.equals(vehicleCharacteristics.getVehicleType(0))) {
                parametresDatex2.setValeur("ACCIDENT_NB_MOTOS", (Object)"1");
            } else if (VehicleTypeEnum.tram.equals(vehicleCharacteristics.getVehicleType(0))) {
                parametresDatex2.setValeur("ACCIDENT_NB_TRAMWAYS", (Object)"1");
            } else if (VehicleTypeEnum.agriculturalVehicle.equals(vehicleCharacteristics.getVehicleType(0))) {
                parametresDatex2.setValeur("ACCIDENT_NB_ENGINSAGRICOLES", (Object)"1");
            } else if (VehicleTypeEnum.other.equals(vehicleCharacteristics.getVehicleType(0))) {
                if (generalPublicComment != null) {
                    Comment[] commentArray = generalPublicComment;
                    int n3 = generalPublicComment.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Comment comment = commentArray[n4];
                        if (comment.getCommentType().equals(CommentTypeEnum.internalNote) && comment.getComment() != null && comment.getComment().getValues() != null) {
                            MultilingualStringValue[] multilingualStringValueArray = comment.getComment().getValues();
                            int n5 = multilingualStringValueArray.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                MultilingualStringValue value = multilingualStringValueArray[n6];
                                if (value.getValue() != null && value.getValue().indexOf("Implique un train", 0) >= 0) {
                                    parametresDatex2.setValeur("ACCIDENT_NB_TRAINS", (Object)"1");
                                }
                                ++n6;
                            }
                        }
                        ++n4;
                    }
                }
                parametresDatex2.setValeur("ACCIDENT_NB_AUTRES", (Object)"1");
            }
            ++n2;
        }
        this.LOGGER.debug((Object)"</defineVehiclesInvolved>");
    }

    @Override
    public void defineVehiclesNetworkManagement(Extension parametresDatex2, NetworkManagement networkManagement) {
        VehicleCharacteristics[] vehiclesCharacteristics = networkManagement.getForVehiclesWithCharacteristicsOf();
        if (vehiclesCharacteristics != null && vehiclesCharacteristics.length > 0) {
            this.LOGGER.debug((Object)"<forVehiclesWithCharacteristicsOf>");
            VehicleCharacteristics vehicleCharacteristics = vehiclesCharacteristics[0];
            if (VehicleTypeEnum.anyVehicle.equals(vehiclesCharacteristics[0].getVehicleType()[0])) {
                parametresDatex2.setValeur("VEHCIULES_CONCERNES", (Object)"VEHCIULES_CONCERNES_TOUSVEHICULES");
            } else if (VehicleTypeEnum.other.equals(vehiclesCharacteristics[0].getVehicleType()[0])) {
                parametresDatex2.setValeur("VEHCIULES_CONCERNES", (Object)"VEHCIULES_CONCERNES_AUTRE");
                MessageElement[] messagesElement = vehicleCharacteristics.getVehicleCharacteristicsExtension().get_any();
                try {
                    String valeur = (String)messagesElement[0].getObjectValue(String.class);
                    parametresDatex2.setValeur("DESCRIPTION_VEHICULE", (Object)valeur);
                }
                catch (Exception e) {
                    this.LOGGER.debug((Object)"Erreur lors de la r\u00e9cup\u00e9ration de la description Vehicle", (Throwable)e);
                }
            } else {
                this.LOGGER.debug((Object)"<grossWeightCharacteristic>");
                GrossWeightCharacteristic grossWeightCharacteristic = vehicleCharacteristics.getGrossWeightCharacteristic()[0];
                if (ComparisonOperatorEnum.lessThanOrEqualTo.equals(grossWeightCharacteristic.getComparisonOperator()) && grossWeightCharacteristic.getGrossVehicleWeight() == 19.0f) {
                    parametresDatex2.setValeur("VEHCIULES_CONCERNES", (Object)"VEHCIULES_CONCERNES_VEHICULES_INFEGA19T");
                } else if (ComparisonOperatorEnum.greaterThan.equals(grossWeightCharacteristic.getComparisonOperator()) && grossWeightCharacteristic.getGrossVehicleWeight() == 19.0f) {
                    parametresDatex2.setValeur("VEHCIULES_CONCERNES", (Object)"VEHCIULES_CONCERNES_VEHICULES_SUP19T");
                } else if (ComparisonOperatorEnum.lessThanOrEqualTo.equals(grossWeightCharacteristic.getComparisonOperator()) && grossWeightCharacteristic.getGrossVehicleWeight() == 7.5f) {
                    parametresDatex2.setValeur("VEHCIULES_CONCERNES", (Object)"VEHCIULES_CONCERNES_VEHICULES_INFEGA7P5T");
                } else {
                    parametresDatex2.setValeur("VEHCIULES_CONCERNES", (Object)"VEHCIULES_CONCERNES_VEHICULES_SUP7P5T");
                }
                this.LOGGER.debug((Object)"</grossWeightCharacteristic>");
            }
            networkManagement.setForVehiclesWithCharacteristicsOf(new VehicleCharacteristics[]{vehicleCharacteristics});
            this.LOGGER.debug((Object)"</forVehiclesWithCharacteristicsOf>");
        }
    }

    @Override
    public void defineGroupOfVehiclesInvolved(Extension parametresDatex2, GroupOfVehiclesInvolved[] vehiclesInvolved, Comment[] generalPublicComment) {
        this.LOGGER.debug((Object)"<defineGroupOfVehiclesInvolved>");
        if (vehiclesInvolved != null) {
            GroupOfVehiclesInvolved[] groupOfVehiclesInvolvedArray = vehiclesInvolved;
            int n = vehiclesInvolved.length;
            int n2 = 0;
            while (n2 < n) {
                GroupOfVehiclesInvolved onVehiclesInvolved = groupOfVehiclesInvolvedArray[n2];
                if (VehicleTypeEnum.car.equals(onVehiclesInvolved.getVehicleCharacteristics().getVehicleType()[0])) {
                    if (onVehiclesInvolved.getNumberOfVehicles() != null) {
                        parametresDatex2.setValeur("ACCIDENT_NB_VEHICULES", (Object)Long.toString(onVehiclesInvolved.getNumberOfVehicles().longValue()));
                    }
                    if (onVehiclesInvolved.getVehicleStatus() != null) {
                        parametresDatex2.setValeur("ACCIDENT_NB_VEHICULES", (Object)onVehiclesInvolved.getVehicleStatus().toString());
                    }
                }
                if (VehicleTypeEnum.lorry.equals(onVehiclesInvolved.getVehicleCharacteristics().getVehicleType()[0])) {
                    if (onVehiclesInvolved.getNumberOfVehicles() != null) {
                        parametresDatex2.setValeur("ACCIDENT_NB_PL", (Object)Long.toString(onVehiclesInvolved.getNumberOfVehicles().longValue()));
                    }
                    if (onVehiclesInvolved.getVehicleStatus() != null) {
                        parametresDatex2.setValeur("ACCIDENT_NB_PL", (Object)onVehiclesInvolved.getVehicleStatus().toString());
                    }
                    if (LoadTypeEnum.hazardousMaterials.equals(onVehiclesInvolved.getVehicleCharacteristics().getLoadType())) {
                        parametresDatex2.setValeur("ACCIDENT_TMD", (Object)"1");
                    }
                }
                if (VehicleTypeEnum.bus.equals(onVehiclesInvolved.getVehicleCharacteristics().getVehicleType()[0])) {
                    if (onVehiclesInvolved.getNumberOfVehicles() != null) {
                        parametresDatex2.setValeur("ACCIDENT_NB_BUS", (Object)Long.toString(onVehiclesInvolved.getNumberOfVehicles().longValue()));
                    }
                    if (onVehiclesInvolved.getVehicleStatus() != null) {
                        parametresDatex2.setValeur("ACCIDENT_NB_BUS", (Object)onVehiclesInvolved.getVehicleStatus().toString());
                    }
                }
                if (VehicleTypeEnum.bicycle.equals(onVehiclesInvolved.getVehicleCharacteristics().getVehicleType()[0])) {
                    if (onVehiclesInvolved.getNumberOfVehicles() != null) {
                        parametresDatex2.setValeur("ACCIDENT_NB_VELOS", (Object)Long.toString(onVehiclesInvolved.getNumberOfVehicles().longValue()));
                    }
                    if (onVehiclesInvolved.getVehicleStatus() != null) {
                        parametresDatex2.setValeur("ACCIDENT_NB_VELOS", (Object)onVehiclesInvolved.getVehicleStatus().toString());
                    }
                }
                if (VehicleTypeEnum.twoWheeledVehicle.equals(onVehiclesInvolved.getVehicleCharacteristics().getVehicleType()[0])) {
                    if (onVehiclesInvolved.getNumberOfVehicles() != null) {
                        parametresDatex2.setValeur("ACCIDENT_NB_DEUXROUES", (Object)Long.toString(onVehiclesInvolved.getNumberOfVehicles().longValue()));
                    }
                    if (onVehiclesInvolved.getVehicleStatus() != null) {
                        parametresDatex2.setValeur("ACCIDENT_STATUS_DEUXROUES", (Object)onVehiclesInvolved.getVehicleStatus().toString());
                    }
                }
                if (VehicleTypeEnum.carWithCaravan.equals(onVehiclesInvolved.getVehicleCharacteristics().getVehicleType()[0])) {
                    if (onVehiclesInvolved.getNumberOfVehicles() != null) {
                        parametresDatex2.setValeur("ACCIDENT_NB_CARAVANES", (Object)Long.toString(onVehiclesInvolved.getNumberOfVehicles().longValue()));
                    }
                    if (onVehiclesInvolved.getVehicleStatus() != null) {
                        parametresDatex2.setValeur("ACCIDENT_STATUS_CARAVANES", (Object)onVehiclesInvolved.getVehicleStatus().toString());
                    }
                }
                if (VehicleTypeEnum.other.equals(onVehiclesInvolved.getVehicleCharacteristics().getVehicleType()[0])) {
                    boolean found = false;
                    if (generalPublicComment != null) {
                        Comment[] commentArray = generalPublicComment;
                        int n3 = generalPublicComment.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Comment comment = commentArray[n4];
                            if (comment.getCommentType().equals(CommentTypeEnum.internalNote) && comment.getComment() != null && comment.getComment().getValues() != null) {
                                MultilingualStringValue[] multilingualStringValueArray = comment.getComment().getValues();
                                int n5 = multilingualStringValueArray.length;
                                int n6 = 0;
                                while (n6 < n5) {
                                    MultilingualStringValue value = multilingualStringValueArray[n6];
                                    if (value.getValue() != null && value.getValue().indexOf("train", 0) >= 0) {
                                        if (onVehiclesInvolved.getNumberOfVehicles() != null) {
                                            parametresDatex2.setValeur("ACCIDENT_NB_TRAINS", (Object)Long.toString(onVehiclesInvolved.getNumberOfVehicles().longValue()));
                                        }
                                        if (onVehiclesInvolved.getVehicleStatus() != null) {
                                            parametresDatex2.setValeur("ACCIDENT_STATUS_TRAINS", (Object)onVehiclesInvolved.getVehicleStatus().toString());
                                        }
                                        found = true;
                                    }
                                    if (value.getValue() != null && value.getValue().indexOf("pi\u00e9ton", 0) >= 0) {
                                        if (onVehiclesInvolved.getNumberOfVehicles() != null) {
                                            parametresDatex2.setValeur("ACCIDENT_NB_PIETONS", (Object)Long.toString(onVehiclesInvolved.getNumberOfVehicles().longValue()));
                                        }
                                        if (onVehiclesInvolved.getVehicleStatus() != null) {
                                            parametresDatex2.setValeur("ACCIDENT_STATUS_PIETONS", (Object)onVehiclesInvolved.getVehicleStatus().toString());
                                        }
                                        found = true;
                                    }
                                    ++n6;
                                }
                            }
                            ++n4;
                        }
                    }
                    if (!found) {
                        if (onVehiclesInvolved.getNumberOfVehicles() != null) {
                            parametresDatex2.setValeur("ACCIDENT_NB_AUTRES", (Object)Long.toString(onVehiclesInvolved.getNumberOfVehicles().longValue()));
                        }
                        if (onVehiclesInvolved.getVehicleStatus() != null) {
                            parametresDatex2.setValeur("ACCIDENT_NB_AUTRES", (Object)onVehiclesInvolved.getVehicleStatus().toString());
                        }
                    }
                }
                if (VehicleTypeEnum.tram.equals(onVehiclesInvolved.getVehicleCharacteristics().getVehicleType()[0])) {
                    if (onVehiclesInvolved.getNumberOfVehicles() != null) {
                        parametresDatex2.setValeur("ACCIDENT_NB_TRAMWAYS", (Object)Long.toString(onVehiclesInvolved.getNumberOfVehicles().longValue()));
                    }
                    if (onVehiclesInvolved.getVehicleStatus() != null) {
                        parametresDatex2.setValeur("ACCIDENT_STATUS_TRAMWAYS", (Object)onVehiclesInvolved.getVehicleStatus().toString());
                    }
                }
                if (VehicleTypeEnum.agriculturalVehicle.equals(onVehiclesInvolved.getVehicleCharacteristics().getVehicleType()[0])) {
                    if (onVehiclesInvolved.getNumberOfVehicles() != null) {
                        parametresDatex2.setValeur("ACCIDENT_NB_ENGINSAGRICOLES", (Object)Long.toString(onVehiclesInvolved.getNumberOfVehicles().longValue()));
                    }
                    if (onVehiclesInvolved.getVehicleStatus() != null) {
                        parametresDatex2.setValeur("ACCIDENT_STATUS_ENGINSAGRICOLES", (Object)onVehiclesInvolved.getVehicleStatus().toString());
                    }
                }
                if (VehicleTypeEnum.motorcycle.equals(onVehiclesInvolved.getVehicleCharacteristics().getVehicleType()[0])) {
                    if (onVehiclesInvolved.getNumberOfVehicles() != null) {
                        parametresDatex2.setValeur("ACCIDENT_NB_MOTOS", (Object)Long.toString(onVehiclesInvolved.getNumberOfVehicles().longValue()));
                    }
                    if (onVehiclesInvolved.getVehicleStatus() != null) {
                        parametresDatex2.setValeur("ACCIDENT_NB_MOTOS", (Object)onVehiclesInvolved.getVehicleStatus().toString());
                    }
                }
                ++n2;
            }
        }
        this.LOGGER.debug((Object)"</defineVehiclesInvolved>");
    }

    @Override
    public void defineGroupOfPeopleInvolved(Extension parametresDatex2, GroupOfPeopleInvolved[] peopleInvolved) {
        this.LOGGER.debug((Object)"<defineGroupOfPeopleInvolved>");
        if (peopleInvolved != null) {
            GroupOfPeopleInvolved[] groupOfPeopleInvolvedArray = peopleInvolved;
            int n = peopleInvolved.length;
            int n2 = 0;
            while (n2 < n) {
                GroupOfPeopleInvolved onPeopleInvolved = groupOfPeopleInvolvedArray[n2];
                if (InvolvementRolesEnum.pedestrian.equals(onPeopleInvolved.getInvolvementRole())) {
                    if (onPeopleInvolved.getNumberOfPeople() != null) {
                        parametresDatex2.setValeur("ACCIDENT_PIETONS_IMPLIQUES", (Object)Long.toString(onPeopleInvolved.getNumberOfPeople().longValue()));
                    } else {
                        parametresDatex2.setValeur("ACCIDENT_PIETONS_IMPLIQUES", (Object)"1");
                    }
                }
                if (InjuryStatusTypeEnum.seriouslyInjured.equals(onPeopleInvolved.getInjuryStatus())) {
                    if (onPeopleInvolved.getNumberOfPeople() != null) {
                        parametresDatex2.setValeur("ACCIDENT_PERSONNES_BLESSEES", (Object)Long.toString(onPeopleInvolved.getNumberOfPeople().longValue()));
                    } else {
                        parametresDatex2.setValeur("ACCIDENT_PERSONNES_BLESSEES", (Object)"1");
                    }
                }
                if (InjuryStatusTypeEnum.injured.equals(onPeopleInvolved.getInjuryStatus())) {
                    if (onPeopleInvolved.getNumberOfPeople() != null) {
                        parametresDatex2.setValeur("ACCIDENT_PERSONNES_BLESSEES", (Object)Long.toString(onPeopleInvolved.getNumberOfPeople().longValue()));
                    } else {
                        parametresDatex2.setValeur("ACCIDENT_PERSONNES_BLESSEES", (Object)"1");
                    }
                }
                if (InjuryStatusTypeEnum.dead.equals(onPeopleInvolved.getInjuryStatus())) {
                    if (onPeopleInvolved.getNumberOfPeople() != null) {
                        parametresDatex2.setValeur("ACCIDENT_PERSONNES_TUEES", (Object)Long.toString(onPeopleInvolved.getNumberOfPeople().longValue()));
                    } else {
                        parametresDatex2.setValeur("ACCIDENT_PERSONNES_TUEES", (Object)"1");
                    }
                }
                if (PersonCategoryEnum.child.equals(onPeopleInvolved.getCategoryOfPeopleInvolved())) {
                    if (onPeopleInvolved.getNumberOfPeople() != null) {
                        parametresDatex2.setValeur("ACCIDENT_PERSONNES_IMPLIQUEES_ENFANTS", (Object)Long.toString(onPeopleInvolved.getNumberOfPeople().longValue()));
                    } else {
                        parametresDatex2.setValeur("ACCIDENT_PERSONNES_IMPLIQUEES_ENFANTS", (Object)"1");
                    }
                }
                if (PersonCategoryEnum.veryImportantPerson.equals(onPeopleInvolved.getCategoryOfPeopleInvolved())) {
                    if (onPeopleInvolved.getNumberOfPeople() != null) {
                        parametresDatex2.setValeur("ACCIDENT_PERSONNES_IMPLIQUEES_VIP", (Object)Long.toString(onPeopleInvolved.getNumberOfPeople().longValue()));
                    } else {
                        parametresDatex2.setValeur("ACCIDENT_PERSONNES_IMPLIQUEES_VIP", (Object)"1");
                    }
                }
                if (PersonCategoryEnum.emergencyServicesPerson.equals(onPeopleInvolved.getCategoryOfPeopleInvolved())) {
                    if (onPeopleInvolved.getNumberOfPeople() != null) {
                        parametresDatex2.setValeur("ACCIDENT_PERSONNES_IMPLIQUEES_SERVICE_URGENCE", (Object)Long.toString(onPeopleInvolved.getNumberOfPeople().longValue()));
                    } else {
                        parametresDatex2.setValeur("ACCIDENT_PERSONNES_IMPLIQUEES_SERVICE_URGENCE", (Object)"1");
                    }
                }
                if (PersonCategoryEnum.trafficOfficer.equals(onPeopleInvolved.getCategoryOfPeopleInvolved())) {
                    if (onPeopleInvolved.getNumberOfPeople() != null) {
                        parametresDatex2.setValeur("ACCIDENT_PERSONNES_IMPLIQUEES_GESTIONNAIRE_ROUTIER", (Object)Long.toString(onPeopleInvolved.getNumberOfPeople().longValue()));
                    } else {
                        parametresDatex2.setValeur("ACCIDENT_PERSONNES_IMPLIQUEES_GESTIONNAIRE_ROUTIER", (Object)"1");
                    }
                }
                if (PersonCategoryEnum.policeman.equals(onPeopleInvolved.getCategoryOfPeopleInvolved())) {
                    if (onPeopleInvolved.getNumberOfPeople() != null) {
                        parametresDatex2.setValeur("ACCIDENT_PERSONNES_IMPLIQUEES_FORCE_ORDRE", (Object)Long.toString(onPeopleInvolved.getNumberOfPeople().longValue()));
                    } else {
                        parametresDatex2.setValeur("ACCIDENT_PERSONNES_IMPLIQUEES_FORCE_ORDRE", (Object)"1");
                    }
                }
                ++n2;
            }
        }
        this.LOGGER.debug((Object)"</defineGroupOfPeopleInvolved>");
    }

    @Override
    public void genererSituationRecordTypeAccident(Extension parametresDatex2, Accident accident) {
        parametresDatex2.setValeur("descriptionEvenement", (Object)"TYPE_ACCIDENT");
        this.defineGroupOfVehiclesInvolved(parametresDatex2, accident.getGroupOfVehiclesInvolved(), accident.getGeneralPublicComment());
        AccidentTypeEnum[] accidentTypeEnumArray = accident.getAccidentType();
        int n = accidentTypeEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            Comment[] generalPublicComment;
            AccidentTypeEnum accidentType = accidentTypeEnumArray[n2];
            if (AccidentTypeEnum.accident.equals(accidentType) && (generalPublicComment = accident.getGeneralPublicComment()) != null) {
                Comment[] commentArray = generalPublicComment;
                int n3 = generalPublicComment.length;
                int n4 = 0;
                while (n4 < n3) {
                    Comment comment = commentArray[n4];
                    if (comment.getCommentType().equals(CommentTypeEnum.internalNote) && comment.getComment() != null && comment.getComment().getValues() != null) {
                        MultilingualStringValue[] multilingualStringValueArray = comment.getComment().getValues();
                        int n5 = multilingualStringValueArray.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            MultilingualStringValue value = multilingualStringValueArray[n6];
                            if (value.getValue() != null && value.getValue().indexOf("Mati\u00e8re dangereuse transport\u00e9e", 0) >= 0) {
                                parametresDatex2.setValeur("ACCIDENT_FACTAUERAGGRAVANT_TMD", (Object)true);
                            }
                            if (value.getValue() != null && value.getValue().indexOf("Accident concernant des transports publics", 0) >= 0) {
                                parametresDatex2.setValeur("ACCIDENT_FACTAUERAGGRAVANT_TC", (Object)true);
                            }
                            if (value.getValue() != null && value.getValue().indexOf("Carambolage impliquant au moins", 0) >= 0) {
                                parametresDatex2.setValeur("ACCIDENT_FACTAUERAGGRAVANT_CARAMBOLAGE", (Object)true);
                            }
                            ++n6;
                        }
                    }
                    ++n4;
                }
            }
            if (AccidentTypeEnum.multivehicleAccident.equals(accidentType)) {
                parametresDatex2.setValeur("ACCIDENT_FACTAUERAGGRAVANT_CARAMBOLAGE", (Object)true);
            }
            if (AccidentTypeEnum.accidentInvolvingBuses.equals(accidentType)) {
                parametresDatex2.setValeur("ACCIDENT_FACTAUERAGGRAVANT_TC", (Object)true);
            }
            if (AccidentTypeEnum.accidentInvolvingHazardousMaterials.equals(accidentType)) {
                parametresDatex2.setValeur("ACCIDENT_FACTAUERAGGRAVANT_TMD", (Object)true);
            }
            if (AccidentTypeEnum.accidentInvolvingRadioactiveMaterial.equals(accidentType)) {
                parametresDatex2.setValeur("ACCIDENT_FACTAUERAGGRAVANT_TMD", (Object)true);
            }
            if (AccidentTypeEnum.fuelSpillageAccident.equals(accidentType)) {
                parametresDatex2.setValeur("ACCIDENT_FACTAUERAGGRAVANT_TMD", (Object)true);
            }
            if (AccidentTypeEnum.oilSpillageAccident.equals(accidentType)) {
                parametresDatex2.setValeur("ACCIDENT_FACTAUERAGGRAVANT_TMD", (Object)true);
            }
            if (AccidentTypeEnum.accidentInvolvingMassTransitVehicle.equals(accidentType)) {
                parametresDatex2.setValeur("ACCIDENT_FACTAUERAGGRAVANT_PL", (Object)true);
            }
            if (AccidentTypeEnum.overturnedHeavyLorry.equals(accidentType)) {
                parametresDatex2.setValeur("ACCIDENT_FACTAUERAGGRAVANT_PL", (Object)true);
            }
            ++n2;
        }
        this.defineGroupOfPeopleInvolved(parametresDatex2, accident.getGroupOfPeopleInvolved());
    }

    public void genererSituationRecordTypeAbnormalTraffic(Extension parametresDatex2, AbnormalTraffic abnormalTraffic) {
        parametresDatex2.setValeur("descriptionEvenement", (Object)"TYPE_BOUCHON");
        if (!AbnormalTrafficTypeEnum.heavyTraffic.equals(abnormalTraffic.getAbnormalTrafficType()) && !AbnormalTrafficTypeEnum.other.equals(abnormalTraffic.getAbnormalTrafficType())) {
            if (AbnormalTrafficTypeEnum.queuingTraffic.equals(abnormalTraffic.getAbnormalTrafficType())) {
                parametresDatex2.setValeur("TYPE_BOUCHON", (Object)"typeBouchon");
                parametresDatex2.setValeur("descriptionEvenement", (Object)"typeBouchon");
            } else if (AbnormalTrafficTypeEnum.slowTraffic.equals(abnormalTraffic.getAbnormalTrafficType())) {
                parametresDatex2.setValeur("TYPE_BOUCHON", (Object)"typeRalentissement");
                parametresDatex2.setValeur("descriptionEvenement", (Object)"typeRalentissement");
            } else if (AbnormalTrafficTypeEnum.stationaryTraffic.equals(abnormalTraffic.getAbnormalTrafficType())) {
                parametresDatex2.setValeur("TYPE_BOUCHON", (Object)"typeCirculationBloquee");
                parametresDatex2.setValeur("descriptionEvenement", (Object)"typeCirculationBloquee");
                if (abnormalTraffic.getTrafficFlowCharacteristics() != null && TrafficFlowCharacteristicsEnum.stopAndGo.equals(abnormalTraffic.getTrafficFlowCharacteristics())) {
                    parametresDatex2.setValeur("TYPE_BOUCHON", (Object)"typeAccordeon");
                    parametresDatex2.setValeur("descriptionEvenement", (Object)"typeAccordeon");
                }
            } else {
                AbnormalTrafficTypeEnum.unspecifiedAbnormalTraffic.equals(abnormalTraffic.getAbnormalTrafficType());
            }
        }
        if (abnormalTraffic.getTrafficTrendType() != null) {
            if (TrafficTrendTypeEnum.trafficEasing.equals(abnormalTraffic.getTrafficTrendType())) {
                parametresDatex2.setValeur("TYPE_BOUCHON_TENDANCE", (Object)"TYPE_BOUCHON_TENDANCE_AMELIORATION");
            } else if (TrafficTrendTypeEnum.trafficStable.equals(abnormalTraffic.getTrafficTrendType())) {
                parametresDatex2.setValeur("TYPE_BOUCHON_TENDANCE", (Object)"TYPE_BOUCHON_TENDANCE_STABLE");
            } else if (TrafficTrendTypeEnum.trafficBuildingUp.equals(abnormalTraffic.getTrafficTrendType())) {
                parametresDatex2.setValeur("TYPE_BOUCHON_TENDANCE", (Object)"TYPE_BOUCHON_TENDANCE_DEGRADATION");
            }
        }
        if (abnormalTraffic.getRelativeTrafficFlow() != null) {
            if (RelativeTrafficFlowEnum.trafficVeryMuchHeavierThanNormal.equals(abnormalTraffic.getRelativeTrafficFlow())) {
                parametresDatex2.setValeur("TYPE_BOUCHON_NORMALITE", (Object)"TYPE_BOUCHON_NORMALITE_BIENPLUSCHARGE");
            } else if (RelativeTrafficFlowEnum.trafficHeavierThanNormal.equals(abnormalTraffic.getRelativeTrafficFlow())) {
                parametresDatex2.setValeur("TYPE_BOUCHON_NORMALITE", (Object)"TYPE_BOUCHON_NORMALITE_PLUSCHARGE");
            } else if (RelativeTrafficFlowEnum.trafficLighterThanNormal.equals(abnormalTraffic.getRelativeTrafficFlow())) {
                parametresDatex2.setValeur("TYPE_BOUCHON_NORMALITE", (Object)"TYPE_BOUCHON_NORMALITE_MOINSCHARGE");
            } else if (RelativeTrafficFlowEnum.trafficVeryMuchLighterThanNormal.equals(abnormalTraffic.getRelativeTrafficFlow())) {
                parametresDatex2.setValeur("TYPE_BOUCHON_NORMALITE", (Object)"TYPE_BOUCHON_NORMALITE_BIENMOINSCHARGE");
            } else if (RelativeTrafficFlowEnum.trafficFlowNormal.equals(abnormalTraffic.getRelativeTrafficFlow())) {
                parametresDatex2.setValeur("TYPE_BOUCHON_NORMALITE", (Object)"TYPE_BOUCHON_NORMALITE_COMMEHABITUDE");
            }
        }
        abnormalTraffic.getQueueLength();
        if (abnormalTraffic.getImpact() != null) {
            if (abnormalTraffic.getImpact().getNumberOfLanesRestricted() != null) {
                parametresDatex2.setValeur("TYPE_BOUCHON_VOIESCONCERNEES", (Object)String.valueOf(abnormalTraffic.getImpact().getNumberOfLanesRestricted().intValue()));
            }
            if (abnormalTraffic.getImpact().getOriginalNumberOfLanes() != null) {
                parametresDatex2.setValeur("TYPE_BOUCHON_VOIESNORMALES", (Object)String.valueOf(abnormalTraffic.getImpact().getOriginalNumberOfLanes().intValue()));
            }
        }
    }

    @Override
    public void genererMobilityType(Extension parametresDatex2, Obstruction obstruction) {
        if (obstruction.getMobilityOfObstruction() != null && obstruction.getMobilityOfObstruction().getMobilityType() != null) {
            if (MobilityEnum.mobile.equals(obstruction.getMobilityOfObstruction().getMobilityType())) {
                parametresDatex2.setValeur("TYPE_OBSTACLE_MOBILITE", (Object)"Mobile");
            } else if (MobilityEnum.stationary.equals(obstruction.getMobilityOfObstruction().getMobilityType())) {
                parametresDatex2.setValeur("TYPE_OBSTACLE_MOBILITE", (Object)"Fixe");
            }
        }
    }

    @Override
    public void genererSituationRecordTypeVehicleObstruction(Extension parametresDatex2, VehicleObstruction vehicleObstruction) {
        Comment[] generalPublicComment = vehicleObstruction.getGeneralPublicComment();
        parametresDatex2.setValeur("descriptionEvenement", (Object)"typeObstacleVehicule");
        switch (vehicleObstruction.getVehicleObstructionType().getValue()) {
            case "abandonedVehicle": {
                parametresDatex2.setValeur("TYPE_OBSTACLE", (Object)"TYPE_OBSTACLE_VEHICULE_ABANDONNE");
                break;
            }
            case "damagedVehicle": {
                parametresDatex2.setValeur("TYPE_OBSTACLE", (Object)"TYPE_OBSTACLE_VEHICULE_DIFFICULTE");
                break;
            }
            case "vehicleStuck": {
                parametresDatex2.setValeur("TYPE_OBSTACLE", (Object)"TYPE_OBSTACLE_VEHICULE_ARRETE");
                break;
            }
            case "brokenDownVehicle": {
                parametresDatex2.setValeur("TYPE_OBSTACLE", (Object)"TYPE_OBSTACLE_VEHICULE_PANNE");
                break;
            }
            case "vehicleOnWrongCarriageway": {
                parametresDatex2.setValeur("TYPE_OBSTACLE", (Object)"TYPE_OBSTACLE_VEHICULE_CONTRESENS");
                break;
            }
            case "slowVehicle": {
                parametresDatex2.setValeur("TYPE_OBSTACLE", (Object)"TYPE_OBSTACLE_VEHICULE_LENT");
                break;
            }
            case "vehicleOnFire": {
                parametresDatex2.setValeur("TYPE_OBSTACLE", (Object)"TYPE_OBSTACLE_VEHICULE_FEU");
                break;
            }
            case "abnormalLoad": {
                parametresDatex2.setValeur("TYPE_OBSTACLE", (Object)"TYPE_OBSTACLE_VEHICULE_CONVOI_EXCEPTIONNEL");
            }
        }
        if (vehicleObstruction.getObstructingVehicle() != null) {
            this.defineVehicles(parametresDatex2, vehicleObstruction.getObstructingVehicle(), generalPublicComment);
        }
    }

    @Override
    public void genererSituationRecordTypeGeneralObstruction(Extension parametresDatex2, GeneralObstruction generalObstruction) {
        Comment[] generalPublicComment = generalObstruction.getGeneralPublicComment();
        ObstructionTypeEnum[] obstructionTypeEnumArray = generalObstruction.getObstructionType();
        int n = obstructionTypeEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            ObstructionTypeEnum type = obstructionTypeEnumArray[n2];
            switch (type.getValue()) {
                case "explosion": {
                    parametresDatex2.setValeur("TYPE_OBSTACLE", (Object)"TYPE_OBSTACLE_INCIDENT_EXPLOSION");
                    parametresDatex2.setValeur("descriptionEvenement", (Object)"typeObstacleIncident");
                    break;
                }
                case "incident": {
                    parametresDatex2.setValeur("TYPE_OBSTACLE", (Object)"TYPE_OBSTACLE_INCIDENT_INCIDENT");
                    parametresDatex2.setValeur("descriptionEvenement", (Object)"typeObstacleIncident");
                    break;
                }
                case "industrialAccident": {
                    parametresDatex2.setValeur("TYPE_OBSTACLE", (Object)"TYPE_OBSTACLE_INCIDENT_INCENDIEINDUSTRIEL");
                    parametresDatex2.setValeur("descriptionEvenement", (Object)"typeObstacleIncident");
                    break;
                }
                case "objectOnTheRoad": {
                    parametresDatex2.setValeur("TYPE_OBSTACLE", (Object)"TYPE_OBSTACLE_EQUIPEMENT_EQUIPEMENTFAISANTOBSTACLE");
                    parametresDatex2.setValeur("descriptionEvenement", (Object)"typeObstacleEquipement");
                    break;
                }
                case "obstructionOnTheRoad": {
                    parametresDatex2.setValeur("TYPE_OBSTACLE", (Object)"TYPE_OBSTACLE_AUTRE_OBSTACLE");
                    parametresDatex2.setValeur("descriptionEvenement", (Object)"typeObstacleAutre");
                    break;
                }
                case "objectsFallingFromMovingVehicle": {
                    parametresDatex2.setValeur("TYPE_OBSTACLE", (Object)"TYPE_OBSTACLE_AUTRE_CHARGEMENTPERDU");
                    parametresDatex2.setValeur("descriptionEvenement", (Object)"typeObstacleAutre");
                    break;
                }
                case "cyclistsOnRoadway": {
                    parametresDatex2.setValeur("TYPE_OBSTACLE", (Object)"TYPE_OBSTACLE_AUTRE_CYCLISTE");
                    parametresDatex2.setValeur("descriptionEvenement", (Object)"typeObstacleAutre");
                    break;
                }
                case "peopleOnRoadway": {
                    parametresDatex2.setValeur("TYPE_OBSTACLE", (Object)"TYPE_OBSTACLE_AUTRE_PIETON");
                    parametresDatex2.setValeur("descriptionEvenement", (Object)"typeObstacleAutre");
                }
            }
            ++n2;
        }
    }

    @Override
    public void genererSituationRecordTypeAnimalPresenceObstruction(Extension parametresDatex2, AnimalPresenceObstruction animalPresenceObstruction) {
        Comment[] generalPublicComment = animalPresenceObstruction.getGeneralPublicComment();
        switch (animalPresenceObstruction.getAnimalPresenceType().getValue()) {
            case "animalsOnTheRoad": {
                if (animalPresenceObstruction.getAlive() == null) break;
                parametresDatex2.setValeur("descriptionEvenement", (Object)"typeObstacleAutre");
                if (animalPresenceObstruction.getAlive().booleanValue()) {
                    parametresDatex2.setValeur("TYPE_OBSTACLE", (Object)"TYPE_OBSTACLE_AUTRE_ANIMALERRANT");
                } else {
                    parametresDatex2.setValeur("TYPE_OBSTACLE", (Object)"TYPE_OBSTACLE_AUTRE_ANIMALECRASE");
                }
                boolean found = false;
                ArrayList<String> animaux = new ArrayList<String>();
                if (generalPublicComment != null) {
                    Comment[] commentArray = generalPublicComment;
                    int n = generalPublicComment.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Comment comment = commentArray[n2];
                        if (comment.getCommentType().equals(CommentTypeEnum.internalNote) && comment.getComment() != null && comment.getComment().getValues() != null) {
                            MultilingualStringValue[] multilingualStringValueArray = comment.getComment().getValues();
                            int n3 = multilingualStringValueArray.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                MultilingualStringValue value = multilingualStringValueArray[n4];
                                if (value.getValue() != null && value.getValue().indexOf("Sanglier", 0) >= 0) {
                                    animaux.add("Sanglier");
                                    found = true;
                                }
                                if (value.getValue() != null && value.getValue().indexOf("Chevreuil/biche", 0) >= 0) {
                                    animaux.add("Chevreuil/biche");
                                    found = true;
                                }
                                if (value.getValue() != null && value.getValue().indexOf("Cerf", 0) >= 0) {
                                    animaux.add("Cerf");
                                    found = true;
                                }
                                if (value.getValue() != null && value.getValue().indexOf("Chat", 0) >= 0) {
                                    animaux.add("Chat");
                                    found = true;
                                }
                                if (value.getValue() != null && value.getValue().indexOf("Cheval", 0) >= 0) {
                                    animaux.add("Cheval");
                                    found = true;
                                }
                                if (value.getValue() != null && value.getValue().indexOf("Chien", 0) >= 0) {
                                    animaux.add("Chien");
                                    found = true;
                                }
                                if (value.getValue() != null && value.getValue().indexOf("Blaireau", 0) >= 0) {
                                    animaux.add("Blaireau");
                                    found = true;
                                }
                                if (value.getValue() != null && value.getValue().indexOf("Faon", 0) >= 0) {
                                    animaux.add("Faon");
                                    found = true;
                                }
                                if (value.getValue() != null && value.getValue().indexOf("Renard", 0) >= 0) {
                                    animaux.add("Renard");
                                    found = true;
                                }
                                ++n4;
                            }
                        }
                        ++n2;
                    }
                }
                if (!found) {
                    animaux.add("Autre");
                }
                parametresDatex2.setValeur("TYPE_OBSTACLE_AUTRE_ANIMAL", animaux.get(0));
            }
        }
    }

    @Override
    public void genererSituationRecordTypeEnvironmentalObstruction(Extension parametresDatex2, EnvironmentalObstruction environmentalObstruction) {
        Comment[] generalPublicComment = environmentalObstruction.getGeneralPublicComment();
        switch (environmentalObstruction.getEnvironmentalObstructionType().getValue()) {
            case "seriousFire": {
                if (generalPublicComment == null) break;
                Comment[] commentArray = generalPublicComment;
                int n = generalPublicComment.length;
                int n2 = 0;
                while (n2 < n) {
                    Comment comment = commentArray[n2];
                    if (comment.getCommentType().equals(CommentTypeEnum.internalNote) && comment.getComment() != null && comment.getComment().getValues() != null) {
                        MultilingualStringValue[] multilingualStringValueArray = comment.getComment().getValues();
                        int n3 = multilingualStringValueArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            MultilingualStringValue value = multilingualStringValueArray[n4];
                            if (value.getValue() != null && value.getValue().indexOf("Incendie", 0) >= 0) {
                                parametresDatex2.setValeur("TYPE_OBSTACLE", (Object)"TYPE_OBSTACLE_INCIDENT_INCENDIE");
                                parametresDatex2.setValeur("descriptionEvenement", (Object)"typeObstacleIncident");
                            } else if (value.getValue() != null && value.getValue().indexOf("Feu de for\u00eat", 0) >= 0) {
                                parametresDatex2.setValeur("TYPE_OBSTACLE", (Object)"TYPE_OBSTACLE_INCIDENT_FEUFORET");
                                parametresDatex2.setValeur("descriptionEvenement", (Object)"typeObstacleIncident");
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
                break;
            }
            case "flooding": {
                parametresDatex2.setValeur("TYPE_OBSTACLE", (Object)"TYPE_OBSTACLE_INCIDENT_INONDATION");
                parametresDatex2.setValeur("descriptionEvenement", (Object)"typeObstacleIncident");
                break;
            }
            case "rockfalls": {
                parametresDatex2.setValeur("TYPE_OBSTACLE", (Object)"TYPE_OBSTACLE_INCIDENT_EBOULEMENENT");
                parametresDatex2.setValeur("descriptionEvenement", (Object)"typeObstacleIncident");
                break;
            }
            case "subsidence": {
                parametresDatex2.setValeur("TYPE_OBSTACLE", (Object)"TYPE_OBSTACLE_INCIDENT_EFFONDREMENT");
                parametresDatex2.setValeur("descriptionEvenement", (Object)"typeObstacleIncident");
                break;
            }
            case "landslips": {
                parametresDatex2.setValeur("TYPE_OBSTACLE", (Object)"TYPE_OBSTACLE_INCIDENT_GLISSEMENTTERRAIN");
                parametresDatex2.setValeur("descriptionEvenement", (Object)"typeObstacleIncident");
                break;
            }
            case "mudSlide": {
                parametresDatex2.setValeur("TYPE_OBSTACLE", (Object)"TYPE_OBSTACLE_INCIDENT_COULEEBOUE");
                parametresDatex2.setValeur("descriptionEvenement", (Object)"typeObstacleIncident");
                break;
            }
            case "fallenTrees": {
                parametresDatex2.setValeur("TYPE_OBSTACLE", (Object)"TYPE_OBSTACLE_AUTRE_ARBRE");
                parametresDatex2.setValeur("descriptionEvenement", (Object)"typeObstacleAutre");
            }
        }
    }

    @Override
    public void genererSituationRecordTypeEnvironmentalObstruction(Extension parametresDatex2, InfrastructureDamageObstruction infrastructureDamageObstruction) {
        Comment[] generalPublicComment = infrastructureDamageObstruction.getGeneralPublicComment();
        parametresDatex2.setValeur("descriptionEvenement", (Object)"typeObstacleEquipement");
        switch (infrastructureDamageObstruction.getInfrastructureDamageType().getValue()) {
            case "burstPipe": {
                parametresDatex2.setValeur("TYPE_OBSTACLE", (Object)"TYPE_OBSTACLE_EQUIPEMENT_ECLATEMENTCANALISATION");
                break;
            }
            case "gasLeak": {
                parametresDatex2.setValeur("TYPE_OBSTACLE", (Object)"TYPE_OBSTACLE_EQUIPEMENT_CANALISATIONGAZ");
                break;
            }
            case "fallenPowerCables": {
                parametresDatex2.setValeur("TYPE_OBSTACLE", (Object)"TYPE_OBSTACLE_EQUIPEMENT_CABLEHTSURCHAUSSEE");
                break;
            }
            case "damagedRoadSurface": {
                parametresDatex2.setValeur("TYPE_OBSTACLE", (Object)"TYPE_OBSTACLE_EQUIPEMENT_CHAUSSEEDEGRADE");
            }
        }
    }

    @Override
    public void genererSituationRecordTypeMaintenanceWorks(Extension parametresDatex2, MaintenanceWorks maintenanceWorks) {
    }

    @Override
    public void genererSituationRecordTypeWeatherRelatedRoadConditions(Extension parametresDatex2, WeatherRelatedRoadConditions weatherRelatedRoadConditions) {
    }

    public void genererSituationRecordTypeNonWeatherRelatedRoadConditions(Extension parametresDatex2, NonWeatherRelatedRoadConditions nonWeatherRelatedRoadConditions) {
        Comment[] generalPublicComment = nonWeatherRelatedRoadConditions.getGeneralPublicComment();
        parametresDatex2.setValeur("descriptionEvenement", (Object)"typeObstacleAutre");
        ArrayList<String> produits = new ArrayList<String>();
        NonWeatherRelatedRoadConditionTypeEnum[] nonWeatherRelatedRoadConditionTypeEnumArray = nonWeatherRelatedRoadConditions.getNonWeatherRelatedRoadConditionType();
        int n = nonWeatherRelatedRoadConditionTypeEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            NonWeatherRelatedRoadConditionTypeEnum type = nonWeatherRelatedRoadConditionTypeEnumArray[n2];
            switch (type.getValue()) {
                case "other": {
                    parametresDatex2.setValeur("TYPE_OBSTACLE", (Object)"TYPE_OBSTACLE_AUTRE_PRODUITSURCHAUSSEE");
                    if (generalPublicComment == null) break;
                    Comment[] commentArray = generalPublicComment;
                    int n3 = generalPublicComment.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Comment comment = commentArray[n4];
                        if (comment.getCommentType().equals(CommentTypeEnum.internalNote) && comment.getComment() != null && comment.getComment().getValues() != null) {
                            MultilingualStringValue[] multilingualStringValueArray = comment.getComment().getValues();
                            int n5 = multilingualStringValueArray.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                MultilingualStringValue value = multilingualStringValueArray[n6];
                                if (value.getValue() != null && value.getValue().indexOf("eau sur chauss\u00e9e", 0) >= 0) {
                                    produits.add("Eau");
                                } else if (value.getValue() != null && value.getValue().indexOf("liquide sur chauss\u00e9e", 0) >= 0) {
                                    produits.add("Lquide");
                                }
                                ++n6;
                            }
                        }
                        ++n4;
                    }
                    break;
                }
                case "dieselOnRoad": {
                    parametresDatex2.setValeur("TYPE_OBSTACLE", (Object)"TYPE_OBSTACLE_AUTRE_PRODUITSURCHAUSSEE");
                    break;
                }
                case "leavesOnRoad": {
                    parametresDatex2.setValeur("TYPE_OBSTACLE", (Object)"TYPE_OBSTACLE_AUTRE_PRODUITSURCHAUSSEE");
                    break;
                }
                case "looseChippings": {
                    parametresDatex2.setValeur("TYPE_OBSTACLE", (Object)"TYPE_OBSTACLE_AUTRE_PRODUITSURCHAUSSEE");
                    produits.add("Gravier");
                    break;
                }
                case "looseSandOnRoad": {
                    parametresDatex2.setValeur("TYPE_OBSTACLE", (Object)"TYPE_OBSTACLE_AUTRE_PRODUITSURCHAUSSEE");
                    produits.add("Sable");
                    break;
                }
                case "mudOnRoad": {
                    parametresDatex2.setValeur("TYPE_OBSTACLE", (Object)"TYPE_OBSTACLE_AUTRE_PRODUITSURCHAUSSEE");
                    produits.add("Boue");
                    break;
                }
                case "oilOnRoad": {
                    parametresDatex2.setValeur("TYPE_OBSTACLE", (Object)"TYPE_OBSTACLE_AUTRE_PRODUITSURCHAUSSEE");
                    produits.add("Huile");
                    break;
                }
                case "petrolOnRoad": {
                    parametresDatex2.setValeur("TYPE_OBSTACLE", (Object)"TYPE_OBSTACLE_AUTRE_PRODUITSURCHAUSSEE");
                    produits.add("Gazole");
                    break;
                }
                case "roadSurfaceInPoorCondition": {
                    parametresDatex2.setValeur("TYPE_OBSTACLE", (Object)"TYPE_OBSTACLE_AUTRE_PRODUITSURCHAUSSEE");
                    break;
                }
                case "slipperyRoad": {
                    parametresDatex2.setValeur("TYPE_OBSTACLE", (Object)"TYPE_OBSTACLE_AUTRE_PRODUITSURCHAUSSEE");
                }
            }
            ++n2;
        }
        parametresDatex2.setValeur("TYPE_OBSTACLE_AUTRE_PRODUIT", produits);
    }

    @Override
    public void genererSituationRecordTypeEquipmentOrSystemFault(Extension parametresDatex2, EquipmentOrSystemFault equipmentOrSystemFault) {
    }

    @Override
    public void genererSituationRecordTypePoorEnvironmentConditions(Extension parametresDatex2, PoorEnvironmentConditions poorEnvironmentConditions) {
        Comment[] generalPublicComment = poorEnvironmentConditions.getGeneralPublicComment();
        PoorEnvironmentTypeEnum[] poorEnvironmentTypeEnumArray = poorEnvironmentConditions.getPoorEnvironmentType();
        int n = poorEnvironmentTypeEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            PoorEnvironmentTypeEnum poor = poorEnvironmentTypeEnumArray[n2];
            switch (poor.getValue()) {
                case "smokeHazard": {
                    parametresDatex2.setValeur("TYPE_OBSTACLE", (Object)"TYPE_OBSTACLE_INCIDENT_FUMEE");
                    parametresDatex2.setValeur("descriptionEvenement", (Object)"typeObstacleIncident");
                }
            }
            ++n2;
        }
    }

    @Override
    public void genererSituationRecordTypeRoadOrCarriagewayOrLaneManagement(Extension parametresDatex2, RoadOrCarriagewayOrLaneManagement roadOrCarriagewayOrLaneManagement) {
    }

    @Override
    public void genererSituationRecordTypeReroutingManagement(Extension parametresDatex2, ReroutingManagement reroutingManagement) {
    }

    @Override
    public void genererSituationRecordTypeSpeedManagement(Extension parametresDatex2, SpeedManagement speedManagement) {
    }

    @Override
    public void genererSituationRecordType(Extension parametresDatex2, SituationRecord situationRecord) {
        if (situationRecord instanceof Accident) {
            this.genererSituationRecordTypeAccident(parametresDatex2, (Accident)situationRecord);
        } else if (situationRecord instanceof VehicleObstruction) {
            this.genererSituationRecordTypeVehicleObstruction(parametresDatex2, (VehicleObstruction)situationRecord);
        } else if (situationRecord instanceof EnvironmentalObstruction) {
            this.genererSituationRecordTypeEnvironmentalObstruction(parametresDatex2, (EnvironmentalObstruction)situationRecord);
        } else if (situationRecord instanceof PoorEnvironmentConditions) {
            this.genererSituationRecordTypePoorEnvironmentConditions(parametresDatex2, (PoorEnvironmentConditions)situationRecord);
        } else if (situationRecord instanceof GeneralObstruction) {
            this.genererSituationRecordTypeGeneralObstruction(parametresDatex2, (GeneralObstruction)situationRecord);
        } else if (situationRecord instanceof InfrastructureDamageObstruction) {
            this.genererSituationRecordTypeEnvironmentalObstruction(parametresDatex2, (InfrastructureDamageObstruction)situationRecord);
        } else if (situationRecord instanceof AnimalPresenceObstruction) {
            this.genererSituationRecordTypeAnimalPresenceObstruction(parametresDatex2, (AnimalPresenceObstruction)situationRecord);
        } else if (situationRecord instanceof AbnormalTraffic) {
            this.genererSituationRecordTypeAbnormalTraffic(parametresDatex2, (AbnormalTraffic)situationRecord);
        } else if (situationRecord instanceof MaintenanceWorks) {
            this.genererSituationRecordTypeMaintenanceWorks(parametresDatex2, (MaintenanceWorks)situationRecord);
        } else if (situationRecord instanceof WeatherRelatedRoadConditions) {
            this.genererSituationRecordTypeWeatherRelatedRoadConditions(parametresDatex2, (WeatherRelatedRoadConditions)situationRecord);
        } else if (situationRecord instanceof NonWeatherRelatedRoadConditions) {
            this.genererSituationRecordTypeNonWeatherRelatedRoadConditions(parametresDatex2, (NonWeatherRelatedRoadConditions)situationRecord);
        } else if (situationRecord instanceof EquipmentOrSystemFault) {
            this.genererSituationRecordTypeEquipmentOrSystemFault(parametresDatex2, (EquipmentOrSystemFault)situationRecord);
        } else if (situationRecord instanceof RoadOrCarriagewayOrLaneManagement) {
            this.genererSituationRecordTypeRoadOrCarriagewayOrLaneManagement(parametresDatex2, (RoadOrCarriagewayOrLaneManagement)situationRecord);
        } else if (situationRecord instanceof ReroutingManagement) {
            this.genererSituationRecordTypeReroutingManagement(parametresDatex2, (ReroutingManagement)situationRecord);
        } else if (situationRecord instanceof SpeedManagement) {
            this.genererSituationRecordTypeSpeedManagement(parametresDatex2, (SpeedManagement)situationRecord);
        }
        if (situationRecord instanceof Obstruction) {
            this.genererMobilityType(parametresDatex2, (Obstruction)situationRecord);
        }
    }

    @Override
    public void genererAlertcMethod4Linear(Extension parametresDatex2, AlertCMethod4Linear alertcMethod4Linear) throws Exception {
        parametresDatex2.setValeur("alertcCodePays", (Object)alertcMethod4Linear.getAlertCLocationCountryCode());
        parametresDatex2.setValeur("alertcTableNumber", (Object)alertcMethod4Linear.getAlertCLocationTableNumber());
        parametresDatex2.setValeur("alertcVersion", (Object)alertcMethod4Linear.getAlertCLocationTableVersion());
        this.genererAlertcDirection(parametresDatex2, alertcMethod4Linear.getAlertCDirection());
        this.genererAlertcMethod4PrimaryPointLocation(parametresDatex2, alertcMethod4Linear.getAlertCMethod4PrimaryPointLocation());
        this.genererAlertcMethod4SecondaryPointLocation(parametresDatex2, alertcMethod4Linear.getAlertCMethod4SecondaryPointLocation());
    }

    @Override
    public void genererAlertcDirection(Extension parametresDatex2, AlertCDirection alertcDirection) throws Exception {
        parametresDatex2.setValeur(LOCATION_ALERTC_DIRECTION, (Object)alertcDirection.getAlertCDirectionCoded().getValue());
    }

    @Override
    public boolean estPointAlertcIntersection(String alertcSubType) {
        return GLS.estDansLaListe((String[])ALERTC_SUBTYPE_INTERSECTION, (String)alertcSubType);
    }

    @Override
    public TpegLoc01SimplePointLocationSubtypeEnum getTPEGLoc01SimplePointLocationSubtype(String alertcSubType) {
        if (this.estPointAlertcIntersection(alertcSubType)) {
            return TpegLoc01SimplePointLocationSubtypeEnum.intersection;
        }
        return TpegLoc01SimplePointLocationSubtypeEnum.nonLinkedPoint;
    }

    @Override
    public String getPointCoordinates(Extension parametresDatex2, PointCoordinates pointCoordinates) throws Exception {
        if (pointCoordinates == null) {
            return null;
        }
        GeoPoint geoPoint = new GeoPoint(pointCoordinates.getLongitude(), pointCoordinates.getLatitude(), 0.0);
        return geoPoint.toString();
    }

    @Override
    public void genererTPEGOtherPointDescriptorsSecondary(Extension parametresDatex2, TpegOtherPointDescriptor[] tpegOtherPointDescriptor) throws Exception {
        if (tpegOtherPointDescriptor == null) {
            return;
        }
        TpegOtherPointDescriptor[] tpegOtherPointDescriptorArray = tpegOtherPointDescriptor;
        int n = tpegOtherPointDescriptor.length;
        int n2 = 0;
        while (n2 < n) {
            TpegOtherPointDescriptor tpegDesc = tpegOtherPointDescriptorArray[n2];
            if (TpegLoc03OtherPointDescriptorSubtypeEnum.townName.equals(tpegDesc.getTpegOtherPointDescriptorType())) {
                parametresDatex2.setValeur("communeSecondaire", (Object)this.recupererMultiLang(tpegDesc.getDescriptor(), new Language("fr")));
            } else if (TpegLoc03OtherPointDescriptorSubtypeEnum.linkName.equals(tpegDesc.getTpegOtherPointDescriptorType())) {
                parametresDatex2.setValeur("RouteSecondaire", (Object)this.recupererMultiLang(tpegDesc.getDescriptor(), new Language("fr")));
            }
            ++n2;
        }
    }

    @Override
    public void genererTPEGOtherPointDescriptorsPrimary(Extension parametresDatex2, TpegOtherPointDescriptor[] tpegOtherPointDescriptor) throws Exception {
        if (tpegOtherPointDescriptor == null) {
            return;
        }
        TpegOtherPointDescriptor[] tpegOtherPointDescriptorArray = tpegOtherPointDescriptor;
        int n = tpegOtherPointDescriptor.length;
        int n2 = 0;
        while (n2 < n) {
            TpegOtherPointDescriptor tpegDesc = tpegOtherPointDescriptorArray[n2];
            if (TpegLoc03OtherPointDescriptorSubtypeEnum.townName.equals(tpegDesc.getTpegOtherPointDescriptorType())) {
                parametresDatex2.setValeur("communePrimaire", (Object)this.recupererMultiLang(tpegDesc.getDescriptor(), new Language("fr")));
            } else if (TpegLoc03OtherPointDescriptorSubtypeEnum.linkName.equals(tpegDesc.getTpegOtherPointDescriptorType())) {
                parametresDatex2.setValeur("RoutePrimaire", (Object)this.recupererMultiLang(tpegDesc.getDescriptor(), new Language("fr")));
            }
            ++n2;
        }
    }

    @Override
    public void genererTPEGSimplePoint(Extension parametresDatex2, TpegSimplePoint tpegLocation) throws Exception {
        parametresDatex2.setValeur(LOCATION_TPEG_DIRECTION, (Object)tpegLocation.getTpegDirection());
        if (tpegLocation.getPoint() instanceof TpegNonJunctionPoint) {
            this.genererTPEGNonJunctionPrimary(parametresDatex2, (TpegNonJunctionPoint)tpegLocation.getPoint());
        } else {
            this.LOGGER.warn((Object)("localisation non trait\u00e9e : " + tpegLocation.getPoint()));
        }
    }

    @Override
    public void genererTPEGNonJunctionPrimary(Extension parametresDatex2, TpegNonJunctionPoint tpegNonJunctionPoint) throws Exception {
        if (tpegNonJunctionPoint.getPointCoordinates() != null) {
            parametresDatex2.setValeur("XYPrimaire", (Object)this.getPointCoordinates(parametresDatex2, tpegNonJunctionPoint.getPointCoordinates()));
            parametresDatex2.setValeur("LONPrimaire", (Object)Float.valueOf(tpegNonJunctionPoint.getPointCoordinates().getLongitude()));
            parametresDatex2.setValeur("LATPrimaire", (Object)Float.valueOf(tpegNonJunctionPoint.getPointCoordinates().getLatitude()));
        }
        this.genererTPEGOtherPointDescriptorsPrimary(parametresDatex2, tpegNonJunctionPoint.getName());
    }

    @Override
    public void genererTPEGNonJunctionSecondary(Extension parametresDatex2, TpegNonJunctionPoint tpegNonJunctionPoint) throws Exception {
        if (tpegNonJunctionPoint.getPointCoordinates() != null) {
            parametresDatex2.setValeur("XYSecondaire", (Object)this.getPointCoordinates(parametresDatex2, tpegNonJunctionPoint.getPointCoordinates()));
            parametresDatex2.setValeur("LONSecondaire", (Object)Float.valueOf(tpegNonJunctionPoint.getPointCoordinates().getLongitude()));
            parametresDatex2.setValeur("LATSecondaire", (Object)Float.valueOf(tpegNonJunctionPoint.getPointCoordinates().getLatitude()));
        }
        this.genererTPEGOtherPointDescriptorsSecondary(parametresDatex2, tpegNonJunctionPoint.getName());
    }

    @Override
    public void genererTPEGLinearLocation(Extension parametresDatex2, TpegLinearLocation tpegLocation) throws Exception {
        parametresDatex2.setValeur(LOCATION_TPEG_DIRECTION, (Object)tpegLocation.getTpegDirection());
        parametresDatex2.setValeur(LOCATION_TPEG_POINT_SUBTYPE, (Object)tpegLocation.getTpegLinearLocationType());
        if (tpegLocation.getFrom() instanceof TpegNonJunctionPoint) {
            this.genererTPEGNonJunctionPrimary(parametresDatex2, (TpegNonJunctionPoint)tpegLocation.getFrom());
        } else {
            this.LOGGER.warn((Object)("localisation non trait\u00e9e : " + tpegLocation.getFrom()));
        }
        if (tpegLocation.getTo() instanceof TpegNonJunctionPoint) {
            this.genererTPEGNonJunctionSecondary(parametresDatex2, (TpegNonJunctionPoint)tpegLocation.getTo());
        } else {
            this.LOGGER.warn((Object)("localisation non trait\u00e9e : " + tpegLocation.getTo()));
        }
    }

    @Override
    public void genererPointAlongLinearElement(Extension parametresDatex2, PointAlongLinearElement pointAlongLinearElement) {
        this.LOGGER.debug((Object)"<pointAlongLinearElement>");
        if (pointAlongLinearElement.getDistanceAlongLinearElement() instanceof DistanceFromLinearElementReferent) {
            DistanceFromLinearElementReferent distanceAlongLinearElement = (DistanceFromLinearElementReferent)pointAlongLinearElement.getDistanceAlongLinearElement();
            parametresDatex2.setValeur("prDistancePrimaire", (Object)Float.toString(distanceAlongLinearElement.getDistanceAlong()));
            Referent fromReferent = distanceAlongLinearElement.getFromReferent();
            parametresDatex2.setValeur("prPrimaire", (Object)fromReferent.getReferentIdentifier());
        }
        if (LinearReferencingDirectionEnum.aligned.equals(pointAlongLinearElement.getDirectionRelativeAtPoint())) {
            parametresDatex2.setValeur("prDirection", (Object)String.valueOf(1));
        } else if (LinearReferencingDirectionEnum.opposite.equals(pointAlongLinearElement.getDirectionRelativeAtPoint())) {
            parametresDatex2.setValeur("prDirection", (Object)String.valueOf(2));
        } else if (LinearReferencingDirectionEnum.both.equals(pointAlongLinearElement.getDirectionRelativeAtPoint())) {
            parametresDatex2.setValeur("prDirection", (Object)String.valueOf(3));
        } else {
            parametresDatex2.setValeur("prDirection", (Object)String.valueOf(0));
        }
        parametresDatex2.setValeur("departementPrimaire", (Object)this.recupererMultiLang(pointAlongLinearElement.getAdministrativeAreaOfPoint(), new Language("fr")));
        if (pointAlongLinearElement.getLinearElement() instanceof LinearElementByPoints) {
            this.genererLinearElementByPoints(parametresDatex2, (LinearElementByPoints)pointAlongLinearElement.getLinearElement());
        }
        this.LOGGER.debug((Object)"</pointAlongLinearElement>");
    }

    @Override
    public void genererLinearElement(Extension parametresDatex2, LinearElement linearElement) {
        this.LOGGER.debug((Object)"<linearElement>");
        parametresDatex2.setValeur("RoutePrimaire", (Object)linearElement.getRoadNumber());
        parametresDatex2.setValeur("RouteSecondaire", (Object)linearElement.getRoadNumber());
        this.LOGGER.debug((Object)"</linearElement>");
    }

    @Override
    public void genererLinearElementByPoints(Extension parametresDatex2, LinearElementByPoints linearElement) {
        this.LOGGER.debug((Object)"<linearElement>");
        parametresDatex2.setValeur("RoutePrimaire", (Object)linearElement.getRoadNumber());
        parametresDatex2.setValeur("RouteSecondaire", (Object)linearElement.getRoadNumber());
        parametresDatex2.setValeur("prPrimaire", (Object)linearElement.getStartPointOfLinearElement().getReferentIdentifier());
        parametresDatex2.setValeur("prSecondaire", (Object)linearElement.getEndPointOfLinearElement().getReferentIdentifier());
        this.LOGGER.debug((Object)"</linearElement>");
    }

    @Override
    public void genererLinearWithinLinearElement(Extension parametresDatex2, LinearWithinLinearElement linearWithinLinearElement) throws Exception {
        this.LOGGER.debug((Object)"<linearWithinLinearElement>");
        if (linearWithinLinearElement.getFromPoint() instanceof DistanceFromLinearElementStart) {
            DistanceFromLinearElementStart fromPoint = (DistanceFromLinearElementStart)linearWithinLinearElement.getFromPoint();
            parametresDatex2.setValeur("prDistancePrimaire", (Object)Float.valueOf(fromPoint.getDistanceAlong()));
            DistanceFromLinearElementStart toPoint = (DistanceFromLinearElementStart)linearWithinLinearElement.getToPoint();
            parametresDatex2.setValeur("prDistanceSecondaire", (Object)Float.valueOf(toPoint.getDistanceAlong()));
        } else if (linearWithinLinearElement.getFromPoint() instanceof DistanceFromLinearElementReferent) {
            DistanceFromLinearElementReferent distanceAlongLinearElement = (DistanceFromLinearElementReferent)linearWithinLinearElement.getFromPoint();
            parametresDatex2.setValeur("prDistancePrimaire", (Object)Float.toString(distanceAlongLinearElement.getDistanceAlong()));
            Referent fromReferent = distanceAlongLinearElement.getFromReferent();
            parametresDatex2.setValeur("prPrimaire", (Object)fromReferent.getReferentIdentifier());
            if (linearWithinLinearElement.getToPoint() != null) {
                distanceAlongLinearElement = (DistanceFromLinearElementReferent)linearWithinLinearElement.getToPoint();
                parametresDatex2.setValeur("prDistanceSecondaire", (Object)Float.toString(distanceAlongLinearElement.getDistanceAlong()));
                fromReferent = distanceAlongLinearElement.getFromReferent();
                parametresDatex2.setValeur("prSecondaire", (Object)fromReferent.getReferentIdentifier());
            }
        }
        if (LinearReferencingDirectionEnum.aligned.equals(linearWithinLinearElement.getDirectionRelativeOnLinearSection())) {
            parametresDatex2.setValeur("prDirection", (Object)String.valueOf(1));
        } else if (LinearReferencingDirectionEnum.opposite.equals(linearWithinLinearElement.getDirectionRelativeOnLinearSection())) {
            parametresDatex2.setValeur("prDirection", (Object)String.valueOf(2));
        } else if (LinearReferencingDirectionEnum.both.equals(linearWithinLinearElement.getDirectionRelativeOnLinearSection())) {
            parametresDatex2.setValeur("prDirection", (Object)String.valueOf(3));
        } else {
            parametresDatex2.setValeur("prDirection", (Object)String.valueOf(0));
        }
        if (linearWithinLinearElement.getLinearElement() instanceof LinearElementByPoints) {
            this.genererLinearElementByPoints(parametresDatex2, (LinearElementByPoints)linearWithinLinearElement.getLinearElement());
        }
        this.LOGGER.debug((Object)"</linearWithinLinearElement>");
    }

    @Override
    public void genererLinearWithinLinearElementList(Extension parametresDatex2, LinearWithinLinearElement linearWithinLinearElement) throws Exception {
        Referent fromReferent;
        DistanceFromLinearElementReferent distanceAlongLinearElement;
        this.LOGGER.debug((Object)"<linearWithinLinearElement>");
        if (linearWithinLinearElement.getFromPoint() instanceof DistanceFromLinearElementReferent) {
            distanceAlongLinearElement = (DistanceFromLinearElementReferent)linearWithinLinearElement.getFromPoint();
            parametresDatex2.setValeur("prDistancePrimaire", (Object)Float.toString(distanceAlongLinearElement.getDistanceAlong()));
            fromReferent = distanceAlongLinearElement.getFromReferent();
            parametresDatex2.setValeur("prPrimaire", (Object)fromReferent.getReferentIdentifier());
        }
        if (linearWithinLinearElement.getToPoint() instanceof DistanceFromLinearElementReferent) {
            distanceAlongLinearElement = (DistanceFromLinearElementReferent)linearWithinLinearElement.getToPoint();
            parametresDatex2.setValeur("prDistanceSecondaire", (Object)Float.toString(distanceAlongLinearElement.getDistanceAlong()));
            fromReferent = distanceAlongLinearElement.getFromReferent();
            parametresDatex2.setValeur("prSecondaire", (Object)fromReferent.getReferentIdentifier());
        }
        if (LinearReferencingDirectionEnum.aligned.equals(linearWithinLinearElement.getDirectionRelativeOnLinearSection())) {
            parametresDatex2.setValeur("prDirection", (Object)String.valueOf(1));
        } else if (LinearReferencingDirectionEnum.opposite.equals(linearWithinLinearElement.getDirectionRelativeOnLinearSection())) {
            parametresDatex2.setValeur("prDirection", (Object)String.valueOf(2));
        } else if (LinearReferencingDirectionEnum.both.equals(linearWithinLinearElement.getDirectionRelativeOnLinearSection())) {
            parametresDatex2.setValeur("prDirection", (Object)String.valueOf(3));
        } else {
            parametresDatex2.setValeur("prDirection", (Object)String.valueOf(0));
        }
        this.genererLinearElement(parametresDatex2, linearWithinLinearElement.getLinearElement());
        this.LOGGER.debug((Object)"</linearWithinLinearElement>");
    }

    @Override
    public void genererSupplementaryPositionDescription(Extension parametresDatex2, SupplementaryPositionalDescription suppPositionDesc) {
        if (suppPositionDesc != null) {
            this.LOGGER.debug((Object)"<supplementaryPositionalDescription>");
            AffectedCarriagewayAndLanes[] affectedCarriagewayAndLanes = suppPositionDesc.getAffectedCarriagewayAndLanes();
            StringBuffer sb = new StringBuffer();
            boolean first = true;
            if (affectedCarriagewayAndLanes != null) {
                AffectedCarriagewayAndLanes affectedCarriagewayAndLane = affectedCarriagewayAndLanes[0];
                if (affectedCarriagewayAndLane.getLane() != null) {
                    LaneEnum[] laneEnumArray = affectedCarriagewayAndLane.getLane();
                    int n = laneEnumArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        LaneEnum lane = laneEnumArray[n2];
                        if (first) {
                            first = false;
                        } else {
                            sb.append(",");
                        }
                        sb.append(lane.getValue());
                        ++n2;
                    }
                    parametresDatex2.setValeur("supplementaryPositionalDescription", (Object)"1");
                    parametresDatex2.setValeur("supplementaryPositionalDescriptionLanes", (Object)sb.toString());
                }
                parametresDatex2.setValeur("supplementaryPositionalDescriptionCarriage", (Object)affectedCarriagewayAndLane.getCarriageway());
            }
            this.LOGGER.debug((Object)"</supplementaryPositionalDescription>");
        }
    }

    @Override
    public TpegOtherPointDescriptor genererTPEGOtherPointDescriptor(TpegLoc03OtherPointDescriptorSubtypeEnum otherPointDescriptorSubtype, String tpegDescriptor) throws Exception {
        MultilingualStringValue multiVal = new MultilingualStringValue(tpegDescriptor);
        multiVal.setLang(new Language("fr"));
        MultilingualString descriptor = new MultilingualString(new MultilingualStringValue[]{multiVal});
        TpegOtherPointDescriptor otherPointDescriptor = new TpegOtherPointDescriptor();
        otherPointDescriptor.setTpegOtherPointDescriptorType(otherPointDescriptorSubtype);
        otherPointDescriptor.setDescriptor(descriptor);
        otherPointDescriptor.setTpegDescriptorExtension(new _ExtensionType());
        otherPointDescriptor.setTpegPointDescriptorExtension(new _ExtensionType());
        return otherPointDescriptor;
    }

    @Override
    public void genererAlertcMethod4PrimaryPointLocation(Extension parametresDatex2, AlertCMethod4PrimaryPointLocation alertCMethod4PrimaryPointLocation) throws Exception {
        AlertCLocation alertCLocation = alertCMethod4PrimaryPointLocation.getAlertCLocation();
        MultilingualString alertCLocationAlertCLocationName = alertCLocation.getAlertCLocationName();
        parametresDatex2.setValeur("alertcNomLocalisantDebut", (Object)this.recupererMultiLang(alertCLocationAlertCLocationName, new Language("fr")));
        parametresDatex2.setValeur("alertcLocalisantDebut", (Object)alertCLocation.getSpecificLocation().toString());
        parametresDatex2.setValeur("alertcDistanceLocalisantDebut", (Object)alertCMethod4PrimaryPointLocation.getOffsetDistance().getOffsetDistance().toString());
    }

    @Override
    public void genererAlertcMethod4SecondaryPointLocation(Extension parametresDatex2, AlertCMethod4SecondaryPointLocation alertCMethod4SecondaryPointLocation) throws Exception {
        AlertCLocation alertCLocation = alertCMethod4SecondaryPointLocation.getAlertCLocation();
        MultilingualString alertCLocationAlertCLocationName = alertCLocation.getAlertCLocationName();
        parametresDatex2.setValeur("alertcNomLocalisantSecondaire", (Object)this.recupererMultiLang(alertCLocationAlertCLocationName, new Language("fr")));
        parametresDatex2.setValeur("alertcLocalisantSecondaire", (Object)alertCLocation.getSpecificLocation().toString());
        parametresDatex2.setValeur("alertcDistanceLocalisantSecondaire", (Object)alertCMethod4SecondaryPointLocation.getOffsetDistance().getOffsetDistance().toString());
    }

    @Override
    public void genererAlertcMethod4Point(Extension parametresDatex2, AlertCMethod4Point alertCMethod4Point) throws Exception {
        parametresDatex2.setValeur("alertcCodePays", (Object)alertCMethod4Point.getAlertCLocationCountryCode());
        parametresDatex2.setValeur("alertcTableNumber", (Object)alertCMethod4Point.getAlertCLocationTableNumber());
        parametresDatex2.setValeur("alertcVersion", (Object)alertCMethod4Point.getAlertCLocationTableVersion());
        this.genererAlertcDirection(parametresDatex2, alertCMethod4Point.getAlertCDirection());
        this.genererAlertcMethod4PrimaryPointLocation(parametresDatex2, alertCMethod4Point.getAlertCMethod4PrimaryPointLocation());
    }

    @Override
    public void genererLocationCommune(Extension parametresDatex2, NetworkLocation location) throws Exception {
        this.LOGGER.debug((Object)"<groupOfLocations-commun>");
        if (location.getSupplementaryPositionalDescription() != null) {
            this.genererSupplementaryPositionDescription(parametresDatex2, location.getSupplementaryPositionalDescription());
        }
        if (location.getDestination() != null) {
            if (location.getDestination() instanceof AreaDestination) {
                this.genererAreaLocation(parametresDatex2, (AreaDestination)location.getDestination());
            } else {
                this.LOGGER.warn((Object)("localisation non g\u00e9r\u00e9e : " + location.getDestination()));
            }
        }
        this.LOGGER.debug((Object)"</groupOfLocations-commun>");
    }

    @Override
    public void genererLocation(Extension parametresDatex2, Point point) throws Exception {
        this.LOGGER.debug((Object)"<groupOfLocations>");
        parametresDatex2.setValeur("typeLocalisation", (Object)"Point");
        parametresDatex2.setValeur("XYPrimaire", (Object)this.getPointCoordinates(parametresDatex2, point.getLocationForDisplay()));
        if (point.getPointAlongLinearElement() != null) {
            this.genererPointAlongLinearElement(parametresDatex2, point.getPointAlongLinearElement());
        }
        if (point.getAlertCPoint() != null) {
            if (point.getAlertCPoint() instanceof AlertCMethod4Point) {
                this.genererAlertcMethod4Point(parametresDatex2, (AlertCMethod4Point)point.getAlertCPoint());
            } else {
                this.LOGGER.warn((Object)("Localisaiton non g\u00e9r\u00e9e : " + point.getAlertCPoint()));
            }
        }
        if (point.getTpegPointLocation() != null) {
            if (point.getTpegPointLocation() instanceof TpegSimplePoint) {
                this.genererTPEGSimplePoint(parametresDatex2, (TpegSimplePoint)point.getTpegPointLocation());
            } else {
                this.LOGGER.warn((Object)("Localisaiton non g\u00e9r\u00e9e : " + point.getTpegPointLocation()));
            }
        }
        this.genererLocationCommune(parametresDatex2, point);
        this.LOGGER.debug((Object)"</groupOfLocations>");
    }

    @Override
    public void genererLocation(Extension parametresDatex2, Linear linear) throws Exception {
        this.LOGGER.debug((Object)"<groupOfLocations>");
        parametresDatex2.setValeur("typeLocalisation", (Object)"Lin\u00e9aire");
        if (linear.getAlertCLinear() != null) {
            if (linear.getAlertCLinear() instanceof AlertCMethod4Linear) {
                this.genererAlertcMethod4Linear(parametresDatex2, (AlertCMethod4Linear)linear.getAlertCLinear());
            } else {
                this.LOGGER.warn((Object)("Localisation non trait\u00e9e : " + linear.getAlertCLinear()));
            }
        }
        if (linear.getTpegLinearLocation() != null) {
            if (linear.getTpegLinearLocation() instanceof TpegLinearLocation) {
                this.genererTPEGLinearLocation(parametresDatex2, linear.getTpegLinearLocation());
            } else {
                this.LOGGER.warn((Object)("Localisation non trait\u00e9e : " + linear.getTpegLinearLocation()));
            }
        }
        if (linear.getLinearWithinLinearElement() != null) {
            this.genererLinearWithinLinearElement(parametresDatex2, linear.getLinearWithinLinearElement());
        }
        this.genererLocationCommune(parametresDatex2, linear);
        this.LOGGER.debug((Object)"</groupOfLocations>");
    }

    @Override
    public void genererLocationList(Extension parametresDatex2, NonOrderedLocationGroupByList listLinear) throws Exception {
        this.LOGGER.debug((Object)"<groupOfLocations>");
        parametresDatex2.setValeur("typeLocalisation", (Object)"NonOrderedLocationGroupByList");
        Location[] locationContainedInGroup = listLinear.getLocationContainedInGroup();
        if (locationContainedInGroup != null) {
            if (locationContainedInGroup[0] instanceof Linear) {
                Linear linear = (Linear)locationContainedInGroup[0];
                this.genererLinearWithinLinearElementList(parametresDatex2, linear.getLinearWithinLinearElement());
                parametresDatex2.setValeur("XYPrimaire", (Object)this.getPointCoordinates(parametresDatex2, linear.getLocationForDisplay()));
            } else {
                this.LOGGER.warn((Object)"<groupOfLocations> de type Areau => Non g\u00e9r\u00e9");
            }
        } else {
            this.LOGGER.debug((Object)("<groupOfLocations> null pour" + parametresDatex2.getString("idSituationRecord")));
        }
        this.LOGGER.debug((Object)"</groupOfLocations>");
    }

    @Override
    public void genererAreaLocation(Extension parametresDatex2, AreaDestination destination) {
        Area areaLocation = destination.getArea();
        TpegNamedOnlyArea area = (TpegNamedOnlyArea)areaLocation.getTpegAreaLocation();
        TpegAreaDescriptor[] tpegAreaDescriptorArray = area.getName();
        int n = tpegAreaDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            TpegAreaDescriptor tpegDesc = tpegAreaDescriptorArray[n2];
            if (TpegLoc03AreaDescriptorSubtypeEnum.townName.equals(tpegDesc.getTpegAreaDescriptorType())) {
                parametresDatex2.setValeur("destination", (Object)this.recupererMultiLang(tpegDesc.getDescriptor(), new Language("fr")));
            }
            ++n2;
        }
    }

    @Override
    public VmsPictogramDisplayCharacteristics genererVmsPictogramDisplayCharacteristics(Extension parametresDatex2) {
        VmsPictogramDisplayCharacteristics vmsPictogramDisplayCharacteristics = new VmsPictogramDisplayCharacteristics();
        return vmsPictogramDisplayCharacteristics;
    }

    @Override
    public _VmsRecordPictogramDisplayAreaIndexVmsPictogramDisplayCharacteristics[] genererVmsRecordPictogramDisplayAreaIndexVmsPictogramDisplayCharacteristics(Extension parametresDatex2) {
        if (parametresDatex2.getBoolean("PMV_PICTOGRAMME", false)) {
            _VmsRecordPictogramDisplayAreaIndexVmsPictogramDisplayCharacteristics vmsPictogramDisplayCharacteristics = new _VmsRecordPictogramDisplayAreaIndexVmsPictogramDisplayCharacteristics();
            vmsPictogramDisplayCharacteristics.setPictogramDisplayAreaIndex(1);
            vmsPictogramDisplayCharacteristics.setVmsPictogramDisplayCharacteristics(this.genererVmsPictogramDisplayCharacteristics(parametresDatex2));
            return new _VmsRecordPictogramDisplayAreaIndexVmsPictogramDisplayCharacteristics[]{vmsPictogramDisplayCharacteristics};
        }
        return null;
    }

    @Override
    public VmsTextDisplayCharacteristics genererVmsTextDisplayCharacteristics(Extension parametresDatex2) {
        VmsTextDisplayCharacteristics vmsTextDisplayCharacteristics = new VmsTextDisplayCharacteristics();
        vmsTextDisplayCharacteristics.setTextLanternsPresent(parametresDatex2.getBoolean("PMV_FEU_FLASH", false));
        vmsTextDisplayCharacteristics.setMaxNumberOfCharacters(new NonNegativeInteger(parametresDatex2.getString("PMV_NOMBRE_CARACTERE_PAR_LIGNE")));
        vmsTextDisplayCharacteristics.setMaxNumberOfRows(new NonNegativeInteger(parametresDatex2.getString("PMV_NOMBRE_LIGNE")));
        return vmsTextDisplayCharacteristics;
    }

    @Override
    public LocationByReference genererLocationByReference(Extension parametresDatex2) {
        _PredefinedLocationVersionedReference predefinedLocationVersionedReference = new _PredefinedLocationVersionedReference();
        predefinedLocationVersionedReference.setId(parametresDatex2.getString("LOCALISATION_CODE"));
        predefinedLocationVersionedReference.setTargetClass("PredefinedLocation");
        predefinedLocationVersionedReference.setVersion("1");
        LocationByReference locationByReference = new LocationByReference();
        locationByReference.setPredefinedLocationReference(predefinedLocationVersionedReference);
        return locationByReference;
    }

    @Override
    public void genererHeaderInformation(Extension parametresDatex2, HeaderInformation headerInformation) throws Exception {
        this.LOGGER.debug((Object)"<headerInformation>");
        parametresDatex2.setValeur(CONFIDENTIALITY, (Object)headerInformation.getConfidentiality().getValue());
        parametresDatex2.setValeur(INFORMATION_STATUS, (Object)headerInformation.getInformationStatus().getValue());
        this.LOGGER.debug((Object)"</headerInformation>");
    }

    @Override
    public Extension genererSituation(Situation situation) throws Exception {
        this.LOGGER.debug((Object)"<situation>");
        Extension parametresDatex2 = new Extension();
        this.genererHeaderInformation(parametresDatex2, situation.getHeaderInformation());
        parametresDatex2.setValeur("situationRecordVersion", (Object)situation.getVersion());
        parametresDatex2.setValeur("idSituation", (Object)situation.getId());
        if (situation.getOverallSeverity() != null) {
            parametresDatex2.setValeur(OVERALL_SECURITY, (Object)situation.getOverallSeverity().getValue());
        }
        this.LOGGER.debug((Object)"</situation>");
        return parametresDatex2;
    }

    @Override
    public Evenement extensionDatex2ToEvenement(Extension parametresDatex2) throws Exception {
        ValeurChampTexte v;
        Evenement evenement = new Evenement();
        if (parametresDatex2.getString("descriptionEvenement") == null) {
            return null;
        }
        CorrespondanceDatex2 correspondanceDatex2 = this.mapDatex2Prism.get(parametresDatex2.getString("descriptionEvenement"));
        if (correspondanceDatex2 == null) {
            this.LOGGER.error((Object)("correspondanceDatex2 impossible \u00e0 trouver pour " + parametresDatex2.getString("descriptionEvenement")));
            return null;
        }
        String typeIncident = correspondanceDatex2.getDescription();
        parametresDatex2.setValeur("natureEvenement", (Object)correspondanceDatex2.getNature());
        Map natures = BusinessServiceFactory.getBusinessService().getNatures();
        Nature n = (Nature)DeepCopy.copy((Object)((Nature)natures.get(parametresDatex2.getString("natureEvenement"))));
        evenement.setValeurNature(n.extraireValeurs());
        ValeurChampCollectionChoixUnique d = evenement.getValeurNature().getDescription();
        ValeurChampLocalisation l = evenement.getValeurNature().getLocalisation();
        List listeDesc = (List)BusinessServiceFactory.getBusinessService().getDescriptionsNatureMap().get(n.getCode());
        int iDesc = MetierCommun.getIndiceObjetListe((List)listeDesc, (Object)typeIncident);
        if (iDesc <= -1) {
            this.LOGGER.error((Object)("erreur description nature impossible \u00e0 trouver " + d.getValeur()));
            throw new RuntimeException();
        }
        IDescription desc = (IDescription)listeDesc.get(iDesc);
        d.setIndexSelectionnee(iDesc);
        d.setValeur(desc.getLibelle());
        evenement.setAnnule(parametresDatex2.getBoolean("lifeCycleManagementCancel", false));
        evenement.setTermine(parametresDatex2.getBoolean("lifeCycleManagementEnd", false));
        evenement.setDateCreation(parametresDatex2.getLong("creationTime", Calendar.getInstance().getTimeInMillis()));
        evenement.setDateMaj(parametresDatex2.getLong("versionTime", Calendar.getInstance().getTimeInMillis()));
        if (evenement.isTermine()) {
            evenement.setDateFin(evenement.getDateMaj());
        }
        if (!GLS.estVide((String)parametresDatex2.getString("commentaireMultiLang"))) {
            ValeurChampTexte v2 = (ValeurChampTexte)MetierCommun.getValeurChamp((List)evenement.getValeurNature().getValeurs(), (String)"commentaire");
            if (parametresDatex2.getString("commentaireMultiLangFr").length() <= 4999) {
                v2.setValeur(parametresDatex2.getString("commentaireMultiLangFr"));
            } else {
                v2.setValeur(parametresDatex2.getString("commentaireMultiLangFr").substring(0, 4999));
            }
        }
        evenement.setIdSituation(parametresDatex2.getString("idSituation"));
        evenement.setIdReference(parametresDatex2.getString("idSituationRecord"));
        evenement.setNumVersion((int)parametresDatex2.getLong("situationRecordVersion", -1L));
        l.setAxe(parametresDatex2.getString("RoutePrimaire"));
        l.setCommune(parametresDatex2.getString("communeSecondaire"));
        GeoPoint point = new GeoPoint(parametresDatex2.getString("XYPrimaire"));
        Position p = new Position();
        p.setX((float)point.getX());
        p.setY((float)point.getY());
        l.setPositionDebut(p);
        int sens = parametresDatex2.getInt("prDirection", -1);
        if (sens == 1 || sens == 3) {
            l.setSensPr(1);
        } else if (sens == 2) {
            l.setSensPr(0);
        } else {
            l.setSensPr(-1);
        }
        String prDeb = parametresDatex2.getString("prPrimaire");
        String prFin = parametresDatex2.getString("prSecondaire");
        String prDebSeul = "-1";
        if (!GLS.estVide((String)prDeb)) {
            String deptDeb = prDeb.substring(0, prDeb.indexOf("PR"));
            if (deptDeb.length() > 0) {
                l.setDeptDebut(deptDeb);
            }
            prDebSeul = prDeb.substring(prDeb.indexOf("PR") + 2, prDeb.length() - 1);
            l.setPrDebut(GLS.getInt((String)prDebSeul));
        }
        if (!GLS.estVide((String)prFin)) {
            String deptFin = prFin.substring(0, prFin.indexOf("PR"));
            if (deptFin.length() > 0) {
                l.setDeptFin(deptFin);
            }
            String pr = prFin.substring(prFin.indexOf("PR") + 2, prFin.length() - 1);
            l.setPrFin(GLS.getInt((String)pr));
            l.setAbsPrFin((int)Math.round(parametresDatex2.getDouble("prDistanceSecondaire", -1.0)));
        } else {
            l.setPrFin(-1);
            l.setAbsPrFin(-1);
        }
        Double distance = parametresDatex2.getDouble("prDistancePrimaire", -1.0);
        if (distance < 0.0) {
            l.setAbsPrDebut(0);
        } else {
            l.setAbsPrDebut((int)Math.round(distance));
        }
        GLS.estVide((String)parametresDatex2.getString("supplementaryPositionalDescription"));
        String valeur = (String)parametresDatex2.getValeur("DESCRIPTION_ITINERAIRE_DEVIATION");
        if (!GLS.estVide((String)valeur)) {
            MetierCommun.instanceOf();
            v = (ValeurChampTexte)MetierCommun.getValeurChamp((List)evenement.getValeurNature().getValeurs(), (String)"deviation");
            v.setValeur(valeur);
        }
        if (!GLS.estVide((String)(valeur = (String)parametresDatex2.getValeur("LIMITATION_VITESSE_VALEUR")))) {
            MetierCommun.instanceOf();
            v = (ValeurChampEntier)MetierCommun.getValeurChamp((List)evenement.getValeurNature().getValeurs(), (String)"limitationVitesse");
            int limitation = GLS.getInt((String)valeur);
            if (limitation < 0) {
                limitation = (int)GLS.getDouble((String)valeur);
            }
            v.setValeur(limitation);
            v.setChecked(true);
        }
        if (!GLS.estVide((String)(valeur = (String)parametresDatex2.getValeur("CAUSE_PL")))) {
            MetierCommun.instanceOf();
            v = (ValeurChampCollectionChoixUnique)MetierCommun.getValeurChamp((List)evenement.getValeurNature().getValeurs(), (String)"typeIncidentPL");
            ChampCollectionChoixUnique c = (ChampCollectionChoixUnique)MetierCommun.instanceOf().getChamp(n.getChamps(), "typeIncidentPL");
            if ("nc".equals(valeur)) {
                v.setValeur("Probl\u00e8me inconnu");
            } else if ("problemeGabarit".equals(valeur)) {
                v.setValeur("Probl\u00e8me gabarit");
            } else if ("perteChargement".equals(valeur)) {
                v.setValeur("Perte de chargement");
            } else if ("other".equals(valeur)) {
                v.setValeur("Probl\u00e8me autre");
            }
            iDesc = MetierCommun.getIndiceObjetListe((List)c.getValeurs(), (Object)v.getValeur());
            if (iDesc > -1) {
                v.setIndexSelectionnee(iDesc);
            }
        }
        if (!GLS.estVide((String)(valeur = (String)parametresDatex2.getValeur("VEHCIULES_CONCERNES")))) {
            String valeurBDD = "VEHCIULES_CONCERNES_TOUSVEHICULES";
            if ("VEHCIULES_CONCERNES_TOUSVEHICULES".equals(valeur)) {
                valeurBDD = "Tous v\u00e9hicules";
            } else if ("VEHCIULES_CONCERNES_VEHICULES_INFEGA19T".equals(valeur)) {
                valeurBDD = "V\u00e9hicules <= 19T";
            } else if ("VEHCIULES_CONCERNES_VEHICULES_SUP19T".equals(valeur)) {
                valeurBDD = "V\u00e9hicules > 19T";
            } else if ("VEHCIULES_CONCERNES_VEHICULES_INFEGA7P5T".equals(valeur)) {
                valeurBDD = "V\u00e9hicules <= 7,5T";
            } else if ("VEHCIULES_CONCERNES_VEHICULES_SUP7P5T".equals(valeur)) {
                valeurBDD = "V\u00e9hicules > 7,5T";
            } else if ("VEHCIULES_CONCERNES_AUTRE".equals(valeur)) {
                valeurBDD = parametresDatex2.getString("DESCRIPTION_VEHICULE");
            }
            MetierCommun.instanceOf();
            ValeurChampCollectionChoixUnique v3 = (ValeurChampCollectionChoixUnique)MetierCommun.getValeurChamp((List)evenement.getValeurNature().getValeurs(), (String)"vehiculesConcernes");
            ChampCollectionChoixUnique c = (ChampCollectionChoixUnique)MetierCommun.instanceOf().getChamp(n.getChamps(), "vehiculesConcernes");
            v3.setValeur(valeurBDD);
            if ("VEHCIULES_CONCERNES_AUTRE".equals(valeur)) {
                iDesc = MetierCommun.getIndiceObjetListe((List)c.getValeurs(), (Object)"Autre");
                if (iDesc > -1) {
                    v3.setIndexSelectionnee(iDesc);
                }
            } else {
                iDesc = MetierCommun.getIndiceObjetListe((List)c.getValeurs(), (Object)valeurBDD);
                if (iDesc > -1) {
                    v3.setIndexSelectionnee(iDesc);
                }
            }
        }
        if (!GLS.estVide((String)(valeur = (String)parametresDatex2.getValeur("REDUCTION_NBREVOIES")))) {
            MetierCommun.instanceOf();
            v = (ValeurChampEntier)MetierCommun.getValeurChamp((List)evenement.getValeurNature().getValeurs(), (String)"reductionNombreVoies");
            try {
                v.setValeur(GLS.getInt((String)valeur));
                v.setChecked(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (parametresDatex2.getString("descriptionEvenement").equals("TYPE_ACCIDENT")) {
            this.extensionDatex2ToEvenementAccident(evenement, parametresDatex2, n);
        } else if (parametresDatex2.getString("descriptionEvenement").equals("TYPE_BOUCHON") || parametresDatex2.getString("descriptionEvenement").equals("typeRalentissement") || parametresDatex2.getString("descriptionEvenement").equals("typeCirculationBloquee") || parametresDatex2.getString("descriptionEvenement").equals("typeAccordeon") || parametresDatex2.getString("descriptionEvenement").equals("typeBouchon")) {
            this.extensionDatex2ToEvenementBouchon(evenement, parametresDatex2, n);
        } else {
            if (parametresDatex2.getString("descriptionEvenement").equals("typeObstacleVehicule") || parametresDatex2.getString("descriptionEvenement").equals("typeObstacleAutre") || parametresDatex2.getString("descriptionEvenement").equals("typeObstacleIncident") || parametresDatex2.getString("descriptionEvenement").equals("typeObstacleEquipement")) {
                this.extensionDatex2ToEvenementObstacle(evenement, parametresDatex2);
            }
            if (parametresDatex2.getString("descriptionEvenement").equals("typeObstacleVehicule")) {
                this.extensionDatex2ToEvenementObstacleVehicule(evenement, parametresDatex2, n);
            } else if (parametresDatex2.getString("descriptionEvenement").equals("typeObstacleAutre")) {
                this.extensionDatex2ToEvenementObstacleAutre(evenement, parametresDatex2, n);
            } else if (parametresDatex2.getString("descriptionEvenement").equals("typeObstacleIncident")) {
                this.extensionDatex2ToEvenementObstacleIncident(evenement, parametresDatex2, n);
            } else if (parametresDatex2.getString("descriptionEvenement").equals("typeObstacleEquipement")) {
                this.extensionDatex2ToEvenementObstacleEquipement(evenement, parametresDatex2, n);
            }
        }
        return evenement;
    }

    protected void extensionDatex2ToEvenementAccident(Evenement evenement, Extension parametresDatex2, Nature n) throws Exception {
        ValeurChampMultiCheckBox v10;
        ValeurChampEntier v22;
        ValeurChampMultiCheckBox v32;
        int iDesc;
        String valeur;
        ValeurChampVehiculeEnCause vec = null;
        try {
            vec = (ValeurChampVehiculeEnCause)MetierCommun.getValeurChamp((List)evenement.getValeurNature().getValeurs(), (String)"typeVehicule");
        }
        catch (Exception e) {
            try {
                vec = (ValeurChampVehiculeEnCause)MetierCommun.getValeurChamp((List)evenement.getValeurNature().getValeurs(), (String)"typeVehicule2");
            }
            catch (Exception e2) {
                vec = null;
            }
        }
        if (vec != null) {
            ValeurChampTexte v4;
            valeur = (String)parametresDatex2.getValeur("ACCIDENT_NB_VEHICULES");
            if (!GLS.estVide((String)valeur)) {
                vec.setVl(GLS.getInt((String)valeur));
            }
            if (!GLS.estVide((String)(valeur = (String)parametresDatex2.getValeur("ACCIDENT_NB_BUS")))) {
                vec.setVtc(GLS.getInt((String)valeur));
            }
            if (!GLS.estVide((String)(valeur = (String)parametresDatex2.getValeur("ACCIDENT_NB_VELOS")))) {
                vec.setVelo(GLS.getInt((String)valeur));
            }
            if (!GLS.estVide((String)(valeur = (String)parametresDatex2.getValeur("ACCIDENT_NB_MOTOS")))) {
                vec.setMoto(GLS.getInt((String)valeur));
            }
            if (!GLS.estVide((String)(valeur = (String)parametresDatex2.getValeur("ACCIDENT_NB_AUTRES")))) {
                vec.setAutres(GLS.getInt((String)valeur));
            }
            if (!GLS.estVide((String)(valeur = (String)parametresDatex2.getValeur("ACCIDENT_NB_PIETONS")))) {
                vec.setPietonCycle(GLS.getInt((String)valeur));
            }
            if (!GLS.estVide((String)(valeur = (String)parametresDatex2.getValeur("ACCIDENT_NB_PL")))) {
                vec.setPl(GLS.getInt((String)valeur));
            }
            if (!GLS.estVide((String)(valeur = (String)parametresDatex2.getValeur("ACCIDENT_NB_DEUXROUES")))) {
                vec.setDeuxRoues(GLS.getInt((String)valeur));
            }
            if (!GLS.estVide((String)(valeur = (String)parametresDatex2.getValeur("ACCIDENT_NB_CARAVANES")))) {
                vec.setCaravane(GLS.getInt((String)valeur));
            }
            if (!GLS.estVide((String)(valeur = (String)parametresDatex2.getValeur("ACCIDENT_NB_TRAINS")))) {
                vec.setTrain(GLS.getInt((String)valeur));
            }
            if (!GLS.estVide((String)(valeur = (String)parametresDatex2.getValeur("ACCIDENT_NB_TRAMWAYS")))) {
                vec.setTramway(GLS.getInt((String)valeur));
            }
            if (!GLS.estVide((String)(valeur = (String)parametresDatex2.getValeur("ACCIDENT_NB_ENGINSAGRICOLES")))) {
                vec.setEnginAgricole(GLS.getInt((String)valeur));
            }
            if (!GLS.estVide((String)(valeur = (String)parametresDatex2.getValeur("ACCIDENT_AUTRES_COM")))) {
                v4 = (ValeurChampTexte)MetierCommun.getValeurChamp((List)evenement.getValeurNature().getValeurs(), (String)"description-autres-typeVehicule");
                v4.setValeur(valeur);
            }
            if (!GLS.estVide((String)(valeur = (String)parametresDatex2.getValeur("ACCIDENT_PL_NONDETERMINE")))) {
                try {
                    v4 = (ValeurChampCollectionChoixUnique)MetierCommun.getValeurChamp((List)evenement.getValeurNature().getValeurs(), (String)"categoriePL");
                    ChampCollectionChoixUnique c = (ChampCollectionChoixUnique)MetierCommun.instanceOf().getChamp(n.getChamps(), "categoriePL");
                    v4.setValeur("Non d\u00e9termin\u00e9e");
                    iDesc = MetierCommun.getIndiceObjetListe((List)c.getValeurs(), (Object)v4.getValeur());
                    if (iDesc > -1) {
                        v4.setIndexSelectionnee(iDesc);
                    }
                }
                catch (Exception v5) {
                    // empty catch block
                }
            }
            if (!GLS.estVide((String)(valeur = (String)parametresDatex2.getValeur("ACCIDENT_NB_PL")))) {
                try {
                    int valeurInt = Integer.valueOf(valeur);
                    if (valeurInt > 0) {
                        vec.setPl(valeurInt);
                        v32 = (ValeurChampCollectionChoixUnique)MetierCommun.getValeurChamp((List)evenement.getValeurNature().getValeurs(), (String)"categoriePL");
                        ChampCollectionChoixUnique c = (ChampCollectionChoixUnique)MetierCommun.instanceOf().getChamp(n.getChamps(), "categoriePL");
                        v32.setValeur("Non articul\u00e9");
                        iDesc = MetierCommun.getIndiceObjetListe((List)c.getValeurs(), (Object)v32.getValeur());
                        if (iDesc > -1) {
                            v32.setIndexSelectionnee(iDesc);
                        }
                    }
                }
                catch (Exception valeurInt) {
                    // empty catch block
                }
            }
        }
        Vector<String> listeValeurs_FACTEURSAGGRAVANTS = new Vector<String>();
        if (!GLS.estVide((String)parametresDatex2.getString("ACCIDENT_FACTAUERAGGRAVANT_TMD"))) {
            listeValeurs_FACTEURSAGGRAVANTS.add("TMD");
            listeValeurs_FACTEURSAGGRAVANTS.add("Mati\u00e8res dangereuses");
        }
        if (!GLS.estVide((String)parametresDatex2.getString("ACCIDENT_PERSONNES_IMPLIQUEES_ENFANTS"))) {
            listeValeurs_FACTEURSAGGRAVANTS.add("Transport d'enfants");
        }
        if (!GLS.estVide((String)parametresDatex2.getString("ACCIDENT_PERSONNES_IMPLIQUEES_VIP"))) {
            listeValeurs_FACTEURSAGGRAVANTS.add("VIP");
        }
        if (!GLS.estVide((String)parametresDatex2.getString("ACCIDENT_PERSONNES_IMPLIQUEES_GESTIONNAIRE_ROUTIER"))) {
            listeValeurs_FACTEURSAGGRAVANTS.add("Gestionnaire routier impliqu\u00e9");
        }
        if (!GLS.estVide((String)parametresDatex2.getString("ACCIDENT_PERSONNES_IMPLIQUEES_SERVICE_URGENCE"))) {
            listeValeurs_FACTEURSAGGRAVANTS.add("Secours impliqu\u00e9s");
        }
        if (!GLS.estVide((String)parametresDatex2.getString("ACCIDENT_PERSONNES_IMPLIQUEES_FORCE_ORDRE"))) {
            listeValeurs_FACTEURSAGGRAVANTS.add("Forces de l'ordre ou secours impliqu\u00e9s");
        }
        if (!GLS.estVide((String)parametresDatex2.getString("ACCIDENT_FACTAUERAGGRAVANT_TC"))) {
            listeValeurs_FACTEURSAGGRAVANTS.add("Transport public");
        }
        if (!GLS.estVide((String)parametresDatex2.getString("ACCIDENT_FACTAUERAGGRAVANT_CARAMBOLAGE"))) {
            listeValeurs_FACTEURSAGGRAVANTS.add("Carambolage");
        }
        if (listeValeurs_FACTEURSAGGRAVANTS.size() > 0) {
            try {
                v32 = (ValeurChampMultiCheckBox)MetierCommun.getValeurChamp((List)evenement.getValeurNature().getValeurs(), (String)"facteursAggravants");
                v32.setValeursSelectionnee(listeValeurs_FACTEURSAGGRAVANTS);
            }
            catch (Exception v32) {
                // empty catch block
            }
            try {
                v32 = (ValeurChampMultiCheckBox)MetierCommun.getValeurChamp((List)evenement.getValeurNature().getValeurs(), (String)"facteurAggravant");
                v32.setValeursSelectionnee(listeValeurs_FACTEURSAGGRAVANTS);
            }
            catch (Exception v6) {
                // empty catch block
            }
        }
        Vector<String> listeValeurs_PARTICULARITES = new Vector<String>();
        if (!GLS.estVide((String)parametresDatex2.getString("ACCIDENT_PERSONNES_IMPLIQUEES_ENFANTS"))) {
            listeValeurs_PARTICULARITES.add("Enfant");
        }
        if (!GLS.estVide((String)parametresDatex2.getString("ACCIDENT_PERSONNES_IMPLIQUEES_VIP"))) {
            listeValeurs_PARTICULARITES.add("VIP");
        }
        if (!GLS.estVide((String)parametresDatex2.getString("ACCIDENT_PERSONNES_IMPLIQUEES_SERVICE_URGENCE"))) {
            listeValeurs_PARTICULARITES.add("Service d'urgence");
        }
        if (!GLS.estVide((String)parametresDatex2.getString("ACCIDENT_PERSONNES_IMPLIQUEES_FORCE_ORDRE"))) {
            listeValeurs_PARTICULARITES.add("FO");
        }
        if (!GLS.estVide((String)parametresDatex2.getString("ACCIDENT_PERSONNES_IMPLIQUEES_GESTIONNAIRE_ROUTIER"))) {
            listeValeurs_PARTICULARITES.add("Gestionnaire routier");
        }
        if (listeValeurs_PARTICULARITES.size() > 0) {
            try {
                ValeurChampMultiCheckBox v7 = (ValeurChampMultiCheckBox)MetierCommun.getValeurChamp((List)evenement.getValeurNature().getValeurs(), (String)"particularites");
                v7.setValeursSelectionnee(listeValeurs_PARTICULARITES);
            }
            catch (Exception v7) {
                // empty catch block
            }
        }
        Vector<String> listeValeurs_CONSEQUENCES = new Vector<String>();
        boolean valeurConsequenses = false;
        boolean accidetnMortel = false;
        boolean accidetnCorporel = false;
        valeur = (String)parametresDatex2.getValeur("ACCIDENT_PERSONNES_BLESSEES");
        if (!GLS.estVide((String)valeur)) {
            valeurConsequenses = true;
            accidetnCorporel = true;
            try {
                v22 = (ValeurChampEntier)MetierCommun.getValeurChamp((List)evenement.getValeurNature().getValeurs(), (String)"blessesGraves");
                v22.setValeur(GLS.getInt((String)valeur));
                v22.setChecked(true);
            }
            catch (Exception v22) {
                // empty catch block
            }
            try {
                v22 = (ValeurChampEntier)MetierCommun.getValeurChamp((List)evenement.getValeurNature().getValeurs(), (String)"blesses");
                v22.setValeur(GLS.getInt((String)valeur));
                v22.setChecked(true);
            }
            catch (Exception v8) {
                // empty catch block
            }
        }
        if (!GLS.estVide((String)(valeur = (String)parametresDatex2.getValeur("ACCIDENT_PERSONNES_TUEES")))) {
            valeurConsequenses = true;
            accidetnMortel = true;
            v22 = (ValeurChampEntier)MetierCommun.getValeurChamp((List)evenement.getValeurNature().getValeurs(), (String)"tues");
            v22.setValeur(GLS.getInt((String)valeur));
            v22.setChecked(true);
        }
        try {
            v22 = (ValeurChampCollectionChoixUnique)MetierCommun.getValeurChamp((List)evenement.getValeurNature().getValeurs(), (String)"natureAccident");
            ChampCollectionChoixUnique c = (ChampCollectionChoixUnique)MetierCommun.instanceOf().getChamp(n.getChamps(), "natureAccident");
            if (accidetnMortel) {
                this.setValeur((ValeurChampCollectionChoixUnique)v22, c, "mortel");
            } else if (accidetnCorporel) {
                this.setValeur((ValeurChampCollectionChoixUnique)v22, c, "corporel");
            } else {
                this.setValeur((ValeurChampCollectionChoixUnique)v22, c, "mat\u00e9riel");
            }
            iDesc = MetierCommun.getIndiceObjetListe((List)c.getValeurs(), (Object)v22.getValeur());
            if (iDesc > -1) {
                v22.setIndexSelectionnee(iDesc);
            }
        }
        catch (Exception v9) {
            // empty catch block
        }
        boolean valeurMaterielles = parametresDatex2.getBoolean("ACCIDENT_MATERIELLES", false);
        if (valeurConsequenses || valeurMaterielles) {
            if (valeurConsequenses) {
                listeValeurs_CONSEQUENCES.add("Corporelles");
            }
            if (valeurMaterielles) {
                listeValeurs_CONSEQUENCES.add("Mat\u00e9rielles");
            }
            try {
                v10 = (ValeurChampMultiCheckBox)MetierCommun.getValeurChamp((List)evenement.getValeurNature().getValeurs(), (String)"consequences");
                v10.setValeursSelectionnee(listeValeurs_CONSEQUENCES);
            }
            catch (Exception v10) {
                // empty catch block
            }
        }
        if (!GLS.estVide((String)(valeur = (String)parametresDatex2.getValeur("DESCRIPTION_VEHICULE")))) {
            try {
                v10 = (ValeurChampTexte)MetierCommun.getValeurChamp((List)evenement.getValeurNature().getValeurs(), (String)"description-autres-typeVehicule");
                v10.setValeur(valeur);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void extensionDatex2ToEvenementBouchon(Evenement evenement, Extension parametresDatex2, Nature n) throws Exception {
        ValeurChampEntier ve;
        String valeur;
        block40: {
            int iDesc;
            ChampCollectionChoixUnique c;
            ValeurChampCollectionChoixUnique v;
            block38: {
                valeur = (String)parametresDatex2.getValeur("TYPE_BOUCHON_TENDANCE");
                if (GLS.estVide((String)valeur)) break block38;
                v = (ValeurChampCollectionChoixUnique)MetierCommun.getValeurChamp((List)evenement.getValeurNature().getValeurs(), (String)"tendance");
                c = (ChampCollectionChoixUnique)MetierCommun.instanceOf().getChamp(n.getChamps(), "tendance");
                switch (valeur) {
                    case "TYPE_BOUCHON_TENDANCE_AMELIORATION": {
                        v.setValeur("Am\u00e9lioration");
                        break;
                    }
                    case "TYPE_BOUCHON_TENDANCE_DEGRADATION": {
                        v.setValeur("D\u00e9gradation");
                        break;
                    }
                    case "TYPE_BOUCHON_TENDANCE_STABLE": {
                        v.setValeur("Stable");
                    }
                }
                iDesc = MetierCommun.getIndiceObjetListe((List)c.getValeurs(), (Object)v.getValeur());
                if (iDesc > -1) {
                    v.setIndexSelectionnee(iDesc);
                }
            }
            if (GLS.estVide((String)(valeur = (String)parametresDatex2.getValeur("TYPE_BOUCHON_NORMALITE")))) break block40;
            v = (ValeurChampCollectionChoixUnique)MetierCommun.getValeurChamp((List)evenement.getValeurNature().getValeurs(), (String)"normalite");
            c = (ChampCollectionChoixUnique)MetierCommun.instanceOf().getChamp(n.getChamps(), "normalite");
            switch (valeur) {
                case "TYPE_BOUCHON_NORMALITE_BIENMOINSCHARGE": {
                    v.setValeur("Bien moins charg\u00e9");
                    break;
                }
                case "TYPE_BOUCHON_NORMALITE_BIENPLUSCHARGE": {
                    v.setValeur("Bien plus charg\u00e9");
                    break;
                }
                case "TYPE_BOUCHON_NORMALITE_MOINSCHARGE": {
                    v.setValeur("Moins charg\u00e9");
                    break;
                }
                case "TYPE_BOUCHON_NORMALITE_PLUSCHARGE": {
                    v.setValeur("Plus charg\u00e9");
                    break;
                }
                case "TYPE_BOUCHON_NORMALITE_COMMEHABITUDE": {
                    v.setValeur("Comme d'habitude");
                }
            }
            iDesc = MetierCommun.getIndiceObjetListe((List)c.getValeurs(), (Object)v.getValeur());
            if (iDesc > -1) {
                v.setIndexSelectionnee(iDesc);
            }
        }
        if (!GLS.estVide((String)(valeur = (String)parametresDatex2.getValeur("TYPE_BOUCHON_VOIESCONCERNEES")))) {
            ve = (ValeurChampEntier)MetierCommun.getValeurChamp((List)evenement.getValeurNature().getValeurs(), (String)"voiesConcernees");
            int limitation = GLS.getInt((String)valeur);
            if (limitation < 0) {
                limitation = (int)GLS.getDouble((String)valeur);
            }
            ve.setValeur(limitation);
            ve.setChecked(true);
        }
        if (!GLS.estVide((String)(valeur = (String)parametresDatex2.getValeur("TYPE_BOUCHON_VOIESNORMALES")))) {
            ve = (ValeurChampEntier)MetierCommun.getValeurChamp((List)evenement.getValeurNature().getValeurs(), (String)"voiesNormales");
            int limitation = GLS.getInt((String)valeur);
            if (limitation < 0) {
                limitation = (int)GLS.getDouble((String)valeur);
            }
            ve.setValeur(limitation);
            ve.setChecked(true);
        }
    }

    protected void extensionDatex2ToEvenementObstacleVehicule(Evenement evenement, Extension parametresDatex2, Nature n) throws Exception {
        String valeur = (String)parametresDatex2.getValeur("TYPE_OBSTACLE");
        ValeurChampCollectionChoixUnique v = (ValeurChampCollectionChoixUnique)MetierCommun.getValeurChamp((List)evenement.getValeurNature().getValeurs(), (String)"etatVehicule");
        ChampCollectionChoixUnique c = (ChampCollectionChoixUnique)MetierCommun.instanceOf().getChamp(n.getChamps(), "etatVehicule");
        switch (valeur) {
            case "TYPE_OBSTACLE_VEHICULE_ABANDONNE": {
                v.setValeur("Abandonn\u00e9");
                break;
            }
            case "TYPE_OBSTACLE_VEHICULE_DIFFICULTE": {
                v.setValeur("En difficult\u00e9");
                break;
            }
            case "TYPE_OBSTACLE_VEHICULE_ARRETE": {
                v.setValeur("Arr\u00eat\u00e9");
                break;
            }
            case "TYPE_OBSTACLE_VEHICULE_PANNE": {
                v.setValeur("En panne");
                break;
            }
            case "TYPE_OBSTACLE_VEHICULE_CONTRESENS": {
                v.setValeur("A contre-sens");
                break;
            }
            case "TYPE_OBSTACLE_VEHICULE_LENT": {
                v.setValeur("Lent");
                break;
            }
            case "TYPE_OBSTACLE_VEHICULE_FEU": {
                v.setValeur("En feu");
                break;
            }
            case "TYPE_OBSTACLE_VEHICULE_CONVOI_EXCEPTIONNEL": {
                v.setValeur("Convoi exceptionnel");
            }
        }
        int iDesc = MetierCommun.getIndiceObjetListe((List)c.getValeurs(), (Object)v.getValeur());
        if (iDesc > -1) {
            v.setIndexSelectionnee(iDesc);
        }
        ValeurChampVehiculeEnCause vec = null;
        try {
            vec = (ValeurChampVehiculeEnCause)MetierCommun.getValeurChamp((List)evenement.getValeurNature().getValeurs(), (String)"typeVehicule");
        }
        catch (Exception e) {
            try {
                vec = (ValeurChampVehiculeEnCause)MetierCommun.getValeurChamp((List)evenement.getValeurNature().getValeurs(), (String)"typeVehicule2");
            }
            catch (Exception e1) {
                vec = null;
            }
        }
        if (vec != null) {
            valeur = (String)parametresDatex2.getValeur("ACCIDENT_NB_VEHICULES");
            if (!GLS.estVide((String)valeur)) {
                vec.setVl(GLS.getInt((String)valeur));
            }
            if (!GLS.estVide((String)(valeur = (String)parametresDatex2.getValeur("ACCIDENT_NB_BUS")))) {
                vec.setVtc(GLS.getInt((String)valeur));
            }
            if (!GLS.estVide((String)(valeur = (String)parametresDatex2.getValeur("ACCIDENT_NB_VELOS")))) {
                vec.setVelo(GLS.getInt((String)valeur));
            }
            if (!GLS.estVide((String)(valeur = (String)parametresDatex2.getValeur("ACCIDENT_NB_MOTOS")))) {
                vec.setMoto(GLS.getInt((String)valeur));
            }
            if (!GLS.estVide((String)(valeur = (String)parametresDatex2.getValeur("ACCIDENT_NB_AUTRES")))) {
                vec.setAutres(GLS.getInt((String)valeur));
            }
            if (!GLS.estVide((String)(valeur = (String)parametresDatex2.getValeur("ACCIDENT_NB_PIETONS")))) {
                vec.setPietonCycle(GLS.getInt((String)valeur));
            }
            if (!GLS.estVide((String)(valeur = (String)parametresDatex2.getValeur("ACCIDENT_NB_PL")))) {
                vec.setPl(GLS.getInt((String)valeur));
            }
            if (!GLS.estVide((String)(valeur = (String)parametresDatex2.getValeur("ACCIDENT_NB_DEUXROUES")))) {
                vec.setDeuxRoues(GLS.getInt((String)valeur));
            }
            if (!GLS.estVide((String)(valeur = (String)parametresDatex2.getValeur("ACCIDENT_NB_CARAVANES")))) {
                vec.setCaravane(GLS.getInt((String)valeur));
            }
            if (!GLS.estVide((String)(valeur = (String)parametresDatex2.getValeur("ACCIDENT_NB_TRAINS")))) {
                vec.setTrain(GLS.getInt((String)valeur));
            }
            if (!GLS.estVide((String)(valeur = (String)parametresDatex2.getValeur("ACCIDENT_NB_TRAMWAYS")))) {
                vec.setTramway(GLS.getInt((String)valeur));
            }
            if (!GLS.estVide((String)(valeur = (String)parametresDatex2.getValeur("ACCIDENT_NB_ENGINSAGRICOLES")))) {
                vec.setEnginAgricole(GLS.getInt((String)valeur));
            }
        }
    }

    protected void extensionDatex2ToEvenementObstacleAutre(Evenement evenement, Extension parametresDatex2, Nature n) throws Exception {
        String valeur = (String)parametresDatex2.getValeur("TYPE_OBSTACLE");
        ValeurChampCollectionChoixUnique v = (ValeurChampCollectionChoixUnique)MetierCommun.getValeurChamp((List)evenement.getValeurNature().getValeurs(), (String)"etatAutreObstacle");
        ChampCollectionChoixUnique c = (ChampCollectionChoixUnique)MetierCommun.instanceOf().getChamp(n.getChamps(), "etatAutreObstacle");
        switch (valeur) {
            case "TYPE_OBSTACLE_AUTRE_ANIMALERRANT": {
                v.setValeur("Animal errant");
                break;
            }
            case "TYPE_OBSTACLE_AUTRE_ANIMALECRASE": {
                v.setValeur("Animal \u00e9cras\u00e9");
                break;
            }
            case "TYPE_OBSTACLE_AUTRE_ARBRE": {
                v.setValeur("Arbre sur chauss\u00e9e");
                break;
            }
            case "TYPE_OBSTACLE_AUTRE_OBSTACLE": {
                v.setValeur("Obstacle");
                break;
            }
            case "TYPE_OBSTACLE_AUTRE_CHARGEMENTPERDU": {
                v.setValeur("Chargement perdu");
                break;
            }
            case "TYPE_OBSTACLE_AUTRE_CYCLISTE": {
                v.setValeur("Cycliste sur chauss\u00e9e");
                break;
            }
            case "TYPE_OBSTACLE_AUTRE_PIETON": {
                v.setValeur("Pi\u00e9ton sur chauss\u00e9e");
                break;
            }
            case "TYPE_OBSTACLE_AUTRE_PRODUITSURCHAUSSEE": {
                v.setValeur("Produit sur chauss\u00e9e");
            }
        }
        int iDesc = MetierCommun.getIndiceObjetListe((List)c.getValeurs(), (Object)v.getValeur());
        if (iDesc > -1) {
            v.setIndexSelectionnee(iDesc);
        }
        if ((valeur = (String)parametresDatex2.getValeur("TYPE_OBSTACLE_AUTRE_ANIMAL")) != null) {
            v = (ValeurChampCollectionChoixUnique)MetierCommun.getValeurChamp((List)evenement.getValeurNature().getValeurs(), (String)"typeAnimal");
            c = (ChampCollectionChoixUnique)MetierCommun.instanceOf().getChamp(n.getChamps(), "typeAnimal");
            v.setValeur(valeur);
            iDesc = MetierCommun.getIndiceObjetListe((List)c.getValeurs(), (Object)v.getValeur());
            if (iDesc > -1) {
                v.setIndexSelectionnee(iDesc);
            }
        }
    }

    protected void extensionDatex2ToEvenementObstacleEquipement(Evenement evenement, Extension parametresDatex2, Nature n) throws Exception {
        String valeur = (String)parametresDatex2.getValeur("TYPE_OBSTACLE");
        ValeurChampCollectionChoixUnique v = (ValeurChampCollectionChoixUnique)MetierCommun.getValeurChamp((List)evenement.getValeurNature().getValeurs(), (String)"etatEquipement");
        ChampCollectionChoixUnique c = (ChampCollectionChoixUnique)MetierCommun.instanceOf().getChamp(n.getChamps(), "etatEquipement");
        switch (valeur) {
            case "TYPE_OBSTACLE_EQUIPEMENT_EQUIPEMENTFAISANTOBSTACLE": {
                v.setValeur("Equipement faisant obstacle");
                break;
            }
            case "TYPE_OBSTACLE_EQUIPEMENT_ECLATEMENTCANALISATION": {
                v.setValeur("Eclatement de canalisation");
                break;
            }
            case "TYPE_OBSTACLE_EQUIPEMENT_CANALISATIONGAZ": {
                v.setValeur("Canalisation de gaz");
                break;
            }
            case "TYPE_OBSTACLE_EQUIPEMENT_CABLEHTSURCHAUSSEE": {
                v.setValeur("C\u00e2ble HT sur chauss\u00e9e");
                break;
            }
            case "TYPE_OBSTACLE_EQUIPEMENT_CHAUSSEEDEGRADE": {
                v.setValeur("Chauss\u00e9e d\u00e9grad\u00e9e");
            }
        }
        int iDesc = MetierCommun.getIndiceObjetListe((List)c.getValeurs(), (Object)v.getValeur());
        if (iDesc > -1) {
            v.setIndexSelectionnee(iDesc);
        }
    }

    protected void extensionDatex2ToEvenementObstacleIncident(Evenement evenement, Extension parametresDatex2, Nature n) throws Exception {
        String valeur = (String)parametresDatex2.getValeur("TYPE_OBSTACLE");
        ValeurChampCollectionChoixUnique v = (ValeurChampCollectionChoixUnique)MetierCommun.getValeurChamp((List)evenement.getValeurNature().getValeurs(), (String)"etatIncident");
        ChampCollectionChoixUnique c = (ChampCollectionChoixUnique)MetierCommun.instanceOf().getChamp(n.getChamps(), "etatIncident");
        switch (valeur) {
            case "TYPE_OBSTACLE_INCIDENT_INCENDIE": {
                v.setValeur("Incendie");
                break;
            }
            case "TYPE_OBSTACLE_INCIDENT_FEUFORET": {
                v.setValeur("Feu de for\u00eat");
                break;
            }
            case "TYPE_OBSTACLE_INCIDENT_INONDATION": {
                v.setValeur("Inondation");
                break;
            }
            case "TYPE_OBSTACLE_INCIDENT_EBOULEMENENT": {
                v.setValeur("Eboulement");
                break;
            }
            case "TYPE_OBSTACLE_INCIDENT_EFFONDREMENT": {
                v.setValeur("Effondrement");
                break;
            }
            case "TYPE_OBSTACLE_INCIDENT_GLISSEMENTTERRAIN": {
                v.setValeur("Glissement de terrain");
                break;
            }
            case "TYPE_OBSTACLE_INCIDENT_COULEEBOUE": {
                v.setValeur("Coul\u00e9e de boue");
                break;
            }
            case "TYPE_OBSTACLE_INCIDENT_FUMEE": {
                v.setValeur("Fum\u00e9e");
                break;
            }
            case "TYPE_OBSTACLE_INCIDENT_EXPLOSION": {
                v.setValeur("Explosion");
                break;
            }
            case "TYPE_OBSTACLE_INCIDENT_INCIDENT": {
                v.setValeur("Incident");
                break;
            }
            case "TYPE_OBSTACLE_INCIDENT_INCENDIEINDUSTRIEL": {
                v.setValeur("Incendie industriel");
            }
        }
        int iDesc = MetierCommun.getIndiceObjetListe((List)c.getValeurs(), (Object)v.getValeur());
        if (iDesc > -1) {
            v.setIndexSelectionnee(iDesc);
        }
    }

    protected void extensionDatex2ToEvenementObstacle(Evenement evenement, Extension parametresDatex2) throws Exception {
    }

    @Override
    public ArrayList<Evenement> genererEvenements(D2LogicalModel d2LogicalModel) throws Exception {
        ArrayList<Evenement> listeEvenements = new ArrayList<Evenement>();
        SituationPublication situationPublication = (SituationPublication)d2LogicalModel.getPayloadPublication();
        Situation[] situations = situationPublication.getSituation();
        Evenement evenement = null;
        String district = null;
        try {
            IConfiguration myConfig = ConfigurationFactory.getInstance();
            district = myConfig.get("datex2.district");
        }
        catch (Exception e) {
            district = null;
        }
        Situation[] situationArray = situations;
        int n = situations.length;
        int n2 = 0;
        while (n2 < n) {
            Situation situation = situationArray[n2];
            if (situation.getSituationRecord() != null) {
                SituationRecord[] situationRecordArray = situation.getSituationRecord();
                int n3 = situationRecordArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    SituationRecord situationRecord = situationRecordArray[n4];
                    try {
                        Extension parametresDatex2 = this.genererSituation(situation);
                        this.genererSituationRecord(parametresDatex2, situationRecord);
                        evenement = this.extensionDatex2ToEvenement(parametresDatex2);
                        if (evenement != null) {
                            evenement.setDistrict(district);
                            listeEvenements.add(evenement);
                        } else {
                            this.LOGGER.warn((Object)("Type evenement non g\u00e9r\u00e9 " + situationRecord.getClass() + " - " + situationRecord.getId()));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.LOGGER.error((Object)("Erreur lors de la conversion de l'\u00e9v\u00e9nement Datex II " + situationRecord.getId()), (Throwable)e);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return listeEvenements;
    }

    @Override
    public ArrayList<Evenement> genererEvenements(D2LogicalModel d2LogicalModel, String zoneRoutiere, String filtreDelegation) throws Exception {
        return this.genererEvenements(d2LogicalModel);
    }

    @Override
    public void initMapDatex2(Map<String, CorrespondanceDatex2> map) {
        this.mapDatex2Prism = map;
    }

    @Override
    public void setNationalIdentifier(String nationalIdentifier) {
        this.nationalIdentifier = nationalIdentifier;
    }

    public void setValeur(ValeurChampCollectionChoixUnique v, ChampCollectionChoixUnique c, String valeur) {
        for (String valeurTemp : c.getValeurs()) {
            if (!valeurTemp.equalsIgnoreCase(valeur)) continue;
            v.setValeur(valeurTemp);
            break;
        }
    }
}

