/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prism.webservices.datex2;

import com.geolocsystems.deepcopyutil.DeepCopy;
import com.geolocsystems.prism.webservices.datex2.ConstantesDatex2v2;
import com.geolocsystems.prism.webservices.datex2.ConvertisseurDatex2V2;
import com.geolocsystems.prism.webservices.datex2.CorrespondanceTablesV2;
import com.geolocsystems.prism.webservices.datex2.LocalisationDatex2DepartementException;
import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.IDescription;
import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampLocalisation;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampVehiculeEnCause;
import com.geolocsystems.prismbatch.BusinessServiceFactory;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.beans.CorrespondanceDatex2;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import com.geolocsystems.prismcentralvaadin.config.IConfiguration;
import eu.datex2.schema._2._2_0.AbnormalTraffic;
import eu.datex2.schema._2._2_0.AbnormalTrafficTypeEnum;
import eu.datex2.schema._2._2_0.Accident;
import eu.datex2.schema._2._2_0.AccidentTypeEnum;
import eu.datex2.schema._2._2_0.AffectedCarriagewayAndLanes;
import eu.datex2.schema._2._2_0.AlertCDirection;
import eu.datex2.schema._2._2_0.AlertCDirectionEnum;
import eu.datex2.schema._2._2_0.AlertCLocation;
import eu.datex2.schema._2._2_0.AlertCMethod4Linear;
import eu.datex2.schema._2._2_0.AlertCMethod4Point;
import eu.datex2.schema._2._2_0.AlertCMethod4PrimaryPointLocation;
import eu.datex2.schema._2._2_0.AlertCMethod4SecondaryPointLocation;
import eu.datex2.schema._2._2_0.AnimalPresenceObstruction;
import eu.datex2.schema._2._2_0.AnimalPresenceTypeEnum;
import eu.datex2.schema._2._2_0.Area;
import eu.datex2.schema._2._2_0.AreaDestination;
import eu.datex2.schema._2._2_0.CarriagewayEnum;
import eu.datex2.schema._2._2_0.Comment;
import eu.datex2.schema._2._2_0.CommentTypeEnum;
import eu.datex2.schema._2._2_0.ComparisonOperatorEnum;
import eu.datex2.schema._2._2_0.ConfidentialityValueEnum;
import eu.datex2.schema._2._2_0.CountryEnum;
import eu.datex2.schema._2._2_0.D2LogicalModel;
import eu.datex2.schema._2._2_0.DelayBandEnum;
import eu.datex2.schema._2._2_0.Delays;
import eu.datex2.schema._2._2_0.DelaysTypeEnum;
import eu.datex2.schema._2._2_0.Destination;
import eu.datex2.schema._2._2_0.DirectionEnum;
import eu.datex2.schema._2._2_0.DistanceFromLinearElementReferent;
import eu.datex2.schema._2._2_0.EnvironmentalObstruction;
import eu.datex2.schema._2._2_0.EnvironmentalObstructionTypeEnum;
import eu.datex2.schema._2._2_0.EquipmentOrSystemFault;
import eu.datex2.schema._2._2_0.Exchange;
import eu.datex2.schema._2._2_0.GeneralObstruction;
import eu.datex2.schema._2._2_0.GrossWeightCharacteristic;
import eu.datex2.schema._2._2_0.GroupOfLocations;
import eu.datex2.schema._2._2_0.GroupOfPeopleInvolved;
import eu.datex2.schema._2._2_0.GroupOfVehiclesInvolved;
import eu.datex2.schema._2._2_0.HeaderInformation;
import eu.datex2.schema._2._2_0.Impact;
import eu.datex2.schema._2._2_0.InformationStatusEnum;
import eu.datex2.schema._2._2_0.InfrastructureDamageObstruction;
import eu.datex2.schema._2._2_0.InfrastructureDamageTypeEnum;
import eu.datex2.schema._2._2_0.InjuryStatusTypeEnum;
import eu.datex2.schema._2._2_0.InternationalIdentifier;
import eu.datex2.schema._2._2_0.LaneEnum;
import eu.datex2.schema._2._2_0.LifeCycleManagement;
import eu.datex2.schema._2._2_0.Linear;
import eu.datex2.schema._2._2_0.LinearElement;
import eu.datex2.schema._2._2_0.LinearElementByPoints;
import eu.datex2.schema._2._2_0.LinearElementNatureEnum;
import eu.datex2.schema._2._2_0.LinearReferencingDirectionEnum;
import eu.datex2.schema._2._2_0.LinearWithinLinearElement;
import eu.datex2.schema._2._2_0.LoadTypeEnum;
import eu.datex2.schema._2._2_0.Location;
import eu.datex2.schema._2._2_0.LocationByReference;
import eu.datex2.schema._2._2_0.MaintenanceWorks;
import eu.datex2.schema._2._2_0.Management;
import eu.datex2.schema._2._2_0.MeasurementSiteRecord;
import eu.datex2.schema._2._2_0.MeasurementSiteTable;
import eu.datex2.schema._2._2_0.MeasurementSiteTablePublication;
import eu.datex2.schema._2._2_0.Mobility;
import eu.datex2.schema._2._2_0.MobilityEnum;
import eu.datex2.schema._2._2_0.MultilingualString;
import eu.datex2.schema._2._2_0.MultilingualStringValue;
import eu.datex2.schema._2._2_0.NetworkLocation;
import eu.datex2.schema._2._2_0.NetworkManagement;
import eu.datex2.schema._2._2_0.NonManagedCause;
import eu.datex2.schema._2._2_0.NonOrderedLocationGroupByList;
import eu.datex2.schema._2._2_0.NonWeatherRelatedRoadConditionTypeEnum;
import eu.datex2.schema._2._2_0.NonWeatherRelatedRoadConditions;
import eu.datex2.schema._2._2_0.Obstruction;
import eu.datex2.schema._2._2_0.ObstructionTypeEnum;
import eu.datex2.schema._2._2_0.OffsetDistance;
import eu.datex2.schema._2._2_0.OperatingModeEnum;
import eu.datex2.schema._2._2_0.OverallPeriod;
import eu.datex2.schema._2._2_0.PersonCategoryEnum;
import eu.datex2.schema._2._2_0.Point;
import eu.datex2.schema._2._2_0.PointAlongLinearElement;
import eu.datex2.schema._2._2_0.PointCoordinates;
import eu.datex2.schema._2._2_0.PoorEnvironmentConditions;
import eu.datex2.schema._2._2_0.PoorEnvironmentTypeEnum;
import eu.datex2.schema._2._2_0.PredefinedLocation;
import eu.datex2.schema._2._2_0.PredefinedLocationsPublication;
import eu.datex2.schema._2._2_0.PredefinedNonOrderedLocationGroup;
import eu.datex2.schema._2._2_0.ProbabilityOfOccurrenceEnum;
import eu.datex2.schema._2._2_0.Referent;
import eu.datex2.schema._2._2_0.ReferentTypeEnum;
import eu.datex2.schema._2._2_0.RelativeTrafficFlowEnum;
import eu.datex2.schema._2._2_0.ReroutingManagement;
import eu.datex2.schema._2._2_0.ResponseEnum;
import eu.datex2.schema._2._2_0.RoadOrCarriagewayOrLaneManagement;
import eu.datex2.schema._2._2_0.SeverityEnum;
import eu.datex2.schema._2._2_0.Situation;
import eu.datex2.schema._2._2_0.SituationPublication;
import eu.datex2.schema._2._2_0.SituationRecord;
import eu.datex2.schema._2._2_0.Source;
import eu.datex2.schema._2._2_0.SourceTypeEnum;
import eu.datex2.schema._2._2_0.SpeedManagement;
import eu.datex2.schema._2._2_0.Subscription;
import eu.datex2.schema._2._2_0.SubscriptionStateEnum;
import eu.datex2.schema._2._2_0.SupplementaryPositionalDescription;
import eu.datex2.schema._2._2_0.Target;
import eu.datex2.schema._2._2_0.TpegAreaDescriptor;
import eu.datex2.schema._2._2_0.TpegHeight;
import eu.datex2.schema._2._2_0.TpegLinearLocation;
import eu.datex2.schema._2._2_0.TpegLoc01AreaLocationSubtypeEnum;
import eu.datex2.schema._2._2_0.TpegLoc01LinearLocationSubtypeEnum;
import eu.datex2.schema._2._2_0.TpegLoc01SimplePointLocationSubtypeEnum;
import eu.datex2.schema._2._2_0.TpegLoc03AreaDescriptorSubtypeEnum;
import eu.datex2.schema._2._2_0.TpegLoc03OtherPointDescriptorSubtypeEnum;
import eu.datex2.schema._2._2_0.TpegLoc04HeightTypeEnum;
import eu.datex2.schema._2._2_0.TpegNamedOnlyArea;
import eu.datex2.schema._2._2_0.TpegNonJunctionPoint;
import eu.datex2.schema._2._2_0.TpegOtherPointDescriptor;
import eu.datex2.schema._2._2_0.TpegPointLocation;
import eu.datex2.schema._2._2_0.TpegSimplePoint;
import eu.datex2.schema._2._2_0.TrafficConstrictionTypeEnum;
import eu.datex2.schema._2._2_0.TrafficElement;
import eu.datex2.schema._2._2_0.TrafficFlowCharacteristicsEnum;
import eu.datex2.schema._2._2_0.TrafficTrendTypeEnum;
import eu.datex2.schema._2._2_0.UpdateMethodEnum;
import eu.datex2.schema._2._2_0.UrlLink;
import eu.datex2.schema._2._2_0.UrlLinkTypeEnum;
import eu.datex2.schema._2._2_0.Validity;
import eu.datex2.schema._2._2_0.ValidityStatusEnum;
import eu.datex2.schema._2._2_0.Vehicle;
import eu.datex2.schema._2._2_0.VehicleCharacteristics;
import eu.datex2.schema._2._2_0.VehicleObstruction;
import eu.datex2.schema._2._2_0.VehicleObstructionTypeEnum;
import eu.datex2.schema._2._2_0.VehicleTypeEnum;
import eu.datex2.schema._2._2_0.VmsPictogramDisplayCharacteristics;
import eu.datex2.schema._2._2_0.VmsRecord;
import eu.datex2.schema._2._2_0.VmsTablePublication;
import eu.datex2.schema._2._2_0.VmsTextDisplayCharacteristics;
import eu.datex2.schema._2._2_0.VmsUnitRecord;
import eu.datex2.schema._2._2_0.VmsUnitTable;
import eu.datex2.schema._2._2_0.WeatherRelatedRoadConditions;
import eu.datex2.schema._2._2_0._ExtensionType;
import eu.datex2.schema._2._2_0._PredefinedLocationVersionedReference;
import eu.datex2.schema._2._2_0._VehicleCharacteristicsExtensionType;
import eu.datex2.schema._2._2_0._VmsRecordPictogramDisplayAreaIndexVmsPictogramDisplayCharacteristics;
import eu.datex2.schema._2._2_0._VmsUnitRecordVmsIndexVmsRecord;
import gls.geometry.GeoPoint;
import gls.outils.Extension;
import gls.outils.GLS;
import gls.outils.GLSDate;
import gls.outils.GLSHashMap;
import gls.outils.classe.ClassUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axis.Constants;
import org.apache.axis.encoding.ser.CalendarDeserializer;
import org.apache.axis.message.MessageElement;
import org.apache.axis.types.Id;
import org.apache.axis.types.Language;
import org.apache.axis.types.NonNegativeInteger;
import org.apache.axis.types.URI;
import org.apache.axis.utils.XMLChar;
import org.apache.log4j.Logger;

public class ConvertisseurDatex2V2Impl
implements ConstantesDatex2v2,
ConvertisseurDatex2V2 {
    private Logger log = Logger.getLogger(ConvertisseurDatex2V2Impl.class);
    protected Map<String, CorrespondanceDatex2> mapPrismDatex2 = null;
    protected String nationalIdentifier = "PRISM";

    @Override
    public Id convertStringToId(String id) {
        Id monId = null;
        if (id != null && Id.isValid((String)id)) {
            monId = new Id(id);
        } else {
            StringBuffer strBuff = new StringBuffer();
            int i = 0;
            while (i < id.length()) {
                if (i == 0) {
                    if (!XMLChar.isNCNameStart((int)id.charAt(i))) {
                        strBuff.append("X");
                        if (!XMLChar.isNCName((int)id.charAt(i))) {
                            strBuff.append("_");
                        } else {
                            strBuff.append(id.charAt(i));
                        }
                    } else {
                        strBuff.append(id.charAt(i));
                    }
                }
                if (i != 0) {
                    if (!XMLChar.isNCName((int)id.charAt(i))) {
                        strBuff.append("_");
                    } else {
                        strBuff.append(id.charAt(i));
                    }
                }
                ++i;
            }
            monId = new Id(strBuff.toString());
        }
        return monId;
    }

    @Override
    public Vector<String> getNomChampsStaticEnum(Class classe) {
        try {
            return ClassUtils.getNomChamps((Class)classe, (Class)classe);
        }
        catch (Exception e) {
            return new Vector<String>();
        }
    }

    @Override
    public Object getObjetDatex2(String classe) throws Exception {
        return ClassUtils.getObject((Class)this.getClasseDatex2(classe));
    }

    @Override
    public Class getClasseDatex2(String classe) throws Exception {
        return ClassUtils.getClasse((String)PACKAGE_DATEX2, (String)classe);
    }

    @Override
    public Object lancerMethodeEnumFromValue(String classe, String parametre) throws Exception {
        return this.lancerMethodeEnumFromValue(this.getClasseDatex2(classe), (Object)parametre);
    }

    @Override
    public Object lancerMethodeEnumFromValue(Class classe, Object parametre) throws Exception {
        try {
            return ClassUtils.lancerMethode(null, (Class)classe, (Object[])new Object[]{parametre}, (String)"fromValue");
        }
        catch (Exception e) {
            throw new Exception("LA VALEUR " + parametre + " DE LA CLASSE ENUMERATION " + classe.getSimpleName() + " N'EXISTE PAS");
        }
    }

    @Override
    public Subscription genererSubscription(Extension parametresDatex2) throws Exception {
        Subscription subscription = new Subscription();
        if (parametresDatex2.getBoolean("MODE_PUSH", true)) {
            subscription.setOperatingMode(OperatingModeEnum.operatingMode1);
            subscription.setUpdateMethod(UpdateMethodEnum.allElementUpdate);
        } else {
            subscription.setOperatingMode(OperatingModeEnum.operatingMode3);
            subscription.setUpdateMethod(UpdateMethodEnum.snapshot);
        }
        subscription.setSubscriptionStartTime(this.getDateTimeDatex(parametresDatex2.getString("SUBSCRIPTION_START")));
        subscription.setSubscriptionState(SubscriptionStateEnum.active);
        Target[] t = new Target[]{new Target()};
        t[0].setAddress(parametresDatex2.getString("TARGET_ADDRESS"));
        t[0].setProtocol(parametresDatex2.getString("TARGET_PROTOCOL"));
        subscription.setTarget(t);
        return subscription;
    }

    @Override
    public InternationalIdentifier genererInternationalIdentifier(Extension parametresDatex2) throws Exception {
        return new InternationalIdentifier(CountryEnum.fromString(parametresDatex2.getString(COUNTRY_ENUM)), parametresDatex2.getString("fournisseur"), null);
    }

    @Override
    public Exchange genererExchange(Extension parametresDatex2, ResponseEnum response) throws Exception {
        Exchange exchange;
        block7: {
            this.log.debug((Object)"<defineExchange>");
            exchange = new Exchange();
            try {
                try {
                    Calendar cal = GLSDate.maintenant();
                    Calendar calPlus1H = GLSDate.maintenant();
                    calPlus1H.add(10, 1);
                    exchange.setHistoricalStartDate(cal);
                    exchange.setHistoricalStopDate(calPlus1H);
                    exchange.setSupplierIdentification(this.genererInternationalIdentifier(parametresDatex2));
                    this.log.debug((Object)("SupplierIdentification --> " + parametresDatex2.getString("fournisseur")));
                    exchange.setSubscription(this.genererSubscription(parametresDatex2));
                    exchange.setResponse(response);
                }
                catch (Exception e) {
                    this.log.debug((Object)e);
                    this.log.debug((Object)"</defineExchange>");
                    break block7;
                }
            }
            catch (Throwable throwable) {
                this.log.debug((Object)"</defineExchange>");
                throw throwable;
            }
            this.log.debug((Object)"</defineExchange>");
        }
        try {
            exchange.setResponse(ResponseEnum.fromString(parametresDatex2.getString(RESPONSE)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return exchange;
    }

    @Override
    public Language genererLanguage(Extension parametresDatex2) throws Exception {
        Language language = new Language();
        language = new Language(parametresDatex2.getString("COUNTRY"));
        return language;
    }

    @Override
    public SituationPublication genererSituationPublication(Extension parametresDatex2) throws Exception {
        this.log.debug((Object)"<SituationPublication>");
        SituationPublication situationPublication = new SituationPublication();
        situationPublication.setLang(this.genererLanguage(parametresDatex2));
        situationPublication.setPublicationTime(this.getDateTime());
        situationPublication.setPublicationCreator(this.genererInternationalIdentifier(parametresDatex2));
        situationPublication.setFeedType(String.valueOf(BusinessServiceFactory.getDatex2Service().getNumFichier()));
        this.log.debug((Object)"</SituationPublication>");
        return situationPublication;
    }

    @Override
    public String genererIdSituation(Extension parametresDatex2) throws Exception {
        return this.genererId(parametresDatex2.getString("fournisseur").concat("_"));
    }

    @Override
    public String genererId(String prefix) {
        return GLS.genererNumeroUnique((String)prefix);
    }

    @Override
    public Validity genererValidity(Extension parametresDatex2) throws Exception {
        this.log.debug((Object)"<validity>");
        Validity validity = new Validity();
        validity.setValidityTimeSpecification(this.getOverallPeriod(parametresDatex2.getString("validityTimeSpecificationStart"), parametresDatex2.getString("validityTimeSpecificationStop")));
        validity.setValidityStatus(ValidityStatusEnum.fromString(parametresDatex2.getString(VALIDITY_STATUS)));
        this.log.debug((Object)"</validity>");
        return validity;
    }

    @Override
    public OverallPeriod getOverallPeriod(String dateDebut, String dateFin) throws Exception {
        this.log.debug((Object)"<overallPeriod>");
        OverallPeriod overallPeriod = new OverallPeriod();
        overallPeriod.setOverallStartTime(this.getDateTimeDatex(dateDebut));
        if (!GLS.estVide((String)dateFin)) {
            Calendar t = this.getDateTimeDatex(dateFin);
            overallPeriod.setOverallEndTime(t);
        }
        this.log.debug((Object)"</overallPeriod>");
        return overallPeriod;
    }

    @Override
    public Calendar getDateTime() {
        return GLSDate.maintenant();
    }

    @Override
    public Calendar getDateTime(String date) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        try {
            String temp = String.valueOf(date.substring(0, 22)) + date.substring(23);
            Date d1 = sdf.parse(temp);
            Calendar cal = Calendar.getInstance(Locale.FRANCE);
            cal.setTime(d1);
            int offset = cal.get(15) + cal.get(16);
            cal.setTimeInMillis(cal.getTimeInMillis() - (long)offset);
            return cal;
        }
        catch (ParseException e) {
            Calendar cal = (Calendar)new CalendarDeserializer(String.class, Constants.XSD_STRING).makeValue(date);
            int offset = cal.get(15) + cal.get(16);
            cal.setTimeInMillis(cal.getTimeInMillis() - (long)offset);
            return cal;
        }
    }

    @Override
    public Calendar getDateTimeDatex(String date) throws Exception {
        if (!GLS.estVide((String)date)) {
            if (date.indexOf("P") != -1) {
                date = date.substring(0, date.length() - 3);
            }
        } else {
            GLS.getDate();
            date = GLSDate.toDateDatex();
        }
        this.log.debug((Object)("Date \u00e0 parser " + date));
        try {
            GLS.getDate();
            Calendar c = GLSDate.toDateDatex((String)date);
            return c;
        }
        catch (Exception e) {
            this.log.error((Object)(String.valueOf(date) + "\n"), (Throwable)e);
            return Calendar.getInstance();
        }
    }

    @Override
    public Delays genererDelays(Extension parametresDatex2) throws Exception {
        Delays delays = new Delays();
        boolean delayExist = false;
        if (parametresDatex2.existe(IMPACT_DELAYS_BAND)) {
            delays.setDelayBand(DelayBandEnum.fromString(parametresDatex2.getString(IMPACT_DELAYS_BAND)));
            delayExist = true;
        }
        if (parametresDatex2.existe(IMPACT_DELAYS_TYPE)) {
            delays.setDelaysType(DelaysTypeEnum.fromString(parametresDatex2.getString(IMPACT_DELAYS_TYPE)));
            delayExist = true;
        }
        if (parametresDatex2.existe("delaysValue")) {
            delays.setDelayTimeValue(Float.valueOf(parametresDatex2.getFloat("delaysValue", 60.0f)));
            delayExist = true;
        }
        if (delayExist) {
            return delays;
        }
        return null;
    }

    @Override
    public Impact genererImpact(Extension parametresDatex2) throws Exception {
        Impact impact = new Impact();
        if (!parametresDatex2.estIntVide("numberOfLanesRestricted")) {
            impact.setNumberOfLanesRestricted(new NonNegativeInteger(parametresDatex2.getString("numberOfLanesRestricted")));
        }
        if (!parametresDatex2.estIntVide("numberOfOperationalLanes")) {
            impact.setNumberOfOperationalLanes(new NonNegativeInteger(parametresDatex2.getString("numberOfOperationalLanes")));
        }
        if (!parametresDatex2.estIntVide("originalNumberOfLanes")) {
            impact.setOriginalNumberOfLanes(new NonNegativeInteger(parametresDatex2.getString("originalNumberOfLanes")));
        }
        if (!parametresDatex2.estStringVide(IMPACT_DETAILS_TRAFFIC_RESTRICTION_TYPE)) {
            impact.setTrafficConstrictionType(TrafficConstrictionTypeEnum.fromString(parametresDatex2.getString(IMPACT_DETAILS_TRAFFIC_RESTRICTION_TYPE)));
        }
        impact.setDelays(this.genererDelays(parametresDatex2));
        return impact;
    }

    @Override
    public Source genererSourceInformation(Extension parametresDatex2) throws Exception {
        Source sourceInformation = new Source();
        if (!parametresDatex2.estStringVide("sourceIdentification")) {
            sourceInformation.setSourceIdentification(parametresDatex2.getString("sourceIdentification"));
        }
        sourceInformation.setSourceType(SourceTypeEnum.fromString(parametresDatex2.getString("sourceIdentificationSourceType")));
        if (!parametresDatex2.estStringVide("sourceIdentificationSourceName")) {
            MultilingualStringValue values = new MultilingualStringValue(parametresDatex2.getString("sourceInformationSourceName"));
            values.setLang(new Language("fr"));
            sourceInformation.setSourceName(new MultilingualString(new MultilingualStringValue[]{values}));
        }
        return sourceInformation;
    }

    @Override
    public Comment[] genererCommentaireMultiLang(Comment[] commentsInit, String commentaireFr, String commentaireEn, CommentTypeEnum commentType) throws Exception {
        Comment comment;
        ArrayList<Comment> comments = new ArrayList<Comment>();
        if (commentsInit != null && commentsInit.length > 0) {
            Comment[] commentArray = commentsInit;
            int n = commentsInit.length;
            int n2 = 0;
            while (n2 < n) {
                comment = commentArray[n2];
                comments.add(comment);
                ++n2;
            }
        }
        if (!GLS.estVide((String)commentaireFr)) {
            comment = new Comment();
            MultilingualString commentComment = new MultilingualString();
            MultilingualStringValue[] commentValues = new MultilingualStringValue[2];
            MultilingualStringValue ccv = new MultilingualStringValue(GLS.getString((String)commentaireFr, (String)""));
            ccv.setLang(new Language("fr"));
            commentValues[0] = ccv;
            ccv = new MultilingualStringValue(GLS.getString((String)commentaireEn, (String)""));
            ccv.setLang(new Language("en"));
            commentValues[1] = ccv;
            commentComment.setValues(commentValues);
            comment.setComment(commentComment);
            comment.setCommentType(commentType);
            comments.add(comment);
        }
        return comments.toArray(new Comment[comments.size()]);
    }

    @Override
    public Comment[] genererCommentaire(Comment[] commentsInit, String commentaire, CommentTypeEnum commentType) throws Exception {
        Comment comment;
        ArrayList<Comment> comments = new ArrayList<Comment>();
        if (commentsInit != null && commentsInit.length > 0) {
            Comment[] commentArray = commentsInit;
            int n = commentsInit.length;
            int n2 = 0;
            while (n2 < n) {
                comment = commentArray[n2];
                comments.add(comment);
                ++n2;
            }
        }
        if (!GLS.estVide((String)commentaire)) {
            comment = new Comment();
            MultilingualString commentComment = new MultilingualString();
            MultilingualStringValue[] commentValues = new MultilingualStringValue[]{new MultilingualStringValue(GLS.getString((String)commentaire, (String)""))};
            commentComment.setValues(commentValues);
            comment.setComment(commentComment);
            comment.setCommentType(commentType);
            comments.add(comment);
        }
        return comments.toArray(new Comment[comments.size()]);
    }

    @Override
    public LifeCycleManagement genererLifeCycleManagement(boolean end, boolean cancel) throws Exception {
        LifeCycleManagement lifeCycleManagement = new LifeCycleManagement();
        lifeCycleManagement.setCancel(cancel);
        lifeCycleManagement.setEnd(end);
        return lifeCycleManagement;
    }

    @Override
    public Management genererManagement(Boolean end, Boolean cancel) throws Exception {
        Management management = new Management();
        management.setLifeCycleManagement(this.genererLifeCycleManagement(end, cancel));
        return management;
    }

    @Override
    public SituationRecord genererSituationRecord(SituationRecord situationRecord, Extension parametresDatex2, String situationRecordId, String situationRecordReference, String situationRecordVersion, Boolean end, Boolean cancel) throws Exception {
        Comment[] comments;
        this.log.debug((Object)"<situationRecord>");
        situationRecord.setId(situationRecordId);
        situationRecord.setVersion(situationRecordVersion);
        situationRecord.setSituationRecordCreationTime(this.getDateTimeDatex(parametresDatex2.getString("creationTime")));
        situationRecord.setSituationRecordVersionTime(this.getDateTimeDatex(parametresDatex2.getString("versionTime")));
        situationRecord.setSituationRecordObservationTime(this.getDateTime());
        situationRecord.setSituationRecordFirstSupplierVersionTime(this.getDateTimeDatex(parametresDatex2.getString("firstSupplierVersionTime")));
        situationRecord.setSituationRecordCreationReference(situationRecordReference);
        situationRecord.setProbabilityOfOccurrence(ProbabilityOfOccurrenceEnum.fromString(parametresDatex2.getString(PROBABILITY_OF_OCCURRENCE)));
        situationRecord.setValidity(this.genererValidity(parametresDatex2));
        if (parametresDatex2.getValeur("PHOTOS") != null) {
            String[] lienPhotos = (String[])parametresDatex2.getValeur("PHOTOS");
            UrlLink[] urlLink = new UrlLink[lienPhotos.length];
            int i = 0;
            while (i < lienPhotos.length) {
                urlLink[i] = new UrlLink();
                urlLink[i].setUrlLinkAddress(new URI(lienPhotos[i]));
                urlLink[i].setUrlLinkType(UrlLinkTypeEnum.image);
                ++i;
            }
            situationRecord.setUrlLink(urlLink);
        }
        if (!parametresDatex2.estStringVide("commentaireMultiLang")) {
            comments = this.genererCommentaireMultiLang(situationRecord.getGeneralPublicComment(), parametresDatex2.getString("commentaireMultiLangFr"), parametresDatex2.getString("commentaireMultiLangEn"), CommentTypeEnum.description);
            situationRecord.setGeneralPublicComment(comments);
        }
        if (!parametresDatex2.estStringVide("priveCommentaireMultiLang")) {
            comments = this.genererCommentaireMultiLang(situationRecord.getGeneralPublicComment(), parametresDatex2.getString("priveeCommentaireMultiLangFr"), parametresDatex2.getString("priveeCommentaireMultiLangEn"), CommentTypeEnum.description);
            situationRecord.setNonGeneralPublicComment(comments);
        }
        situationRecord.setImpact(this.genererImpact(parametresDatex2));
        situationRecord.setSource(this.genererSourceInformation(parametresDatex2));
        String typeLocalisation = parametresDatex2.getString("typeLocalisation");
        if (typeLocalisation.equals("NonOrderedLocationGroupByList")) {
            situationRecord.setGroupOfLocations(this.genererLocationList(parametresDatex2));
        } else {
            situationRecord.setGroupOfLocations(this.genererLocation(parametresDatex2));
        }
        this.genererSituationRecordType(situationRecord, parametresDatex2);
        situationRecord.setManagement(this.genererManagement(end, cancel));
        this.log.debug((Object)"</situationRecord>");
        return situationRecord;
    }

    @Override
    public Vehicle[] defineVehicles(Extension parametresDatex2) {
        Vehicle[] vehicles = null;
        Vehicle vehicle = null;
        ArrayList<Vehicle> alPI = new ArrayList<Vehicle>();
        this.log.debug((Object)"<obstructingVehicle>");
        try {
            try {
                VehicleCharacteristics vehicleCharacteristics;
                int nbe = parametresDatex2.getInt("ACCIDENT_NB_VEHICULES", 0);
                if (nbe > 0) {
                    vehicle = new Vehicle();
                    vehicleCharacteristics = new VehicleCharacteristics();
                    vehicleCharacteristics.setVehicleType(new VehicleTypeEnum[]{VehicleTypeEnum.car});
                    vehicle.setVehicleCharacteristics(vehicleCharacteristics);
                    alPI.add(vehicle);
                    this.log.debug((Object)("NumberOfVehicles --> " + nbe));
                }
                if ((nbe = parametresDatex2.getInt("ACCIDENT_NB_PL", 0)) > 0 || parametresDatex2.getBoolean("ACCIDENT_TMD", false)) {
                    vehicle = new Vehicle();
                    vehicleCharacteristics = new VehicleCharacteristics();
                    if (nbe > 0) {
                        vehicleCharacteristics.setVehicleType(new VehicleTypeEnum[]{VehicleTypeEnum.lorry});
                    }
                    if (parametresDatex2.getBoolean("ACCIDENT_TMD", false)) {
                        vehicleCharacteristics.setLoadType(LoadTypeEnum.hazardousMaterials);
                    }
                    if (parametresDatex2.getString("CAUSE_PL") != null) {
                        _VehicleCharacteristicsExtensionType vehicleCharacteristicsExtension = new _VehicleCharacteristicsExtensionType();
                        MessageElement[] messageElement = new MessageElement[1];
                        NonManagedCause cause = new NonManagedCause();
                        cause.setCauseDescription(this.genererMultilingualString(parametresDatex2.getString("CAUSE_PL"), "fre"));
                        messageElement[0] = new MessageElement(new QName("http://datex2.eu/schema/2/2_0", "nonManagedCause"), (Object)cause);
                        vehicleCharacteristicsExtension.set_any(messageElement);
                        vehicleCharacteristics.setVehicleCharacteristicsExtension(vehicleCharacteristicsExtension);
                    }
                    vehicle.setVehicleCharacteristics(vehicleCharacteristics);
                    alPI.add(vehicle);
                    this.log.debug((Object)("NumberOfLorry --> " + nbe));
                }
                if ((nbe = parametresDatex2.getInt("ACCIDENT_NB_BUS", 0)) > 0) {
                    vehicle = new Vehicle();
                    vehicleCharacteristics = new VehicleCharacteristics();
                    vehicleCharacteristics.setVehicleType(new VehicleTypeEnum[]{VehicleTypeEnum.bus});
                    vehicle.setVehicleCharacteristics(vehicleCharacteristics);
                    alPI.add(vehicle);
                    this.log.debug((Object)("NumberOfBus --> " + nbe));
                }
                if ((nbe = parametresDatex2.getInt("ACCIDENT_NB_VELOS", 0) + parametresDatex2.getInt("ACCIDENT_NB_MOTOS", 0)) > 0) {
                    vehicle = new Vehicle();
                    vehicleCharacteristics = new VehicleCharacteristics();
                    vehicleCharacteristics.setVehicleType(new VehicleTypeEnum[]{VehicleTypeEnum.twoWheeledVehicle});
                    vehicle.setVehicleCharacteristics(vehicleCharacteristics);
                    alPI.add(vehicle);
                    this.log.debug((Object)("NumberOfTwoWheeledVehicle --> " + nbe));
                }
                if (alPI.size() > 0) {
                    vehicles = new Vehicle[alPI.size()];
                    vehicles = alPI.toArray(vehicles);
                }
            }
            catch (Exception e) {
                this.log.debug((Object)e);
                vehicles = null;
                this.log.debug((Object)"</defineVehiclesInvolved>");
            }
        }
        finally {
            this.log.debug((Object)"</defineVehiclesInvolved>");
        }
        return vehicles;
    }

    @Override
    public void defineVehiclesNetworkManagement(Extension parametresDatex2, NetworkManagement networkManagement) {
        if (parametresDatex2.getString("VEHCIULES_CONCERNES") != null) {
            this.log.debug((Object)"<forVehiclesWithCharacteristicsOf>");
            VehicleCharacteristics vehicleCharacteristics = new VehicleCharacteristics();
            if ("VEHCIULES_CONCERNES_TOUSVEHICULES".equals(parametresDatex2.getString("VEHCIULES_CONCERNES"))) {
                vehicleCharacteristics.setVehicleType(new VehicleTypeEnum[]{VehicleTypeEnum.anyVehicle});
            } else if ("VEHCIULES_CONCERNES_AUTRE".equals(parametresDatex2.getString("VEHCIULES_CONCERNES"))) {
                vehicleCharacteristics.setVehicleType(new VehicleTypeEnum[]{VehicleTypeEnum.other});
                _VehicleCharacteristicsExtensionType vehicleCharacteristicsExtension = new _VehicleCharacteristicsExtensionType();
                MessageElement messageElement = new MessageElement(new QName("http://datex2.eu/schema/2/2_0", "comment"), (Object)parametresDatex2.getString("DESCRIPTION_VEHICULE"));
                messageElement.addAttribute("http://datex2.eu/schema/2/2_0", "lang", "fre");
                vehicleCharacteristicsExtension.set_any(new MessageElement[]{messageElement});
                vehicleCharacteristics.setVehicleCharacteristicsExtension(vehicleCharacteristicsExtension);
            } else {
                vehicleCharacteristics.setVehicleType(new VehicleTypeEnum[]{VehicleTypeEnum.lorry});
                this.log.debug((Object)"<grossWeightCharacteristic>");
                GrossWeightCharacteristic grossWeightCharacteristic = new GrossWeightCharacteristic();
                if ("VEHCIULES_CONCERNES_VEHICULES_INFEGA19T".equals(parametresDatex2.getString("VEHCIULES_CONCERNES"))) {
                    grossWeightCharacteristic.setComparisonOperator(ComparisonOperatorEnum.lessThanOrEqualTo);
                    grossWeightCharacteristic.setGrossVehicleWeight(19.0f);
                } else if ("VEHCIULES_CONCERNES_VEHICULES_SUP19T".equals(parametresDatex2.getString("VEHCIULES_CONCERNES"))) {
                    grossWeightCharacteristic.setComparisonOperator(ComparisonOperatorEnum.greaterThan);
                    grossWeightCharacteristic.setGrossVehicleWeight(19.0f);
                } else if ("VEHCIULES_CONCERNES_VEHICULES_INFEGA7P5T".equals(parametresDatex2.getString("VEHCIULES_CONCERNES"))) {
                    grossWeightCharacteristic.setComparisonOperator(ComparisonOperatorEnum.lessThanOrEqualTo);
                    grossWeightCharacteristic.setGrossVehicleWeight(7.5f);
                } else {
                    grossWeightCharacteristic.setComparisonOperator(ComparisonOperatorEnum.greaterThan);
                    grossWeightCharacteristic.setGrossVehicleWeight(7.5f);
                }
                vehicleCharacteristics.setGrossWeightCharacteristic(new GrossWeightCharacteristic[]{grossWeightCharacteristic});
                this.log.debug((Object)"</grossWeightCharacteristic>");
            }
            networkManagement.setForVehiclesWithCharacteristicsOf(new VehicleCharacteristics[]{vehicleCharacteristics});
            this.log.debug((Object)"</forVehiclesWithCharacteristicsOf>");
        }
    }

    @Override
    public void genererSituationRecordTypeAccident(Accident accident, Extension parametresDatex2) {
    }

    public void genererSituationRecordTypeAbnormalTraffic(AbnormalTraffic abnormalTraffic, Extension parametresDatex2) {
    }

    @Override
    public void genererSituationRecordTypeVehicleObstruction(VehicleObstruction vehicleObstruction, Extension parametresDatex2) {
    }

    @Override
    public void genererSituationRecordTypeGeneralObstruction(GeneralObstruction generalObstruction, Extension parametresDatex2) {
    }

    @Override
    public void genererSituationRecordTypeAnimalPresenceObstruction(AnimalPresenceObstruction animalPresenceObstruction, Extension parametresDatex2) {
    }

    @Override
    public void genererSituationRecordTypeEnvironmentalObstruction(EnvironmentalObstruction environmentalObstruction, Extension parametresDatex2) {
    }

    @Override
    public void genererSituationRecordTypeEnvironmentalObstruction(InfrastructureDamageObstruction infrastructureDamageObstruction, Extension parametresDatex2) {
    }

    @Override
    public void genererSituationRecordTypeMaintenanceWorks(MaintenanceWorks maintenanceWorks, Extension parametresDatex2) {
        CorrespondanceTablesV2 corres = CorrespondanceTablesV2.instanceOf();
    }

    @Override
    public void genererSituationRecordTypeWeatherRelatedRoadConditions(WeatherRelatedRoadConditions weatherRelatedRoadConditions, Extension parametresDatex2) {
        CorrespondanceTablesV2 corres = CorrespondanceTablesV2.instanceOf();
    }

    @Override
    public void genererSituationRecordTypeEquipmentOrSystemFault(EquipmentOrSystemFault equipmentOrSystemFault, Extension parametresDatex2) {
        CorrespondanceTablesV2 corres = CorrespondanceTablesV2.instanceOf();
    }

    @Override
    public void genererSituationRecordTypePoorEnvironmentConditions(PoorEnvironmentConditions poorEnvironmentConditions, Extension parametresDatex2) {
    }

    @Override
    public void genererSituationRecordTypeRoadOrCarriagewayOrLaneManagement(RoadOrCarriagewayOrLaneManagement roadOrCarriagewayOrLaneManagement, Extension parametresDatex2) {
        CorrespondanceTablesV2 corres = CorrespondanceTablesV2.instanceOf();
        this.defineVehiclesNetworkManagement(parametresDatex2, roadOrCarriagewayOrLaneManagement);
    }

    @Override
    public void genererSituationRecordTypeReroutingManagement(ReroutingManagement reroutingManagement, Extension parametresDatex2) {
        CorrespondanceTablesV2 corres = CorrespondanceTablesV2.instanceOf();
        this.defineVehiclesNetworkManagement(parametresDatex2, reroutingManagement);
    }

    @Override
    public void genererSituationRecordTypeSpeedManagement(SpeedManagement speedManagement, Extension parametresDatex2) {
        CorrespondanceTablesV2 corres = CorrespondanceTablesV2.instanceOf();
        this.defineVehiclesNetworkManagement(parametresDatex2, speedManagement);
    }

    @Override
    public void genererSituationRecordType(SituationRecord situationRecord, Extension parametresDatex2) {
        if (situationRecord instanceof Accident) {
            this.genererSituationRecordTypeAccident((Accident)situationRecord, parametresDatex2);
        } else if (situationRecord instanceof AbnormalTraffic) {
            this.genererSituationRecordTypeAbnormalTraffic((AbnormalTraffic)situationRecord, parametresDatex2);
        } else if (situationRecord instanceof VehicleObstruction) {
            this.genererSituationRecordTypeVehicleObstruction((VehicleObstruction)situationRecord, parametresDatex2);
        } else if (situationRecord instanceof GeneralObstruction) {
            this.genererSituationRecordTypeGeneralObstruction((GeneralObstruction)situationRecord, parametresDatex2);
        } else if (situationRecord instanceof AnimalPresenceObstruction) {
            this.genererSituationRecordTypeAnimalPresenceObstruction((AnimalPresenceObstruction)situationRecord, parametresDatex2);
        } else if (situationRecord instanceof EnvironmentalObstruction) {
            this.genererSituationRecordTypeEnvironmentalObstruction((EnvironmentalObstruction)situationRecord, parametresDatex2);
        } else if (situationRecord instanceof InfrastructureDamageObstruction) {
            this.genererSituationRecordTypeEnvironmentalObstruction((InfrastructureDamageObstruction)situationRecord, parametresDatex2);
        } else if (situationRecord instanceof MaintenanceWorks) {
            this.genererSituationRecordTypeMaintenanceWorks((MaintenanceWorks)situationRecord, parametresDatex2);
        } else if (situationRecord instanceof WeatherRelatedRoadConditions) {
            this.genererSituationRecordTypeWeatherRelatedRoadConditions((WeatherRelatedRoadConditions)situationRecord, parametresDatex2);
        } else if (situationRecord instanceof EquipmentOrSystemFault) {
            this.genererSituationRecordTypeEquipmentOrSystemFault((EquipmentOrSystemFault)situationRecord, parametresDatex2);
        } else if (situationRecord instanceof PoorEnvironmentConditions) {
            this.genererSituationRecordTypePoorEnvironmentConditions((PoorEnvironmentConditions)situationRecord, parametresDatex2);
        } else if (situationRecord instanceof RoadOrCarriagewayOrLaneManagement) {
            this.genererSituationRecordTypeRoadOrCarriagewayOrLaneManagement((RoadOrCarriagewayOrLaneManagement)situationRecord, parametresDatex2);
        } else if (situationRecord instanceof ReroutingManagement) {
            this.genererSituationRecordTypeReroutingManagement((ReroutingManagement)situationRecord, parametresDatex2);
        } else if (situationRecord instanceof SpeedManagement) {
            this.genererSituationRecordTypeSpeedManagement((SpeedManagement)situationRecord, parametresDatex2);
        } else {
            this.log.warn((Object)"SituationRecord non g\u00e9r\u00e9");
            return;
        }
        CorrespondanceTablesV2 corres = CorrespondanceTablesV2.instanceOf();
    }

    public String getLibelleEtatEvenement(int etat) {
        switch (etat) {
            case 0: {
                return "creation";
            }
            case 1: {
                return "modification";
            }
            case 2: {
                return "fin";
            }
        }
        return "";
    }

    public Boolean getLifeCycleManagementEnd(int etat) throws Exception {
        if (etat == 2) {
            return true;
        }
        return false;
    }

    public String getSituationRecordVersion(int etat) throws Exception {
        switch (etat) {
            case 0: {
                return "1";
            }
            case 1: {
                return "2";
            }
            case 2: {
                return "3";
            }
        }
        throw new Exception("ERREUR LE MODE EVENEMENT " + etat + " N'EST PAS VALIDE");
    }

    @Override
    public AlertCMethod4Linear genererAlertcMethod4Linear(Extension parametresDatex2) throws Exception {
        AlertCMethod4Linear alertcMethod4Linear = new AlertCMethod4Linear();
        alertcMethod4Linear.setAlertCLocationCountryCode(parametresDatex2.getString("alertcCodePays"));
        alertcMethod4Linear.setAlertCLocationTableNumber(parametresDatex2.getString("alertcTableNumber"));
        alertcMethod4Linear.setAlertCLocationTableVersion(parametresDatex2.getString("alertcVersion"));
        alertcMethod4Linear.setAlertCDirection(this.genererAlertcDirection(parametresDatex2));
        alertcMethod4Linear.setAlertCMethod4PrimaryPointLocation(this.genererAlertcMethod4PrimaryPointLocation(parametresDatex2));
        alertcMethod4Linear.setAlertCMethod4SecondaryPointLocation(this.genererAlertcMethod4SecondaryPointLocation(parametresDatex2));
        return alertcMethod4Linear;
    }

    @Override
    public MultilingualString genererMultilingualString(String value, String lang) {
        if (!GLS.estVide((String)value)) {
            return this.genererMultilingualString(new String[]{value}, new String[]{lang});
        }
        return null;
    }

    @Override
    public MultilingualString genererMultilingualString(String[] values, String[] langs) {
        if (!GLS.estVide((String[])values)) {
            MultilingualString multilingualString = new MultilingualString();
            MultilingualStringValue[] multilingualStringValue = new MultilingualStringValue[values.length];
            multilingualString.setValues(multilingualStringValue);
            int i = 0;
            while (i < values.length) {
                multilingualStringValue[i] = new MultilingualStringValue(values[i]);
                multilingualStringValue[i].setLang(new Language(langs[i]));
                ++i;
            }
            return multilingualString;
        }
        return null;
    }

    @Override
    public MultilingualString genererAlertcLocationName(String locationNames) throws Exception {
        if (!GLS.estVide((String)locationNames)) {
            return this.genererAlertcLocationName(new String[]{locationNames});
        }
        return null;
    }

    @Override
    public MultilingualString genererAlertcLocationName(String[] locationNames) throws Exception {
        if (!GLS.estVide((String[])locationNames)) {
            MultilingualString multilingualString = new MultilingualString();
            MultilingualStringValue[] alertCLocationAlertCLocationNameValues = new MultilingualStringValue[locationNames.length];
            multilingualString.setValues(alertCLocationAlertCLocationNameValues);
            int i = 0;
            while (i < locationNames.length) {
                alertCLocationAlertCLocationNameValues[i] = new MultilingualStringValue(locationNames[i]);
                ++i;
            }
            return multilingualString;
        }
        return null;
    }

    @Override
    public AlertCDirection genererAlertcDirection(Extension parametresDatex2) throws Exception {
        AlertCDirection alertcDirection = new AlertCDirection();
        try {
            alertcDirection.setAlertCDirectionCoded(AlertCDirectionEnum.fromString(parametresDatex2.getString(LOCATION_ALERTC_DIRECTION)));
        }
        catch (Exception e) {
            alertcDirection.setAlertCDirectionCoded(AlertCDirectionEnum.unknown);
        }
        return alertcDirection;
    }

    @Override
    public boolean estPointAlertcIntersection(String alertcSubType) {
        return GLS.estDansLaListe((String[])ALERTC_SUBTYPE_INTERSECTION, (String)alertcSubType);
    }

    @Override
    public TpegLoc01SimplePointLocationSubtypeEnum getTPEGLoc01SimplePointLocationSubtype(String alertcSubType) {
        if (this.estPointAlertcIntersection(alertcSubType)) {
            return TpegLoc01SimplePointLocationSubtypeEnum.intersection;
        }
        return TpegLoc01SimplePointLocationSubtypeEnum.nonLinkedPoint;
    }

    @Override
    public TpegLoc01SimplePointLocationSubtypeEnum getTPEGLoc01SimplePointLocationSubtype() {
        return TpegLoc01SimplePointLocationSubtypeEnum.nonLinkedPoint;
    }

    @Override
    public PointCoordinates getPointCoordinates(Extension parametresDatex2, String lignePoint) throws Exception {
        return this.getPointCoordinates(parametresDatex2, new GeoPoint(lignePoint));
    }

    @Override
    public PointCoordinates getPointCoordinates(Extension parametresDatex2, GeoPoint point) throws Exception {
        if (!point.isNull()) {
            PointCoordinates pointCoordonates = new PointCoordinates();
            pointCoordonates.setLongitude((float)point.getX());
            pointCoordonates.setLatitude((float)point.getY());
            return pointCoordonates;
        }
        throw new Exception("ERREUR LE POINT EST NUL");
    }

    @Override
    public TpegOtherPointDescriptor[] genererTPEGOtherPointDescriptorsSecondary(Extension parametresDatex2) throws Exception {
        GLSHashMap tpegDescriptorsMap = new GLSHashMap();
        if (!GLS.estVide((String)parametresDatex2.getString("communeSecondaire"))) {
            tpegDescriptorsMap.put((Object)"townName", (Object)parametresDatex2.getString("communeSecondaire"));
        }
        tpegDescriptorsMap.put((Object)"linkName", (Object)parametresDatex2.getString("RouteSecondaire"));
        return this.genererTPEGOtherPointDescriptors(tpegDescriptorsMap);
    }

    @Override
    public TpegOtherPointDescriptor[] genererTPEGOtherPointDescriptorsPrimary(Extension parametresDatex2) throws Exception {
        GLSHashMap tpegDescriptorsMap = new GLSHashMap();
        if (!GLS.estVide((String)parametresDatex2.getString("communePrimaire"))) {
            tpegDescriptorsMap.put((Object)"townName", (Object)parametresDatex2.getString("communePrimaire"));
        }
        tpegDescriptorsMap.put((Object)"linkName", (Object)parametresDatex2.getString("RoutePrimaire"));
        return this.genererTPEGOtherPointDescriptors(tpegDescriptorsMap);
    }

    @Override
    public TpegOtherPointDescriptor[] genererTPEGOtherPointDescriptors(GLSHashMap tpegDescriptorsMap) throws Exception {
        TpegOtherPointDescriptor[] otherPointDescriptors = new TpegOtherPointDescriptor[tpegDescriptorsMap.size()];
        int i = 0;
        for (String cle : tpegDescriptorsMap.keySet()) {
            otherPointDescriptors[i++] = this.genererTPEGOtherPointDescriptor(TpegLoc03OtherPointDescriptorSubtypeEnum.fromString(cle), tpegDescriptorsMap.getString(cle));
        }
        return otherPointDescriptors;
    }

    @Override
    public TpegPointLocation genererTPEGSimplePoint(Extension parametresDatex2) throws Exception {
        TpegSimplePoint tpegLocation = new TpegSimplePoint();
        tpegLocation.setTpegDirection(DirectionEnum.fromValue(parametresDatex2.getString(LOCATION_TPEG_DIRECTION)));
        tpegLocation.setTpegSimplePointLocationType(this.getTPEGLoc01SimplePointLocationSubtype());
        tpegLocation.setPoint(this.genererTPEGNonJunctionPrimary(parametresDatex2));
        return tpegLocation;
    }

    @Override
    public TpegNonJunctionPoint genererTPEGNonJunctionPrimary(Extension parametresDatex2) throws Exception {
        return this.genererTPEGNonJunction(parametresDatex2, parametresDatex2.getString("XYPrimaire"), this.genererTPEGOtherPointDescriptorsPrimary(parametresDatex2));
    }

    @Override
    public TpegNonJunctionPoint genererTPEGNonJunctionSecondary(Extension parametresDatex2) throws Exception {
        return this.genererTPEGNonJunction(parametresDatex2, parametresDatex2.getString("XYSecondaire"), this.genererTPEGOtherPointDescriptorsSecondary(parametresDatex2));
    }

    @Override
    public TpegNonJunctionPoint genererTPEGNonJunction(Extension parametresDatex2, String point, TpegOtherPointDescriptor[] description) throws Exception {
        TpegNonJunctionPoint tpegNonJunctionPoint = new TpegNonJunctionPoint();
        if (GLS.estVide((String)point)) {
            throw new Exception("ERREUR LE POINT EST NUL");
        }
        tpegNonJunctionPoint.setPointCoordinates(this.getPointCoordinates(parametresDatex2, point));
        tpegNonJunctionPoint.setName(description);
        return tpegNonJunctionPoint;
    }

    @Override
    public TpegLinearLocation genererTPEGLinearLocation(Extension parametresDatex2) throws Exception {
        TpegLinearLocation tpegLocation = new TpegLinearLocation();
        tpegLocation.setTpegDirection(DirectionEnum.fromValue(parametresDatex2.getString(LOCATION_TPEG_DIRECTION)));
        tpegLocation.setTpegLinearLocationType(TpegLoc01LinearLocationSubtypeEnum.fromString(GLS.getString((String)parametresDatex2.getString(LOCATION_TPEG_POINT_SUBTYPE), (String)"segment")));
        tpegLocation.setFrom(this.genererTPEGNonJunctionPrimary(parametresDatex2));
        tpegLocation.setTo(this.genererTPEGNonJunctionSecondary(parametresDatex2));
        return tpegLocation;
    }

    @Override
    public PointAlongLinearElement genererPointAlongLinearElement(Extension parametresDatex2) throws Exception {
        this.log.debug((Object)"<pointAlongLinearElement>");
        PointAlongLinearElement pointAlongLinearElement = new PointAlongLinearElement();
        DistanceFromLinearElementReferent distanceAlongLinearElement = new DistanceFromLinearElementReferent();
        distanceAlongLinearElement.setDistanceAlong(parametresDatex2.getFloat("prDistancePrimaire", 0.0f));
        Referent fromReferent = new Referent();
        fromReferent.setReferentIdentifier(parametresDatex2.getString("prPrimaire"));
        fromReferent.setReferentType(ReferentTypeEnum.boundary);
        distanceAlongLinearElement.setFromReferent(fromReferent);
        pointAlongLinearElement.setDistanceAlongLinearElement(distanceAlongLinearElement);
        String prDirection = GLS.getString((String)parametresDatex2.getString("prDirection"), (String)String.valueOf(1));
        if (String.valueOf(1).equals(prDirection)) {
            pointAlongLinearElement.setDirectionRelativeAtPoint(LinearReferencingDirectionEnum.aligned);
        } else if (String.valueOf(2).equals(prDirection)) {
            pointAlongLinearElement.setDirectionRelativeAtPoint(LinearReferencingDirectionEnum.opposite);
        } else if (String.valueOf(3).equals(prDirection)) {
            pointAlongLinearElement.setDirectionRelativeAtPoint(LinearReferencingDirectionEnum.both);
        } else {
            pointAlongLinearElement.setDirectionRelativeAtPoint(LinearReferencingDirectionEnum.unknown);
        }
        MultilingualStringValue values = new MultilingualStringValue(parametresDatex2.getString("departementPrimaire"));
        values.setLang(new Language("fr"));
        MultilingualString administrativeAreaOfPoint = new MultilingualString(new MultilingualStringValue[]{values});
        pointAlongLinearElement.setAdministrativeAreaOfPoint(administrativeAreaOfPoint);
        pointAlongLinearElement.setLinearElement(this.genererLinearElementByPoints(parametresDatex2));
        this.log.debug((Object)"</pointAlongLinearElement>");
        return pointAlongLinearElement;
    }

    @Override
    public LinearElement genererLinearElement(Extension parametresDatex2) {
        this.log.debug((Object)"<linearElement>");
        LinearElement linearElement = new LinearElement();
        linearElement.setLinearElementNature(LinearElementNatureEnum.road);
        linearElement.setRoadNumber(parametresDatex2.getString("RoutePrimaire"));
        this.log.debug((Object)"</linearElement>");
        return linearElement;
    }

    @Override
    public LinearElement genererLinearElementByPoints(Extension parametresDatex2) {
        this.log.debug((Object)"<linearElement>");
        LinearElementByPoints linearElement = new LinearElementByPoints();
        linearElement.setLinearElementNature(LinearElementNatureEnum.road);
        linearElement.setRoadNumber(parametresDatex2.getString("RoutePrimaire"));
        Referent startPointOfLinearElement = new Referent();
        linearElement.setStartPointOfLinearElement(startPointOfLinearElement);
        startPointOfLinearElement.setReferentIdentifier(parametresDatex2.getString("prPrimaire"));
        startPointOfLinearElement.setReferentType(ReferentTypeEnum.referenceMarker);
        if (!GLS.estVide((String)parametresDatex2.getString("prSecondaire"))) {
            Referent endPointOfLinearElement = new Referent();
            linearElement.setEndPointOfLinearElement(endPointOfLinearElement);
            endPointOfLinearElement.setReferentIdentifier(parametresDatex2.getString("prSecondaire"));
            endPointOfLinearElement.setReferentType(ReferentTypeEnum.referenceMarker);
        } else {
            Referent endPointOfLinearElement = new Referent();
            linearElement.setEndPointOfLinearElement(endPointOfLinearElement);
            endPointOfLinearElement.setReferentIdentifier(parametresDatex2.getString("prPrimaire"));
            endPointOfLinearElement.setReferentType(ReferentTypeEnum.referenceMarker);
        }
        this.log.debug((Object)"</linearElement>");
        return linearElement;
    }

    @Override
    public LinearWithinLinearElement genererLinearWithinLinearElement(Extension parametresDatex2) throws Exception {
        this.log.debug((Object)"<linearWithinLinearElement>");
        LinearWithinLinearElement linearWithinLinearElement = new LinearWithinLinearElement();
        DistanceFromLinearElementReferent fromPoint = new DistanceFromLinearElementReferent();
        Referent fromReferent = new Referent();
        fromReferent.setReferentIdentifier(parametresDatex2.getString("prPrimaire"));
        fromReferent.setReferentType(ReferentTypeEnum.boundary);
        fromPoint.setFromReferent(fromReferent);
        fromPoint.setDistanceAlong(parametresDatex2.getFloat("prDistancePrimaire", 0.0f));
        DistanceFromLinearElementReferent toPoint = new DistanceFromLinearElementReferent();
        Referent toReferent = new Referent();
        toReferent.setReferentIdentifier(parametresDatex2.getString("prSecondaire"));
        toReferent.setReferentType(ReferentTypeEnum.boundary);
        toPoint.setFromReferent(toReferent);
        toPoint.setDistanceAlong(parametresDatex2.getFloat("prDistanceSecondaire", 0.0f));
        linearWithinLinearElement.setFromPoint(fromPoint);
        linearWithinLinearElement.setToPoint(toPoint);
        String prDirection = GLS.getString((String)parametresDatex2.getString("prDirection"), (String)String.valueOf(1));
        if (String.valueOf(1).equals(prDirection)) {
            linearWithinLinearElement.setDirectionRelativeOnLinearSection(LinearReferencingDirectionEnum.aligned);
        } else if (String.valueOf(2).equals(prDirection)) {
            linearWithinLinearElement.setDirectionRelativeOnLinearSection(LinearReferencingDirectionEnum.opposite);
        } else if (String.valueOf(3).equals(prDirection)) {
            linearWithinLinearElement.setDirectionRelativeOnLinearSection(LinearReferencingDirectionEnum.both);
        } else {
            linearWithinLinearElement.setDirectionRelativeOnLinearSection(LinearReferencingDirectionEnum.unknown);
        }
        linearWithinLinearElement.setLinearElement(this.genererLinearElementByPoints(parametresDatex2));
        this.log.debug((Object)"</linearWithinLinearElement>");
        return linearWithinLinearElement;
    }

    @Override
    public LinearWithinLinearElement genererLinearWithinLinearElementList(Extension parametresDatex2) throws Exception {
        this.log.debug((Object)"<linearWithinLinearElement>");
        LinearWithinLinearElement linearWithinLinearElement = new LinearWithinLinearElement();
        DistanceFromLinearElementReferent fromPoint = new DistanceFromLinearElementReferent();
        fromPoint.setDistanceAlong(parametresDatex2.getFloat("prDistancePrimaire", 0.0f));
        Referent fromReferent = new Referent();
        fromReferent.setReferentIdentifier(parametresDatex2.getString("prPrimaire"));
        fromReferent.setReferentType(ReferentTypeEnum.boundary);
        fromPoint.setFromReferent(fromReferent);
        linearWithinLinearElement.setFromPoint(fromPoint);
        DistanceFromLinearElementReferent toPoint = new DistanceFromLinearElementReferent();
        toPoint.setDistanceAlong(parametresDatex2.getFloat("prDistanceSecondaire", 0.0f));
        Referent toReferent = new Referent();
        toReferent.setReferentIdentifier(parametresDatex2.getString("prSecondaire"));
        toReferent.setReferentType(ReferentTypeEnum.boundary);
        toPoint.setFromReferent(toReferent);
        linearWithinLinearElement.setToPoint(toPoint);
        String prDirection = GLS.getString((String)parametresDatex2.getString("prDirection"), (String)String.valueOf(1));
        if (String.valueOf(1).equals(prDirection)) {
            linearWithinLinearElement.setDirectionRelativeOnLinearSection(LinearReferencingDirectionEnum.aligned);
        } else if (String.valueOf(2).equals(prDirection)) {
            linearWithinLinearElement.setDirectionRelativeOnLinearSection(LinearReferencingDirectionEnum.opposite);
        } else if (String.valueOf(3).equals(prDirection)) {
            linearWithinLinearElement.setDirectionRelativeOnLinearSection(LinearReferencingDirectionEnum.both);
        } else {
            linearWithinLinearElement.setDirectionRelativeOnLinearSection(LinearReferencingDirectionEnum.unknown);
        }
        linearWithinLinearElement.setLinearElement(this.genererLinearElement(parametresDatex2));
        this.log.debug((Object)"</linearWithinLinearElement>");
        return linearWithinLinearElement;
    }

    @Override
    public SupplementaryPositionalDescription genererSupplementaryPositionalDescription(Extension parametresDatex2) {
        if (!parametresDatex2.estStringVide("supplementaryPositionalDescription") && !GLS.estVide((String)parametresDatex2.getString("supplementaryPositionalDescriptionLanes"))) {
            this.log.debug((Object)"<supplementaryPositionalDescription>");
            SupplementaryPositionalDescription suppPositionDesc = new SupplementaryPositionalDescription();
            Vector<LaneEnum> vecLanes = new Vector<LaneEnum>();
            String lanes = parametresDatex2.getString("supplementaryPositionalDescriptionLanes");
            String[] stringArray = lanes.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String valLane = stringArray[n2];
                try {
                    vecLanes.add(LaneEnum.fromString(valLane));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n2;
            }
            AffectedCarriagewayAndLanes[] affectedCarriagewayAndLanes = new AffectedCarriagewayAndLanes[1];
            suppPositionDesc.setAffectedCarriagewayAndLanes(affectedCarriagewayAndLanes);
            LaneEnum[] tabLanes = new LaneEnum[vecLanes.size()];
            int i = 0;
            while (i < vecLanes.size()) {
                tabLanes[i] = (LaneEnum)vecLanes.get(i);
                ++i;
            }
            affectedCarriagewayAndLanes[0] = new AffectedCarriagewayAndLanes();
            affectedCarriagewayAndLanes[0].setLane(tabLanes);
            String carriage = parametresDatex2.getString("supplementaryPositionalDescriptionCarriage");
            affectedCarriagewayAndLanes[0].setCarriageway(CarriagewayEnum.fromString(carriage));
            this.log.debug((Object)"</supplementaryPositionalDescription>");
            return suppPositionDesc;
        }
        return null;
    }

    @Override
    public TpegOtherPointDescriptor genererTPEGOtherPointDescriptor(TpegLoc03OtherPointDescriptorSubtypeEnum otherPointDescriptorSubtype, String tpegDescriptor) throws Exception {
        MultilingualStringValue multiVal = new MultilingualStringValue(tpegDescriptor);
        multiVal.setLang(new Language("fr"));
        MultilingualString descriptor = new MultilingualString(new MultilingualStringValue[]{multiVal});
        TpegOtherPointDescriptor otherPointDescriptor = new TpegOtherPointDescriptor();
        otherPointDescriptor.setTpegOtherPointDescriptorType(otherPointDescriptorSubtype);
        otherPointDescriptor.setDescriptor(descriptor);
        otherPointDescriptor.setTpegDescriptorExtension(new _ExtensionType());
        otherPointDescriptor.setTpegPointDescriptorExtension(new _ExtensionType());
        return otherPointDescriptor;
    }

    @Override
    public AlertCMethod4PrimaryPointLocation genererAlertcMethod4PrimaryPointLocation(Extension parametresDatex2) throws Exception {
        if (!GLS.estVide((String)parametresDatex2.getString("alertcLocalisantDebut")) && !"-1".equals(parametresDatex2.getString("alertcLocalisantDebut"))) {
            MultilingualString alertCLocationAlertCLocationName = this.genererAlertcLocationName(parametresDatex2.getString("alertcNomLocalisantDebut"));
            AlertCLocation alertCLocation = new AlertCLocation(alertCLocationAlertCLocationName, new NonNegativeInteger(parametresDatex2.getString("alertcLocalisantDebut")), new _ExtensionType());
            OffsetDistance offsetDistance = new OffsetDistance(new NonNegativeInteger(parametresDatex2.getString("alertcDistanceLocalisantDebut")), new _ExtensionType());
            return new AlertCMethod4PrimaryPointLocation(alertCLocation, offsetDistance, new _ExtensionType());
        }
        return null;
    }

    @Override
    public AlertCMethod4SecondaryPointLocation genererAlertcMethod4SecondaryPointLocation(Extension parametresDatex2) throws Exception {
        if (!GLS.estVide((String)parametresDatex2.getString("alertcLocalisantSecondaire")) && !"-1".equals(parametresDatex2.getString("alertcLocalisantSecondaire"))) {
            MultilingualString alertCLocationAlertCLocationName = this.genererAlertcLocationName(parametresDatex2.getString("alertcNomLocalisantSecondaire"));
            AlertCLocation alertCLocation = new AlertCLocation(alertCLocationAlertCLocationName, new NonNegativeInteger(parametresDatex2.getString("alertcLocalisantSecondaire")), new _ExtensionType());
            OffsetDistance offsetDistance = new OffsetDistance(new NonNegativeInteger(parametresDatex2.getString("alertcDistanceLocalisantSecondaire")), new _ExtensionType());
            return new AlertCMethod4SecondaryPointLocation(alertCLocation, offsetDistance, new _ExtensionType());
        }
        return null;
    }

    @Override
    public AlertCMethod4Point genererAlertcMethod4Point(Extension parametresDatex2) throws Exception {
        AlertCMethod4Point alertCMethod4Point = new AlertCMethod4Point();
        alertCMethod4Point.setAlertCLocationCountryCode(parametresDatex2.getString("alertcCodePays"));
        alertCMethod4Point.setAlertCLocationTableNumber(parametresDatex2.getString("alertcTableNumber"));
        alertCMethod4Point.setAlertCLocationTableVersion(parametresDatex2.getString("alertcVersion"));
        alertCMethod4Point.setAlertCDirection(this.genererAlertcDirection(parametresDatex2));
        alertCMethod4Point.setAlertCMethod4PrimaryPointLocation(this.genererAlertcMethod4PrimaryPointLocation(parametresDatex2));
        return alertCMethod4Point;
    }

    @Override
    public Location genererLocation(Extension parametresDatex2) throws Exception {
        this.log.debug((Object)"<groupOfLocations>");
        NetworkLocation location = null;
        String typeLocalisation = parametresDatex2.getString("typeLocalisation");
        if (typeLocalisation.equals("Point")) {
            Point point = new Point();
            if (!GLS.estVide((String)parametresDatex2.getString("prPrimaire"))) {
                point.setPointAlongLinearElement(this.genererPointAlongLinearElement(parametresDatex2));
            }
            if (parametresDatex2.getBoolean("isAlertc", false)) {
                point.setAlertCPoint(this.genererAlertcMethod4Point(parametresDatex2));
            }
            try {
                point.setTpegPointLocation(this.genererTPEGSimplePoint(parametresDatex2));
            }
            catch (Exception e) {
                this.log.debug((Object)"Pes de localisation Point");
            }
            location = point;
        } else {
            Linear linear = new Linear();
            if (parametresDatex2.getBoolean("isAlertc", false)) {
                linear.setAlertCLinear(this.genererAlertcMethod4Linear(parametresDatex2));
            }
            try {
                linear.setTpegLinearLocation(this.genererTPEGLinearLocation(parametresDatex2));
            }
            catch (Exception e) {
                this.log.debug((Object)"Pes de localisation Point");
            }
            if (!GLS.estVide((String)parametresDatex2.getString("prPrimaire"))) {
                linear.setLinearWithinLinearElement(this.genererLinearWithinLinearElement(parametresDatex2));
            }
            location = linear;
        }
        SupplementaryPositionalDescription supplementaryPositionalDescription = this.genererSupplementaryPositionalDescription(parametresDatex2);
        if (supplementaryPositionalDescription != null && location != null) {
            location.setSupplementaryPositionalDescription(supplementaryPositionalDescription);
        }
        if (!parametresDatex2.estStringVide("destination") && location != null) {
            location.setDestination(this.genererAreaLocation(parametresDatex2));
        }
        if (!parametresDatex2.estStringVide("XYPrimaire")) {
            try {
                location.setLocationForDisplay(this.getPointCoordinates(parametresDatex2, parametresDatex2.getString("XYPrimaire")));
            }
            catch (Exception e) {
                this.log.debug((Object)"LocationForDisplay Point nul");
            }
        }
        this.log.debug((Object)"</groupOfLocations>");
        return location;
    }

    @Override
    public GroupOfLocations genererLocationList(Extension parametresDatex2) throws Exception {
        this.log.debug((Object)"<groupOfLocations>");
        NonOrderedLocationGroupByList location = null;
        NonOrderedLocationGroupByList listLinear = new NonOrderedLocationGroupByList();
        Location[] locationContainedInGroup = new Location[1];
        listLinear.setLocationContainedInGroup(locationContainedInGroup);
        Linear linear = new Linear();
        locationContainedInGroup[0] = linear;
        SupplementaryPositionalDescription supplementaryPositionalDescription = this.genererSupplementaryPositionalDescription(parametresDatex2);
        if (supplementaryPositionalDescription != null && linear != null) {
            linear.setSupplementaryPositionalDescription(supplementaryPositionalDescription);
        }
        if (!GLS.estVide((String)parametresDatex2.getString("prPrimaire"))) {
            linear.setLinearWithinLinearElement(this.genererLinearWithinLinearElementList(parametresDatex2));
        }
        if (!parametresDatex2.estStringVide("XYPrimaire")) {
            linear.setLocationForDisplay(this.getPointCoordinates(parametresDatex2, parametresDatex2.getString("XYPrimaire")));
        }
        location = listLinear;
        this.log.debug((Object)"</groupOfLocations>");
        return location;
    }

    @Override
    public Destination genererAreaLocation(Extension parametresDatex2) {
        Area areaLocation = new Area();
        AreaDestination destination = new AreaDestination();
        TpegHeight tpegHeight = new TpegHeight();
        tpegHeight.setHeightType(TpegLoc04HeightTypeEnum.unknown);
        TpegNamedOnlyArea area = new TpegNamedOnlyArea();
        area.setTpegHeight(tpegHeight);
        TpegAreaDescriptor tpegDesc = new TpegAreaDescriptor();
        MultilingualString tpegDescDescVal = new MultilingualString();
        MultilingualStringValue tpegDescVal = new MultilingualStringValue(parametresDatex2.getString("destination"));
        tpegDescVal.setLang(new Language("fr"));
        tpegDescDescVal.setValues(new MultilingualStringValue[]{tpegDescVal});
        tpegDesc.setTpegAreaDescriptorType(TpegLoc03AreaDescriptorSubtypeEnum.townName);
        tpegDesc.setDescriptor(tpegDescDescVal);
        area.setName(new TpegAreaDescriptor[]{tpegDesc});
        area.setTpegAreaLocationType(TpegLoc01AreaLocationSubtypeEnum.largeArea);
        areaLocation.setTpegAreaLocation(area);
        destination.setArea(areaLocation);
        return destination;
    }

    @Override
    public VmsPictogramDisplayCharacteristics genererVmsPictogramDisplayCharacteristics(Extension parametresDatex2) {
        VmsPictogramDisplayCharacteristics vmsPictogramDisplayCharacteristics = new VmsPictogramDisplayCharacteristics();
        return vmsPictogramDisplayCharacteristics;
    }

    @Override
    public _VmsRecordPictogramDisplayAreaIndexVmsPictogramDisplayCharacteristics[] genererVmsRecordPictogramDisplayAreaIndexVmsPictogramDisplayCharacteristics(Extension parametresDatex2) {
        if (parametresDatex2.getBoolean("PMV_PICTOGRAMME", false)) {
            _VmsRecordPictogramDisplayAreaIndexVmsPictogramDisplayCharacteristics vmsPictogramDisplayCharacteristics = new _VmsRecordPictogramDisplayAreaIndexVmsPictogramDisplayCharacteristics();
            vmsPictogramDisplayCharacteristics.setPictogramDisplayAreaIndex(1);
            vmsPictogramDisplayCharacteristics.setVmsPictogramDisplayCharacteristics(this.genererVmsPictogramDisplayCharacteristics(parametresDatex2));
            return new _VmsRecordPictogramDisplayAreaIndexVmsPictogramDisplayCharacteristics[]{vmsPictogramDisplayCharacteristics};
        }
        return null;
    }

    @Override
    public VmsTextDisplayCharacteristics genererVmsTextDisplayCharacteristics(Extension parametresDatex2) {
        VmsTextDisplayCharacteristics vmsTextDisplayCharacteristics = new VmsTextDisplayCharacteristics();
        vmsTextDisplayCharacteristics.setTextLanternsPresent(parametresDatex2.getBoolean("PMV_FEU_FLASH", false));
        vmsTextDisplayCharacteristics.setMaxNumberOfCharacters(new NonNegativeInteger(parametresDatex2.getString("PMV_NOMBRE_CARACTERE_PAR_LIGNE")));
        vmsTextDisplayCharacteristics.setMaxNumberOfRows(new NonNegativeInteger(parametresDatex2.getString("PMV_NOMBRE_LIGNE")));
        return vmsTextDisplayCharacteristics;
    }

    @Override
    public LocationByReference genererLocationByReference(Extension parametresDatex2) {
        _PredefinedLocationVersionedReference predefinedLocationVersionedReference = new _PredefinedLocationVersionedReference();
        predefinedLocationVersionedReference.setId(parametresDatex2.getString("LOCALISATION_CODE"));
        predefinedLocationVersionedReference.setTargetClass("PredefinedLocation");
        predefinedLocationVersionedReference.setVersion("1");
        LocationByReference locationByReference = new LocationByReference();
        locationByReference.setPredefinedLocationReference(predefinedLocationVersionedReference);
        return locationByReference;
    }

    @Override
    public VmsRecord genererVmsRecord(Extension parametresDatex2) {
        VmsRecord vmsRecord = new VmsRecord();
        if (parametresDatex2.getBoolean("PMV_PICTOGRAMME", false)) {
            vmsRecord.setNumberOfPictogramDisplayAreas(new NonNegativeInteger("1"));
        } else {
            vmsRecord.setNumberOfPictogramDisplayAreas(new NonNegativeInteger("0"));
        }
        vmsRecord.setVmsLocation(this.genererLocationByReference(parametresDatex2));
        vmsRecord.setVmsTextDisplayCharacteristics(this.genererVmsTextDisplayCharacteristics(parametresDatex2));
        vmsRecord.setVmsPictogramDisplayCharacteristics(this.genererVmsRecordPictogramDisplayAreaIndexVmsPictogramDisplayCharacteristics(parametresDatex2));
        return vmsRecord;
    }

    @Override
    public VmsUnitRecord[] genererVmsUnitRecord(Extension parametresDatex2) {
        VmsUnitRecord vmsUnitRecord = new VmsUnitRecord();
        vmsUnitRecord.setVmsUnitIdentifier(parametresDatex2.getString("PMV_CODE"));
        vmsUnitRecord.setVersion("1");
        vmsUnitRecord.setId(parametresDatex2.getString("PMV_CODE"));
        _VmsUnitRecordVmsIndexVmsRecord vmsUnitRecordVmsIndexVmsRecord = new _VmsUnitRecordVmsIndexVmsRecord();
        vmsUnitRecordVmsIndexVmsRecord.setVmsIndex(1);
        vmsUnitRecordVmsIndexVmsRecord.setVmsRecord(this.genererVmsRecord(parametresDatex2));
        vmsUnitRecord.setVmsRecord(new _VmsUnitRecordVmsIndexVmsRecord[]{vmsUnitRecordVmsIndexVmsRecord});
        return new VmsUnitRecord[]{vmsUnitRecord};
    }

    @Override
    public VmsUnitTable genererVmsUnitTable(Extension parametresDatex2) {
        VmsUnitTable vmsUnitTable = new VmsUnitTable();
        vmsUnitTable.setVmsUnitTableIdentification(String.valueOf(parametresDatex2.getString("PMV_FRONTAL_PMV")) + "_" + parametresDatex2.getString("PMV_CODE"));
        vmsUnitTable.setVersion("1");
        vmsUnitTable.setId(String.valueOf(parametresDatex2.getString("PMV_FRONTAL_PMV")) + "_" + parametresDatex2.getString("PMV_CODE"));
        vmsUnitTable.setVmsUnitRecord(this.genererVmsUnitRecord(parametresDatex2));
        return vmsUnitTable;
    }

    @Override
    public VmsTablePublication genererVmsTablePublication(Extension parametresDatex2) throws Exception {
        VmsTablePublication vmsTablePublication = new VmsTablePublication();
        vmsTablePublication.setLang(this.genererLanguage(parametresDatex2));
        vmsTablePublication.setPublicationTime(this.getDateTime());
        vmsTablePublication.setPublicationCreator(this.genererInternationalIdentifier(parametresDatex2));
        vmsTablePublication.setFeedType(String.valueOf(BusinessServiceFactory.getDatex2Service().getNumFichier()));
        VmsUnitTable[] vmsUnitTables = new VmsUnitTable[1];
        vmsTablePublication.setVmsUnitTable(vmsUnitTables);
        vmsTablePublication.setHeaderInformation(this.genererHeaderInformation(parametresDatex2));
        return vmsTablePublication;
    }

    @Override
    public MeasurementSiteRecord genererMeasurementSiteRecord(Extension parametresDatex2) {
        MeasurementSiteRecord measurementSiteRecord = new MeasurementSiteRecord();
        measurementSiteRecord.setId(parametresDatex2.getString("BOUCLE_REF"));
        measurementSiteRecord.setMeasurementEquipmentReference(parametresDatex2.getString("BOUCLE_REF"));
        measurementSiteRecord.setMeasurementSiteLocation(this.genererLocationByReference(parametresDatex2));
        measurementSiteRecord.setVersion("1");
        return measurementSiteRecord;
    }

    @Override
    public MeasurementSiteTable genererMeasurementSiteTable(Extension parametresDatex2) {
        MeasurementSiteTable measurementSiteTable = new MeasurementSiteTable();
        measurementSiteTable.setMeasurementSiteTableIdentification(parametresDatex2.getString("BOUCLE_CODE_STATION"));
        measurementSiteTable.setId(parametresDatex2.getString("BOUCLE_ID"));
        measurementSiteTable.setVersion("1");
        return measurementSiteTable;
    }

    @Override
    public MeasurementSiteTablePublication genererMeasurementSiteTablePublication(Extension parametresDatex2) throws Exception {
        MeasurementSiteTablePublication measurementSiteTablePublication = new MeasurementSiteTablePublication();
        measurementSiteTablePublication.setLang(this.genererLanguage(parametresDatex2));
        measurementSiteTablePublication.setPublicationTime(this.getDateTime());
        measurementSiteTablePublication.setPublicationCreator(this.genererInternationalIdentifier(parametresDatex2));
        measurementSiteTablePublication.setFeedType(String.valueOf(BusinessServiceFactory.getDatex2Service().getNumFichier()));
        MeasurementSiteTable[] measurementSiteTables = new MeasurementSiteTable[1];
        measurementSiteTablePublication.setMeasurementSiteTable(measurementSiteTables);
        measurementSiteTablePublication.setHeaderInformation(this.genererHeaderInformation(parametresDatex2));
        return measurementSiteTablePublication;
    }

    @Override
    public PredefinedLocation genererPredefinedLocation(Extension parametresDatex2) throws Exception {
        PredefinedLocation predefinedLocation = new PredefinedLocation();
        predefinedLocation.setId(parametresDatex2.getString("LOCALISATION_CODE"));
        MultilingualString predefinedLocationName = new MultilingualString();
        MultilingualStringValue[] values = new MultilingualStringValue[]{new MultilingualStringValue(parametresDatex2.getString("LOCALISATION_CODE"))};
        values[0].setLang(new Language("fr"));
        predefinedLocationName.setValues(values);
        predefinedLocation.setPredefinedLocationName(predefinedLocationName);
        predefinedLocation.setVersion("1");
        predefinedLocation.setLocation(this.genererLocation(parametresDatex2));
        return predefinedLocation;
    }

    @Override
    public PredefinedNonOrderedLocationGroup genererPredefinedLocationContainer(Extension parametresDatex2) {
        PredefinedNonOrderedLocationGroup predefinedLocationContainer = new PredefinedNonOrderedLocationGroup();
        predefinedLocationContainer.setId(parametresDatex2.getString("LOCALISATION_TYPE"));
        predefinedLocationContainer.setVersion("1");
        return predefinedLocationContainer;
    }

    @Override
    public PredefinedLocationsPublication genererPredefinedLocationsPublication(Extension parametresDatex2) throws Exception {
        PredefinedLocationsPublication predefinedLocationsPublication = new PredefinedLocationsPublication();
        predefinedLocationsPublication.setLang(this.genererLanguage(parametresDatex2));
        predefinedLocationsPublication.setPublicationTime(this.getDateTime());
        predefinedLocationsPublication.setPublicationCreator(this.genererInternationalIdentifier(parametresDatex2));
        predefinedLocationsPublication.setFeedType(String.valueOf(BusinessServiceFactory.getDatex2Service().getNumFichier()));
        predefinedLocationsPublication.setHeaderInformation(this.genererHeaderInformation(parametresDatex2));
        return predefinedLocationsPublication;
    }

    @Override
    public HeaderInformation genererHeaderInformation(Extension parametresDatex2) throws Exception {
        this.log.debug((Object)"<headerInformation>");
        HeaderInformation headerInformation = new HeaderInformation();
        headerInformation.setConfidentiality(ConfidentialityValueEnum.fromString(parametresDatex2.getString(CONFIDENTIALITY)));
        headerInformation.setInformationStatus(InformationStatusEnum.fromString(parametresDatex2.getString(INFORMATION_STATUS)));
        this.log.debug((Object)"</headerInformation>");
        return headerInformation;
    }

    @Override
    public Situation genererSituation(Extension parametresDatex2, String idSituation) throws Exception {
        this.log.debug((Object)"<situation>");
        Situation situation = new Situation();
        situation.setHeaderInformation(this.genererHeaderInformation(parametresDatex2));
        situation.setVersion(parametresDatex2.getString("situationRecordVersion"));
        situation.setId(idSituation);
        situation.setOverallSeverity(SeverityEnum.fromString(parametresDatex2.getString(OVERALL_SECURITY)));
        this.log.debug((Object)"</situation>");
        return situation;
    }

    @Override
    public Extension enteteToExtensionDatex2(boolean bPush) {
        Extension parametresDatex2 = new Extension();
        parametresDatex2.setValeur(COUNTRY_ENUM, (Object)DEFAULT_COUNTRY_ENUM);
        parametresDatex2.setValeur("COUNTRY", (Object)"fre");
        parametresDatex2.setValeur("fournisseur", (Object)this.nationalIdentifier);
        parametresDatex2.setValeur(RESPONSE, (Object)"acknowledge");
        parametresDatex2.setValeur(CONFIDENTIALITY, (Object)ConfidentialityValueEnum.noRestriction);
        parametresDatex2.setValeur(INFORMATION_STATUS, (Object)InformationStatusEnum.real);
        parametresDatex2.setValeur(VALIDITY_STATUS, (Object)"active");
        parametresDatex2.setValeur("sourceInformationSourceName", (Object)"PRISM");
        parametresDatex2.setValeur("sourceIdentification", (Object)"PRISM");
        parametresDatex2.setValeur("sourceIdentificationSourceType", (Object)"otherInformation");
        parametresDatex2.setValeur(PROBABILITY_OF_OCCURRENCE, (Object)"certain");
        parametresDatex2.setValeur(OVERALL_SECURITY, (Object)"none");
        parametresDatex2.setValeur("TARGET_ADDRESS", (Object)"http://localhost/");
        parametresDatex2.setValeur("TARGET_PROTOCOL", (Object)"http");
        parametresDatex2.setValeur("MODE_PUSH", (Object)bPush);
        parametresDatex2.setValeur("SUBSCRIPTION_START", (Object)"20120101000000");
        return parametresDatex2;
    }

    @Override
    public GroupOfPeopleInvolved[] defineGroupOfPeopleInvolved(HashMap<String, String> evenement, Extension parametresDatex2) {
        ArrayList<GroupOfPeopleInvolved> peopleInvolved;
        block29: {
            String[] valeurs;
            GroupOfPeopleInvolved gp;
            peopleInvolved = new ArrayList<GroupOfPeopleInvolved>();
            String valeur = evenement.get("natureAccident");
            if (!GLS.estVide((String)evenement.get("blessesGraves")) || "corporel".equalsIgnoreCase(valeur)) {
                gp = new GroupOfPeopleInvolved();
                gp.setInjuryStatus(InjuryStatusTypeEnum.injured);
                try {
                    gp.setNumberOfPeople(new NonNegativeInteger(evenement.get("blessesGraves")));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                peopleInvolved.add(gp);
            }
            if (!GLS.estVide((String)evenement.get("blesses")) || "corporel".equalsIgnoreCase(valeur)) {
                gp = new GroupOfPeopleInvolved();
                gp.setInjuryStatus(InjuryStatusTypeEnum.injured);
                try {
                    gp.setNumberOfPeople(new NonNegativeInteger(evenement.get("blesses")));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                peopleInvolved.add(gp);
            }
            if (!GLS.estVide((String)evenement.get("ACCIDENT_PERSONNES_TUEES")) || "mortel".equalsIgnoreCase(valeur)) {
                gp = new GroupOfPeopleInvolved();
                gp.setInjuryStatus(InjuryStatusTypeEnum.dead);
                try {
                    gp.setNumberOfPeople(new NonNegativeInteger(evenement.get("tues")));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                peopleInvolved.add(gp);
            }
            if (GLS.estVide((String)(valeur = evenement.get("particularites")))) break block29;
            String[] stringArray = valeurs = valeur.split(";");
            int n = valeurs.length;
            int n2 = 0;
            while (n2 < n) {
                String val = stringArray[n2];
                GroupOfPeopleInvolved gp2 = new GroupOfPeopleInvolved();
                switch (val) {
                    case "VIP": {
                        gp2.setCategoryOfPeopleInvolved(PersonCategoryEnum.veryImportantPerson);
                        break;
                    }
                    case "Enfant": {
                        gp2.setCategoryOfPeopleInvolved(PersonCategoryEnum.child);
                        break;
                    }
                    case "FO": {
                        gp2.setCategoryOfPeopleInvolved(PersonCategoryEnum.policeman);
                        break;
                    }
                    case "Service d'urgence": {
                        gp2.setCategoryOfPeopleInvolved(PersonCategoryEnum.emergencyServicesPerson);
                        break;
                    }
                    case "Gestionnaire routier": {
                        gp2.setCategoryOfPeopleInvolved(PersonCategoryEnum.trafficOfficer);
                    }
                }
                peopleInvolved.add(gp2);
                ++n2;
            }
        }
        return peopleInvolved.size() == 0 ? null : peopleInvolved.toArray(new GroupOfPeopleInvolved[peopleInvolved.size()]);
    }

    @Override
    public void defineGroupOfVehiclesInvolved(HashMap<String, String> evenementInit, Extension parametresDatex2, Accident accident) {
        GroupOfVehiclesInvolved onVehiclesInvolved;
        ArrayList<GroupOfVehiclesInvolved> vehicleInvolved = new ArrayList<GroupOfVehiclesInvolved>();
        String valeurType = evenementInit.get("typeVehicule");
        if (GLS.estVide((String)valeurType)) {
            valeurType = evenementInit.get("typeVehicule2");
        }
        String[] valeurs = valeurType.split(":");
        HashMap<String, String> evenement = new HashMap<String, String>();
        String[] stringArray = valeurs;
        int n = valeurs.length;
        int n2 = 0;
        while (n2 < n) {
            String valeurBis = stringArray[n2];
            try {
                String[] v = valeurBis.split("=");
                evenement.put(v[0], v[1]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        String valeur = (String)evenement.get("vl");
        if (!GLS.estVide((String)valeur)) {
            onVehiclesInvolved = new GroupOfVehiclesInvolved();
            onVehiclesInvolved.setNumberOfVehicles(new NonNegativeInteger(valeur));
            VehicleCharacteristics vehicleCharacteristics = new VehicleCharacteristics();
            vehicleCharacteristics.setVehicleType(new VehicleTypeEnum[]{VehicleTypeEnum.car});
            onVehiclesInvolved.setVehicleCharacteristics(vehicleCharacteristics);
            vehicleInvolved.add(onVehiclesInvolved);
        }
        if (!GLS.estVide((String)(valeur = (String)evenement.get("pl")))) {
            onVehiclesInvolved = new GroupOfVehiclesInvolved();
            onVehiclesInvolved.setNumberOfVehicles(new NonNegativeInteger(valeur));
            VehicleCharacteristics vehicleCharacteristics = new VehicleCharacteristics();
            vehicleCharacteristics.setVehicleType(new VehicleTypeEnum[]{VehicleTypeEnum.lorry});
            onVehiclesInvolved.setVehicleCharacteristics(vehicleCharacteristics);
            vehicleInvolved.add(onVehiclesInvolved);
        }
        if (!GLS.estVide((String)(valeur = (String)evenement.get("tc")))) {
            onVehiclesInvolved = new GroupOfVehiclesInvolved();
            onVehiclesInvolved.setNumberOfVehicles(new NonNegativeInteger(valeur));
            VehicleCharacteristics vehicleCharacteristics = new VehicleCharacteristics();
            vehicleCharacteristics.setVehicleType(new VehicleTypeEnum[]{VehicleTypeEnum.bus});
            onVehiclesInvolved.setVehicleCharacteristics(vehicleCharacteristics);
            vehicleInvolved.add(onVehiclesInvolved);
        }
        if (!GLS.estVide((String)(valeur = (String)evenement.get("velo")))) {
            onVehiclesInvolved = new GroupOfVehiclesInvolved();
            onVehiclesInvolved.setNumberOfVehicles(new NonNegativeInteger(valeur));
            VehicleCharacteristics vehicleCharacteristics = new VehicleCharacteristics();
            vehicleCharacteristics.setVehicleType(new VehicleTypeEnum[]{VehicleTypeEnum.bicycle});
            onVehiclesInvolved.setVehicleCharacteristics(vehicleCharacteristics);
            vehicleInvolved.add(onVehiclesInvolved);
        }
        if (!GLS.estVide((String)(valeur = (String)evenement.get("deuxRoues")))) {
            onVehiclesInvolved = new GroupOfVehiclesInvolved();
            onVehiclesInvolved.setNumberOfVehicles(new NonNegativeInteger(valeur));
            VehicleCharacteristics vehicleCharacteristics = new VehicleCharacteristics();
            vehicleCharacteristics.setVehicleType(new VehicleTypeEnum[]{VehicleTypeEnum.twoWheeledVehicle});
            onVehiclesInvolved.setVehicleCharacteristics(vehicleCharacteristics);
            vehicleInvolved.add(onVehiclesInvolved);
        }
        if (!GLS.estVide((String)(valeur = (String)evenement.get("caravane")))) {
            onVehiclesInvolved = new GroupOfVehiclesInvolved();
            onVehiclesInvolved.setNumberOfVehicles(new NonNegativeInteger(valeur));
            VehicleCharacteristics vehicleCharacteristics = new VehicleCharacteristics();
            vehicleCharacteristics.setVehicleType(new VehicleTypeEnum[]{VehicleTypeEnum.carWithCaravan});
            onVehiclesInvolved.setVehicleCharacteristics(vehicleCharacteristics);
            vehicleInvolved.add(onVehiclesInvolved);
        }
        if (!GLS.estVide((String)(valeur = (String)evenement.get("tramway")))) {
            onVehiclesInvolved = new GroupOfVehiclesInvolved();
            onVehiclesInvolved.setNumberOfVehicles(new NonNegativeInteger(valeur));
            VehicleCharacteristics vehicleCharacteristics = new VehicleCharacteristics();
            vehicleCharacteristics.setVehicleType(new VehicleTypeEnum[]{VehicleTypeEnum.tram});
            onVehiclesInvolved.setVehicleCharacteristics(vehicleCharacteristics);
            vehicleInvolved.add(onVehiclesInvolved);
        }
        if (!GLS.estVide((String)(valeur = (String)evenement.get("enginAgricole")))) {
            onVehiclesInvolved = new GroupOfVehiclesInvolved();
            onVehiclesInvolved.setNumberOfVehicles(new NonNegativeInteger(valeur));
            VehicleCharacteristics vehicleCharacteristics = new VehicleCharacteristics();
            vehicleCharacteristics.setVehicleType(new VehicleTypeEnum[]{VehicleTypeEnum.agriculturalVehicle});
            onVehiclesInvolved.setVehicleCharacteristics(vehicleCharacteristics);
            vehicleInvolved.add(onVehiclesInvolved);
        }
        if (!GLS.estVide((String)(valeur = (String)evenement.get("campingCar")))) {
            onVehiclesInvolved = new GroupOfVehiclesInvolved();
            onVehiclesInvolved.setNumberOfVehicles(new NonNegativeInteger(valeur));
            VehicleCharacteristics vehicleCharacteristics = new VehicleCharacteristics();
            vehicleCharacteristics.setVehicleType(new VehicleTypeEnum[]{VehicleTypeEnum.car});
            onVehiclesInvolved.setVehicleCharacteristics(vehicleCharacteristics);
            vehicleInvolved.add(onVehiclesInvolved);
        }
        if (!GLS.estVide((String)(valeur = (String)evenement.get("moto")))) {
            onVehiclesInvolved = new GroupOfVehiclesInvolved();
            onVehiclesInvolved.setNumberOfVehicles(new NonNegativeInteger(valeur));
            VehicleCharacteristics vehicleCharacteristics = new VehicleCharacteristics();
            vehicleCharacteristics.setVehicleType(new VehicleTypeEnum[]{VehicleTypeEnum.motorcycle});
            onVehiclesInvolved.setVehicleCharacteristics(vehicleCharacteristics);
            vehicleInvolved.add(onVehiclesInvolved);
        }
        if (!GLS.estVide((String)(valeur = (String)evenement.get("pietonCycle")))) {
            onVehiclesInvolved = new GroupOfVehiclesInvolved();
            onVehiclesInvolved.setNumberOfVehicles(new NonNegativeInteger(valeur));
            VehicleCharacteristics vehicleCharacteristics = new VehicleCharacteristics();
            vehicleCharacteristics.setVehicleType(new VehicleTypeEnum[]{VehicleTypeEnum.other});
            onVehiclesInvolved.setVehicleCharacteristics(vehicleCharacteristics);
            vehicleInvolved.add(onVehiclesInvolved);
            try {
                Comment[] generalPublicComment = this.genererCommentaire(accident.getGeneralPublicComment(), "Accident avec " + valeur + " pi\u00e9ton", CommentTypeEnum.internalNote);
                accident.setGeneralPublicComment(generalPublicComment);
            }
            catch (Exception e) {
                Log.error((Object)"Pb generation comment", (Throwable)e);
            }
        }
        if (!GLS.estVide((String)(valeur = (String)evenement.get("train")))) {
            onVehiclesInvolved = new GroupOfVehiclesInvolved();
            onVehiclesInvolved.setNumberOfVehicles(new NonNegativeInteger(valeur));
            VehicleCharacteristics vehicleCharacteristics = new VehicleCharacteristics();
            vehicleCharacteristics.setVehicleType(new VehicleTypeEnum[]{VehicleTypeEnum.other});
            onVehiclesInvolved.setVehicleCharacteristics(vehicleCharacteristics);
            vehicleInvolved.add(onVehiclesInvolved);
            try {
                Comment[] generalPublicComment = this.genererCommentaire(accident.getGeneralPublicComment(), "Accident avec " + valeur + " train", CommentTypeEnum.internalNote);
                accident.setGeneralPublicComment(generalPublicComment);
            }
            catch (Exception e) {
                Log.error((Object)"Pb generation comment", (Throwable)e);
            }
        }
        accident.setGroupOfVehiclesInvolved(vehicleInvolved.size() == 0 ? null : vehicleInvolved.toArray(new GroupOfVehiclesInvolved[vehicleInvolved.size()]));
    }

    protected SituationRecord extensionDatex2ToEvenementAccident(HashMap<String, String> evenement, Extension parametresDatex2, Nature n) throws Exception {
        int nbTotalVehicules;
        Accident accident;
        block44: {
            ArrayList<AccidentTypeEnum> types;
            block47: {
                String valeur;
                block45: {
                    accident = new Accident();
                    this.defineGroupOfVehiclesInvolved(evenement, parametresDatex2, accident);
                    nbTotalVehicules = 0;
                    if (accident.getGroupOfVehiclesInvolved() != null) {
                        Object object = accident.getGroupOfVehiclesInvolved();
                        int n2 = ((GroupOfVehiclesInvolved[])object).length;
                        int n3 = 0;
                        while (n3 < n2) {
                            GroupOfVehiclesInvolved groupOfLocation = object[n3];
                            nbTotalVehicules += groupOfLocation.getNumberOfVehicles().intValue();
                            ++n3;
                        }
                    }
                    if ((valeur = evenement.get("facteurAggravant")) == null) {
                        valeur = evenement.get("facteursAggravants");
                    }
                    if (valeur == null) break block44;
                    String[] valeurs = valeur.split(";");
                    types = new ArrayList<AccidentTypeEnum>();
                    if (valeurs.length <= 1) break block45;
                    types.add(AccidentTypeEnum.accident);
                    String[] stringArray = valeurs;
                    int n4 = valeurs.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        String val;
                        switch (val = stringArray[n5]) {
                            case "Transport public": {
                                Comment[] generalPublicComment;
                                try {
                                    generalPublicComment = this.genererCommentaire(accident.getGeneralPublicComment(), "Accident concernant des transports publics", CommentTypeEnum.internalNote);
                                    accident.setGeneralPublicComment(generalPublicComment);
                                }
                                catch (Exception generalPublicComment2) {}
                                break;
                            }
                            case "Carambolage": {
                                Comment[] generalPublicComment;
                                try {
                                    generalPublicComment = this.genererCommentaire(accident.getGeneralPublicComment(), "Carambolage impliquant au moins (" + nbTotalVehicules + ") v\u00e9hicules", CommentTypeEnum.internalNote);
                                    accident.setGeneralPublicComment(generalPublicComment);
                                }
                                catch (Exception generalPublicComment3) {}
                                break;
                            }
                            case "Mati\u00e8res dangereuses": {
                                Comment[] generalPublicComment;
                                try {
                                    generalPublicComment = this.genererCommentaire(accident.getGeneralPublicComment(), "Mati\u00e8re dangereuse transport\u00e9e", CommentTypeEnum.internalNote);
                                    accident.setGeneralPublicComment(generalPublicComment);
                                }
                                catch (Exception generalPublicComment4) {}
                                break;
                            }
                            case "TMD": {
                                Comment[] generalPublicComment;
                                try {
                                    generalPublicComment = this.genererCommentaire(accident.getGeneralPublicComment(), "Mati\u00e8re dangereuse transport\u00e9e", CommentTypeEnum.internalNote);
                                    accident.setGeneralPublicComment(generalPublicComment);
                                    break;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                        ++n5;
                    }
                    break block47;
                }
                switch (valeur) {
                    case "Transport public": {
                        types.add(AccidentTypeEnum.accidentInvolvingBuses);
                        break;
                    }
                    case "Carambolage": {
                        types.add(AccidentTypeEnum.multivehicleAccident);
                        break;
                    }
                    case "Mati\u00e8res dangereuses": {
                        types.add(AccidentTypeEnum.accidentInvolvingHazardousMaterials);
                        break;
                    }
                    case "TMD": {
                        types.add(AccidentTypeEnum.accidentInvolvingHazardousMaterials);
                        break;
                    }
                    default: {
                        types.add(AccidentTypeEnum.accident);
                    }
                }
            }
            accident.setAccidentType(types.toArray(new AccidentTypeEnum[types.size()]));
        }
        accident.setTotalNumberOfVehiclesInvolved(new NonNegativeInteger(String.valueOf(nbTotalVehicules)));
        accident.setGroupOfPeopleInvolved(this.defineGroupOfPeopleInvolved(evenement, parametresDatex2));
        return accident;
    }

    protected SituationRecord extensionDatex2ToEvenementBouchon(HashMap<String, String> evenement, Extension parametresDatex2, Nature n, String definitionDatex2) throws Exception {
        String valeur;
        AbnormalTraffic abnormalTraffic = new AbnormalTraffic();
        if (definitionDatex2.equals("typeBouchon")) {
            abnormalTraffic.setAbnormalTrafficType(AbnormalTrafficTypeEnum.queuingTraffic);
        } else if (definitionDatex2.equals("typeAccordeon")) {
            abnormalTraffic.setAbnormalTrafficType(AbnormalTrafficTypeEnum.stationaryTraffic);
        } else if (definitionDatex2.equals("typeCirculationBloquee")) {
            abnormalTraffic.setAbnormalTrafficType(AbnormalTrafficTypeEnum.stationaryTraffic);
            abnormalTraffic.setTrafficFlowCharacteristics(TrafficFlowCharacteristicsEnum.stopAndGo);
        } else if (definitionDatex2.equals("typeRalentissement")) {
            abnormalTraffic.setAbnormalTrafficType(AbnormalTrafficTypeEnum.slowTraffic);
        }
        switch (valeur = evenement.get("tendance")) {
            case "Am\u00e9lioration": {
                abnormalTraffic.setTrafficTrendType(TrafficTrendTypeEnum.trafficEasing);
                break;
            }
            case "Stable": {
                abnormalTraffic.setTrafficTrendType(TrafficTrendTypeEnum.trafficStable);
                break;
            }
            case "D\u00e9gradation": {
                abnormalTraffic.setTrafficTrendType(TrafficTrendTypeEnum.trafficBuildingUp);
            }
        }
        switch (valeur = evenement.get("normalite")) {
            case "Bien moins charg\u00e9": {
                abnormalTraffic.setRelativeTrafficFlow(RelativeTrafficFlowEnum.trafficVeryMuchLighterThanNormal);
                break;
            }
            case "Bien plus charg\u00e9": {
                abnormalTraffic.setRelativeTrafficFlow(RelativeTrafficFlowEnum.trafficVeryMuchHeavierThanNormal);
                break;
            }
            case "Comme d'habitude": {
                abnormalTraffic.setRelativeTrafficFlow(RelativeTrafficFlowEnum.trafficFlowNormal);
                break;
            }
            case "Moins charg\u00e9": {
                abnormalTraffic.setRelativeTrafficFlow(RelativeTrafficFlowEnum.trafficLighterThanNormal);
                break;
            }
            case "Plus charg\u00e9": {
                abnormalTraffic.setRelativeTrafficFlow(RelativeTrafficFlowEnum.trafficHeavierThanNormal);
            }
        }
        valeur = evenement.get("voiesConcernees");
        if (!GLS.estVide((String)valeur)) {
            abnormalTraffic.getImpact().setNumberOfLanesRestricted(new NonNegativeInteger(valeur));
        }
        if (!GLS.estVide((String)(valeur = evenement.get("TYPE_BOUCHON_VOIESNORMALES")))) {
            abnormalTraffic.getImpact().setOriginalNumberOfLanes(new NonNegativeInteger(valeur));
        }
        return abnormalTraffic;
    }

    public void defineMobility(HashMap<String, String> evenement, Extension parametresDatex2, VehicleObstruction vehicleObstruction) {
        block10: {
            String valeur = evenement.get("Mobilit\u00e9");
            if (GLS.estVide((String)valeur)) break block10;
            switch (valeur) {
                case "Mobile": {
                    Mobility mobility = new Mobility();
                    mobility.setMobilityType(MobilityEnum.mobile);
                    vehicleObstruction.setMobilityOfObstruction(mobility);
                    break;
                }
                case "Fixe": {
                    Mobility mobility = new Mobility();
                    mobility.setMobilityType(MobilityEnum.stationary);
                    vehicleObstruction.setMobilityOfObstruction(mobility);
                }
            }
        }
    }

    public void defineVehiclesObstruction(HashMap<String, String> evenementInit, Extension parametresDatex2, VehicleObstruction vehicleObstruction) {
        Vehicle vehicle;
        ArrayList<Vehicle> vehicleType = new ArrayList<Vehicle>();
        String valeurType = evenementInit.get("typeVehicule");
        if (GLS.estVide((String)valeurType)) {
            valeurType = evenementInit.get("typeVehicule2");
        }
        String[] valeurs = valeurType.split(":");
        HashMap<String, String> evenement = new HashMap<String, String>();
        String[] stringArray = valeurs;
        int n = valeurs.length;
        int n2 = 0;
        while (n2 < n) {
            String valeurBis = stringArray[n2];
            try {
                String[] v = valeurBis.split("=");
                evenement.put(v[0], v[1]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        String valeur = (String)evenement.get("vl");
        if (!GLS.estVide((String)valeur)) {
            vehicle = new Vehicle();
            VehicleCharacteristics vehicleCharacteristics = new VehicleCharacteristics();
            vehicleCharacteristics.setVehicleType(new VehicleTypeEnum[]{VehicleTypeEnum.car});
            vehicle.setVehicleCharacteristics(vehicleCharacteristics);
            vehicleType.add(vehicle);
        }
        if (!GLS.estVide((String)(valeur = (String)evenement.get("pl")))) {
            vehicle = new Vehicle();
            VehicleCharacteristics vehicleCharacteristics = new VehicleCharacteristics();
            vehicleCharacteristics.setVehicleType(new VehicleTypeEnum[]{VehicleTypeEnum.lorry});
            vehicle.setVehicleCharacteristics(vehicleCharacteristics);
            vehicleType.add(vehicle);
        }
        if (!GLS.estVide((String)(valeur = (String)evenement.get("tc")))) {
            vehicle = new Vehicle();
            VehicleCharacteristics vehicleCharacteristics = new VehicleCharacteristics();
            vehicleCharacteristics.setVehicleType(new VehicleTypeEnum[]{VehicleTypeEnum.bus});
            vehicle.setVehicleCharacteristics(vehicleCharacteristics);
            vehicleType.add(vehicle);
        }
        if (!GLS.estVide((String)(valeur = (String)evenement.get("velo")))) {
            vehicle = new Vehicle();
            VehicleCharacteristics vehicleCharacteristics = new VehicleCharacteristics();
            vehicleCharacteristics.setVehicleType(new VehicleTypeEnum[]{VehicleTypeEnum.bicycle});
            vehicle.setVehicleCharacteristics(vehicleCharacteristics);
            vehicleType.add(vehicle);
        }
        if (!GLS.estVide((String)(valeur = (String)evenement.get("deuxRoues")))) {
            vehicle = new Vehicle();
            VehicleCharacteristics vehicleCharacteristics = new VehicleCharacteristics();
            vehicleCharacteristics.setVehicleType(new VehicleTypeEnum[]{VehicleTypeEnum.twoWheeledVehicle});
            vehicle.setVehicleCharacteristics(vehicleCharacteristics);
            vehicleType.add(vehicle);
        }
        if (!GLS.estVide((String)(valeur = (String)evenement.get("caravane")))) {
            vehicle = new Vehicle();
            VehicleCharacteristics vehicleCharacteristics = new VehicleCharacteristics();
            vehicleCharacteristics.setVehicleType(new VehicleTypeEnum[]{VehicleTypeEnum.carWithCaravan});
            vehicle.setVehicleCharacteristics(vehicleCharacteristics);
            vehicleType.add(vehicle);
        }
        if (!GLS.estVide((String)(valeur = (String)evenement.get("tramway")))) {
            vehicle = new Vehicle();
            VehicleCharacteristics vehicleCharacteristics = new VehicleCharacteristics();
            vehicleCharacteristics.setVehicleType(new VehicleTypeEnum[]{VehicleTypeEnum.tram});
            vehicle.setVehicleCharacteristics(vehicleCharacteristics);
            vehicleType.add(vehicle);
        }
        if (!GLS.estVide((String)(valeur = (String)evenement.get("enginAgricole")))) {
            vehicle = new Vehicle();
            VehicleCharacteristics vehicleCharacteristics = new VehicleCharacteristics();
            vehicleCharacteristics.setVehicleType(new VehicleTypeEnum[]{VehicleTypeEnum.agriculturalVehicle});
            vehicle.setVehicleCharacteristics(vehicleCharacteristics);
            vehicleType.add(vehicle);
        }
        if (!GLS.estVide((String)(valeur = (String)evenement.get("campingCar")))) {
            vehicle = new Vehicle();
            VehicleCharacteristics vehicleCharacteristics = new VehicleCharacteristics();
            vehicleCharacteristics.setVehicleType(new VehicleTypeEnum[]{VehicleTypeEnum.car});
            vehicle.setVehicleCharacteristics(vehicleCharacteristics);
            vehicleType.add(vehicle);
        }
        if (!GLS.estVide((String)(valeur = (String)evenement.get("moto")))) {
            vehicle = new Vehicle();
            VehicleCharacteristics vehicleCharacteristics = new VehicleCharacteristics();
            vehicleCharacteristics.setVehicleType(new VehicleTypeEnum[]{VehicleTypeEnum.motorcycle});
            vehicle.setVehicleCharacteristics(vehicleCharacteristics);
            vehicleType.add(vehicle);
        }
        if (!GLS.estVide((String)(valeur = (String)evenement.get("train")))) {
            vehicle = new Vehicle();
            VehicleCharacteristics vehicleCharacteristics = new VehicleCharacteristics();
            vehicleCharacteristics.setVehicleType(new VehicleTypeEnum[]{VehicleTypeEnum.other});
            vehicle.setVehicleCharacteristics(vehicleCharacteristics);
            vehicleType.add(vehicle);
            try {
                Comment[] generalPublicComment = this.genererCommentaire(vehicleObstruction.getGeneralPublicComment(), "Implique un train", CommentTypeEnum.internalNote);
                vehicleObstruction.setGeneralPublicComment(generalPublicComment);
            }
            catch (Exception e) {
                Log.error((Object)"Pb generation comment", (Throwable)e);
            }
        }
        vehicleObstruction.setObstructingVehicle(vehicleType.size() == 0 ? null : vehicleType.toArray(new Vehicle[vehicleType.size()]));
    }

    protected SituationRecord extensionDatex2ToEvenementObstacleVehicule(HashMap<String, String> evenement, Extension parametresDatex2, Nature n) throws Exception {
        String valeur = evenement.get("etatVehicule");
        VehicleObstruction sr = null;
        switch (valeur) {
            case "Abandonn\u00e9": {
                sr = new VehicleObstruction();
                sr.setVehicleObstructionType(VehicleObstructionTypeEnum.abandonedVehicle);
                break;
            }
            case "En difficult\u00e9": {
                sr = new VehicleObstruction();
                sr.setVehicleObstructionType(VehicleObstructionTypeEnum.damagedVehicle);
                break;
            }
            case "Arr\u00eat\u00e9": {
                sr = new VehicleObstruction();
                sr.setVehicleObstructionType(VehicleObstructionTypeEnum.vehicleStuck);
                break;
            }
            case "En panne": {
                sr = new VehicleObstruction();
                sr.setVehicleObstructionType(VehicleObstructionTypeEnum.brokenDownVehicle);
                break;
            }
            case "A contre-sens": {
                sr = new VehicleObstruction();
                sr.setVehicleObstructionType(VehicleObstructionTypeEnum.vehicleOnWrongCarriageway);
                break;
            }
            case "Lent": {
                sr = new VehicleObstruction();
                sr.setVehicleObstructionType(VehicleObstructionTypeEnum.slowVehicle);
                break;
            }
            case "En feu": {
                sr = new VehicleObstruction();
                sr.setVehicleObstructionType(VehicleObstructionTypeEnum.vehicleOnFire);
                break;
            }
            case "Convoi exceptionnel": {
                sr = new VehicleObstruction();
                sr.setVehicleObstructionType(VehicleObstructionTypeEnum.abnormalLoad);
            }
        }
        this.defineVehiclesObstruction(evenement, parametresDatex2, sr);
        this.defineMobility(evenement, parametresDatex2, sr);
        return sr;
    }

    protected SituationRecord extensionDatex2ToEvenementObstacleAutre(HashMap<String, String> evenement, Extension parametresDatex2, Nature n) throws Exception {
        String valeur = evenement.get("etatAutreObstacle");
        TrafficElement sr = null;
        switch (valeur) {
            case "Animal errant": {
                sr = new AnimalPresenceObstruction();
                ((AnimalPresenceObstruction)sr).setAnimalPresenceType(AnimalPresenceTypeEnum.animalsOnTheRoad);
                ((AnimalPresenceObstruction)sr).setAlive(true);
                valeur = evenement.get("typeAnimal");
                if ("Autre".equals(valeur)) break;
                Comment[] generalPublicComment = this.genererCommentaire(sr.getGeneralPublicComment(), "Animal errant signal\u00e9 (" + valeur + ")", CommentTypeEnum.internalNote);
                sr.setGeneralPublicComment(generalPublicComment);
                break;
            }
            case "Animal \u00e9cras\u00e9": {
                sr = new AnimalPresenceObstruction();
                ((AnimalPresenceObstruction)sr).setAnimalPresenceType(AnimalPresenceTypeEnum.animalsOnTheRoad);
                ((AnimalPresenceObstruction)sr).setAlive(false);
                valeur = evenement.get("typeAnimal");
                if ("Autre".equals(valeur)) break;
                Comment[] generalPublicComment = this.genererCommentaire(sr.getGeneralPublicComment(), "Animal errant signal\u00e9 (" + valeur + ")", CommentTypeEnum.internalNote);
                sr.setGeneralPublicComment(generalPublicComment);
                break;
            }
            case "Arbre sur chauss\u00e9e": {
                sr = new EnvironmentalObstruction();
                ((EnvironmentalObstruction)sr).setEnvironmentalObstructionType(EnvironmentalObstructionTypeEnum.fallenTrees);
                break;
            }
            case "Obstacle": {
                sr = new GeneralObstruction();
                ObstructionTypeEnum[] enums = new ObstructionTypeEnum[]{ObstructionTypeEnum.obstructionOnTheRoad};
                ((GeneralObstruction)sr).setObstructionType(enums);
                break;
            }
            case "Chargement perdu": {
                sr = new GeneralObstruction();
                ObstructionTypeEnum[] enums = new ObstructionTypeEnum[]{ObstructionTypeEnum.objectsFallingFromMovingVehicle};
                ((GeneralObstruction)sr).setObstructionType(enums);
                break;
            }
            case "Cycliste sur chauss\u00e9e": {
                sr = new GeneralObstruction();
                ObstructionTypeEnum[] enums = new ObstructionTypeEnum[]{ObstructionTypeEnum.cyclistsOnRoadway};
                ((GeneralObstruction)sr).setObstructionType(enums);
                break;
            }
            case "Pi\u00e9ton sur chauss\u00e9e": {
                sr = new GeneralObstruction();
                ObstructionTypeEnum[] enums = new ObstructionTypeEnum[]{ObstructionTypeEnum.peopleOnRoadway};
                ((GeneralObstruction)sr).setObstructionType(enums);
                break;
            }
            case "Produit sur chauss\u00e9e": {
                sr = new NonWeatherRelatedRoadConditions();
                NonWeatherRelatedRoadConditionTypeEnum[] enumNW = new NonWeatherRelatedRoadConditionTypeEnum[]{NonWeatherRelatedRoadConditionTypeEnum.other};
                ((NonWeatherRelatedRoadConditions)sr).setNonWeatherRelatedRoadConditionType(enumNW);
            }
        }
        return sr;
    }

    protected SituationRecord extensionDatex2ToEvenementObstacleEquipement(HashMap<String, String> evenement, Extension parametresDatex2, Nature n) throws Exception {
        String valeur = evenement.get("etatEquipement");
        Obstruction sr = null;
        switch (valeur) {
            case "Equipement faisant obstacle": {
                sr = new GeneralObstruction();
                ObstructionTypeEnum[] enums = new ObstructionTypeEnum[]{ObstructionTypeEnum.objectOnTheRoad};
                ((GeneralObstruction)sr).setObstructionType(enums);
                break;
            }
            case "Eclatement de canalisation": {
                sr = new InfrastructureDamageObstruction();
                ((InfrastructureDamageObstruction)sr).setInfrastructureDamageType(InfrastructureDamageTypeEnum.burstPipe);
                break;
            }
            case "Canalisation de gaz": {
                sr = new InfrastructureDamageObstruction();
                ((InfrastructureDamageObstruction)sr).setInfrastructureDamageType(InfrastructureDamageTypeEnum.gasLeak);
                break;
            }
            case "C\u00e2ble HT sur chauss\u00e9e": {
                sr = new InfrastructureDamageObstruction();
                ((InfrastructureDamageObstruction)sr).setInfrastructureDamageType(InfrastructureDamageTypeEnum.fallenPowerCables);
                break;
            }
            case "Chauss\u00e9e d\u00e9grad\u00e9e": {
                sr = new InfrastructureDamageObstruction();
                ((InfrastructureDamageObstruction)sr).setInfrastructureDamageType(InfrastructureDamageTypeEnum.damagedRoadSurface);
            }
        }
        return sr;
    }

    protected SituationRecord extensionDatex2ToEvenementObstacleIncident(HashMap<String, String> evenement, Extension parametresDatex2, Nature n) throws Exception {
        String valeur = evenement.get("etatIncident");
        TrafficElement sr = null;
        switch (valeur) {
            case "Incendie": {
                sr = new EnvironmentalObstruction();
                ((EnvironmentalObstruction)sr).setEnvironmentalObstructionType(EnvironmentalObstructionTypeEnum.seriousFire);
                Comment[] generalPublicComment = this.genererCommentaire(sr.getGeneralPublicComment(), "Incendie", CommentTypeEnum.internalNote);
                sr.setGeneralPublicComment(generalPublicComment);
                break;
            }
            case "Feu de for\u00eat": {
                sr = new EnvironmentalObstruction();
                ((EnvironmentalObstruction)sr).setEnvironmentalObstructionType(EnvironmentalObstructionTypeEnum.seriousFire);
                Comment[] generalPublicComment = this.genererCommentaire(sr.getGeneralPublicComment(), "Feu de for\u00eat", CommentTypeEnum.internalNote);
                sr.setGeneralPublicComment(generalPublicComment);
                break;
            }
            case "Inondation": {
                sr = new EnvironmentalObstruction();
                ((EnvironmentalObstruction)sr).setEnvironmentalObstructionType(EnvironmentalObstructionTypeEnum.flooding);
                break;
            }
            case "Eboulement": {
                sr = new EnvironmentalObstruction();
                ((EnvironmentalObstruction)sr).setEnvironmentalObstructionType(EnvironmentalObstructionTypeEnum.rockfalls);
                break;
            }
            case "Effondrement": {
                sr = new EnvironmentalObstruction();
                ((EnvironmentalObstruction)sr).setEnvironmentalObstructionType(EnvironmentalObstructionTypeEnum.subsidence);
                break;
            }
            case "Glissement de terrain": {
                sr = new EnvironmentalObstruction();
                ((EnvironmentalObstruction)sr).setEnvironmentalObstructionType(EnvironmentalObstructionTypeEnum.landslips);
                break;
            }
            case "Coul\u00e9e de boue": {
                sr = new EnvironmentalObstruction();
                ((EnvironmentalObstruction)sr).setEnvironmentalObstructionType(EnvironmentalObstructionTypeEnum.mudSlide);
                break;
            }
            case "Fum\u00e9e": {
                sr = new PoorEnvironmentConditions();
                PoorEnvironmentTypeEnum[] enums = new PoorEnvironmentTypeEnum[]{PoorEnvironmentTypeEnum.smokeHazard};
                ((PoorEnvironmentConditions)sr).setPoorEnvironmentType(enums);
                break;
            }
            case "Explosion": {
                sr = new GeneralObstruction();
                ObstructionTypeEnum[] enums2 = new ObstructionTypeEnum[]{ObstructionTypeEnum.explosion};
                ((GeneralObstruction)sr).setObstructionType(enums2);
                break;
            }
            case "Incident": {
                sr = new GeneralObstruction();
                ObstructionTypeEnum[] enums4 = new ObstructionTypeEnum[]{ObstructionTypeEnum.incident};
                ((GeneralObstruction)sr).setObstructionType(enums4);
                break;
            }
            case "Incendie industriel": {
                sr = new GeneralObstruction();
                ObstructionTypeEnum[] enums3 = new ObstructionTypeEnum[]{ObstructionTypeEnum.industrialAccident};
                ((GeneralObstruction)sr).setObstructionType(enums3);
            }
        }
        return sr;
    }

    public void genererMobilityType(HashMap<String, String> attributsEvenements, Extension parametresDatex2, Obstruction obstruction) {
    }

    @Override
    public Extension evenementToExtensionDatex2(boolean bPush, Evenement evenement) throws Exception {
        Extension parametresDatex2 = this.enteteToExtensionDatex2(bPush);
        if (evenement.getLocalisation().getLongueur() > 0) {
            parametresDatex2.setValeur("typeLocalisation", (Object)"Lin\u00e9aire");
        } else {
            parametresDatex2.setValeur("typeLocalisation", (Object)"Point");
        }
        List listeDesc = (List)BusinessServiceFactory.getBusinessService().getDescriptionsNatureMap().get(evenement.getValeurNature().getCode());
        int iDesc = MetierCommun.getIndiceObjetListe((List)listeDesc, (Object)evenement.getValeurNature().getDescription().getValeur());
        String phr = null;
        if (iDesc <= -1) {
            throw new RuntimeException();
        }
        IDescription desc = (IDescription)listeDesc.get(iDesc);
        phr = desc.getCode();
        String dobStr = evenement.getValeurNature().getCode();
        SituationRecord dob = null;
        CorrespondanceDatex2 correspondanceDatex2 = this.mapPrismDatex2.get(phr);
        Nature n = (Nature)DeepCopy.copy((Object)((Nature)BusinessServiceFactory.getBusinessService().getNatures().get(evenement.getValeurNature().getCode())));
        n.chargerValeurs(evenement.getValeurNature());
        HashMap attributsEvenements = MetierCommun.convertirAttributs((Nature)n, (Evenement)evenement);
        try {
            String definitionDatex2 = correspondanceDatex2.getDefinitionDatex2();
            if (definitionDatex2.equals("typeObstacleVehicule")) {
                dob = this.extensionDatex2ToEvenementObstacleVehicule(attributsEvenements, parametresDatex2, n);
            } else if (definitionDatex2.equals("typeObstacleAutre")) {
                dob = this.extensionDatex2ToEvenementObstacleAutre(attributsEvenements, parametresDatex2, n);
            } else if (definitionDatex2.equals("typeObstacleIncident")) {
                dob = this.extensionDatex2ToEvenementObstacleIncident(attributsEvenements, parametresDatex2, n);
            } else if (definitionDatex2.equals("typeObstacleEquipement")) {
                dob = this.extensionDatex2ToEvenementObstacleEquipement(attributsEvenements, parametresDatex2, n);
            } else if (definitionDatex2.equals("TYPE_ACCIDENT")) {
                dob = this.extensionDatex2ToEvenementAccident(attributsEvenements, parametresDatex2, n);
            } else if (definitionDatex2.equals("typeBouchon") || definitionDatex2.equals("typeAccordeon") || definitionDatex2.equals("typeCirculationBloquee") || definitionDatex2.equals("typeRalentissement")) {
                dob = this.extensionDatex2ToEvenementBouchon(attributsEvenements, parametresDatex2, n, definitionDatex2);
            }
        }
        catch (Exception e) {
            try {
                this.log.error((Object)("erreur cr\u00e9ation avec DOB SituationRecordString " + CorrespondanceTablesV2.instanceOf().getMapSituationRecordString().get(phr)));
                dob = CorrespondanceTablesV2.instanceOf().getMapSituationRecord().get(phr);
            }
            catch (Exception e1) {
                this.log.error((Object)("erreur cr\u00e9ation DOB " + CorrespondanceTablesV2.instanceOf().getMapSituationRecordString().get(phr)));
                throw new RuntimeException();
            }
        }
        if (dob != null && dob instanceof Obstruction) {
            this.genererMobilityType(attributsEvenements, parametresDatex2, (Obstruction)dob);
        }
        String lanes = "";
        parametresDatex2.setValeur("validityTimeSpecificationStart", (Object)GLSDate.toDateDatex((long)evenement.getDateCreation()));
        if (evenement.isTermine()) {
            parametresDatex2.setValeur("validityTimeSpecificationStop", (Object)GLSDate.toDateDatex((long)evenement.getDateMaj()));
        }
        parametresDatex2.setValeur("lifeCycleManagementCancel", (Object)GLS.getInt((boolean)false));
        parametresDatex2.setValeur("creationTime", (Object)GLSDate.toDateDatex((long)evenement.getDateCreation()));
        parametresDatex2.setValeur("firstSupplierVersionTime", (Object)GLSDate.toDateDatex((long)evenement.getDateCreation()));
        parametresDatex2.setValeur("versionTime", (Object)GLSDate.toDateDatex((long)evenement.getDateMaj()));
        if (evenement.isTermine()) {
            parametresDatex2.setValeur("stopTime", (Object)GLSDate.toDateDatex((long)evenement.getDateMaj()));
        }
        parametresDatex2.setValeur("lifeCycleManagementEnd", (Object)GLS.getInt((boolean)evenement.isTermine()));
        parametresDatex2.setValeur("commentaireMultiLang", (Object)"1");
        parametresDatex2.setValeur("commentaireMultiLangFr", attributsEvenements.get("commentaire"));
        parametresDatex2.setValeur("commentaireMultiLangEn", (Object)"");
        parametresDatex2.setValeur("typeEvenement", (Object)phr);
        parametresDatex2.setValeur("idSituation", (Object)evenement.getIdSituation());
        parametresDatex2.setValeur("natureEvenement", (Object)dob);
        parametresDatex2.setValeur("idSituationRecord", (Object)evenement.getIdReference());
        parametresDatex2.setValeur("situationRecordVersion", (Object)evenement.getNumVersion());
        ValeurChampLocalisation evtLoc = evenement.getLocalisation();
        parametresDatex2.setValeur("alertcCodePays", (Object)"F");
        parametresDatex2.setValeur("alertcTableNumber", (Object)"32");
        parametresDatex2.setValeur("alertcVersion", null);
        parametresDatex2.setValeur(LOCATION_ALERTC_DIRECTION, null);
        parametresDatex2.setValeur("communeSecondaire", (Object)evtLoc.getCommune());
        parametresDatex2.setValeur("RoutePrimaire", (Object)evtLoc.getAxe());
        parametresDatex2.setValeur("RouteSecondaire", (Object)evtLoc.getAxe());
        parametresDatex2.setValeur("communePrimaire", (Object)evtLoc.getCommune());
        parametresDatex2.setValeur(LOCATION_TPEG_DIRECTION, (Object)"unknown");
        if (evtLoc.getX() != null && evtLoc.getX().length > 0) {
            parametresDatex2.setValeur("XYPrimaire", (Object)(String.valueOf(evtLoc.getX()[0]) + ";" + evtLoc.getY()[0]));
        }
        if (evtLoc.getX() != null && evtLoc.getX().length > 0) {
            parametresDatex2.setValeur("XYSecondaire", (Object)(String.valueOf(evtLoc.getX()[evtLoc.getX().length - 1]) + ";" + evtLoc.getY()[evtLoc.getX().length - 1]));
        }
        parametresDatex2.setValeur(LOCATION_TPEG_POINT_SUBTYPE, (Object)"segment");
        IConfiguration myConfig = ConfigurationFactory.getInstance();
        int sens = evtLoc.getSensPr();
        if (sens == 1) {
            parametresDatex2.setValeur("prDirection", (Object)1);
        } else if (sens == -1) {
            parametresDatex2.setValeur("prDirection", (Object)0);
        } else if (sens == 2) {
            parametresDatex2.setValeur("prDirection", (Object)3);
        } else {
            parametresDatex2.setValeur("prDirection", (Object)2);
        }
        int prDeb = evtLoc.getPrDebut();
        int prFin = evtLoc.getPrFin();
        String deptDeb = evtLoc.getDeptDebut();
        String deptFin = evtLoc.getDeptFin();
        if ("-1".equals(deptDeb) && "-1".equals(deptFin)) {
            throw new LocalisationDatex2DepartementException();
        }
        parametresDatex2.setValeur("departementPrimaire", (Object)deptDeb);
        parametresDatex2.setValeur("departementSecondaire", (Object)deptFin);
        StringBuffer sbPRDeb = new StringBuffer();
        StringBuffer sbPRFin = new StringBuffer();
        if (1 == sens || sens == 0 || 2 == sens || 3 == sens) {
            if (-1 != prDeb) {
                sbPRDeb.append(deptDeb);
                sbPRDeb.append("PR");
                sbPRDeb.append(prDeb);
                if (sens == 0 || 2 == sens) {
                    sbPRDeb.append("G");
                } else {
                    sbPRDeb.append("D");
                }
            }
            if (-1 != prFin) {
                sbPRFin.append(deptFin);
                sbPRFin.append("PR");
                sbPRFin.append(prFin);
                if (sens == 0 || 2 == sens) {
                    sbPRFin.append("G");
                } else {
                    sbPRFin.append("D");
                }
            }
        }
        parametresDatex2.setValeur("prPrimaire", (Object)sbPRDeb.toString());
        parametresDatex2.setValeur("prSecondaire", (Object)sbPRFin.toString());
        if (evtLoc.getAbsPrDebut() < 0) {
            parametresDatex2.setValeur("prDistancePrimaire", (Object)0);
        } else {
            parametresDatex2.setValeur("prDistancePrimaire", (Object)evtLoc.getAbsPrDebut());
        }
        if (evtLoc.getAbsPrFin() < 0) {
            parametresDatex2.setValeur("prDistanceSecondaire", (Object)0);
        } else {
            parametresDatex2.setValeur("prDistanceSecondaire", (Object)evtLoc.getAbsPrFin());
        }
        if (!GLS.estVide((String)lanes)) {
            parametresDatex2.setValeur("supplementaryPositionalDescription", (Object)"1");
            parametresDatex2.setValeur("supplementaryPositionalDescriptionLanes", (Object)lanes);
            parametresDatex2.setValeur("supplementaryPositionalDescriptionCarriage", (Object)"mainCarriageway");
        } else {
            parametresDatex2.setValeur("supplementaryPositionalDescription", (Object)"1");
            parametresDatex2.setValeur("supplementaryPositionalDescriptionLanes", (Object)"allLanesCompleteCarriageway");
            parametresDatex2.setValeur("supplementaryPositionalDescriptionCarriage", (Object)"mainCarriageway");
        }
        parametresDatex2.setValeur("isAlertc", (Object)"0");
        parametresDatex2.setValeur("DESCRIPTION_ITINERAIRE_DEVIATION", attributsEvenements.get("deviation"));
        parametresDatex2.setValeur("LIMITATION_VITESSE_VALEUR", attributsEvenements.get("limitationVitesse"));
        String valeur = (String)attributsEvenements.get("typeIncidentPL");
        if (!GLS.estVide((String)valeur)) {
            if (valeur.equals("Probl\u00e8me inconnu")) {
                parametresDatex2.setValeur("CAUSE_PL", (Object)"nc");
            } else if (valeur.equals("Probl\u00e8me gabarit")) {
                parametresDatex2.setValeur("CAUSE_PL", (Object)"problemeGabarit");
            } else if (valeur.equals("Perte de chargement")) {
                parametresDatex2.setValeur("CAUSE_PL", (Object)"perteChargement");
            } else if (valeur.equals("Probl\u00e8me autre")) {
                parametresDatex2.setValeur("CAUSE_PL", (Object)"other");
            }
        }
        ValeurChampVehiculeEnCause vec = null;
        try {
            MetierCommun.instanceOf();
            vec = (ValeurChampVehiculeEnCause)MetierCommun.getValeurChamp((List)evenement.getValeurNature().getValeurs(), (String)"typeVehicule");
        }
        catch (Exception e) {
            vec = null;
        }
        if (vec != null) {
            if (vec.getVl() > 0) {
                parametresDatex2.setValeur("ACCIDENT_NB_VEHICULES", (Object)vec.getVl());
            }
            if (vec.getVtc() > 0) {
                parametresDatex2.setValeur("ACCIDENT_NB_BUS", (Object)vec.getVtc());
            }
            if (vec.getVelo() > 0) {
                parametresDatex2.setValeur("ACCIDENT_NB_VELOS", (Object)vec.getVelo());
            }
            if (vec.getDeuxRoues() > 0) {
                parametresDatex2.setValeur("ACCIDENT_NB_DEUXROUES", (Object)vec.getDeuxRoues());
            }
            if (vec.getMoto() > 0) {
                parametresDatex2.setValeur("ACCIDENT_NB_MOTOS", (Object)vec.getMoto());
            }
            if (vec.getCaravane() > 0) {
                parametresDatex2.setValeur("ACCIDENT_NB_CARAVANES", (Object)vec.getCaravane());
            }
            if (vec.getTramway() > 0) {
                parametresDatex2.setValeur("ACCIDENT_NB_TRAMWAYS", (Object)vec.getTramway());
            }
            if (vec.getTrain() > 0) {
                parametresDatex2.setValeur("ACCIDENT_NB_TRAINS", (Object)vec.getTrain());
            }
            if (vec.getEnginAgricole() > 0) {
                parametresDatex2.setValeur("ACCIDENT_NB_ENGINSAGRICOLES", (Object)vec.getEnginAgricole());
            }
            if (vec.getAutres() > 0) {
                parametresDatex2.setValeur("ACCIDENT_NB_AUTRES", (Object)vec.getAutres());
            }
            if (vec.getPietonCycle() > 0) {
                parametresDatex2.setValeur("ACCIDENT_PIETONS_IMPLIQUES", (Object)vec.getPietonCycle());
                parametresDatex2.setValeur("ACCIDENT_NB_PIETONS", (Object)vec.getPietonCycle());
            }
            if (!GLS.estVide((String)(valeur = (String)attributsEvenements.get("description-autres-typeVehicule")))) {
                parametresDatex2.setValeur("ACCIDENT_AUTRES_COM", (Object)valeur);
            }
            if (vec.getPl() > 0) {
                parametresDatex2.setValeur("ACCIDENT_NB_PL", (Object)vec.getPl());
            }
        }
        if (!GLS.estVide((String)(valeur = (String)attributsEvenements.get("facteursAggravants")))) {
            if (valeur.indexOf("TMD") >= 0 || valeur.indexOf("Mati\u00e8res dangereuses") >= 0) {
                parametresDatex2.setValeur("ACCIDENT_FACTAUERAGGRAVANT_TMD", (Object)true);
            }
            if (valeur.indexOf("Carambolage") >= 0) {
                parametresDatex2.setValeur("ACCIDENT_FACTAUERAGGRAVANT_CARAMBOLAGE", (Object)"1");
            }
            if (valeur.indexOf("Transport public") >= 0) {
                parametresDatex2.setValeur("ACCIDENT_FACTAUERAGGRAVANT_TC", (Object)"1");
            }
            if (valeur.indexOf("Transport d'enfants") >= 0) {
                parametresDatex2.setValeur("ACCIDENT_PERSONNES_IMPLIQUEES_ENFANTS", (Object)"1");
            }
            if (valeur.indexOf("VIP") >= 0) {
                parametresDatex2.setValeur("ACCIDENT_PERSONNES_IMPLIQUEES_VIP", (Object)"1");
            }
            if (valeur.indexOf("Gestionnaire routier impliqu\u00e9") >= 0) {
                parametresDatex2.setValeur("ACCIDENT_PERSONNES_IMPLIQUEES_GESTIONNAIRE_ROUTIER", (Object)"1");
            }
            if (valeur.indexOf("Gestionnaire routier impliqu\u00e9s") >= 0) {
                parametresDatex2.setValeur("ACCIDENT_PERSONNES_IMPLIQUEES_GESTIONNAIRE_ROUTIER", (Object)"1");
            }
            if (valeur.indexOf("Forces de l'ordre ou secours impliqu\u00e9s") >= 0) {
                parametresDatex2.setValeur("ACCIDENT_PERSONNES_IMPLIQUEES_FORCE_ORDRE", (Object)"1");
            }
            if (valeur.indexOf("Secours impliqu\u00e9s") >= 0) {
                parametresDatex2.setValeur("ACCIDENT_PERSONNES_IMPLIQUEES_SERVICE_URGENCE", (Object)"1");
            }
        }
        if (!GLS.estVide((String)(valeur = (String)attributsEvenements.get("blessesGraves")))) {
            parametresDatex2.setValeur("ACCIDENT_PERSONNES_BLESSEES", (Object)valeur);
        }
        if (!GLS.estVide((String)(valeur = (String)attributsEvenements.get("blesses")))) {
            parametresDatex2.setValeur("ACCIDENT_PERSONNES_BLESSEES", (Object)valeur);
        }
        if (!GLS.estVide((String)(valeur = (String)attributsEvenements.get("tues")))) {
            parametresDatex2.setValeur("ACCIDENT_PERSONNES_TUEES", (Object)valeur);
        }
        if (!GLS.estVide((String)(valeur = (String)attributsEvenements.get("consequences")))) {
            if (valeur.contains("Mat\u00e9rielles")) {
                parametresDatex2.setValeur("ACCIDENT_MATERIELLES", (Object)"true");
            } else {
                parametresDatex2.setValeur("ACCIDENT_MATERIELLES", (Object)"false");
            }
        }
        if (!GLS.estVide((String)(valeur = (String)attributsEvenements.get("description-autres-typeVehicule")))) {
            parametresDatex2.setValeur("DESCRIPTION_VEHICULE", (Object)valeur);
        }
        if (!GLS.estVide((String)(valeur = (String)attributsEvenements.get("vehiculesConcernes")))) {
            if ("Tous v\u00e9hicules".equals(valeur)) {
                parametresDatex2.setValeur("VEHCIULES_CONCERNES", (Object)"VEHCIULES_CONCERNES_TOUSVEHICULES");
            } else if ("V\u00e9hicules <= 19T".equals(valeur)) {
                parametresDatex2.setValeur("VEHCIULES_CONCERNES", (Object)"VEHCIULES_CONCERNES_VEHICULES_INFEGA19T");
            } else if ("V\u00e9hicules > 19T".equals(valeur)) {
                parametresDatex2.setValeur("VEHCIULES_CONCERNES", (Object)"VEHCIULES_CONCERNES_VEHICULES_SUP19T");
            } else if ("V\u00e9hicules <= 7,5T".equals(valeur)) {
                parametresDatex2.setValeur("VEHCIULES_CONCERNES", (Object)"VEHCIULES_CONCERNES_VEHICULES_INFEGA7P5T");
            } else if ("V\u00e9hicules > 7,5T".equals(valeur)) {
                parametresDatex2.setValeur("VEHCIULES_CONCERNES", (Object)"VEHCIULES_CONCERNES_VEHICULES_SUP7P5T");
            } else {
                parametresDatex2.setValeur("VEHCIULES_CONCERNES", (Object)"VEHCIULES_CONCERNES_AUTRE");
                parametresDatex2.setValeur("DESCRIPTION_VEHICULE", (Object)valeur);
            }
        }
        return parametresDatex2;
    }

    @Override
    public D2LogicalModel genererModelDatex2KeepAlive(boolean bPush, ResponseEnum response) throws Exception {
        Extension parametresDatex2 = new Extension();
        D2LogicalModel d2LogicalModel = new D2LogicalModel();
        d2LogicalModel.setModelBaseVersion("2");
        parametresDatex2 = this.enteteToExtensionDatex2(bPush);
        d2LogicalModel.setExchange(this.genererExchange(parametresDatex2, response));
        d2LogicalModel.getExchange().setKeepAlive(true);
        return d2LogicalModel;
    }

    @Override
    public D2LogicalModel genererModelDatex2(boolean bPush, ArrayList<Evenement> listeEvenements) throws Exception {
        Extension parametresDatex2 = new Extension();
        D2LogicalModel d2LogicalModel = new D2LogicalModel();
        d2LogicalModel.setModelBaseVersion("2");
        parametresDatex2 = this.enteteToExtensionDatex2(bPush);
        d2LogicalModel.setExchange(this.genererExchange(parametresDatex2, ResponseEnum.acknowledge));
        SituationPublication situationPublication = this.genererSituationPublication(parametresDatex2);
        Vector<Situation> situations = new Vector<Situation>();
        for (Evenement evt : listeEvenements) {
            try {
                parametresDatex2 = this.evenementToExtensionDatex2(bPush, evt);
                Situation situation = this.genererSituation(parametresDatex2, parametresDatex2.getString("idSituation"));
                if (parametresDatex2.getValeur("natureEvenement") != null) {
                    SituationRecord situationRecord = this.genererSituationRecord((SituationRecord)parametresDatex2.getValeur("natureEvenement"), parametresDatex2, parametresDatex2.getString("idSituationRecord"), String.valueOf(parametresDatex2.getString("idSituationRecord")), parametresDatex2.getString("situationRecordVersion"), parametresDatex2.getBoolean("lifeCycleManagementEnd", false), parametresDatex2.getBoolean("lifeCycleManagementCancel", false));
                    situation.setSituationRecord(new SituationRecord[]{situationRecord});
                    situations.add(situation);
                    continue;
                }
                this.log.info((Object)("Evenement non converti => kEventId = " + evt.getkEventid() + ", Code = " + evt.getValeurNature().getCode() + ", Description = " + evt.getValeurNature().getDescription().getValeur()));
            }
            catch (LocalisationDatex2DepartementException e) {
                this.log.info((Object)("Dept vide - Evenement non converti => kEventId = " + evt.getkEventid() + ", Code = " + evt.getValeurNature().getCode() + ", Description = " + evt.getValeurNature().getDescription().getValeur()));
            }
            catch (Exception e) {
                this.log.error((Object)e);
            }
        }
        if (situations.size() == 0) {
            return null;
        }
        Situation[] sit = new Situation[situations.size()];
        int i = 0;
        for (Situation s : situations) {
            sit[i++] = s;
        }
        situationPublication.setSituation(sit);
        d2LogicalModel.setPayloadPublication(situationPublication);
        return d2LogicalModel;
    }

    @Override
    public void initMapPrism(Map<String, CorrespondanceDatex2> map) {
        this.mapPrismDatex2 = map;
    }

    @Override
    public void setNationalIdentifier(String nationalIdentifier) {
        this.nationalIdentifier = nationalIdentifier;
    }
}

