/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.export;

import cartoj.Enregistrement;
import cartoj.util.fichier.MonFichier;
import com.geolocsystems.prism.localisation.CartojCartoService;
import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.Troncon;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.Situation;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampLocalisation;
import com.geolocsystems.prismbatch.BusinessServiceFactory;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.PrismI18n;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.geolocsystems.prismcentral.data.ICartoService;
import gls.geometry.GeoPoint;
import gls.localisation.LocalisationInfo;
import gls.localisation.recherche.Recherche;
import gls.outils.GLS;
import gls.outils.fichier.Fichier;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PrismLocalisationTroncon {
    private static Logger cat1 = Logger.getLogger((String)"localisationTroncons");

    public static void main(String[] args) {
        Date iterationCourante = GregorianCalendar.getInstance().getTime();
        cat1.info((Object)("Lancement \u00e0 " + iterationCourante));
        PrismLocalisationTroncon p = new PrismLocalisationTroncon();
        try {
            p.majNomCommuneErreur();
        }
        catch (Exception e) {
            cat1.error((Object)"ERR", (Throwable)e);
            e.printStackTrace();
        }
    }

    private void miseAJourCaracAxe() throws Exception {
        IBusinessService.EvenementFiltre f = IBusinessService.EvenementFiltre.moduleMetier(null, null, (int)0);
        f.termines = -1;
        f.etat = -1;
        MonFichier fic = new MonFichier("c:/projet/cd26/req_upd_carac.sql", 1);
        List sits = BusinessServiceFactory.getBusinessService().getEvenements(f, null);
        for (Situation s : sits) {
            for (Evenement e : s.getEvenements()) {
                List troncons;
                Map caracteristiquesRoute = BusinessServiceFactory.getBusinessService().getCaracteristiquesRoute();
                if (!caracteristiquesRoute.containsKey("categorie") || (troncons = (List)((Map)caracteristiquesRoute.get("categorie")).get(e.getValeurNature().getLocalisation().getAxe())) == null || troncons.isEmpty()) continue;
                String cat = CartojCartoService.getCaracteristiqueLocalisation((List)troncons, (int)e.getValeurNature().getLocalisation().getPrDebut(), (int)e.getValeurNature().getLocalisation().getAbsPrDebut());
                fic.ecrire("update prism.evenement set donneescomplementaires='categorie=" + cat + ":trafic=' where k_eventid = " + e.getkEventid() + ";\n");
            }
        }
        fic.fermer();
    }

    private void importZoneOmbres() throws Exception {
        IBusinessService iBusinessService = BusinessServiceFactory.getBusinessService();
        GLS.getFichier();
        iBusinessService.importZoneOmbre(Fichier.choixFichier());
    }

    private void importTroncons(String table, String champ) throws Exception {
        IBusinessService iBusinessService = BusinessServiceFactory.getBusinessService();
        GLS.getFichier();
        iBusinessService.importTronconsPr(table, champ, Fichier.choixFichier());
    }

    private void importCaracteristiques() throws Exception {
        IBusinessService iBusinessService = BusinessServiceFactory.getBusinessService();
        GLS.getFichier();
        iBusinessService.importNiveauxExploitation(Fichier.choixFichier());
    }

    private void localisationZonesSensible(boolean enErreur) {
        this.localisationTroncons("donnees_metier.zone_sensible", enErreur);
    }

    private void localisationTroncons(String table, boolean enErreur) {
        List troncons = BusinessServiceFactory.getBusinessService().getTroncons(table);
        if (!enErreur) {
            for (Troncon t : troncons) {
                try {
                    BusinessServiceFactory.getCartoService().localisation(t);
                    BusinessServiceFactory.getBusinessService().miseAJourCoordonneesTroncon(table, t);
                }
                catch (Exception e) {
                    Log.error((Object)"", (Throwable)e);
                }
            }
        } else {
            for (Troncon t : troncons) {
                if (t.getLongueur() != -1) continue;
                try {
                    BusinessServiceFactory.getCartoService().localisation(t);
                    BusinessServiceFactory.getBusinessService().miseAJourCoordonneesTroncon(table, t);
                }
                catch (Exception e) {
                    Log.error((Object)(String.valueOf(t.getId()) + " --> " + e.getMessage()));
                }
            }
        }
    }

    private void localisationEvenementsLineaireSansLongueur() {
        List situations = BusinessServiceFactory.getBusinessService().getEvenements(IBusinessService.EvenementFiltre.byDelegation(null, null), new ArrayList());
        for (Situation s : situations) {
            for (Evenement e : s.getEvenements()) {
                if (!MetierCommun.estLineaireEnErreur((ValeurChampLocalisation)e.getLocalisation())) continue;
                try {
                    BusinessServiceFactory.getCartoService().localisation(e.getLocalisation());
                    e.setErreur(null);
                }
                catch (ICartoService.LocalisationException ex) {
                    Log.error((Object)e);
                    e.setErreur(PrismI18n.getString((String)ex.getErreurI18n()));
                }
                catch (Throwable ex) {
                    Log.error((Object)e);
                    e.setErreur("ERREUR INCONNUE LOCALISATION");
                }
                if (e.getErreur() == null && e.getLocalisation().getPositionDebut() != null && e.getLocalisation().getX() != null && e.getLocalisation().getX().length > 0) {
                    BusinessServiceFactory.getBusinessService().miseAJourGeometryEvenement(e);
                    continue;
                }
                Log.error((Object)("EVENEMENT " + e.getkEventid() + " en erreur !"));
            }
        }
    }

    private void relocalisationEvenements() {
        IBusinessService.EvenementFiltre f = IBusinessService.EvenementFiltre.byDelegation(null, null);
        f.etat = -1;
        f.termines = -1;
        List situations = BusinessServiceFactory.getBusinessService().getEvenements(f, new ArrayList());
        for (Situation s : situations) {
            for (Evenement e : s.getEvenements()) {
                try {
                    e.getLocalisation().setPrDebut(-1);
                    e.getLocalisation().setPrFin(-1);
                    e.getLocalisation().setPositionFin(null);
                    e.getLocalisation().setAbsPrDebut(-1);
                    e.getLocalisation().setAbsPrFin(-1);
                    BusinessServiceFactory.getCartoService().localisation(e.getLocalisation());
                    e.setErreur(null);
                }
                catch (ICartoService.LocalisationException ex) {
                    Log.error((Object)e);
                    e.setErreur(PrismI18n.getString((String)ex.getErreurI18n()));
                }
                catch (Throwable ex) {
                    Log.error((Object)e);
                    e.setErreur("ERREUR INCONNUE LOCALISATION");
                }
                if (e.getErreur() == null && e.getLocalisation().getPositionDebut() != null && e.getLocalisation().getX() != null && e.getLocalisation().getX().length > 0) {
                    BusinessServiceFactory.getBusinessService().miseAJourGeometryEvenement(e);
                    continue;
                }
                Log.error((Object)("EVENEMENT " + e.getkEventid() + " en erreur !"));
            }
        }
    }

    private void remplirCommunes() {
        Enregistrement[] enrs;
        try {
            MonFichier.supprimer((String)"c:/projet/cd67/req_upd_communes.sql");
        }
        catch (Exception exception) {
            // empty catch block
        }
        MonFichier fic = new MonFichier("c:/projet/cd67/req_upd_communes.sql", 1);
        BusinessServiceFactory.getCartoService().getCommunes();
        Enregistrement[] enregistrementArray = enrs = LocalisationInfo.getCoucheCommuneZone().getDon().getAllEnreg();
        int n = enrs.length;
        int n2 = 0;
        while (n2 < n) {
            Enregistrement enr = enregistrementArray[n2];
            try {
                String req = "INSERT INTO prism.communes (insee, commune, centre, zone_routiere, departement, delegation) VALUES('" + enr.getValeur(1) + "' , '" + enr.getValeur(0) + "', null, 'cg67','" + enr.getValeur(1).substring(0, 2) + "', null);\n";
                fic.ecrire(req);
            }
            catch (Exception e) {
                System.out.println("Err" + e);
                e.printStackTrace();
            }
            ++n2;
        }
        try {
            fic.fermer();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void localisationPRTronconsCircuit() {
        this.localisationPRTroncons("donnees_metier.troncon_circuit");
    }

    private void localisationPRTroncons(String table) {
        List troncons = BusinessServiceFactory.getBusinessService().getTroncons(table);
        for (Troncon t : troncons) {
            if (t.getPrDebut() != -1 && t.getPrFin() != -1) continue;
            try {
                BusinessServiceFactory.getCartoService().localisation(t);
                BusinessServiceFactory.getBusinessService().miseAJourPRTroncon(table, t);
            }
            catch (Exception e) {
                Log.error((Object)"", (Throwable)e);
            }
        }
    }

    private void majNomCommuneErreur() {
        String nomFichier = "req_upd_communes_erreur.sql";
        try {
            MonFichier.supprimer((String)nomFichier);
        }
        catch (Exception exception) {
            // empty catch block
        }
        MonFichier fic = new MonFichier(nomFichier, 1);
        IBusinessService.EvenementFiltre f = IBusinessService.EvenementFiltre.byDelegation(null, null);
        f.etat = -1;
        f.termines = -1;
        List situations = BusinessServiceFactory.getBusinessService().getEvenements(f, new ArrayList());
        for (Situation s : situations) {
            for (Evenement e : s.getEvenements()) {
                float y;
                float x;
                Enregistrement enr;
                if (!GLS.estVide((String)e.getLocalisation().getCommune()) || (enr = Recherche.rechercherPremiereCommuneDistance((GeoPoint)new GeoPoint(x = e.getLocalisation().getPositionDebut().getX(), y = e.getLocalisation().getPositionDebut().getY()), (int)1)) == null) continue;
                String nomCommune = enr.getValeur(0);
                String requete = "update prism.evenement set commune = '" + nomCommune + "' where k_eventid = " + e.getkEventid() + ";";
                try {
                    fic.ecrire(requete);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        try {
            fic.fermer();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

