/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.stats.tab;

import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismcentral.beans.EvenementStatistiqueBean;
import com.neogls.prism.central.vaadin.view.mct.common.event.filter.EventFilter;
import com.neogls.prism.central.vaadin.view.stats.chart.BarChart;
import com.neogls.prism.central.vaadin.view.stats.chart.PieChart;
import com.neogls.prism.central.vaadin.view.stats.tab.CommonStatsTab;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.html.Span;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;

public class StatsTabCentre
extends CommonStatsTab {
    @Nullable
    private final String key;

    public StatsTabCentre(@Nullable String key, @Nonnull EvenementStatistiqueBean evenement, @Nonnull Map<String, Nature> natures, @Nonnull EventFilter eventFilter) {
        super(evenement, natures, eventFilter);
        this.key = key;
        PieChart pieChart = new PieChart(evenement.getNbEvenementsParNature(), (ItemLabelGenerator & Serializable)code -> Optional.ofNullable((Nature)natures.get(code)).map(Nature::getLabel).orElse(null), true, true, evenement.getNbEvenements());
        this.add(new Component[]{pieChart});
        evenement.calculTempsMoyenTraitement(Duration.ofDays(1L).toMillis());
        for (String nature : evenement.getNbEvenementsParSousNature().keySet()) {
            Span titre = new Span(natures.get(nature).getLabel().toUpperCase());
            titre.setSizeFull();
            titre.addClassName("stats-title-label");
            this.add(new Component[]{titre});
            this.add(new Component[]{new BarChart("", this.getTranslation("stats.statistiques.nb.evenements", new Object[0]), (Map)evenement.getNbEvenementsParSousNature().get(nature))});
            if (evenement.getTempsMoyenTraitementParSousNature().get(nature) == null) continue;
            this.add(new Component[]{new BarChart("", this.getTranslation("stats.statistiques.tps.moyen.traitement.jours", new Object[0]), (Map)evenement.getTempsMoyenTraitementParSousNature().get(nature))});
        }
    }

    @Nonnull
    public String getTitle() {
        if (this.key == null) {
            return this.getTranslation("stats.statistiques.autre", new Object[0]);
        }
        if (this.key.isEmpty()) {
            return this.getTranslation("stats.statistiques.tous", new Object[0]);
        }
        return this.key;
    }
}

