/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.stats.tab;

import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismcentral.beans.EvenementStatistiqueBean;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.geolocsystems.prismcentral.export.StatistiquesExport;
import com.neogls.prism.central.vaadin.util.vaadin.CachedInputStreamFactory;
import com.neogls.prism.central.vaadin.view.mct.common.event.filter.EventFilter;
import com.neogls.prism.central.vaadin.view.stats.tab.StatsTab;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.html.Anchor;
import com.vaadin.flow.component.html.AnchorTarget;
import com.vaadin.flow.component.html.AnchorTargetValue;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.InputStreamFactory;
import com.vaadin.flow.server.StreamResource;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class CommonStatsTab
extends VerticalLayout
implements StatsTab {
    protected CommonStatsTab(@Nonnull EvenementStatistiqueBean evenement, @Nonnull Map<String, Nature> natures, @Nonnull EventFilter eventFilter) {
        this.add(new Component[]{this.createExportButton(evenement, natures, eventFilter)});
        this.setAlignItems(FlexComponent.Alignment.CENTER);
    }

    private Component createExportButton(EvenementStatistiqueBean evenement, Map<String, Nature> natures, EventFilter eventFilter) {
        evenement.setLabelsNatures(natures.values().stream().collect(Collectors.toMap(Nature::getCode, Nature::getLabel)));
        evenement.setFiltres(this.getMapFiltres(eventFilter.getSqlFilter()));
        Button exportButton = new Button(this.getTranslation("stats.statistiques.generer.pdf", new Object[0]));
        Anchor anchor = new Anchor();
        anchor.add(new Component[]{exportButton});
        anchor.setHref((AbstractStreamResource)new StreamResource(MetierCommun.instanceOf().genereIdentifiantUnique("statistiques") + ".pdf", (InputStreamFactory)new CachedInputStreamFactory((InputStreamFactory & Serializable)() -> new StatistiquesExport().export(evenement))));
        anchor.setTarget((AnchorTargetValue)AnchorTarget.BLANK);
        return anchor;
    }

    private Map<String, String> getMapFiltres(IBusinessService.EvenementFiltre filtre) {
        HashMap<String, String> filtres = new HashMap<String, String>();
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        if (filtre.nature != null) {
            filtres.put(this.getTranslation("stats.form.filtre.nature", new Object[0]), filtre.nature.toString());
        }
        if (filtre.route != null) {
            filtres.put(this.getTranslation("stats.form.filtre.route", new Object[0]), filtre.route);
        }
        if (filtre.delegation != null) {
            filtres.put(this.getTranslation("global.delegation", new Object[0]), filtre.delegation);
        }
        if (filtre.centre != null) {
            filtres.put(this.getTranslation("global.centre", new Object[0]), filtre.centre);
        }
        if (filtre.dateMax != null) {
            filtres.put(this.getTranslation("stats.form.filtre.periode", new Object[0]), String.join((CharSequence)" ", this.getTranslation("stats.form.filtre.du", new Object[0]), sdf.format(filtre.dateMin), this.getTranslation("stats.form.filtre.au", new Object[0]), sdf.format(filtre.dateMax)));
        }
        return filtres;
    }
}

