/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.stats.schema_routier.historique;

import com.geolocsystems.prismandroid.model.Centre;
import com.geolocsystems.prismandroid.model.Circuit;
import com.geolocsystems.prismandroid.model.Delegation;
import com.geolocsystems.prismbirtbean.SynthesePatrouilleBean;
import com.geolocsystems.prismbirtbean.SynthesePatrouillesBean;
import com.geolocsystems.prismbirtbean.SyntheseTableauBordStatistiqueSchemaRoutierBean;
import com.geolocsystems.prismcentral.beans.PrismCentralUser;
import com.geolocsystems.prismcentral.beans.TronconSuivi;
import com.neogls.prism.central.vaadin.layout.PrismLayout;
import com.neogls.prism.central.vaadin.rest.WMSController;
import com.neogls.prism.central.vaadin.service.ConfigurationService;
import com.neogls.prism.central.vaadin.service.security.AuthenticatedUser;
import com.neogls.prism.central.vaadin.service.stats.schemaroutier.SchemaRoutierService;
import com.neogls.prism.central.vaadin.util.LeafletUtils;
import com.neogls.prism.central.vaadin.util.vaadin.DatePickerI18nUtils;
import com.neogls.prism.central.vaadin.view.mct.common.ICartoPane;
import com.neogls.prism.central.vaadin.view.mct.common.carto.SuiviStyleService;
import com.neogls.prism.central.vaadin.view.mct.common.carto.cluster.ClusterCartoPaneFactory;
import com.neogls.prism.central.vaadin.view.mct.common.carto.layer.PrismLayerFactory;
import com.neogls.prism.central.vaadin.view.mct.common.carto.layer.TronconVhLayer;
import com.neogls.prism.central.vaadin.view.stats.schema_routier.historique.SchemaRoutierHistorique;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.accordion.Accordion;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.NativeLabel;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.LitRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.router.HasDynamicTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vaadin.addons.componentfactory.leaflet.controls.LeafletControl;
import org.vaadin.addons.componentfactory.leaflet.controls.ScaleControl;
import org.vaadin.addons.componentfactory.leaflet.layer.Layer;
import org.vaadin.addons.componentfactory.leaflet.layer.groups.LayerGroup;
import org.vaadin.addons.componentfactory.leaflet.layer.raster.TileLayer;
import org.vaadin.addons.componentfactory.leaflet.types.LatLngBounds;

@RolesAllowed(value={"ACTION_SCHEMA_ROUTIER_CONSULTATION_HISTORIQUE"})
@Route(value="vh/visualisation-schema_routier-historique", layout=PrismLayout.class)
public class SchemaRoutierHistorique
extends VerticalLayout
implements HasDynamicTitle {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SchemaRoutierHistorique.class);
    public static int TAILLE_BOUTTON = 150;
    private final ConfigurationService configurationService;
    protected ICartoPane cartoPane = null;
    private LatLngBounds maxBounds;
    private TronconVhLayer tronconFauchageLayer;
    protected PrismCentralUser user;
    protected HorizontalLayout headerInfoComponent;
    private HorizontalLayout hlButtons;
    private HorizontalLayout hlCombo;
    protected Button btVisualiser;
    private RadioButtonGroup<String> rbChoixDate;
    protected DatePicker dateDebutHistorique;
    protected DatePicker dateFinHistorique;
    private ComboBox<String> delegationsBox;
    private ComboBox<String> centresBox;
    private Delegation delegationNull;
    private Centre centreNull;
    private Circuit circuitNull;
    protected Span labelHistorique;
    private Map<String, LayerGroup> layersWMS;
    private SchemaRoutierService historiqueSchemaRoutierService;
    private Grid<SyntheseTableauBordStatistiqueSchemaRoutierBean> table;
    private Grid<SynthesePatrouilleBean> table2;

    public SchemaRoutierHistorique(ConfigurationService configurationService, SuiviStyleService suiviStyleService, SchemaRoutierService historiqueSchemaRoutierService, PrismLayerFactory prismLayerFactory, ClusterCartoPaneFactory clusterCartoPaneFactory, ConfigurationService configurationService1) {
        this.historiqueSchemaRoutierService = historiqueSchemaRoutierService;
        this.configurationService = configurationService;
        this.delegationNull = new Delegation();
        this.delegationNull.setNom("");
        this.centreNull = new Centre();
        this.centreNull.setNom("");
        this.circuitNull = new Circuit();
        this.circuitNull.setId("");
        this.layersWMS = new HashMap();
        this.user = historiqueSchemaRoutierService.getUserLogedIn();
        this.createIHM(configurationService, suiviStyleService, historiqueSchemaRoutierService, prismLayerFactory, clusterCartoPaneFactory);
    }

    protected void createIHM(ConfigurationService configurationService, SuiviStyleService suiviStyleService, SchemaRoutierService fauchageService, PrismLayerFactory prismLayerFactory, ClusterCartoPaneFactory clusterCartoPaneFactory) {
        Span titre = new Span(this.getTranslation("schema_routier.historique.title", new Object[0]));
        titre.addClassNames(new String[]{"text-header", "p-s", "bg-base", "shadow-xs", "rounded-l"});
        this.add(new Component[]{titre});
        this.hlButtons = new HorizontalLayout();
        this.hlButtons.setSizeUndefined();
        this.hlButtons.setSpacing(true);
        this.hlButtons.setAlignItems(FlexComponent.Alignment.CENTER);
        this.hlCombo = new HorizontalLayout();
        this.hlCombo.setSizeUndefined();
        this.hlCombo.setSpacing(true);
        this.hlCombo.setMargin(true);
        this.hlCombo.setAlignItems(FlexComponent.Alignment.CENTER);
        this.delegationsBox = new ComboBox(this.getTranslation("global.delegation", new Object[0]));
        this.delegationsBox.setPlaceholder(this.getTranslation("mct.filtre.delegation.toutes", new Object[0]));
        this.delegationsBox.setClearButtonVisible(true);
        this.centresBox = new ComboBox(this.getTranslation("global.centre", new Object[0]));
        this.centresBox.setPlaceholder(this.getTranslation("mct.filtre.centre.tous", new Object[0]));
        this.centresBox.setClearButtonVisible(true);
        List delegations = this.historiqueSchemaRoutierService.getDelegations();
        this.delegationsBox.setItems(delegations.stream().map(Delegation::getNom).toList());
        this.delegationsBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            for (Delegation d : delegations) {
                if (!d.getNom().equals(event.getValue())) continue;
                this.centresBox.clear();
                this.centresBox.setItems(((ComboBox)event.getSource()).isEmpty() ? List.of() : d.getCentres().stream().map(Centre::getNom).toList());
                this.centresBox.setReadOnly(((ComboBox)event.getSource()).isEmpty());
            }
        });
        AuthenticatedUser currentUser = this.historiqueSchemaRoutierService.getCurrentUser();
        if (currentUser.getDelegation() != null) {
            this.delegationsBox.setReadOnly(true);
            this.delegationsBox.setValue((Object)currentUser.getDelegation().getNom());
        }
        if (currentUser.getCentre() != null) {
            this.centresBox.setReadOnly(true);
            this.centresBox.setValue((Object)currentUser.getCentre().getNom());
        }
        this.dateDebutHistorique = new DatePicker(this.getTranslation("fauchage.historique.datefiled.name.debut", new Object[0]));
        this.dateDebutHistorique.setAllowedCharPattern("dd/MM/yyyy HH:mm");
        this.dateDebutHistorique.setWidth(150.0f, Unit.PIXELS);
        this.dateDebutHistorique.setI18n(DatePickerI18nUtils.getDatePickerI18n());
        this.dateFinHistorique = new DatePicker(this.getTranslation("fauchage.historique.datefiled.name.fin", new Object[0]));
        this.dateFinHistorique.setAllowedCharPattern("dd/MM/yyyy HH:mm");
        this.dateFinHistorique.setWidth(150.0f, Unit.PIXELS);
        this.dateFinHistorique.setI18n(DatePickerI18nUtils.getDatePickerI18n());
        this.labelHistorique = new Span();
        VerticalLayout vlDelegationCentre = new VerticalLayout();
        vlDelegationCentre.setSizeUndefined();
        vlDelegationCentre.setSpacing(true);
        vlDelegationCentre.setMargin(true);
        vlDelegationCentre.setAlignItems(FlexComponent.Alignment.CENTER);
        vlDelegationCentre.add(new Component[]{this.delegationsBox});
        vlDelegationCentre.add(new Component[]{this.centresBox});
        this.hlCombo.add(new Component[]{vlDelegationCentre});
        this.hlCombo.setClassName("prism-custom-field");
        HorizontalLayout vlDates = new HorizontalLayout();
        vlDates.add(new Component[]{this.dateDebutHistorique});
        vlDates.add(new Component[]{this.dateFinHistorique});
        this.dateFinHistorique.setVisible(false);
        vlDates.setVisible(true);
        this.rbChoixDate = new RadioButtonGroup();
        this.rbChoixDate.setLabel(this.getTranslation("report.stats.mode_calcul", new Object[0]));
        Object[] modeOptions = new String[]{"Date pr\u00e9cise", "Intervalle de dates"};
        this.rbChoixDate.setItems(modeOptions);
        this.rbChoixDate.setValue((Object)"Date pr\u00e9cise");
        this.rbChoixDate.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            this.dateFinHistorique.setVisible(!"Date pr\u00e9cise".equals(e.getValue()));
            this.dateFinHistorique.setVisible("Intervalle de dates".equals(e.getValue()));
        });
        VerticalLayout layout = new VerticalLayout();
        layout.add(new Component[]{this.rbChoixDate, vlDates});
        this.add(new Component[]{layout});
        this.hlCombo.add(new Component[]{layout});
        Button btAppliquer = new Button(this.getTranslation("fauchage.historique.apply", new Object[0]));
        btAppliquer.setWidth((float)TAILLE_BOUTTON, Unit.PIXELS);
        btAppliquer.addClickListener((ComponentEventListener & Serializable)e -> {
            Date dateDebut = null;
            Date dateFin = null;
            String delegation = this.delegationsBox.getValue() == null ? null : ((String)this.delegationsBox.getValue()).toString();
            String centre = this.centresBox.getValue() == null ? null : ((String)this.centresBox.getValue()).toString();
            dateDebut = Date.from(((LocalDate)this.dateDebutHistorique.getValue()).atStartOfDay(ZoneId.systemDefault()).toInstant());
            SimpleDateFormat sdfDate = new SimpleDateFormat("dd/MM/yyyy");
            dateFin = ((String)this.rbChoixDate.getValue()).equals("Intervalle de dates") ? Date.from(((LocalDate)this.dateFinHistorique.getValue()).atStartOfDay(ZoneId.systemDefault()).toInstant()) : new Date(dateDebut.getTime() + 86400000L);
            Timestamp dateDebutValue = new Timestamp(dateDebut.getTime());
            Timestamp dateFinValue = new Timestamp(dateFin.getTime());
            List synthesePatrouilleBean = this.historiqueSchemaRoutierService.getStatistiqueSchemaRoutierHistorique(dateDebutValue, dateFinValue, 0, delegation, centre);
            SynthesePatrouillesBean synthese = new SynthesePatrouillesBean();
            synthese.setDateDebut(sdfDate.format(dateDebut));
            if (dateFin != null) {
                synthese.setDateFin(sdfDate.format(dateFin));
            } else {
                synthese.setDateFin("-");
            }
            if (this.delegationsBox.getValue() != null) {
                synthese.setArrondissement(((String)this.delegationsBox.getValue()).toString());
            } else {
                synthese.setArrondissement("Tous");
            }
            if (this.centresBox.getValue() != null) {
                synthese.setCerd(((String)this.centresBox.getValue()).toString());
            } else {
                synthese.setCerd("Tous");
            }
            this.updateTable(synthesePatrouilleBean);
            this.setURLWMS((String)configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "carto.mci.url").get(), (String)configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "carto.schema_routier.historique.map").get(), (String)configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "carto.schema_routier.historique.layers").get(), "PNG", true, (String)configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "carto.schema_routier.historique.projection").get(), delegation, centre, sdfDate.format(dateDebut), sdfDate.format(dateFin), (String)configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "carto.schema_routier.historique.buffer").get());
        });
        this.hlButtons.add(new Component[]{btAppliquer});
        this.hlCombo.add(new Component[]{this.hlButtons});
        this.hlCombo.setVerticalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{this.hlButtons});
        this.add(new Component[]{this.hlCombo});
        this.cartoPane = clusterCartoPaneFactory.newClusterCartoPane(Integer.valueOf(this.historiqueSchemaRoutierService.getCodeModuleMetier()));
        this.tronconFauchageLayer = prismLayerFactory.createTronconVhLayer(this.historiqueSchemaRoutierService.getCodeModuleMetier());
        if (this.tronconFauchageLayer != null) {
            this.tronconFauchageLayer.addTo(this.cartoPane, "Barreaux Fauchage");
        }
        this.cartoPane.addCartoLayer();
        prismLayerFactory.tryCreateCartoLayerSupp(this.historiqueSchemaRoutierService.getCodeModuleMetier()).ifPresent(cartoLayers -> cartoLayers.forEach((layerName, layer) -> layer.addTo(this.cartoPane, layerName)));
        this.maxBounds = LeafletUtils.getMaxBounds((ConfigurationService)configurationService);
        if (this.cartoPane != null) {
            ScaleControl scaleControl = new ScaleControl();
            scaleControl.setMaxWidth(100);
            scaleControl.setPosition(LeafletControl.ControlPosition.bottomleft);
            scaleControl.addTo(this.cartoPane.getMap());
            this.cartoPane.setSizeFull();
            this.cartoPane.setWidthFull();
            this.cartoPane.setHeightFull();
            this.cartoPane.setHeight(95.0f, Unit.PERCENTAGE);
            this.cartoPane.setWidth(100.0f, Unit.PERCENTAGE);
            VerticalLayout layoutCarto = new VerticalLayout();
            layoutCarto.setMinWidth(500.0f, Unit.PIXELS);
            layoutCarto.setMinHeight(500.0f, Unit.PIXELS);
            ICartoPane iCartoPane = this.cartoPane;
            if (!(iCartoPane instanceof Component)) {
                throw new IllegalStateException("CartoPane should extends Component but %s does not".formatted(this.cartoPane.getClass().getSimpleName()));
            }
            Component cartoPaneComponent = (Component)iCartoPane;
            layoutCarto.setSizeFull();
            layoutCarto.add(new Component[]{cartoPaneComponent});
            this.add(new Component[]{layoutCarto});
            this.setAlignItems(FlexComponent.Alignment.CENTER);
            this.setSizeFull();
            this.addClassNames(new String[]{"p-m", "box-border"});
        }
    }

    protected void visualisationHistorique() {
        Date dateDebut = Date.from(((LocalDate)this.dateDebutHistorique.getValue()).atStartOfDay(ZoneId.systemDefault()).toInstant());
        Date dateFin = null;
        dateFin = this.dateFinHistorique.getValue() == null ? new Date(dateDebut.getTime() + 86400000L) : Date.from(((LocalDate)this.dateFinHistorique.getValue()).atStartOfDay(ZoneId.systemDefault()).toInstant());
        this.labelHistorique.setText(this.getTranslation("fauchage.historique.date_recherche", new Object[0]) + new SimpleDateFormat("dd/MM/yyyy HH:mm").format(dateDebut) + " - " + new SimpleDateFormat("dd/MM/yyyy HH:mm").format(dateFin));
    }

    private void updateCarto(List<TronconSuivi> barreaux) {
        Set troncon = barreaux.stream().map(b -> {
            TronconSuivi suivi = new TronconSuivi();
            suivi.setCode("FA");
            suivi.setX(b.getX());
            suivi.setY(b.getY());
            return suivi;
        }).collect(Collectors.toSet());
        this.tronconFauchageLayer.clearLayer();
        this.tronconFauchageLayer.setTronconsSuivis(troncon);
        LatLngBounds boundsLayer = this.tronconFauchageLayer.getLayerBounds();
        this.cartoPane.getMap().flyToBounds(boundsLayer);
    }

    public int getActionId() {
        return 30010;
    }

    public String getPath() {
        return this.getTranslation("vh.title", new Object[0]) + " > " + this.getTranslation("vh.historiqueTronconVH.title", new Object[0]);
    }

    public String getPageTitle() {
        return "";
    }

    public void setURLWMS(String urlCarto, String mapfile, String layers, String formatImage, boolean noCache, String srs, String delegation, String centre, String dateMin, String dateMax, String bufferSize) {
        LayerGroup wmsGroupLayer = (LayerGroup)this.layersWMS.get(layers);
        if (wmsGroupLayer == null) {
            wmsGroupLayer = new LayerGroup(new Layer[0]);
            this.layersWMS.put(layers, wmsGroupLayer);
            this.cartoPane.addLayer((Layer)wmsGroupLayer);
            this.cartoPane.addOverlayLayer((Layer)wmsGroupLayer, layers);
        } else {
            wmsGroupLayer.clearLayers();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("FORMAT", formatImage);
        params.put("TRANSPARENT", "true");
        params.put("MAP", mapfile);
        params.put("TIMESTAMP", "" + System.currentTimeMillis());
        params.put("SRS", srs);
        if (delegation != null) {
            params.put("delegation", delegation);
        }
        if (centre != null) {
            params.put("centre", centre);
        }
        params.put("date_debut", dateMin);
        params.put("date_fin", dateMax);
        params.put("buffer", bufferSize);
        params.put("LAYERS", layers);
        TileLayer tileLayer = new TileLayer(WMSController.Helper.createWMSLayerURL((String)urlCarto, (String)layers, (String)this.configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "carto.formatImage").orElse(null), params));
        wmsGroupLayer.addLayer((Layer)tileLayer);
    }

    private void updateTable(List<SyntheseTableauBordStatistiqueSchemaRoutierBean> synthese) {
        if (this.table != null) {
            this.remove(new Component[]{this.table});
        }
        this.table = new Grid();
        this.table.setWidth(100.0f, Unit.PERCENTAGE);
        this.table.setHeight(800.0f, Unit.PIXELS);
        this.table.addColumn(SyntheseTableauBordStatistiqueSchemaRoutierBean::getDelegation).setHeader(this.getTranslation("schema_routier.historique.delegation", new Object[0])).setVisible(true);
        this.table.addColumn(SyntheseTableauBordStatistiqueSchemaRoutierBean::getCentre).setHeader(this.getTranslation("schema_routier.historique.centre", new Object[0])).setVisible(true);
        this.table.addColumn(SyntheseTableauBordStatistiqueSchemaRoutierBean::getNomTroncon).setHeader(this.getTranslation("schema_routier.historique.axe", new Object[0])).setVisible(true);
        this.table.addColumn((ValueProvider & Serializable)stssb -> stssb.getPrAbsDebut() + " - " + stssb.getPrAbsFin()).setHeader(this.getTranslation("schema_routier.historique.PLO", new Object[0])).setVisible(true);
        this.table.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)stbs -> {
            Accordion acc = new Accordion();
            VerticalLayout v = new VerticalLayout();
            Timestamp[] datesPassage = (Timestamp[])stbs.getParametres((Object)"dates");
            Integer[] pourcentages = (Integer[])stbs.getParametres((Object)"pourcentages");
            TreeMap<Timestamp, Integer> orderPassages = new TreeMap<Timestamp, Integer>();
            for (int i = 0; i < datesPassage.length; ++i) {
                orderPassages.put(datesPassage[i], pourcentages[i]);
            }
            for (Map.Entry entry : orderPassages.entrySet()) {
                HorizontalLayout horizontalLayout = new HorizontalLayout();
                horizontalLayout.setWidth(100.0f, Unit.PERCENTAGE);
                horizontalLayout.setAlignItems(FlexComponent.Alignment.END);
                NativeLabel nativeLabelDates = new NativeLabel();
                SimpleDateFormat sdfDate = new SimpleDateFormat("dd/MM/yyyy");
                nativeLabelDates.setText(sdfDate.format((Date)entry.getKey()));
                nativeLabelDates.setSizeFull();
                horizontalLayout.add(new Component[]{nativeLabelDates});
                NativeLabel nativeLabelPourcentages = new NativeLabel();
                nativeLabelPourcentages.setText(String.valueOf(entry.getValue()));
                nativeLabelPourcentages.setSizeFull();
                horizontalLayout.add(new Component[]{nativeLabelPourcentages});
                v.add(new Component[]{horizontalLayout});
            }
            acc.add(String.valueOf(datesPassage.length), (Component)v);
            acc.close();
            return acc;
        })).setHeader(this.getTranslation("schema_routier.historique.dates_pourcentages", new Object[0])).setFlexGrow(0).setAutoWidth(true);
        this.table.setItems(synthese);
        this.add(new Component[]{this.table});
        this.setHeight(1200.0f, Unit.PIXELS);
    }

    private static Renderer<SyntheseTableauBordStatistiqueSchemaRoutierBean> createToggleDetailsRenderer(Grid<SyntheseTableauBordStatistiqueSchemaRoutierBean> grid) {
        return LitRenderer.of((String)"    <vaadin-button\n        theme=\"tertiary icon\"\n        aria-label=\"Toggle details\"\n        aria-expanded=\"${model.detailsOpened ? 'true' : 'false'}\"\n        @click=\"${handleClick}\"\n    >\n        <vaadin-icon\n        .icon=\"${model.detailsOpened ? 'lumo:angle-down' : 'lumo:angle-right'}\"\n        ></vaadin-icon>\n    </vaadin-button>\n").withFunction("handleClick", (SerializableConsumer & Serializable)bean -> grid.setDetailsVisible(bean, !grid.isDetailsVisible(bean)));
    }

    private static ComponentRenderer<BeanDetailsFormLayout, SyntheseTableauBordStatistiqueSchemaRoutierBean> createDetailsRenderer() {
        return new ComponentRenderer(BeanDetailsFormLayout::new, BeanDetailsFormLayout::setBean);
    }

    private void updateTableSynthesePatrouilleBean(List<SynthesePatrouilleBean> synthesePatrouilleBean) {
        if (this.table2 != null) {
            this.remove(new Component[]{this.table2});
        }
        this.table2 = new Grid();
        this.table2.setWidth(100.0f, Unit.PERCENTAGE);
        this.table2.setHeight(800.0f, Unit.PIXELS);
        this.table2.addColumn(SynthesePatrouilleBean::getDateDebut).setHeader(this.getTranslation("rapport.synthese.date_debut", new Object[0])).setVisible(true);
        this.table2.addColumn(SynthesePatrouilleBean::getDateFin).setHeader(this.getTranslation("rapport.synthese.date_fin", new Object[0])).setVisible(true);
        this.table2.addColumn(SynthesePatrouilleBean::getPatrouilleur).setHeader(this.getTranslation("rapport.synthese.patrouilleur", new Object[0])).setVisible(true);
        this.table2.addColumn(SynthesePatrouilleBean::getLongueurPatrouille).setHeader(this.getTranslation("rapport.synthese.longueur_totale", new Object[0])).setVisible(true);
        this.table2.addComponentColumn((ValueProvider & Serializable)spb -> {
            VerticalLayout v = new VerticalLayout();
            Map detailsRoute = spb.getLongueurStatus();
            for (String route : detailsRoute.keySet()) {
                NativeLabel nativeLabel = new NativeLabel();
                nativeLabel.setText(route + ": " + detailsRoute.get(route) + "m");
                v.add(new Component[]{nativeLabel});
            }
            return v;
        }).setHeader(this.getTranslation("rapport.synthese.details_route", new Object[0])).setVisible(true);
        this.table2.setItems(synthesePatrouilleBean);
        this.add(new Component[]{this.table2});
        this.setHeight(1200.0f, Unit.PIXELS);
    }
}

