/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.stats.schema_routier;

import com.geolocsystems.prismandroid.model.Troncon;
import com.geolocsystems.prismbirtbean.SyntheseTableauBordStatistiqueSchemaRoutierBean;
import com.neogls.prism.central.vaadin.service.stats.schemaroutier.SchemaRoutierService;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridVariant;
import com.vaadin.flow.component.html.NativeLabel;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.data.renderer.LitRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.selection.SelectionListener;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vaadin.addons.componentfactory.leaflet.LeafletMap;
import org.vaadin.addons.componentfactory.leaflet.types.LatLng;

/*
 * Exception performing whole class analysis ignored.
 */
@CssImport(themeFor="vaadin-grid", value="themes/prism-theme/grid-stats.css")
public class SchemaRoutierViewer
extends Composite<VerticalLayout>
implements HasSize {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SchemaRoutierViewer.class);
    private final SchemaRoutierService schemaRoutierService;
    private Grid<SyntheseTableauBordStatistiqueSchemaRoutierBean> grid;
    private LeafletMap map;

    public SchemaRoutierViewer(List<SyntheseTableauBordStatistiqueSchemaRoutierBean> syntheseSchemaRoutier, SchemaRoutierService schemaRoutierService) {
        this.schemaRoutierService = schemaRoutierService;
        this.createTable();
        if (syntheseSchemaRoutier != null) {
            this.grid.setItems(syntheseSchemaRoutier);
        }
        VerticalLayout layout = (VerticalLayout)this.getContent();
        layout.add(new Component[]{this.grid});
        layout.setPadding(false);
        layout.setAlignItems(FlexComponent.Alignment.CENTER);
    }

    private void createTable() {
        this.grid = new Grid();
        this.grid.addColumn(SyntheseTableauBordStatistiqueSchemaRoutierBean::getIdTroncon).setHeader("ID").setSortable(true).setAutoWidth(true);
        this.grid.addComponentColumn((ValueProvider & Serializable)b -> {
            VerticalLayout v = new VerticalLayout();
            if (b.getDelegation() != null) {
                NativeLabel nativeLabelDelegation = new NativeLabel();
                nativeLabelDelegation.setText(b.getDelegation());
                v.add(new Component[]{nativeLabelDelegation});
            }
            if (b.getCentre() != null) {
                NativeLabel nativeLabelCentre = new NativeLabel();
                nativeLabelCentre.setText(b.getCentre());
                v.add(new Component[]{nativeLabelCentre});
            }
            return v;
        }).setHeader("D\u00e9l\u00e9gation/Centre").setSortable(true).setComparator((o1, o2) -> {
            if (o1.getDelegation() == null || o1.getDelegation().equals(o2.getDelegation())) {
                if (o1.getCentre() != null) {
                    if (o2.getCentre() != null) {
                        return o1.getCentre().compareTo(o2.getCentre());
                    }
                    return 0;
                }
                return 0;
            }
            return o1.getDelegation().compareTo(o2.getDelegation());
        }).setAutoWidth(true);
        this.grid.addColumn(SyntheseTableauBordStatistiqueSchemaRoutierBean::getNomCircuit).setHeader("Circuit").setSortable(true).setAutoWidth(true);
        this.grid.addColumn(SchemaRoutierViewer.createAxePrRenderer()).setHeader("Axe").setSortable(true).setComparator((o1, o2) -> {
            if (o1.getNomTroncon() == null || o1.getNomTroncon().equals(o2.getNomTroncon())) {
                if (o1.getPrAbsDebut() != null) {
                    return o1.getPrAbsDebut().compareTo(o2.getPrAbsDebut());
                }
                return 0;
            }
            return o1.getNomTroncon().compareTo(o2.getNomTroncon());
        }).setAutoWidth(true);
        this.grid.addColumn(SyntheseTableauBordStatistiqueSchemaRoutierBean::getNiveauExploitation).setHeader("Niv. Exploitation").setSortable(true).setAutoWidth(true);
        this.grid.addColumn((ValueProvider & Serializable)b -> b.getPourcentage() + "%").setClassNameGenerator((SerializableFunction & Serializable)b -> {
            if (b.getPourcentage() >= 95) {
                return "green";
            }
            if (b.getPourcentage() >= 90 && b.getPourcentage() < 95) {
                return "yellow";
            }
            if (b.getPourcentage() >= 75 && b.getPourcentage() < 90) {
                return "orange";
            }
            return "red";
        }).setHeader("Pourcentage").setSortable(true).setAutoWidth(true);
        this.grid.addColumn((ValueProvider & Serializable)e -> {
            if (e.getDateDernierPassage() != null) {
                return new SimpleDateFormat("dd-MM-yyyy HH:mm:ss").format(e.getDateDernierPassage());
            }
            return null;
        }).setHeader("Dernier passage").setAutoWidth(true);
        this.grid.addColumn((ValueProvider & Serializable)e -> new SimpleDateFormat("dd-MM-yyyy HH:mm:ss").format(e.getDateMaj())).setHeader("Date g\u00e9n\u00e9ration").setAutoWidth(true);
        this.grid.setMultiSort(true, Grid.MultiSortPriority.APPEND);
        this.grid.setSelectionMode(Grid.SelectionMode.SINGLE);
        this.grid.addThemeVariants(new GridVariant[]{GridVariant.LUMO_ROW_STRIPES, GridVariant.LUMO_COMPACT, GridVariant.LUMO_WRAP_CELL_CONTENT});
        this.grid.addClassName("text-xs");
        this.grid.recalculateColumnWidths();
        this.grid.addSelectionListener((SelectionListener & Serializable)event -> {
            Optional item = event.getFirstSelectedItem();
            if (item.isPresent()) {
                Troncon tronconSelected = this.schemaRoutierService.getSchemaRoutierTroncons(Integer.parseInt(((SyntheseTableauBordStatistiqueSchemaRoutierBean)item.get()).getIdTroncon()));
                LatLng latlng = new LatLng((double)tronconSelected.getPointDebut().getY(), (double)tronconSelected.getPointDebut().getX());
                this.map.flyTo(latlng, 12);
            }
        });
    }

    private static Renderer<SyntheseTableauBordStatistiqueSchemaRoutierBean> createAxePrRenderer() {
        return LitRenderer.of((String)"<vaadin-vertical-layout style=\"line-height: var(--lumo-line-height-m);\">  <span>${item.axe}</span>  <span style=\"font-size: var(--lumo-font-size-s); color: var(--lumo-secondary-text-color);\">${item.prd} \u00e0 ${item.prf}</span></vaadin-vertical-layout>").withProperty("axe", SyntheseTableauBordStatistiqueSchemaRoutierBean::getNomTroncon).withProperty("prd", SyntheseTableauBordStatistiqueSchemaRoutierBean::getPrAbsDebut).withProperty("prf", SyntheseTableauBordStatistiqueSchemaRoutierBean::getPrAbsFin);
    }

    public void updateViewer(List<SyntheseTableauBordStatistiqueSchemaRoutierBean> syntheseSchemaRoutier) {
        if (syntheseSchemaRoutier != null && syntheseSchemaRoutier.size() > 0) {
            this.grid.setPageSize(syntheseSchemaRoutier.size());
            this.grid.setItems(syntheseSchemaRoutier);
        }
    }

    public void setMap(LeafletMap map) {
        this.map = map;
    }
}

