/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.stats.schema_routier;

import com.geolocsystems.prismbirtbean.SyntheseTableauBordStatistiqueSchemaRoutierBean;
import com.neogls.prism.central.vaadin.layout.PrismLayout;
import com.neogls.prism.central.vaadin.rest.WMSController;
import com.neogls.prism.central.vaadin.service.ConfigurationService;
import com.neogls.prism.central.vaadin.service.stats.schemaroutier.SchemaRoutierService;
import com.neogls.prism.central.vaadin.util.LeafletUtils;
import com.neogls.prism.central.vaadin.view.mct.common.CommonMct;
import com.neogls.prism.central.vaadin.view.mct.common.ICartoPane;
import com.neogls.prism.central.vaadin.view.mct.common.LeftSidePane;
import com.neogls.prism.central.vaadin.view.mct.common.bottomsidepane.BottomSidePane;
import com.neogls.prism.central.vaadin.view.mct.common.carto.SuiviStyleService;
import com.neogls.prism.central.vaadin.view.mct.common.carto.cluster.ClusterCartoPaneFactory;
import com.neogls.prism.central.vaadin.view.mct.common.carto.layer.SchemaRoutierTronconLayer;
import com.neogls.prism.central.vaadin.view.stats.schema_routier.SchemaRoutierSearchForm;
import com.neogls.prism.central.vaadin.view.stats.schema_routier.SchemaRoutierViewer;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.details.Details;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.orderedlayout.Scroller;
import com.vaadin.flow.router.HasDynamicTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.vaadin.addons.componentfactory.leaflet.layer.Layer;
import org.vaadin.addons.componentfactory.leaflet.layer.groups.LayerGroup;
import org.vaadin.addons.componentfactory.leaflet.layer.raster.TileLayer;
import org.vaadin.addons.componentfactory.leaflet.types.LatLngBounds;

@RolesAllowed(value={"ACTION_STATS_SCHEMA_ROUTIER"})
@Route(value="/schema-routier-search", layout=PrismLayout.class)
public class SchemaRoutierSearchView
extends CommonMct
implements HasDynamicTitle {
    private final SchemaRoutierViewer viewer;
    private final SchemaRoutierService schemaRoutierService;
    private final ConfigurationService configurationService;
    private final SuiviStyleService suiviStyleService;
    private final Details panelSearch;
    private List<SyntheseTableauBordStatistiqueSchemaRoutierBean> syntheseSchemaRoutier;
    private final LatLngBounds maxBounds;
    private final LeftSidePane leftSidePane;
    private final ICartoPane cartoPane;
    private final BottomSidePane bottomSidePane;
    private Map<String, LayerGroup> layersWMS;
    private SchemaRoutierTronconLayer layerSchemaRoutier;

    public SchemaRoutierSearchView(ConfigurationService configurationService, SuiviStyleService suiviStyleService, SchemaRoutierService schemaRoutierService, ClusterCartoPaneFactory clusterCartoPaneFactory) {
        super(configurationService);
        this.schemaRoutierService = schemaRoutierService;
        this.configurationService = configurationService;
        this.suiviStyleService = suiviStyleService;
        this.leftSidePane = new LeftSidePane();
        this.cartoPane = clusterCartoPaneFactory.newClusterCartoPane(Integer.valueOf(0));
        this.bottomSidePane = BottomSidePane.create();
        SchemaRoutierSearchForm form = new SchemaRoutierSearchForm(schemaRoutierService, null);
        form.setWidth(52.0f, Unit.EM);
        form.addClassName("mx-auto");
        this.maxBounds = LeafletUtils.getMaxBounds((ConfigurationService)configurationService);
        this.viewer = new SchemaRoutierViewer(this.syntheseSchemaRoutier, schemaRoutierService);
        this.viewer.setSizeFull();
        this.viewer.setMap(this.cartoPane.getMap());
        this.panelSearch = new Details("Crit\u00e8res de recherche", (Component)form);
        this.panelSearch.setOpened(true);
        Scroller scroller = new Scroller();
        scroller.setScrollDirection(Scroller.ScrollDirection.VERTICAL);
        this.leftSidePane.add(new Component[]{this.panelSearch});
        this.leftSidePane.add(new Component[]{this.viewer});
        form.addFormValidatedListener(arg_0 -> this.onFormValidated(arg_0));
        this.layersWMS = new HashMap();
    }

    private void onFormValidated(SchemaRoutierSearchForm.FormValidatedEvent event) {
        List synthseseList;
        Notification notification = Notification.show((String)"Recherche en cours...");
        this.syntheseSchemaRoutier = synthseseList = this.schemaRoutierService.getSyntheseSchemaRoutier(event.getSearchData());
        this.viewer.updateViewer(this.syntheseSchemaRoutier);
        this.panelSearch.setOpened(false);
        boolean tronconPreCalcules = true;
        if (this.layerSchemaRoutier == null) {
            this.layerSchemaRoutier = new SchemaRoutierTronconLayer(this.suiviStyleService);
            this.cartoPane.addLayer((Layer)this.layerSchemaRoutier.getLayer());
            this.cartoPane.addOverlayLayer((Layer)this.layerSchemaRoutier.getLayer(), "sections non patoruill\u00e9es");
        } else {
            this.layerSchemaRoutier.getLayer().clearLayers();
        }
        this.layerSchemaRoutier.showStatistiqueCircuit(synthseseList, tronconPreCalcules);
        ArrayList niveauxExploitation = new ArrayList();
        this.setURLWMS((String)this.configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "carto.mci.url").get(), (String)this.configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "carto.mci.map").get(), (String)this.configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "carto.statistique.schema_routier.layers.troncon").get(), "PNG", true, (String)this.configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "carto.statistique.circuit.projection").get(), niveauxExploitation, "", "", (String)this.configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "carto.statistique.circuit.buffer.size").get(), synthseseList);
        this.setURLWMS((String)this.configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "carto.mci.url").get(), (String)this.configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "carto.mci.map").get(), "schema_routier_pourcentage", "PNG", true, (String)this.configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "carto.statistique.circuit.projection").get(), niveauxExploitation, "", "", (String)this.configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "carto.statistique.circuit.buffer.size").get(), synthseseList);
        notification.close();
    }

    public String getPageTitle() {
        return this.getTranslation("stats.schema_routier.title", new Object[0]);
    }

    public void setURLWMS(String urlCarto, String mapfile, String layers, String formatImage, boolean noCache, String srs, List<String> niveaux, String dateMin, String dateMax, String bufferSize, List<SyntheseTableauBordStatistiqueSchemaRoutierBean> syntheseTableauBordStatistiqueSchemaRoutier) {
        LayerGroup wmsGroupLayer = (LayerGroup)this.layersWMS.get(layers);
        if (wmsGroupLayer == null) {
            wmsGroupLayer = new LayerGroup(new Layer[0]);
            this.layersWMS.put(layers, wmsGroupLayer);
            this.cartoPane.addLayer((Layer)wmsGroupLayer);
            this.cartoPane.addOverlayLayer((Layer)wmsGroupLayer, layers);
        } else {
            wmsGroupLayer.clearLayers();
        }
        int i = 0;
        while (i < syntheseTableauBordStatistiqueSchemaRoutier.size()) {
            Object tronconID = "";
            int j = i;
            while (i < syntheseTableauBordStatistiqueSchemaRoutier.size() && ((String)tronconID).length() <= 1250) {
                tronconID = (String)tronconID + (((String)tronconID).equals("") ? "" : ",") + "'" + syntheseTableauBordStatistiqueSchemaRoutier.get(i).getIdTroncon() + "'";
                ++i;
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("LAYERS", layers);
            params.put("FORMAT", formatImage);
            params.put("TRANSPARENT", "true");
            params.put("MAP", mapfile);
            params.put("TIMESTAMP", "" + System.currentTimeMillis());
            params.put("SRS", srs);
            Object niveauxExploitation = "";
            for (String niveau : niveaux) {
                niveauxExploitation = (String)niveauxExploitation + (((String)niveauxExploitation).equals("") ? "" : ",") + "'" + niveau + "'";
            }
            params.put("niveauxExploitation", niveauxExploitation);
            params.put("date_debut", dateMin);
            params.put("date_fin", dateMax);
            params.put("buffer", bufferSize);
            params.put("troncon_id", tronconID);
            TileLayer tileLayer = new TileLayer(WMSController.Helper.createWMSLayerURL((String)urlCarto, (String)layers, (String)this.configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "carto.formatImage").orElse(null), params));
            wmsGroupLayer.addLayer((Layer)tileLayer);
        }
    }

    protected void init() {
        this.leftSidePane.setMinWidth(70.0f, Unit.PERCENTAGE);
    }

    protected CompletableFuture<Void> refresh() {
        return CompletableFuture.completedFuture(null);
    }

    public LeftSidePane getLeftSidePane() {
        return this.leftSidePane;
    }

    protected ICartoPane getCartoPane() {
        return this.cartoPane;
    }

    protected BottomSidePane getBottomSidePane() {
        return this.bottomSidePane;
    }
}

