/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.stats.schema_routier;

import com.geolocsystems.prismcentral.beans.PrismCentralUser;
import com.neogls.prism.central.vaadin.common.component.delegationandcenterfield.DelegationAndCenter;
import com.neogls.prism.central.vaadin.common.component.delegationandcenterfield.DelegationAndCenterField;
import com.neogls.prism.central.vaadin.common.component.delegationandcenterfield.DelegationAndCenterFieldThemeVariant;
import com.neogls.prism.central.vaadin.service.stats.schemaroutier.SchemaRoutierSearchData;
import com.neogls.prism.central.vaadin.service.stats.schemaroutier.SchemaRoutierService;
import com.neogls.prism.central.vaadin.util.vaadin.DatePickerI18nUtils;
import com.neogls.prism.central.vaadin.view.stats.schema_routier.SchemaRoutierSearchForm;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.checkbox.CheckboxGroup;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.converter.Converter;
import com.vaadin.flow.data.converter.LocalDateToDateConverter;
import jakarta.annotation.Nullable;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class SchemaRoutierSearchForm
extends FormLayout {
    private static final String DERNIERE_DATE_DE_PASSAGE_DANS_LA_FREQUENCE = "Derni\u00e8re date de passage dans la fr\u00e9quence";
    private static final String DERNIERE_DATE_DE_PASSAGE_CONNUE = "Derni\u00e8re date de passage connue";
    private final DelegationAndCenterField delegationAndCenterField;
    private ComboBox<String> cbAxe;
    private RadioButtonGroup<String> rbChoixDateCalcul;
    private DatePicker datePickerAutreDate;
    private String pregeneration;
    private Date datePregeneration;
    private Button exportCSV;
    private ComboBox<String> cbChoixDateDernierePassage;
    private CheckboxGroup<String> cbgNiveauExploitations;
    private final Binder<SchemaRoutierSearchData> binder = new Binder();
    private final SchemaRoutierService service;

    public SchemaRoutierSearchForm(SchemaRoutierService service, @Nullable SchemaRoutierSearchData searchData) {
        this.service = service;
        Button bOk = new Button(this.getTranslation("logBook.ok", new Object[0]), arg_0 -> this.onOkButtonClick(arg_0));
        this.delegationAndCenterField = new DelegationAndCenterField((Collection)service.getDelegationsActives());
        this.initFields();
        this.initBinder();
        this.add(new Component[]{this.delegationAndCenterField});
        this.add(new Component[]{this.cbAxe});
        this.add(new Component[]{this.cbgNiveauExploitations});
        VerticalLayout layout = new VerticalLayout();
        layout.add(new Component[]{this.datePickerAutreDate});
        this.add(new Component[]{layout});
        this.addFormItem((Component)new Div(new Component[]{bOk}), (String)null);
        this.setColspan((Component)this.delegationAndCenterField, 2);
        bOk.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
        this.setResponsiveSteps(new FormLayout.ResponsiveStep[]{new FormLayout.ResponsiveStep("0", 2, FormLayout.ResponsiveStep.LabelsPosition.TOP)});
        this.getStyle().set("--vaadin-form-layout-column-spacing", "var(--lumo-space-s)").set("--vaadin-form-item-row-spacing", "0").set("--vaadin-form-item-label-spacing", "0");
        if (searchData == null) {
            searchData = new SchemaRoutierSearchData();
            searchData.setSelectionLastDate(Boolean.valueOf(false));
            searchData.setModeCalcul(this.pregeneration != null ? this.pregeneration : "Maintenant");
            List<String> vals = service.getNiveauxExploitation().stream().filter(s -> s != null).toList();
            searchData.setNiveauExploitation(vals.stream().collect(Collectors.toUnmodifiableSet()));
        }
        this.binder.readBean((Object)searchData);
    }

    private void initFields() {
        this.delegationAndCenterField.setDelegationPlaceholder(this.getTranslation("mct.filtre.delegation.toutes", new Object[0]));
        this.delegationAndCenterField.setCenterPlaceholder(this.getTranslation("mct.filtre.centre.tous", new Object[0]));
        this.delegationAndCenterField.addThemeVariants((ThemeVariant[])new DelegationAndCenterFieldThemeVariant[]{DelegationAndCenterFieldThemeVariant.HORIZONTAL});
        this.cbAxe = new ComboBox(this.getTranslation("global.axe", new Object[0]));
        this.cbAxe.setPlaceholder(this.getTranslation("logBook.axe.tous", new Object[0]));
        this.cbAxe.setClearButtonVisible(true);
        this.cbAxe.setItems((Collection)this.service.getAxes());
        List<String> vals = this.service.getNiveauxExploitation().stream().filter(s -> s != null).toList();
        this.cbgNiveauExploitations = new CheckboxGroup();
        this.cbgNiveauExploitations.setLabel(this.getTranslation("report.stats.niveau_exploitation", new Object[0]));
        this.cbgNiveauExploitations.setItems(vals);
        this.cbgNiveauExploitations.setValue(vals.stream().collect(Collectors.toUnmodifiableSet()));
        this.cbChoixDateDernierePassage = new ComboBox(this.getTranslation("fauchage.stats.date_dernier_passage", new Object[0]));
        this.cbChoixDateDernierePassage.setItems((Object[])new String[]{DERNIERE_DATE_DE_PASSAGE_DANS_LA_FREQUENCE, DERNIERE_DATE_DE_PASSAGE_CONNUE});
        this.cbChoixDateDernierePassage.setValue((Object)DERNIERE_DATE_DE_PASSAGE_DANS_LA_FREQUENCE);
        SimpleDateFormat formatter = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        this.datePregeneration = this.service.getDateGenerationStatSchemaRoutier();
        if (this.datePregeneration != null) {
            this.pregeneration = "Pr\u00e9calcul - " + formatter.format(this.datePregeneration);
        }
        this.rbChoixDateCalcul = new RadioButtonGroup();
        this.rbChoixDateCalcul.setLabel(this.getTranslation("report.stats.mode_calcul", new Object[0]));
        if (this.pregeneration != null) {
            modeOptions = new String[]{this.pregeneration, "Maintenant", "Autre"};
            this.rbChoixDateCalcul.setItems(modeOptions);
            this.rbChoixDateCalcul.setValue((Object)this.pregeneration);
        } else {
            modeOptions = new String[]{"Maintenant", "Autre"};
            this.rbChoixDateCalcul.setItems(modeOptions);
            this.rbChoixDateCalcul.setValue((Object)"Maintenant");
        }
        this.datePickerAutreDate = new DatePicker(this.getTranslation("report.stats.date_calcul", new Object[0]));
        this.datePickerAutreDate.setI18n(DatePickerI18nUtils.getDatePickerI18n());
        this.datePickerAutreDate.setVisible(true);
        this.datePickerAutreDate.setValue(LocalDate.now());
        DateTimeFormatter formatterDate = DateTimeFormatter.ofPattern("dd-MM-yyyy");
        this.datePickerAutreDate.setPlaceholder(LocalDate.now().format(formatterDate));
    }

    private boolean filterDelegation(PrismCentralUser user) {
        return this.delegationAndCenterField.isEmpty() || ((DelegationAndCenter)this.delegationAndCenterField.getValue()).getDelegation() == null || ((DelegationAndCenter)this.delegationAndCenterField.getValue()).getDelegation().equals(user.getDelegation());
    }

    private boolean filterCentre(PrismCentralUser user) {
        return this.delegationAndCenterField.isEmpty() || ((DelegationAndCenter)this.delegationAndCenterField.getValue()).getCenter() == null || ((DelegationAndCenter)this.delegationAndCenterField.getValue()).getCenter().equals(user.getCentre());
    }

    private void initBinder() {
        this.binder.bind((HasValue)this.delegationAndCenterField, DelegationAndCenterField.createGetter(SchemaRoutierSearchData::getDelegation, SchemaRoutierSearchData::getCenter), DelegationAndCenterField.createSetter(SchemaRoutierSearchData::setDelegation, SchemaRoutierSearchData::setCenter));
        this.binder.bind((HasValue)this.cbAxe, SchemaRoutierSearchData::getAxe, SchemaRoutierSearchData::setAxe);
        this.binder.forField((HasValue)this.cbgNiveauExploitations).asRequired().bind(SchemaRoutierSearchData::getNiveauExploitation, SchemaRoutierSearchData::setNiveauExploitation);
        this.binder.forField((HasValue)this.rbChoixDateCalcul).asRequired().bind(SchemaRoutierSearchData::getModeCalcul, SchemaRoutierSearchData::setModeCalcul);
        this.binder.forField((HasValue)this.datePickerAutreDate).withConverter((Converter)new LocalDateToDateConverter(ZoneId.systemDefault())).bind(SchemaRoutierSearchData::getDateCalcul, SchemaRoutierSearchData::setDateCalcul);
        this.binder.forField((HasValue)this.cbChoixDateDernierePassage).withConverter((Converter)new MyConverter(this)).bind(SchemaRoutierSearchData::getSelectionLastDate, SchemaRoutierSearchData::setSelectionLastDate);
    }

    private void onOkButtonClick(ClickEvent<Button> event) {
        SchemaRoutierSearchData searchData = new SchemaRoutierSearchData();
        if (this.binder.writeBeanIfValid((Object)searchData)) {
            this.fireEvent((ComponentEvent)new FormValidatedEvent(this, event.isFromClient(), searchData));
        }
    }

    public void addFormValidatedListener(ComponentEventListener<FormValidatedEvent> listener) {
        this.addListener(FormValidatedEvent.class, listener);
    }
}

