/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.stats.rapport;

import com.geolocsystems.prismandroid.model.ModuleMetier;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.neogls.prism.central.vaadin.common.component.dateinterval.DateRangePicker;
import com.neogls.prism.central.vaadin.common.component.delegationandcenterfield.DelegationAndCenterField;
import com.neogls.prism.central.vaadin.common.component.delegationandcenterfield.DelegationAndCenterFieldThemeVariant;
import com.neogls.prism.central.vaadin.layout.PrismLayout;
import com.neogls.prism.central.vaadin.service.UserPermissionService;
import com.neogls.prism.central.vaadin.service.bean.DateRange;
import com.neogls.prism.central.vaadin.service.stats.RapportSynthesePatrouilleViseeSearchData;
import com.neogls.prism.central.vaadin.service.stats.RapportSynthesePatrouilleViseeService;
import com.neogls.prism.central.vaadin.view.stats.rapport.RapportSynthesePatrouilleViseeExportButton;
import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.router.Route;
import jakarta.annotation.Nullable;
import jakarta.annotation.security.RolesAllowed;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RolesAllowed(value={"ACTION_RAPPORT_SYNTHESE_PATROUILLE_VISEE"})
@Route(value="/stats/rapport/rapport-synthese-patrouille-visee", layout=PrismLayout.class)
public class RapportSynthesePatrouilleViseeView
extends VerticalLayout {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RapportSynthesePatrouilleViseeView.class);
    private final IBusinessService businessService;
    private final UserPermissionService userPermissionService;
    private final RapportSynthesePatrouilleViseeService rapportSynthesePatrouilleViseeService;
    private Span errorMessage = new Span();
    private FormLayout formLayout = new FormLayout();
    private final DateRangePicker dateRange = new DateRangePicker();
    private VerticalLayout conteneurLayout = new VerticalLayout();
    private DelegationAndCenterField delegationAndCenterField;
    private ComboBox<ModuleMetier> cbTypePatrouille = new ComboBox();
    private RapportSynthesePatrouilleViseeExportButton exporter;
    private final Binder<RapportSynthesePatrouilleViseeSearchData> binder = new Binder();
    private RapportSynthesePatrouilleViseeSearchData searchData;
    private Map<Integer, ModuleMetier> mapModulesMetiers = new HashMap();

    public RapportSynthesePatrouilleViseeView(IBusinessService businessService, UserPermissionService userPermissionService, RapportSynthesePatrouilleViseeService rapportSynthesePatrouilleViseeService, @Nullable RapportSynthesePatrouilleViseeSearchData searchData) {
        this.businessService = businessService;
        this.userPermissionService = userPermissionService;
        this.rapportSynthesePatrouilleViseeService = rapportSynthesePatrouilleViseeService;
        Map mapModulesMetiersTous = businessService.getModulesMetiers();
        String listeMM = businessService.getConfiguration().getString("report.synthese.patrouille.codeMM");
        if (listeMM == null) {
            listeMM = "0;1";
        }
        for (String codeMM : listeMM.split(";")) {
            this.mapModulesMetiers.put(Integer.valueOf(codeMM), (ModuleMetier)mapModulesMetiersTous.get(Integer.valueOf(codeMM)));
        }
        if (searchData == null) {
            searchData = new RapportSynthesePatrouilleViseeSearchData();
            searchData.setDateRange(new DateRange(LocalDate.now(), null));
            searchData.setModuleMetier((ModuleMetier)this.mapModulesMetiers.get(this.mapModulesMetiers.keySet().toArray()[0]));
        }
        this.initFields();
        this.initBinder();
        this.initButton();
        this.binder.readBean((Object)searchData);
        this.add(new Component[]{this.errorMessage});
        this.add(new Component[]{this.formLayout});
        this.add(new Component[]{this.conteneurLayout});
    }

    private void initFields() {
        this.dateRange.addValueChangeListener(arg_0 -> this.updateSearchData(arg_0));
        this.formLayout.addFormItem((Component)this.dateRange, this.getTranslation("logBook.journees", new Object[0]));
        this.delegationAndCenterField = new DelegationAndCenterField((Collection)this.businessService.getDelegationsActives(), arg_0 -> this.updateSearchData(arg_0));
        this.delegationAndCenterField.setDelegationPlaceholder(this.getTranslation("mct.filtre.delegation.toutes", new Object[0]));
        this.delegationAndCenterField.setCenterPlaceholder(this.getTranslation("mct.filtre.centre.tous", new Object[0]));
        this.delegationAndCenterField.addThemeVariants((ThemeVariant[])new DelegationAndCenterFieldThemeVariant[]{DelegationAndCenterFieldThemeVariant.HORIZONTAL});
        this.cbTypePatrouille = new ComboBox(this.getTranslation("rapport.type.patrouille", new Object[0]), arg_0 -> this.updateSearchData(arg_0));
        this.cbTypePatrouille.setItemLabelGenerator(ModuleMetier::getLibelle);
        this.cbTypePatrouille.setClearButtonVisible(false);
        this.cbTypePatrouille.setItems(this.mapModulesMetiers.values());
        this.formLayout.addFormItem((Component)this.cbTypePatrouille, this.getTranslation("rapport.type.patrouille", new Object[0]));
        this.formLayout.add(new Component[]{this.delegationAndCenterField});
    }

    private void initButton() {
        this.exporter = new RapportSynthesePatrouilleViseeExportButton(this.searchData, this.rapportSynthesePatrouilleViseeService.getExportFormats());
        this.updateSearchData(null);
        this.formLayout.add(new Component[]{this.exporter});
    }

    private boolean testErreur() {
        if (this.searchData.getDateRange().getBeginning() == null) {
            this.errorMessage.setText(this.getTranslation("rapport.date.debut.vide.error", new Object[0]));
            return true;
        }
        if (this.searchData.getDateRange().getEnd() != null && new Timestamp(GregorianCalendar.from(this.searchData.getDateRange().getEnd().atStartOfDay(ZoneId.systemDefault())).getTime().getTime()).before(new Timestamp(GregorianCalendar.from(this.searchData.getDateRange().getBeginning().atStartOfDay(ZoneId.systemDefault())).getTime().getTime()))) {
            this.errorMessage.setText(this.getTranslation("rapport.date.fin.error", new Object[0]));
            return true;
        }
        this.errorMessage.setText("");
        return false;
    }

    private void initBinder() {
        if (this.searchData == null) {
            this.searchData = new RapportSynthesePatrouilleViseeSearchData();
            this.searchData.setDateRange(new DateRange(LocalDate.now(), null));
        }
        this.binder.bind((HasValue)this.delegationAndCenterField, DelegationAndCenterField.createGetter(RapportSynthesePatrouilleViseeSearchData::getDelegation, RapportSynthesePatrouilleViseeSearchData::getCenter), DelegationAndCenterField.createSetter(RapportSynthesePatrouilleViseeSearchData::setDelegation, RapportSynthesePatrouilleViseeSearchData::setCenter));
        this.binder.bind((HasValue)this.cbTypePatrouille, RapportSynthesePatrouilleViseeSearchData::getModuleMetier, RapportSynthesePatrouilleViseeSearchData::setModuleMetier);
        this.binder.forField((HasValue)this.dateRange).asRequired().bind(RapportSynthesePatrouilleViseeSearchData::getDateRange, RapportSynthesePatrouilleViseeSearchData::setDateRange);
    }

    private <V> void updateSearchData(AbstractField.ComponentValueChangeEvent<?, V> event) {
        if (this.searchData != null) {
            if (this.binder.writeBeanIfValid((Object)this.searchData)) {
                this.testErreur();
            }
            if (this.exporter != null) {
                this.exporter.updateURL(this.searchData);
            }
        }
    }
}

