/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.stats.rapport;

import com.geolocsystems.prismcentral.beans.DebutFinIntervention;
import com.geolocsystems.prismcentral.beans.DebutFinInterventionString;
import com.geolocsystems.prismcentral.beans.InterventionAgentBean;
import com.geolocsystems.prismcentral.beans.PrismCentralUser;
import com.geolocsystems.prismcentral.beans.SyntheseInterventionAgentBean;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.neogls.prism.central.vaadin.common.component.Table;
import com.neogls.prism.central.vaadin.common.component.dateinterval.DateRangePicker;
import com.neogls.prism.central.vaadin.common.component.delegationandcenterfield.DelegationAndCenter;
import com.neogls.prism.central.vaadin.common.component.delegationandcenterfield.DelegationAndCenterField;
import com.neogls.prism.central.vaadin.common.component.delegationandcenterfield.DelegationAndCenterFieldThemeVariant;
import com.neogls.prism.central.vaadin.layout.PrismLayout;
import com.neogls.prism.central.vaadin.service.UserPermissionService;
import com.neogls.prism.central.vaadin.service.bean.DateRange;
import com.neogls.prism.central.vaadin.service.security.AuthenticatedUser;
import com.neogls.prism.central.vaadin.service.stats.RapportSyntheseInterventionAgentSearchData;
import com.neogls.prism.central.vaadin.service.stats.RapportSyntheseInterventionAgentService;
import com.neogls.prism.central.vaadin.view.stats.rapport.RapportSyntheseInterventionAgentExportButton;
import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.router.Route;
import jakarta.annotation.Nullable;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RolesAllowed(value={"ACTION_RAPPORT_SYNTHESE_AGENT_INTERVENTION"})
@Route(value="/stats/rapport/rapport-synthese-intervention-agent", layout=PrismLayout.class)
public class RapportSyntheseInterventionAgentView
extends VerticalLayout {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RapportSyntheseInterventionAgentView.class);
    private final IBusinessService businessService;
    private final UserPermissionService userPermissionService;
    private final RapportSyntheseInterventionAgentService rapportSyntheseInterventionAgentService;
    private Span errorMessage = new Span();
    private FormLayout formLayout = new FormLayout();
    private final DateRangePicker dateRange = new DateRangePicker();
    private Button valider = new Button(this.getTranslation("report.ok", new Object[0]), arg_0 -> this.valider(arg_0));
    private RapportSyntheseInterventionAgentExportButton exporterCSV;
    private VerticalLayout conteneurLayout = new VerticalLayout();
    private DelegationAndCenterField delegationAndCenterField;
    private ComboBox<PrismCentralUser> cbUser = new ComboBox();
    private final Binder<RapportSyntheseInterventionAgentSearchData> binder = new Binder();

    public RapportSyntheseInterventionAgentView(IBusinessService businessService, UserPermissionService userPermissionService, RapportSyntheseInterventionAgentService rapportSyntheseInterventionAgentService, @Nullable RapportSyntheseInterventionAgentSearchData searchData) {
        this.businessService = businessService;
        this.userPermissionService = userPermissionService;
        this.rapportSyntheseInterventionAgentService = rapportSyntheseInterventionAgentService;
        if (searchData == null) {
            searchData = new RapportSyntheseInterventionAgentSearchData();
            searchData.setDateRange(new DateRange(LocalDate.now(), null));
        }
        this.binder.readBean((Object)searchData);
        this.initFields();
        this.initBinder(searchData);
        this.add(new Component[]{this.errorMessage});
        this.add(new Component[]{this.formLayout});
        this.add(new Component[]{this.valider});
        this.add(new Component[]{this.conteneurLayout});
    }

    private void initFields() {
        this.formLayout.addFormItem((Component)this.dateRange, this.getTranslation("logBook.journees", new Object[0]));
        this.delegationAndCenterField = new DelegationAndCenterField((Collection)this.businessService.getDelegationsActives(), arg_0 -> this.reloadUsers(arg_0));
        this.delegationAndCenterField.setDelegationPlaceholder(this.getTranslation("mct.filtre.delegation.toutes", new Object[0]));
        this.delegationAndCenterField.setCenterPlaceholder(this.getTranslation("mct.filtre.centre.tous", new Object[0]));
        this.delegationAndCenterField.addThemeVariants((ThemeVariant[])new DelegationAndCenterFieldThemeVariant[]{DelegationAndCenterFieldThemeVariant.HORIZONTAL});
        this.cbUser.setPlaceholder(this.getTranslation("logBook.emetteur.tous", new Object[0]));
        this.cbUser.setClearButtonVisible(true);
        this.cbUser.setItemLabelGenerator(PrismCentralUser::getNom);
        this.cbUser.addClassName("readonly-placeholder-visible");
        AuthenticatedUser user = this.userPermissionService.getCurrentUser();
        List users = new ArrayList();
        users = user.getDelegation() == null ? this.businessService.rechercheToutUtilisateur() : (user.getCentre() == null ? this.businessService.rechercheUtilisateurParDelegation(user.getPrismUser()) : this.businessService.rechercheUtilisateurParDelegationCentre(user.getPrismUser()));
        this.cbUser.setItems(users).addFilter(arg_0 -> this.filterDelegation(arg_0)).addFilter(arg_0 -> this.filterCentre(arg_0));
        this.formLayout.add(new Component[]{this.delegationAndCenterField});
        this.formLayout.addFormItem((Component)this.cbUser, this.getTranslation("logBook.emetteur", new Object[0]));
    }

    private boolean filterDelegation(PrismCentralUser user) {
        return this.delegationAndCenterField.isEmpty() || ((DelegationAndCenter)this.delegationAndCenterField.getValue()).getDelegation() == null || ((DelegationAndCenter)this.delegationAndCenterField.getValue()).getDelegation().equals(user.getDelegation());
    }

    private boolean filterCentre(PrismCentralUser user) {
        return this.delegationAndCenterField.isEmpty() || ((DelegationAndCenter)this.delegationAndCenterField.getValue()).getCenter() == null || ((DelegationAndCenter)this.delegationAndCenterField.getValue()).getCenter().equals(user.getCentre());
    }

    private void valider(ClickEvent<Button> event) {
        RapportSyntheseInterventionAgentSearchData searchData = new RapportSyntheseInterventionAgentSearchData();
        if (this.binder.writeBeanIfValid((Object)searchData)) {
            this.conteneurLayout.removeAll();
            String titre = "Synthese des horaires des agents en intervention";
            if (this.testErreur(searchData)) {
                return;
            }
            Timestamp dateDebutValue = new Timestamp(GregorianCalendar.from(searchData.getDateRange().getBeginning().atStartOfDay(ZoneId.systemDefault())).getTime().getTime());
            Timestamp dateFinValue = new Timestamp(GregorianCalendar.from(searchData.getDateRange().getEnd().atStartOfDay(ZoneId.systemDefault())).getTime().getTime());
            String delegationValue = searchData.getDelegation();
            String centreValue = searchData.getCenter();
            String agentValue = null;
            if (searchData.getUser() != null) {
                agentValue = searchData.getUser().getCode();
            }
            SyntheseInterventionAgentBean syntheseBean = this.businessService.getSyntheseInterventionAgentBean(dateDebutValue, dateFinValue, delegationValue, centreValue, agentValue);
            syntheseBean.setTitre(titre);
            syntheseBean.setCentreTitre(this.getTranslation("global.centre", new Object[0]));
            syntheseBean.setDelegationTitre(this.getTranslation("global.delegation", new Object[0]));
            HashMap<String, String> jourSemaine = new HashMap<String, String>();
            jourSemaine.put("1", "Lundi");
            jourSemaine.put("2", "Mardi");
            jourSemaine.put("3", "Mercredi");
            jourSemaine.put("4", "Jeudi");
            jourSemaine.put("5", "Vendredi");
            jourSemaine.put("6", "Samedi");
            jourSemaine.put("7", "Dimanche");
            SimpleDateFormat sdfJour = new SimpleDateFormat("u");
            SimpleDateFormat sdfJourMois = new SimpleDateFormat("dd/MM");
            SimpleDateFormat sdfDate = new SimpleDateFormat("dd/MM/YYYY");
            SimpleDateFormat sdfHeure = new SimpleDateFormat("dd/MM/YYYY HH:mm");
            this.exporterCSV = new RapportSyntheseInterventionAgentExportButton(syntheseBean, this.rapportSyntheseInterventionAgentService.getExportFormats());
            this.conteneurLayout.add(new Component[]{this.exporterCSV});
            for (InterventionAgentBean syntheseAgentBean : syntheseBean.getInterventionAgentList()) {
                ArrayList<DebutFinInterventionString> items = new ArrayList<DebutFinInterventionString>();
                String jourPrec = "";
                for (DebutFinIntervention dates : syntheseAgentBean.getDates()) {
                    DebutFinInterventionString item = new DebutFinInterventionString();
                    if (!jourPrec.equals(sdfDate.format(dates.getDateDebut()))) {
                        item.setJour((String)jourSemaine.get(sdfJour.format(dates.getDateDebut())) + " " + sdfJourMois.format(dates.getDateDebut()));
                    } else {
                        item.setJour("");
                    }
                    if (dates.getDateDebut() != null) {
                        item.setDebut(sdfHeure.format(dates.getDateDebut()));
                    } else {
                        item.setDebut("");
                    }
                    if (dates.getDateFin() != null) {
                        item.setFin(sdfHeure.format(dates.getDateFin()));
                    } else {
                        item.setFin("");
                    }
                    if (dates.getDuree() != -1.0) {
                        item.setDuree("" + dates.getDuree());
                    } else {
                        item.setDuree("");
                    }
                    if (!jourPrec.equals(sdfDate.format(dates.getDateDebut()))) {
                        item.setTotal("" + syntheseAgentBean.getDureeJournee(sdfDate.format(dates.getDateDebut()), sdfDate));
                    } else {
                        item.setTotal("");
                    }
                    items.add(item);
                    jourPrec = sdfDate.format(dates.getDateDebut());
                }
                Span nomAgent = new Span("Agent : " + syntheseAgentBean.getNomAgent());
                this.conteneurLayout.add(new Component[]{nomAgent});
                Table table = new Table();
                table.setItems(items);
                table.addColumn("Jour", true, (ValueProvider & Serializable)i -> i.getJour());
                table.addColumn("D\u00e9but", true, (ValueProvider & Serializable)i -> i.getDebut());
                table.addColumn("Fin", true, (ValueProvider & Serializable)i -> i.getFin());
                table.addColumn("Dur\u00e9e", true, (ValueProvider & Serializable)i -> i.getDuree());
                table.addColumn("Total", true, (ValueProvider & Serializable)i -> i.getTotal());
                table.setSizeFull();
                this.conteneurLayout.add(new Component[]{table});
                Span separateur = new Span(" ");
                this.conteneurLayout.add(new Component[]{separateur});
            }
        }
    }

    private boolean testErreur(RapportSyntheseInterventionAgentSearchData searchData) {
        if (searchData.getDateRange().getBeginning() == null) {
            this.errorMessage.setText(this.getTranslation("rapport.date.debut.vide.error", new Object[0]));
            return true;
        }
        if (searchData.getDateRange().getEnd() == null) {
            this.errorMessage.setText(this.getTranslation("rapport.date.fin.vide.error", new Object[0]));
            return true;
        }
        if (searchData.getDateRange().getEnd() != null && new Timestamp(GregorianCalendar.from(searchData.getDateRange().getEnd().atStartOfDay(ZoneId.systemDefault())).getTime().getTime()).before(new Timestamp(GregorianCalendar.from(searchData.getDateRange().getBeginning().atStartOfDay(ZoneId.systemDefault())).getTime().getTime()))) {
            this.errorMessage.setText(this.getTranslation("rapport.date.fin.error", new Object[0]));
            return true;
        }
        this.errorMessage.setText("");
        return false;
    }

    private <V> void reloadUsers(AbstractField.ComponentValueChangeEvent<?, V> event) {
        this.cbUser.clear();
        this.cbUser.getDataProvider().refreshAll();
        boolean cbUserEmpty = this.cbUser.getListDataView().getItemCount() == 0;
        this.cbUser.setPlaceholder(cbUserEmpty ? this.getTranslation("logBook.emetteur.aucun", new Object[0]) : this.getTranslation("logBook.emetteur.tous", new Object[0]));
        this.cbUser.setReadOnly(cbUserEmpty);
    }

    private void initBinder(RapportSyntheseInterventionAgentSearchData searchData) {
        if (searchData == null) {
            searchData = new RapportSyntheseInterventionAgentSearchData();
            searchData.setDateRange(new DateRange(LocalDate.now(), null));
        }
        this.binder.bind((HasValue)this.delegationAndCenterField, DelegationAndCenterField.createGetter(RapportSyntheseInterventionAgentSearchData::getDelegation, RapportSyntheseInterventionAgentSearchData::getCenter), DelegationAndCenterField.createSetter(RapportSyntheseInterventionAgentSearchData::setDelegation, RapportSyntheseInterventionAgentSearchData::setCenter));
        this.binder.bind((HasValue)this.cbUser, RapportSyntheseInterventionAgentSearchData::getUser, RapportSyntheseInterventionAgentSearchData::setUser);
        this.binder.forField((HasValue)this.dateRange).asRequired().bind(RapportSyntheseInterventionAgentSearchData::getDateRange, RapportSyntheseInterventionAgentSearchData::setDateRange);
    }
}

