/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.stats.patrol;

import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismbirtbean.SyntheseTableauBordBean;
import com.geolocsystems.prismbirtbean.SyntheseTableauBordCentreBean;
import com.geolocsystems.prismcentral.beans.SyntheseTableauBordPatrouille;
import com.geolocsystems.prismcentralvaadin.data.BusinessServiceFactory;
import com.neogls.prism.central.vaadin.view.stats.patrol.StatisticReportSimple;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class StatisticReportSimpleViewer
extends Composite<VerticalLayout>
implements HasSize {
    private static final long serialVersionUID = 1L;
    private StatisticReportSimple conteneur;
    private List<SyntheseTableauBordBean> syntheseTableauBordList = new ArrayList();
    private List<SyntheseTableauBordBean> syntheseTableauBord;
    private List<SyntheseTableauBordBean> syntheseTableauBordSalage;
    private List<SyntheseTableauBordBean> syntheseTableauBordDeneigement;
    private List<SyntheseTableauBordBean> syntheseTableauBordKmParcouru;
    private List<SyntheseTableauBordBean> syntheseTableauBordPatrouilles;
    private VerticalLayout conteneurLayout;
    private Button buttonExport;
    private Span titre;

    public StatisticReportSimpleViewer(StatisticReportSimple conteneur) {
        this.conteneur = conteneur;
        HorizontalLayout hlHeader = new HorizontalLayout();
        hlHeader.setSizeFull();
        hlHeader.setHeight(30.0f, Unit.PIXELS);
        this.titre = new Span(this.getTranslation("stats.patrouilles.title", new Object[0]));
        this.titre.addClassNames(new String[]{"text-header", "p-s", "bg-base", "shadow-xs", "rounded-l"});
        ((VerticalLayout)this.getContent()).add(new Component[]{this.titre});
        hlHeader.add(new Component[]{this.titre});
        hlHeader.setVerticalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{this.titre});
        ((VerticalLayout)this.getContent()).add(new Component[]{hlHeader});
        HorizontalLayout hLayout = new HorizontalLayout();
        hLayout.setWidth(100.0f, Unit.PERCENTAGE);
        ((VerticalLayout)this.getContent()).add(new Component[]{hLayout});
        Button retourFormulaire = new Button(this.getTranslation("statistiques.retour.form", new Object[0]));
        retourFormulaire.addClickListener((ComponentEventListener & Serializable)e -> this.retour(false));
        hLayout.add(new Component[]{retourFormulaire});
        hLayout.setVerticalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{retourFormulaire});
        HorizontalLayout ligne = new HorizontalLayout();
        ligne.setWidth(100.0f, Unit.PERCENTAGE);
        this.buttonExport = new Button(this.getTranslation("exportButton.exporter", new Object[0]));
        hLayout.add(new Component[]{this.buttonExport});
        hLayout.setVerticalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{this.buttonExport});
        this.conteneurLayout = new VerticalLayout();
        ((VerticalLayout)this.getContent()).add(new Component[]{this.conteneurLayout});
        for (SyntheseTableauBordBean syntheseBean : this.syntheseTableauBordList) {
            Grid table = new Grid();
            table.setItems(new Object[]{syntheseBean});
            table.setSizeFull();
            this.conteneurLayout.add(new Component[]{table});
        }
    }

    public void refresh() {
        this.conteneurLayout.removeAll();
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.conteneur.getFormStatistiquesPatrouilles().getDateMin());
        int annee = cal.get(1);
        this.titre.setText(this.getTranslation("stats.patrouilles.title", new Object[0]) + " - " + annee);
        Map syntheseSimple = BusinessServiceFactory.getBusinessService().getStatsSimplePatrouillesParAnnee(annee);
        this.syntheseTableauBordSalage = this.toListSyntheseTableauBordBean(syntheseSimple, "SALAGE");
        this.syntheseTableauBordDeneigement = this.toListSyntheseTableauBordBean(syntheseSimple, "DENEIGEMENT");
        this.syntheseTableauBordKmParcouru = this.toListSyntheseTableauBordBean(syntheseSimple, "KM_TOTAL");
        this.makeLabel("Salage");
        this.createTable(this.syntheseTableauBordSalage, 1);
        this.makeLabel("D\u00e9neigement");
        this.createTable(this.syntheseTableauBordDeneigement, 1);
        this.syntheseTableauBordPatrouilles = this.toListSyntheseTableauBordBean(syntheseSimple, "PATROUILLE_TOTAL");
        this.makeLabel("NB PATROUILLES");
        this.createTable(this.syntheseTableauBordPatrouilles, 1);
        this.makeLabel("NB KM TOTAL");
        this.createTable(this.syntheseTableauBordKmParcouru, 1000);
    }

    private void createTable(List<SyntheseTableauBordBean> syntheseTableauBord, int diviser) {
        for (SyntheseTableauBordBean syntheseTableauBordBean : syntheseTableauBord) {
            ArrayList<SyntheseTableauBordPatrouille> syntheseTableauBordPatrouille = new ArrayList<SyntheseTableauBordPatrouille>();
            for (SyntheseTableauBordCentreBean syntheseTableauBordCentreBean : syntheseTableauBordBean.getSyntheseTableauBordCentreBean()) {
                syntheseTableauBordPatrouille.add(new SyntheseTableauBordPatrouille(syntheseTableauBordCentreBean));
            }
            int total = 0;
            for (int i = 0; i < 12; ++i) {
                total += syntheseTableauBordBean.getTotalParMois()[i].intValue();
            }
            HorizontalLayout hlHeader = new HorizontalLayout();
            hlHeader.setSizeFull();
            hlHeader.setHeight(30.0f, Unit.PIXELS);
            Span titre = new Span(syntheseTableauBordBean.getNomSecteur());
            titre.addClassNames(new String[]{"text-secondary", "p-s", "bg-base", "shadow-none", "rounded-l"});
            titre.setSizeUndefined();
            hlHeader.add(new Component[]{titre});
            hlHeader.setVerticalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{titre});
            this.conteneurLayout.add(new Component[]{hlHeader});
            Grid table = new Grid();
            table.addColumn(SyntheseTableauBordPatrouille::getCentre).setHeader("Centre").setFooter("Total").setFooter(syntheseTableauBordBean.getNomSecteur()).setVisible(true);
            table.addColumn((ValueProvider & Serializable)e -> e.getJanvier() / diviser).setHeader("Janvier").setFooter(String.valueOf(syntheseTableauBordBean.getTotalParMois()[0] / diviser)).setVisible(true);
            table.addColumn((ValueProvider & Serializable)e -> e.getFevrier() / diviser).setHeader("F\u00e9vrier").setFooter(String.valueOf(syntheseTableauBordBean.getTotalParMois()[1] / diviser)).setVisible(true);
            table.addColumn((ValueProvider & Serializable)e -> e.getMars() / diviser).setHeader("Mars").setFooter(String.valueOf(syntheseTableauBordBean.getTotalParMois()[2] / diviser)).setVisible(true);
            table.addColumn((ValueProvider & Serializable)e -> e.getAvril() / diviser).setHeader("Avril").setFooter(String.valueOf(syntheseTableauBordBean.getTotalParMois()[3] / diviser)).setVisible(true);
            table.addColumn((ValueProvider & Serializable)e -> e.getMai() / diviser).setHeader("Mai").setFooter(String.valueOf(syntheseTableauBordBean.getTotalParMois()[4] / diviser)).setVisible(true);
            table.addColumn((ValueProvider & Serializable)e -> e.getJuin() / diviser).setHeader("Juin").setFooter(String.valueOf(syntheseTableauBordBean.getTotalParMois()[5] / diviser)).setVisible(true);
            table.addColumn((ValueProvider & Serializable)e -> e.getJuillet() / diviser).setHeader("Juillet").setFooter(String.valueOf(syntheseTableauBordBean.getTotalParMois()[6] / diviser)).setVisible(true);
            table.addColumn((ValueProvider & Serializable)e -> e.getAout() / diviser).setHeader("Ao\u00fbt").setFooter(String.valueOf(syntheseTableauBordBean.getTotalParMois()[7] / diviser)).setVisible(true);
            table.addColumn((ValueProvider & Serializable)e -> e.getSeptembre() / diviser).setHeader("Septembre").setFooter(String.valueOf(syntheseTableauBordBean.getTotalParMois()[8] / diviser)).setVisible(true);
            table.addColumn((ValueProvider & Serializable)e -> e.getOctobre() / diviser).setHeader("Octobre").setFooter(String.valueOf(syntheseTableauBordBean.getTotalParMois()[9] / diviser)).setVisible(true);
            table.addColumn((ValueProvider & Serializable)e -> e.getNovembre() / diviser).setHeader("Novembre").setFooter(String.valueOf(syntheseTableauBordBean.getTotalParMois()[10] / diviser)).setVisible(true);
            table.addColumn((ValueProvider & Serializable)e -> e.getDecembre() / diviser).setHeader("D\u00e9cembre").setFooter(String.valueOf(syntheseTableauBordBean.getTotalParMois()[11] / diviser)).setVisible(true);
            table.addColumn((ValueProvider & Serializable)e -> e.getTotal() / diviser).setHeader("Total").setFooter(String.valueOf(total)).setVisible(true);
            table.setItems(syntheseTableauBordPatrouille);
            this.conteneurLayout.add(new Component[]{table});
        }
        for (SyntheseTableauBordBean syntheseTableauBordBean : syntheseTableauBord) {
            LinkedHashMap<String, Integer[]> series = new LinkedHashMap<String, Integer[]>();
            for (SyntheseTableauBordCentreBean centreBean : syntheseTableauBordBean.getSyntheseTableauBordCentreBean()) {
                series.put(centreBean.getCentre(), centreBean.getNbJoursPatrouilles());
            }
        }
    }

    private void makeLabel(String label) {
        HorizontalLayout hlHeader = new HorizontalLayout();
        hlHeader.setSizeFull();
        hlHeader.setHeight(30.0f, Unit.PIXELS);
        Span titre = new Span(label);
        titre.addClassNames(new String[]{"text-header", "p-s", "bg-base", "shadow-xs", "rounded-l"});
        titre.setSizeUndefined();
        hlHeader.add(new Component[]{titre});
        hlHeader.setVerticalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{titre});
        this.conteneurLayout.add(new Component[]{hlHeader});
    }

    private List<SyntheseTableauBordBean> toListSyntheseTableauBordBean(Map<String, Map<String, Map<Integer, Map<String, Integer>>>> mapDelegation, String key) {
        ArrayList<SyntheseTableauBordBean> retour = new ArrayList<SyntheseTableauBordBean>();
        for (String delegation : mapDelegation.keySet()) {
            Map<String, Map<Integer, Map<String, Integer>>> mapCentre = mapDelegation.get(delegation);
            SyntheseTableauBordBean beanDelegation = new SyntheseTableauBordBean();
            beanDelegation.setNomSecteur(delegation);
            ArrayList<SyntheseTableauBordCentreBean> syntheseTableauBordCentreBean = new ArrayList<SyntheseTableauBordCentreBean>();
            Integer[] totalParMois = new Integer[13];
            for (int i = 0; i < 13; ++i) {
                totalParMois[i] = 0;
            }
            for (String centre : mapCentre.keySet()) {
                Map<Integer, Map<String, Integer>> map = mapCentre.get(centre);
                SyntheseTableauBordCentreBean beanCentre = new SyntheseTableauBordCentreBean();
                beanCentre.setCentre(centre);
                Integer[] nbJoursPatrouilles = new Integer[12];
                int totalCentre = 0;
                for (int i = 0; i < 12; ++i) {
                    Integer[] statsValue;
                    if (map.get(i) == null) {
                        statsValue = new HashMap();
                        statsValue.put(key, 0);
                        map.put(i, (Map<String, Integer>)statsValue);
                    }
                    try {
                        nbJoursPatrouilles[i] = map.get(i).get(key);
                        totalCentre += map.get(i).get(key).intValue();
                        statsValue = totalParMois;
                        int n = i;
                        Integer.valueOf(statsValue[n] + map.get(i).get(key));
                        continue;
                    }
                    catch (Exception e) {
                        nbJoursPatrouilles[i] = 0;
                    }
                }
                Integer[] integerArray = totalParMois;
                Integer.valueOf(integerArray[12] + totalCentre);
                beanCentre.setNbJoursPatrouilles(nbJoursPatrouilles);
                beanCentre.setTotal(totalCentre);
                syntheseTableauBordCentreBean.add(beanCentre);
            }
            beanDelegation.setSyntheseTableauBordCentreBean(syntheseTableauBordCentreBean);
            beanDelegation.setTotalParMois(totalParMois);
            retour.add(beanDelegation);
        }
        return retour;
    }

    private List<SyntheseTableauBordBean> toListSyntheseTableauBordBean(Map<String, Map<String, Map<Integer, Integer>>> mapDelegation) {
        ArrayList<SyntheseTableauBordBean> retour = new ArrayList<SyntheseTableauBordBean>();
        for (String delegation : mapDelegation.keySet()) {
            Map<String, Map<Integer, Integer>> mapCentre = mapDelegation.get(delegation);
            SyntheseTableauBordBean beanDelegation = new SyntheseTableauBordBean();
            beanDelegation.setNomSecteur(delegation);
            ArrayList<SyntheseTableauBordCentreBean> syntheseTableauBordCentreBean = new ArrayList<SyntheseTableauBordCentreBean>();
            Integer[] totalParMois = new Integer[13];
            for (int i = 0; i < 13; ++i) {
                totalParMois[i] = 0;
            }
            for (String centre : mapCentre.keySet()) {
                Map<Integer, Integer> map = mapCentre.get(centre);
                SyntheseTableauBordCentreBean beanCentre = new SyntheseTableauBordCentreBean();
                beanCentre.setCentre(centre);
                Integer[] nbJoursPatrouilles = new Integer[12];
                int totalCentre = 0;
                for (int i = 0; i < 12; ++i) {
                    if (map.get(i) == null) {
                        map.put(i, 0);
                    }
                    nbJoursPatrouilles[i] = map.get(i);
                    totalCentre += map.get(i).intValue();
                    Integer[] integerArray = totalParMois;
                    int n = i;
                    Integer.valueOf(integerArray[n] + map.get(i));
                }
                Integer[] integerArray = totalParMois;
                Integer.valueOf(integerArray[12] + totalCentre);
                beanCentre.setNbJoursPatrouilles(nbJoursPatrouilles);
                beanCentre.setTotal(totalCentre);
                syntheseTableauBordCentreBean.add(beanCentre);
            }
            beanDelegation.setSyntheseTableauBordCentreBean(syntheseTableauBordCentreBean);
            beanDelegation.setTotalParMois(totalParMois);
            retour.add(beanDelegation);
        }
        return retour;
    }

    private void retour(boolean reinitialiserForm) {
        if (reinitialiserForm) {
            this.conteneur.reinit();
        } else {
            this.conteneur.getFormStatistiquesPatrouilles().setVisible(true);
            this.conteneur.getTableauStatistiquePatrouilles().setVisible(false);
        }
    }

    protected String getExportFilename(String format) {
        return MetierCommun.instanceOf().genereIdentifiantUnique("fiches") + "." + format.toLowerCase();
    }
}

