/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.stats.patrol;

import com.neogls.prism.central.vaadin.view.stats.patrol.StatisticReportSimple;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class StatisticReportSimpleForm
extends FormLayout {
    private static final long serialVersionUID = -991511605783114857L;
    private StatisticReportSimple conteneur;
    private VerticalLayout layout;
    private HorizontalLayout hlHeader;
    private DatePicker dateMin;
    private ComboBox yearPicker;

    public StatisticReportSimpleForm(StatisticReportSimple conteneur) {
        this.conteneur = conteneur;
        this.createForm();
    }

    public void createForm() {
        this.layout = new VerticalLayout();
        this.layout.setSizeFull();
        this.layout.setWidth(400.0f, Unit.PIXELS);
        this.add(new Component[]{this.layout});
        this.hlHeader = new HorizontalLayout();
        this.hlHeader.setSizeFull();
        this.hlHeader.setHeight(30.0f, Unit.PIXELS);
        Span titre = new Span(this.getTranslation("stats.patrouilles.title", new Object[0]));
        titre.addClassNames(new String[]{"text-header", "p-s", "bg-base", "shadow-xs", "rounded-l"});
        titre.setSizeUndefined();
        this.hlHeader.add(new Component[]{titre});
        this.layout.add(new Component[]{this.hlHeader});
        this.creerDates();
        HorizontalLayout buttons = new HorizontalLayout();
        buttons.setWidth(100.0f, Unit.PERCENTAGE);
        Button valider = new Button(this.getTranslation("report.ok", new Object[0]));
        buttons.add(new Component[]{valider});
        valider.setWidth(100.0f, Unit.PERCENTAGE);
        valider.addClickListener((ComponentEventListener & Serializable)e -> this.valider());
        this.layout.add(new Component[]{buttons});
    }

    private void creerDates() {
        this.dateMin = new DatePicker();
        this.dateMin.setPlaceholder("YYYY");
        LocalDate now = LocalDate.now(ZoneId.systemDefault());
        List selectableYears = IntStream.range(now.getYear() - 99, now.getYear() + 1).boxed().sorted((o1, o2) -> o1 > o2 ? -1 : 1).collect(Collectors.toList());
        this.yearPicker = new ComboBox("Year", selectableYears);
        this.yearPicker.setWidth(6.0f, Unit.EM);
        this.layout.add(new Component[]{this.yearPicker});
    }

    public Date getDateMin() {
        Calendar cal = GregorianCalendar.getInstance();
        cal.set(1, Integer.valueOf(this.yearPicker.getValue().toString()));
        return cal.getTime();
    }

    private void valider() {
        this.conteneur.onFiltreValides();
    }
}

