/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.stats.event;

import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.evenements.DescriptionNature;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismandroid.model.evenements.Situation;
import com.geolocsystems.prismandroid.model.evenements.ValeurNature;
import com.geolocsystems.prismbirtbean.SyntheseTableauBordBean;
import com.geolocsystems.prismbirtbean.SyntheseTableauBordCentreBean;
import com.geolocsystems.prismcentral.beans.SyntheseTableauBordPatrouille;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import com.geolocsystems.prismcentralvaadin.data.BusinessServiceFactory;
import com.geolocsystems.prismcentralvaadin.util.ConfigUtils;
import com.neogls.prism.central.vaadin.rest.export.situation.SituationExportService;
import com.neogls.prism.central.vaadin.view.mct.common.event.list.impl.SituationSelectionExportButton;
import com.neogls.prism.central.vaadin.view.mct.common.event.sort.SortCriteria;
import com.neogls.prism.central.vaadin.view.stats.event.ReportEventSimple;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridMultiSelectionModel;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.data.selection.MultiSelectionListener;
import com.vaadin.flow.data.selection.SelectionListener;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReportEventSimpleViewer
extends Composite<VerticalLayout>
implements HasSize {
    private static final long serialVersionUID = 1L;
    private ReportEventSimple conteneur;
    private VerticalLayout conteneurLayout;
    private SituationSelectionExportButton buttonExport;
    private Span titre;
    private Span labelNbEvenements;
    private List<String> visibleColumns;
    private Map<String, Nature> natures = new HashMap();
    private Map<String, List<DescriptionNature>> descriptionsNatures = new HashMap();
    private final SituationExportService situationExportService;
    private Grid<Evenement> tableEvenements;

    public ReportEventSimpleViewer(ReportEventSimple conteneur) {
        this.conteneur = conteneur;
        this.situationExportService = conteneur.getSituationExportService();
        HorizontalLayout hlHeader = new HorizontalLayout();
        hlHeader.setSizeFull();
        hlHeader.setHeight(30.0f, Unit.PIXELS);
        this.titre = new Span(this.getTranslation("report.title", new Object[0]));
        this.titre.addClassNames(new String[]{"text-header", "p-s", "bg-base", "shadow-xs", "rounded-l"});
        ((VerticalLayout)this.getContent()).add(new Component[]{this.titre});
        hlHeader.add(new Component[]{this.titre});
        hlHeader.setVerticalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{this.titre});
        ((VerticalLayout)this.getContent()).add(new Component[]{hlHeader});
        HorizontalLayout hLayout = new HorizontalLayout();
        hLayout.setWidth(100.0f, Unit.PERCENTAGE);
        ((VerticalLayout)this.getContent()).add(new Component[]{hLayout});
        Button retourFormulaire = new Button(this.getTranslation("statistiques.retour.form", new Object[0]));
        retourFormulaire.addClickListener((ComponentEventListener & Serializable)e -> this.retour(false));
        hLayout.add(new Component[]{retourFormulaire});
        hLayout.setVerticalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{retourFormulaire});
        this.buttonExport = new SituationSelectionExportButton(5000);
        hLayout.add(new Component[]{this.buttonExport});
        hLayout.setVerticalComponentAlignment(FlexComponent.Alignment.END, new Component[]{this.buttonExport});
        this.conteneurLayout = new VerticalLayout();
        this.labelNbEvenements = new Span();
        ((VerticalLayout)this.getContent()).add(new Component[]{this.conteneurLayout});
        this.tableEvenements = new Grid();
        this.tableEvenements.setWidth(100.0f, Unit.PERCENTAGE);
        this.tableEvenements.setMinHeight(80.0f, Unit.PERCENTAGE);
        this.tableEvenements.addColumn((ValueProvider & Serializable)e -> e.getValeurNature().getCode()).setHeader("nature").setSortable(true).setAutoWidth(true);
        this.tableEvenements.addColumn((ValueProvider & Serializable)e -> e.getValeurNature().getDescription().getValeur()).setHeader("description").setSortable(true).setAutoWidth(true);
        this.tableEvenements.addColumn(Evenement::getDateCreation).setHeader("dateDebut").setSortable(true).setAutoWidth(true);
        this.tableEvenements.addColumn((ValueProvider & Serializable)e -> e.getLocalisation().getCommune()).setHeader("commune").setSortable(true).setAutoWidth(true);
        this.tableEvenements.addColumn((ValueProvider & Serializable)e -> e.getLocalisation().getAxe()).setHeader("axe").setSortable(true).setAutoWidth(true);
        if (ConfigUtils.getAfficherAdresse()) {
            this.tableEvenements.addColumn((ValueProvider & Serializable)e -> e.getLocalisation().getAdresseDebut()).setHeader("adresse").setSortable(true).setAutoWidth(true);
        }
        if (ConfigUtils.getAfficherPR()) {
            this.tableEvenements.addColumn((ValueProvider & Serializable)e -> e.getLocalisation().getPrDebut()).setHeader("libellePr").setSortable(true).setAutoWidth(true);
        }
        this.tableEvenements.addColumn((ValueProvider & Serializable)e -> e.isTermine()).setHeader("libelleTermine").setSortable(true).setAutoWidth(true);
        this.tableEvenements.setSelectionMode(Grid.SelectionMode.MULTI);
        ((GridMultiSelectionModel)this.tableEvenements.getSelectionModel()).addMultiSelectionListener((MultiSelectionListener & Serializable)event -> this.buttonExport.setEventSelection((Collection)event.getAllSelectedItems()));
        this.tableEvenements.addSelectionListener((SelectionListener & Serializable)event -> this.buttonExport.setEventSelection((Collection)event.getAllSelectedItems()));
        this.conteneurLayout.add(new Component[]{this.tableEvenements});
    }

    public void refresh() {
        this.titre.setText(this.getTranslation("report.title", new Object[0]));
        List situations = BusinessServiceFactory.getBusinessService().getEvenements(this.conteneur.getFiltre(), this.conteneur.getFiltresJava());
        List l = this.getEvents(situations);
        Collections.sort(l, SortCriteria.DATE_DESC);
        situations.clear();
        ArrayList<Evenement> evenements = new ArrayList<Evenement>();
        for (Situation situation : l) {
            if (situation.getEvenements() == null || situation.getEvenements().size() <= 0) continue;
            for (Evenement evenement : situation.getEvenements()) {
                if (evenement.isEvenementPrincipalHorsFiltre()) continue;
                evenements.add(evenement);
            }
        }
        this.tableEvenements.setPageSize(evenements.size());
        this.tableEvenements.setItems(evenements);
        this.setLabelNbEvenements(evenements.size());
        if (ConfigurationFactory.getInstance().getInt("report.table.nbLigne") == 0) {
            // empty if block
        }
        List<Nature> natureList = situations.stream().map(Situation::getEvenements).flatMap(Collection::stream).map(Evenement::getValeurNature).map(ValeurNature::getCode).distinct().map(this.conteneur.getBusinessService().getNatures()::get).toList();
        List exportFormats = this.situationExportService.getNatureExport(natureList);
        this.buttonExport.setFormats(exportFormats);
        this.buttonExport.setWidth("300px");
    }

    public void setLabelNbEvenements(int nbEvenements) {
        if (nbEvenements < 2) {
            this.labelNbEvenements.setText(nbEvenements + " " + this.getTranslation("report.nbEvenementSingulier", new Object[0]));
        } else {
            this.labelNbEvenements.setText(nbEvenements + " " + this.getTranslation("report.nbEvenementPluriel", new Object[0]));
        }
    }

    private List<String> getVisibleColumns() {
        return null;
    }

    private List<String> getVisibleColumnsDefaut() {
        ArrayList<String> visibleColumn = new ArrayList<String>();
        visibleColumn.add("selected");
        visibleColumn.add("nature");
        visibleColumn.add("description");
        visibleColumn.add("dateDebut");
        visibleColumn.add("commune");
        visibleColumn.add("axe");
        visibleColumn.add("libelleTermine");
        return visibleColumn;
    }

    private void createTable(List<SyntheseTableauBordBean> syntheseTableauBord, int diviser) {
        for (SyntheseTableauBordBean syntheseTableauBordBean : syntheseTableauBord) {
            ArrayList<SyntheseTableauBordPatrouille> syntheseTableauBordPatrouille = new ArrayList<SyntheseTableauBordPatrouille>();
            for (SyntheseTableauBordCentreBean syntheseTableauBordCentreBean : syntheseTableauBordBean.getSyntheseTableauBordCentreBean()) {
                syntheseTableauBordPatrouille.add(new SyntheseTableauBordPatrouille(syntheseTableauBordCentreBean));
            }
            int total = 0;
            for (int i = 0; i < 12; ++i) {
                total += syntheseTableauBordBean.getTotalParMois()[i].intValue();
            }
            HorizontalLayout hlHeader = new HorizontalLayout();
            hlHeader.setSizeFull();
            hlHeader.setHeight(30.0f, Unit.PIXELS);
            Span titre = new Span(syntheseTableauBordBean.getNomSecteur());
            titre.addClassNames(new String[]{"text-secondary", "p-s", "bg-base", "shadow-none", "rounded-l"});
            titre.setSizeUndefined();
            hlHeader.add(new Component[]{titre});
            hlHeader.setVerticalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{titre});
            this.conteneurLayout.add(new Component[]{hlHeader});
            Grid table = new Grid();
            table.setItems(syntheseTableauBordPatrouille);
            this.conteneurLayout.add(new Component[]{table});
        }
    }

    private void makeLabel(String label) {
        HorizontalLayout hlHeader = new HorizontalLayout();
        hlHeader.setSizeFull();
        hlHeader.setHeight(30.0f, Unit.PIXELS);
        Span titre = new Span(label);
        titre.addClassNames(new String[]{"text-header", "p-s", "bg-base", "shadow-xs", "rounded-l"});
        titre.setSizeUndefined();
        hlHeader.add(new Component[]{titre});
        hlHeader.setVerticalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{titre});
        this.conteneurLayout.add(new Component[]{hlHeader});
    }

    private void retour(boolean reinitialiserForm) {
        if (reinitialiserForm) {
            this.conteneur.reinit();
        } else {
            this.conteneur.getReportEventSimpleForm().setVisible(true);
            this.conteneur.getReportEventSimpleViewer().setVisible(false);
        }
    }

    protected String getExportFilename(String format) {
        return MetierCommun.instanceOf().genereIdentifiantUnique("fiches") + "." + format.toLowerCase();
    }

    protected List<Situation> getEvents(List<Situation> situations) {
        ArrayList<Situation> situationsFiltrees = new ArrayList<Situation>();
        for (Situation s : situations) {
            Situation sit = new Situation(s.getSid(), s.getEvenements());
            sit.setEvenementPrincipal((Evenement)s.getEvenements().get(0));
            situationsFiltrees.add(sit);
        }
        return situationsFiltrees;
    }
}

