/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.stats.event;

import com.geolocsystems.prismcentral.data.IBusinessService;
import com.geolocsystems.prismcentral.data.filtrejava.FiltreJava;
import com.neogls.prism.central.vaadin.layout.PrismLayout;
import com.neogls.prism.central.vaadin.rest.export.situation.SituationExportService;
import com.neogls.prism.central.vaadin.service.BusinessModuleService;
import com.neogls.prism.central.vaadin.service.security.AuthenticatedUser;
import com.neogls.prism.central.vaadin.service.util.AuthenticatedUserUtils;
import com.neogls.prism.central.vaadin.view.mct.common.event.filter.EventFilter;
import com.neogls.prism.central.vaadin.view.mct.common.event.filter.EventFilterFormService;
import com.neogls.prism.central.vaadin.view.mct.common.event.filter.field.IVaadinEventFilterFieldFactory;
import com.neogls.prism.central.vaadin.view.stats.event.ReportEventSimpleForm;
import com.neogls.prism.central.vaadin.view.stats.event.ReportEventSimpleViewer;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.router.HasDynamicTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.util.List;
import java.util.stream.Collectors;

@RolesAllowed(value={"ACTION_RAPPORT_FICHE_EVENEMENT"})
@Route(value="/report-event", layout=PrismLayout.class)
public class ReportEventSimple
extends VerticalLayout
implements HasDynamicTitle {
    private static final long serialVersionUID = 8831282771855366849L;
    private ReportEventSimpleForm reportEventSimpleForm;
    private ReportEventSimpleViewer reportEventSimpleViewer;
    private EventFilter value;
    private List<Integer> businessModuleCodes;
    private EventFilterFormService service;
    private IVaadinEventFilterFieldFactory factory;
    private SituationExportService situationExportService;
    private IBusinessService businessService;

    public ReportEventSimple(BusinessModuleService businessModuleService, EventFilterFormService service, IVaadinEventFilterFieldFactory factory, SituationExportService situationExportService, IBusinessService businessService) {
        this.businessModuleCodes = businessModuleService.getBusinessModules().stream().map(m -> m.getCode()).collect(Collectors.toList());
        this.service = service;
        this.factory = factory;
        this.situationExportService = situationExportService;
        this.businessService = businessService;
        this.value = EventFilter.builder().unlocalizedName("mct.filtre.evenements.perso").sqlFilter(this.getEmptyFilter()).build();
        this.reinit(this.value, this.businessModuleCodes, service, factory);
    }

    public ReportEventSimpleForm getReportEventSimpleForm() {
        return this.reportEventSimpleForm;
    }

    public void setReportEventSimpleForm(ReportEventSimpleForm reportEventSimpleForm) {
        this.reportEventSimpleForm = reportEventSimpleForm;
    }

    public ReportEventSimpleViewer getReportEventSimpleViewer() {
        return this.reportEventSimpleViewer;
    }

    public void setReportEventSimpleViewer(ReportEventSimpleViewer reportEventSimpleViewer) {
        this.reportEventSimpleViewer = reportEventSimpleViewer;
    }

    public void reinit(EventFilter value, List<Integer> businessModuleCodes, EventFilterFormService service, IVaadinEventFilterFieldFactory factory) {
        this.reportEventSimpleForm = new ReportEventSimpleForm(this, value, businessModuleCodes, service, factory);
        this.add(new Component[]{this.reportEventSimpleForm});
        this.reportEventSimpleViewer = new ReportEventSimpleViewer(this);
        this.reportEventSimpleViewer.setVisible(false);
        this.add(new Component[]{this.reportEventSimpleViewer});
        this.construitPage();
    }

    public void construitPage() {
    }

    public String getPath() {
        return this.getTranslation("stats.tableau.bord.patrouilles", new Object[0]);
    }

    public Component getInfoComponent() {
        return null;
    }

    public void refreshResult() {
        this.reportEventSimpleViewer.setVisible(true);
        this.reportEventSimpleForm.setVisible(false);
        this.reportEventSimpleViewer.refresh();
    }

    public void onFiltreValides() {
        this.refreshResult();
    }

    public String getPageTitle() {
        return "report.title";
    }

    public void reinit() {
        this.reinit(this.value, this.businessModuleCodes, this.service, this.factory);
    }

    protected IBusinessService.EvenementFiltre getEmptyFilter() {
        AuthenticatedUser user = this.service.getCurrentUser();
        return IBusinessService.EvenementFiltre.moduleMetier((String)AuthenticatedUserUtils.getDeletationString((AuthenticatedUser)user), (String)AuthenticatedUserUtils.getCenterString((AuthenticatedUser)user), (List)this.businessModuleCodes);
    }

    public IBusinessService.EvenementFiltre getFiltre() {
        return this.reportEventSimpleForm.getFiltre();
    }

    public List<FiltreJava> getFiltresJava() {
        return this.reportEventSimpleForm.getFiltresJava();
    }

    public SituationExportService getSituationExportService() {
        return this.situationExportService;
    }

    public IBusinessService getBusinessService() {
        return this.businessService;
    }
}

