/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.stats.chart;

import com.neogls.prism.central.vaadin.util.vaadin.CachedInputStreamFactory;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.InputStreamFactory;
import com.vaadin.flow.server.StreamResource;
import gls.outils.Nombre;
import jakarta.annotation.Nonnull;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Objects;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;

public class PieChart
extends Div {
    private final PieDataset dataset;

    public PieChart(@Nonnull Map<String, Integer> values, @Nonnull ItemLabelGenerator<String> itemLabelGenerator, boolean showValue, boolean showPercentage, int eventNumber) {
        this.dataset = this.createDataset(values, itemLabelGenerator, showValue, showPercentage, eventNumber);
        this.add(new Component[]{new Image((AbstractStreamResource)new StreamResource("chart.png", (InputStreamFactory)new CachedInputStreamFactory(() -> this.generateGraph())), "")});
    }

    private PieDataset createDataset(Map<String, Integer> values, ItemLabelGenerator<String> itemLabelGenerator, boolean showValue, boolean showPercentage, int eventNumber) {
        DefaultPieDataset newDataset = new DefaultPieDataset();
        for (Map.Entry<String, Integer> entry : values.entrySet()) {
            String key = entry.getKey();
            Integer value = entry.getValue();
            Object label = key != null ? Objects.requireNonNullElse(itemLabelGenerator.apply((Object)key), key) : this.getTranslation("stats.statistiques.chart.autre", new Object[0]);
            if (showValue && showPercentage) {
                label = (String)label + " : " + value + " (" + Nombre.getNombre((double)((double)value.intValue() * 100.0 / (double)eventNumber), (int)2) + "%)";
            } else if (showValue) {
                label = (String)label + " : " + value;
            } else if (showPercentage) {
                label = (String)label + " : (" + Nombre.getNombre((double)((double)value.intValue() * 100.0 / (double)eventNumber), (int)2) + "%)";
            }
            newDataset.setValue((Comparable)label, (Number)value);
        }
        return newDataset;
    }

    private byte[] generateGraph() {
        JFreeChart chart = ChartFactory.createPieChart3D((String)"", (PieDataset)this.dataset, (boolean)false, (boolean)false, (boolean)false);
        PiePlot3D plot = (PiePlot3D)chart.getPlot();
        plot.setDarkerSides(true);
        plot.setDepthFactor(0.1);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ChartUtilities.writeChartAsPNG((OutputStream)baos, (JFreeChart)chart, (int)1000, (int)500);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return baos.toByteArray();
    }
}

