/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.stats.chart;

import com.neogls.prism.central.vaadin.util.vaadin.CachedInputStreamFactory;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.InputStreamFactory;
import com.vaadin.flow.server.StreamResource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class BarChart
extends Div {
    private final String chartTitle;
    private final String axisTitle;
    private final CategoryDataset dataset;

    public BarChart(String chartTitle, String axisTitle, Map<String, ? extends Number> valeurs) {
        this.chartTitle = chartTitle;
        this.axisTitle = axisTitle;
        this.dataset = this.createDataset(valeurs);
        this.add(new Component[]{new Image((AbstractStreamResource)new StreamResource("chart.png", (InputStreamFactory)new CachedInputStreamFactory(() -> this.generateChart())), "")});
    }

    private CategoryDataset createDataset(Map<String, ? extends Number> valeurs) {
        DefaultCategoryDataset newDataset = new DefaultCategoryDataset();
        valeurs.forEach((key, value) -> newDataset.addValue(value, (Comparable)((Object)""), (Comparable)((Object)key)));
        return newDataset;
    }

    private byte[] generateChart() {
        JFreeChart chart = ChartFactory.createBarChart((String)this.chartTitle, (String)this.getTranslation("stats.statistiques.chart.description", new Object[0]), (String)this.axisTitle, (CategoryDataset)this.dataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)false, (boolean)true, (boolean)false);
        chart.getCategoryPlot().getRenderer().setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator());
        chart.getCategoryPlot().getRenderer().setBaseItemLabelsVisible(true);
        NumberAxis rangeAxis = (NumberAxis)chart.getCategoryPlot().getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ChartUtilities.writeChartAsPNG((OutputStream)baos, (JFreeChart)chart, (int)1000, (int)500);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return baos.toByteArray();
    }
}

