/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.stats;

import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.Situation;
import com.geolocsystems.prismcentral.beans.EvenementStatistiqueBean;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.neogls.prism.central.vaadin.common.component.tabsheet.PrismTabSheet;
import com.neogls.prism.central.vaadin.layout.PrismLayout;
import com.neogls.prism.central.vaadin.view.mct.common.event.filter.EventFilter;
import com.neogls.prism.central.vaadin.view.mct.common.event.filter.EventFilterEditForm;
import com.neogls.prism.central.vaadin.view.mct.common.event.filter.EventFilterFormService;
import com.neogls.prism.central.vaadin.view.mct.common.event.filter.field.IVaadinEventFilterFieldFactory;
import com.neogls.prism.central.vaadin.view.stats.StatsService;
import com.neogls.prism.central.vaadin.view.stats.tab.StatsTabAxe;
import com.neogls.prism.central.vaadin.view.stats.tab.StatsTabCentre;
import com.neogls.prism.central.vaadin.view.stats.tab.StatsTabNature;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.router.Route;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.security.RolesAllowed;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@RolesAllowed(value={"ACTION_STATS_STATISTIQUES"})
@Route(value="stats/stats", layout=PrismLayout.class)
public class Stats
extends VerticalLayout {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Stats.class);
    private final StatsService service;
    private final EventFilterFormService eventFilterFormService;
    private final IVaadinEventFilterFieldFactory filterFieldFactory;
    private final IBusinessService businessService;
    private EventFilterEditForm filterForm = null;
    private EventFilter eventFilter = null;
    private final Button bSearch = new Button(this.getTranslation("report.ok", new Object[0]), arg_0 -> this.onSearchClicked(arg_0));
    private final HorizontalLayout controls = new HorizontalLayout();
    private final PrismTabSheet tabSheet = new PrismTabSheet();
    private final Map<String, EvenementStatistiqueBean> listeEvenements = new HashMap();

    @PostConstruct
    private void init() {
        Button bReturnToForm = new Button(this.getTranslation("statistiques.retour.form", new Object[0]), arg_0 -> this.onReturnToFormClicked(arg_0));
        Button bResetForm = new Button(this.getTranslation("statistiques.reinit.form", new Object[0]), arg_0 -> this.onResetFormClicked(arg_0));
        this.controls.add(new Component[]{bReturnToForm, bResetForm});
        this.tabSheet.setSizeFull();
        this.tabSheet.setMinHeight("0");
        this.showForm(Stats.createEmptyFilter());
        this.add(new Component[]{this.filterForm, this.bSearch, this.controls, this.tabSheet});
        this.setSizeFull();
    }

    private void onSearchClicked(ClickEvent<Button> event) {
        this.filterForm.setVisible(false);
        this.bSearch.setVisible(false);
        this.controls.setVisible(true);
        this.tabSheet.setVisible(true);
        this.eventFilter = this.filterForm.getValue();
        String aggregation = this.eventFilter.getSqlFilter().agregation;
        log.debug("STATS getEvenements d\u00e9but");
        long timeDebut = System.currentTimeMillis();
        List events = this.businessService.getEvenements(this.eventFilter.getSqlFilter(), this.eventFilter.getJavaFilters());
        log.debug("STATS getEvenements r\u00e9alis\u00e9 en {}ms", (Object)(System.currentTimeMillis() - timeDebut));
        this.listeEvenements.clear();
        for (Situation situation : events) {
            if (situation.getEvenements().isEmpty()) continue;
            Evenement evenement = (Evenement)situation.getEvenements().get(0);
            this.ajouterStatistiques(evenement, aggregation);
        }
        this.afficheStatistiques(aggregation);
    }

    private String ajouterStatistiques(Evenement evenement, String aggregation) {
        switch (aggregation) {
            case "Centre": {
                this.ajouterStatistiquesCentre(evenement, aggregation);
                break;
            }
            case "Nature": {
                this.ajouterStatistiquesNature(evenement, aggregation);
                break;
            }
            case "Axe": {
                this.ajouterStatistiquesAxe(evenement, aggregation);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected aggregation value: '" + aggregation + "'");
            }
        }
        if (evenement.getCei() != null) {
            return evenement.getCei();
        }
        return "";
    }

    private void ajouterStatistiquesCentre(Evenement evenement, String aggregation) {
        EvenementStatistiqueBean evenementStatistiqueBean;
        if (this.listeEvenements.containsKey(evenement.getCei())) {
            evenementStatistiqueBean = (EvenementStatistiqueBean)this.listeEvenements.get(evenement.getCei());
            evenementStatistiqueBean.AjouterEvenement(evenement);
        } else {
            evenementStatistiqueBean = new EvenementStatistiqueBean(evenement, aggregation);
            if (evenementStatistiqueBean.getCentre() == null) {
                evenementStatistiqueBean.setCentre(this.getTranslation("stats.statistiques.autre", new Object[0]));
            }
        }
        evenementStatistiqueBean.setNatureLibelle(this.service.getNatureLabel(evenementStatistiqueBean));
        this.listeEvenements.put(evenement.getCei(), evenementStatistiqueBean);
        if (!"".equals(evenement.getCei())) {
            EvenementStatistiqueBean evenementStatistiqueBeanTotal;
            if (this.listeEvenements.containsKey("")) {
                evenementStatistiqueBeanTotal = (EvenementStatistiqueBean)this.listeEvenements.get("");
                evenementStatistiqueBeanTotal.AjouterEvenement(evenement);
            } else {
                evenementStatistiqueBeanTotal = new EvenementStatistiqueBean(evenement, aggregation);
            }
            evenementStatistiqueBeanTotal.setCentre(this.getTranslation("stats.statistiques.tous", new Object[0]));
            this.listeEvenements.put("", evenementStatistiqueBeanTotal);
        }
    }

    private void ajouterStatistiquesNature(Evenement evenement, String aggregation) {
        EvenementStatistiqueBean evenementStatistiqueBean;
        if (this.listeEvenements.containsKey(evenement.getValeurNature().getCode())) {
            evenementStatistiqueBean = (EvenementStatistiqueBean)this.listeEvenements.get(evenement.getValeurNature().getCode());
            evenementStatistiqueBean.AjouterEvenement(evenement);
        } else {
            evenementStatistiqueBean = new EvenementStatistiqueBean(evenement, aggregation);
        }
        evenementStatistiqueBean.setNatureLibelle(this.service.getNatureLabel(evenementStatistiqueBean));
        this.listeEvenements.put(evenement.getValeurNature().getCode(), evenementStatistiqueBean);
        if (!"".equals(evenement.getValeurNature().getCode())) {
            EvenementStatistiqueBean evenementStatistiqueBeanTotal;
            if (this.listeEvenements.containsKey("")) {
                evenementStatistiqueBeanTotal = (EvenementStatistiqueBean)this.listeEvenements.get("");
                evenementStatistiqueBeanTotal.AjouterEvenement(evenement);
                evenementStatistiqueBeanTotal.setNature("Tous");
            } else {
                evenementStatistiqueBeanTotal = new EvenementStatistiqueBean(evenement, aggregation);
                evenementStatistiqueBeanTotal.setNature("Tous");
            }
            this.listeEvenements.put("", evenementStatistiqueBeanTotal);
        }
    }

    private void ajouterStatistiquesAxe(Evenement evenement, String aggregation) {
        EvenementStatistiqueBean evenementStatistiqueBean;
        if (this.listeEvenements.containsKey(evenement.getLocalisation().getAxe())) {
            evenementStatistiqueBean = (EvenementStatistiqueBean)this.listeEvenements.get(evenement.getLocalisation().getAxe());
            evenementStatistiqueBean.AjouterEvenement(evenement);
        } else {
            evenementStatistiqueBean = new EvenementStatistiqueBean(evenement, aggregation);
        }
        evenementStatistiqueBean.setNatureLibelle(this.service.getNatureLabel(evenementStatistiqueBean));
        this.listeEvenements.put(evenement.getLocalisation().getAxe(), evenementStatistiqueBean);
        if (!"".equals(evenement.getLocalisation().getAxe())) {
            EvenementStatistiqueBean evenementStatistiqueBeanTotal;
            if (this.listeEvenements.containsKey("")) {
                evenementStatistiqueBeanTotal = (EvenementStatistiqueBean)this.listeEvenements.get("");
                evenementStatistiqueBeanTotal.AjouterEvenement(evenement);
            } else {
                evenementStatistiqueBeanTotal = new EvenementStatistiqueBean(evenement, aggregation);
            }
            this.listeEvenements.put("", evenementStatistiqueBeanTotal);
        }
    }

    private void afficheStatistiques(String aggregation) {
        this.tabSheet.removeAll();
        switch (aggregation) {
            case "Centre": {
                this.afficheStatistiquesCentre();
                break;
            }
            case "Nature": {
                this.afficheStatistiquesNature();
                break;
            }
            case "Axe": {
                this.afficheStatistiquesAxe();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected aggregation value: '" + aggregation + "'");
            }
        }
    }

    private void afficheStatistiquesCentre() {
        if (this.listeEvenements.containsKey("")) {
            this.afficheStatistiqueCentre("");
        }
        this.listeEvenements.keySet().stream().filter(Objects::nonNull).filter(Predicate.not(String::isEmpty)).forEach(arg_0 -> this.afficheStatistiqueCentre(arg_0));
        if (this.listeEvenements.containsKey(null)) {
            this.afficheStatistiqueCentre(null);
        }
    }

    private void afficheStatistiqueCentre(String key) {
        StatsTabCentre statsTab = new StatsTabCentre(key, (EvenementStatistiqueBean)this.listeEvenements.get(key), this.businessService.getNatures(), this.eventFilter);
        this.tabSheet.add(statsTab.getTitle(), (Component)statsTab);
    }

    private void afficheStatistiquesNature() {
        if (this.listeEvenements.containsKey("")) {
            this.afficheStatistiqueNature("");
        }
        this.listeEvenements.keySet().stream().filter(Objects::nonNull).filter(Predicate.not(String::isEmpty)).forEach(arg_0 -> this.afficheStatistiqueNature(arg_0));
        if (this.listeEvenements.containsKey(null)) {
            this.afficheStatistiqueNature(null);
        }
    }

    private void afficheStatistiqueNature(String key) {
        StatsTabNature statsTab = new StatsTabNature(key, (EvenementStatistiqueBean)this.listeEvenements.get(key), this.businessService.getNatures(), this.eventFilter);
        this.tabSheet.add(statsTab.getTitle(), (Component)statsTab);
    }

    private void afficheStatistiquesAxe() {
        if (this.listeEvenements.containsKey("")) {
            this.afficheStatistiqueAxe("");
        }
        this.listeEvenements.keySet().stream().filter(Objects::nonNull).filter(Predicate.not(String::isEmpty)).forEach(arg_0 -> this.afficheStatistiqueAxe(arg_0));
        if (this.listeEvenements.containsKey(null)) {
            this.afficheStatistiqueAxe(null);
        }
    }

    private void afficheStatistiqueAxe(String key) {
        StatsTabAxe statsTab = new StatsTabAxe(key, (EvenementStatistiqueBean)this.listeEvenements.get(key), this.businessService.getNatures(), this.eventFilter);
        this.tabSheet.add(statsTab.getTitle(), (Component)statsTab);
    }

    private void onReturnToFormClicked(ClickEvent<Button> buttonClickEvent) {
        this.showForm(this.eventFilter);
    }

    private void onResetFormClicked(ClickEvent<Button> buttonClickEvent) {
        this.showForm(Stats.createEmptyFilter());
    }

    private void showForm(EventFilter filter) {
        EventFilterEditForm oldForm = this.filterForm;
        this.filterForm = new EventFilterEditForm(filter, List.of(Integer.valueOf(-1)), this.eventFilterFormService, this.filterFieldFactory, true);
        this.filterForm.addClassNames(new String[]{"mx-auto", "min-h-0"});
        if (oldForm != null) {
            this.replace((Component)oldForm, (Component)this.filterForm);
        }
        this.filterForm.setVisible(true);
        this.bSearch.setVisible(true);
        this.controls.setVisible(false);
        this.tabSheet.setVisible(false);
    }

    private static EventFilter createEmptyFilter() {
        return EventFilter.builder().unlocalizedName("").sqlFilter(IBusinessService.EvenementFiltre.byDelegation(null, null)).build();
    }

    @Generated
    public Stats(StatsService service, EventFilterFormService eventFilterFormService, IVaadinEventFilterFieldFactory filterFieldFactory, IBusinessService businessService) {
        this.service = service;
        this.eventFilterFormService = eventFilterFormService;
        this.filterFieldFactory = filterFieldFactory;
        this.businessService = businessService;
    }
}

