/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.publish;

import com.geolocsystems.prismandroid.model.evenements.DescriptionNature;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.beans.ReformulationDescription;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.neogls.prism.central.vaadin.service.ConfigurationService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class EventPublishDialogService {
    private final IBusinessService businessService;
    private final ConfigurationService configurationService;

    public void publierEvenement(Evenement event, String ligne1, String ligne2, String ligne3, String ligne4, String ligne5) {
        this.businessService.publierEvenement(event, ligne1, ligne2, ligne3, ligne4, ligne5);
    }

    public void lireEvenement(Evenement event) {
        this.businessService.lireEvenement(event);
    }

    public Nature getNature(String nature) {
        return (Nature)this.businessService.getNatures().get(nature);
    }

    public Map<String, String[]> getValeursReformulation() {
        return this.businessService.getValeursReformulation();
    }

    public HashMap<String, String> getSavePublicationEvenement(Evenement event) {
        return this.businessService.getSavePublicationEvenement(event);
    }

    public int getPublicationMax() {
        return this.configurationService.getInt(ConfigurationService.ConfigurationType.DATABASE, "publicationLongueurLigneMax").orElse(35);
    }

    public void saveGetPublicationEvenement(Evenement event, String type1, String complement1, String valeurLigne1, String type2, String complement2, String valeurLigne2, String type3, String complement3, String valeurLigne3, String type4, String complement4, String valeurLigne4, String type5, String complement5, String valeurLigne5) {
        this.businessService.saveGetPublicationEvenement(event, type1, complement1, valeurLigne1, type2, complement2, valeurLigne2, type3, complement3, valeurLigne3, type4, complement4, valeurLigne4, type5, complement5, valeurLigne5);
    }

    public String getPublicationValeurPeriode(Evenement event) {
        return this.businessService.getPublicationValeurPeriode(event);
    }

    public ReformulationDescription getReformulation(Evenement event) {
        List listeDesc = (List)this.businessService.getDescriptionsNatureMap().get(event.getValeurNature().getCode());
        DescriptionNature descriptionNature = null;
        String libelleDescription = event.getValeurNature().getDescription().getValeur();
        for (DescriptionNature d : listeDesc) {
            if (!d.getLibelle().equals(libelleDescription)) continue;
            descriptionNature = d;
            break;
        }
        String codeDescription = descriptionNature.getCode();
        ReformulationDescription reformulation = (ReformulationDescription)this.businessService.getReformulations().get(codeDescription);
        if (reformulation == null) {
            Log.debug((Object)("Reformulation non configur\u00e9 pour la description " + codeDescription));
            reformulation = new ReformulationDescription();
            reformulation.setCode(codeDescription);
            reformulation.setCodeNature(event.getValeurNature().getCode());
            reformulation.setLibelle(descriptionNature.getLibelle());
        }
        return reformulation;
    }

    @Generated
    public EventPublishDialogService(IBusinessService businessService, ConfigurationService configurationService) {
        this.businessService = businessService;
        this.configurationService = configurationService;
    }
}

