/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.publish;

import com.geolocsystems.deepcopyutil.DeepCopy;
import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismandroid.model.evenements.champs.Champ;
import com.geolocsystems.prismandroid.model.evenements.champs.IComposantFactory;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.beans.ReformulationDescription;
import com.geolocsystems.prismcentral.export.PublicationComposantFactory;
import com.neogls.prism.central.vaadin.view.publish.EventPublishDialog;
import com.neogls.prism.central.vaadin.view.publish.EventPublishDialogService;
import com.vaadin.componentfactory.gridlayout.GridLayout;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.html.NativeLabel;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.server.Command;
import gls.outils.GLS;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EventPublishDialog
extends Dialog {
    private Evenement e;
    private Map<String, Champ> champs;
    private Map<String, String> valeursChamps;
    private List<ValeurLabelString> champsItems;
    private Map<String, ValeurLabelString> champsItemsMap;
    private EventPublishDialogService service;
    private List<ValeurLabelInt> typesItems;
    private Map<String, ValeurLabelInt> typesItemsMap;
    private LigneFormulation ligne1;
    private LigneFormulation ligne2;
    private LigneFormulation ligne3;
    private LigneFormulation ligne4;
    private LigneFormulation ligne5;
    private List<LigneFormulation> lignesFormulation;
    private Nature nature;
    private ReformulationDescription reformulation;
    private IComposantFactory factory;
    private boolean estErreur = false;
    private NativeLabel erreur;
    private int longueurMax;

    public EventPublishDialog(EventPublishDialogService service, Evenement evenement) {
        this.e = evenement;
        this.service = service;
        this.reformulation = service.getReformulation(evenement);
        this.nature = (Nature)DeepCopy.copy((Object)service.getNature(this.reformulation.getCodeNature()));
        this.nature.chargerValeurs(this.e.getValeurNature());
        this.factory = new PublicationComposantFactory(service.getValeursReformulation());
        this.setHeaderTitle(this.getTranslation("publication.title", new Object[0]));
        FormLayout layoutContent = new FormLayout();
        layoutContent.setResponsiveSteps(List.of(new FormLayout.ResponsiveStep("0px", 1)));
        NativeLabel manuel = new NativeLabel(this.getTranslation("publication.manual", new Object[0]));
        layoutContent.addFormItem((Component)manuel, "");
        this.valeursChamps = MetierCommun.getMapView((Nature)this.nature, (IComposantFactory)this.factory);
        this.champs = MetierCommun.getChamps((Nature)this.nature);
        this.champsItems = new ArrayList();
        this.champsItemsMap = new HashMap();
        for (Champ champ : this.champs.values()) {
            ValeurLabelString item = new ValeurLabelString(this, champ.getNom(), champ.getLibelle());
            this.champsItems.add(item);
            this.champsItemsMap.put(item.valeur, item);
        }
        this.typesItems = new ArrayList();
        this.typesItemsMap = new HashMap();
        for (Object type : (Object)ReformulationDescription.TYPES) {
            ValeurLabelInt item = new ValeurLabelInt(this, (int)type, this.getTranslation("admin.publication.type." + (int)type, new Object[0]));
            this.typesItems.add(item);
            this.typesItemsMap.put(item.label, item);
            this.typesItemsMap.put("" + (int)type, item);
        }
        HashMap lignes = service.getSavePublicationEvenement(this.e);
        this.ligne1 = this.creerLigne(1, new LigneFormulation(this));
        this.ligne2 = this.creerLigne(2, new LigneFormulation(this));
        this.ligne3 = this.creerLigne(3, new LigneFormulation(this));
        this.ligne4 = this.creerLigne(4, new LigneFormulation(this));
        this.ligne5 = this.creerLigne(5, new LigneFormulation(this));
        this.lignesFormulation = new ArrayList();
        this.lignesFormulation.add(this.ligne1);
        this.lignesFormulation.add(this.ligne2);
        this.lignesFormulation.add(this.ligne3);
        this.lignesFormulation.add(this.ligne4);
        this.lignesFormulation.add(this.ligne5);
        this.lignesFormulation.forEach(l -> layoutContent.addFormItem((Component)l.ligne, ""));
        this.longueurMax = service.getPublicationMax();
        this.erreur = new NativeLabel(this.getTranslation("publication.erreur", new Object[0]).replace("%longueurMax%", "" + this.longueurMax));
        this.erreur.setVisible(false);
        if (!lignes.isEmpty()) {
            this.ligne1.type.setValue(this.typesItemsMap.get(lignes.get("type1")));
            this.ligne1.complement.setValue(this.champsItemsMap.get(lignes.get("complement1")));
            this.ligne1.ancienneValeur.setValue((String)lignes.get("valeur1"));
            this.ligne2.type.setValue(this.typesItemsMap.get(lignes.get("type2")));
            this.ligne2.complement.setValue(this.champsItemsMap.get(lignes.get("complement2")));
            this.ligne2.ancienneValeur.setValue((String)lignes.get("valeur2"));
            this.ligne3.type.setValue(this.typesItemsMap.get(lignes.get("type3")));
            this.ligne3.complement.setValue(this.champsItemsMap.get(lignes.get("complement3")));
            this.ligne3.ancienneValeur.setValue((String)lignes.get("valeur3"));
            this.ligne4.type.setValue(this.typesItemsMap.get(lignes.get("type4")));
            this.ligne4.complement.setValue(this.champsItemsMap.get(lignes.get("complement4")));
            this.ligne4.ancienneValeur.setValue((String)lignes.get("valeur4"));
            this.ligne5.type.setValue(this.typesItemsMap.get(lignes.get("type5")));
            this.ligne5.complement.setValue(this.champsItemsMap.get(lignes.get("complement5")));
            this.ligne5.ancienneValeur.setValue((String)lignes.get("valeur5"));
            this.lignesFormulation.forEach(l -> this.majAncienneValeurLigneReformulation(l));
        }
        this.estErreur = this.estEnErreur();
        layoutContent.add(new Component[]{this.erreur});
        HorizontalLayout buttons = new HorizontalLayout();
        Button cancel = new Button(this.getTranslation("admin.cancel", new Object[0]));
        cancel.setWidth(30.0f, Unit.PERCENTAGE);
        cancel.setHeight(30.0f, Unit.PIXELS);
        buttons.add(new Component[]{cancel});
        Button save = new Button(this.getTranslation("mct.action.publish", new Object[0]));
        save.setWidth(30.0f, Unit.PERCENTAGE);
        save.setHeight(30.0f, Unit.PIXELS);
        buttons.add(new Component[]{save});
        buttons.setAlignItems(FlexComponent.Alignment.CENTER);
        this.add(new Component[]{layoutContent});
        this.add(new Component[]{buttons});
        save.addClickListener((ComponentEventListener & Serializable)e -> this.publish());
        cancel.addClickListener((ComponentEventListener & Serializable)e -> this.close());
        this.setWidth(700.0f, Unit.PIXELS);
    }

    public boolean estErreur() {
        return this.estErreur;
    }

    private void ligneEnErreur(LigneFormulation l) {
        try {
            l.erreur = true;
            UI.getCurrent().access((Command & Serializable)() -> l.label.setClassName("puberreur"));
            UI.getCurrent().access((Command & Serializable)() -> l.valeur.setClassName("publication-trop-long"));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void ligneOk(LigneFormulation l) {
        try {
            l.erreur = false;
            UI.getCurrent().access((Command & Serializable)() -> l.label.setClassName("pubmodif"));
            UI.getCurrent().access((Command & Serializable)() -> l.valeur.setClassName("publication-modif"));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void majAncienneValeurLigneReformulation(LigneFormulation l) {
        boolean modif = !GLS.egal((String)l.valeur.getValue(), (String)l.ancienneValeur.getValue());
        l.ancienneValeur.setVisible(true);
        l.ancienneValeur.setEnabled(false);
        if (modif) {
            if (!l.erreur) {
                this.ligneOk(l);
            } else {
                this.ligneEnErreur(l);
            }
        } else if (!l.erreur) {
            this.ligneOk(l);
        } else {
            this.ligneEnErreur(l);
        }
    }

    private boolean estEnErreur(LigneFormulation l) {
        String v = l.valeur.getValue();
        boolean erreur = v.length() > this.longueurMax;
        return erreur;
    }

    private boolean estEnErreur() {
        boolean haserreur = false;
        boolean uneValeurEstRemplie = false;
        for (LigneFormulation l : this.lignesFormulation) {
            if (!uneValeurEstRemplie && !l.valeur.isEmpty()) {
                uneValeurEstRemplie = true;
            }
            if (this.estEnErreur(l)) {
                haserreur = true;
                this.ligneEnErreur(l);
                continue;
            }
            this.ligneOk(l);
        }
        if (!uneValeurEstRemplie) {
            haserreur = true;
        }
        this.estErreur = haserreur;
        return this.estErreur;
    }

    public void publish() {
        boolean haserreur = this.estEnErreur();
        if (haserreur) {
            this.erreur.setVisible(true);
        } else {
            this.service.publierEvenement(this.e, this.ligne1.valeur.getValue(), this.ligne2.valeur.getValue(), this.ligne3.valeur.getValue(), this.ligne4.valeur.getValue(), this.ligne5.valeur.getValue());
            this.e.setLu(true);
            this.service.lireEvenement(this.e);
            int type1 = ((ValeurLabelInt)this.ligne1.type.getValue()).valeur;
            String complement1 = this.ligne1.complement.getValue() != null ? ((ValeurLabelString)this.ligne1.complement.getValue()).valeur : "";
            int type2 = ((ValeurLabelInt)this.ligne2.type.getValue()).valeur;
            String complement2 = this.ligne2.complement.getValue() != null ? ((ValeurLabelString)this.ligne2.complement.getValue()).valeur : "";
            int type3 = ((ValeurLabelInt)this.ligne3.type.getValue()).valeur;
            String complement3 = this.ligne3.complement.getValue() != null ? ((ValeurLabelString)this.ligne3.complement.getValue()).valeur : "";
            int type4 = ((ValeurLabelInt)this.ligne4.type.getValue()).valeur;
            String complement4 = this.ligne4.complement.getValue() != null ? ((ValeurLabelString)this.ligne4.complement.getValue()).valeur : "";
            int type5 = ((ValeurLabelInt)this.ligne5.type.getValue()).valeur;
            String complement5 = this.ligne5.complement.getValue() != null ? ((ValeurLabelString)this.ligne5.complement.getValue()).valeur : "";
            this.service.saveGetPublicationEvenement(this.e, "" + type1, complement1, this.ligne1.valeur.getValue(), "" + type2, complement2, this.ligne2.valeur.getValue(), "" + type3, complement3, this.ligne3.valeur.getValue(), "" + type4, complement4, this.ligne4.valeur.getValue(), "" + type5, complement5, this.ligne5.valeur.getValue());
            this.close();
        }
    }

    private LigneFormulation creerLigne(int indice, LigneFormulation ligneFormulation) {
        HorizontalLayout ligne = new HorizontalLayout();
        ligne.addClassName("publication-ligne");
        ligne.setWidth(500.0f, Unit.PIXELS);
        NativeLabel label = new NativeLabel(this.getTranslation("publication.ligne", new Object[0]) + " " + indice);
        label.setSizeUndefined();
        ligne.add(new Component[]{label});
        ligne.setVerticalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{label});
        GridLayout partieDroite = new GridLayout(2, 3);
        partieDroite.setWidth(350.0f, Unit.PIXELS);
        ComboBox typeBox = new ComboBox();
        typeBox.setWidth(50.0f, Unit.PERCENTAGE);
        int typeReformulation = this.reformulation.getType(indice);
        int indiceTypeReformulation = GLS.getIndiceObjetListe((List)this.typesItems, (Object)typeReformulation);
        typeBox.setItems((Collection)this.typesItems);
        if (indiceTypeReformulation == -1) {
            typeBox.setValue((Object)((ValeurLabelInt)this.typesItems.get(0)));
        } else {
            typeBox.setValue((Object)((ValeurLabelInt)this.typesItems.get(indiceTypeReformulation)));
        }
        typeBox.setSizeFull();
        partieDroite.addComponent((Component)typeBox, 0, 0);
        ComboBox champBox = new ComboBox();
        champBox.setItems((Collection)this.champsItems);
        champBox.setWidth(50.0f, Unit.PERCENTAGE);
        if (((ValeurLabelInt)typeBox.getValue()).valeur == 4) {
            ValeurLabelString champSelectionne = (ValeurLabelString)this.champsItemsMap.get(this.reformulation.getValeur(indice));
            if (champSelectionne == null) {
                champSelectionne = (ValeurLabelString)this.champsItems.get(0);
            }
            champBox.setValue((Object)champSelectionne);
        } else {
            champBox.setVisible(false);
            champBox.setValue(this.champsItems.get(0));
        }
        champBox.setSizeFull();
        partieDroite.addComponent((Component)champBox, 1, 0);
        TextField ligneTextField = new TextField();
        ligneTextField.setWidth(100.0f, Unit.PERCENTAGE);
        partieDroite.addComponent((Component)ligneTextField, 0, 1, 1, 1);
        ligneTextField.addKeyDownListener((ComponentEventListener & Serializable)e -> this.changeTextePublication(ligneFormulation));
        TextField ligneAncienTextField = new TextField();
        ligneAncienTextField.setWidth(100.0f, Unit.PERCENTAGE);
        ligneAncienTextField.setEnabled(false);
        partieDroite.addComponent((Component)ligneAncienTextField, 0, 2, 1, 2);
        ligne.add(new Component[]{partieDroite});
        if (((ValeurLabelInt)typeBox.getValue()).valeur == 0) {
            ligneTextField.setEnabled(false);
        }
        champBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.listenerReformulation(typeBox, champBox, ligneTextField, indice));
        typeBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.listenerReformulation(typeBox, champBox, ligneTextField, indice));
        ligneFormulation.ligne = ligne;
        ligneFormulation.valeur = ligneTextField;
        ligneFormulation.ancienneValeur = ligneAncienTextField;
        ligneFormulation.type = typeBox;
        ligneFormulation.complement = champBox;
        ligneFormulation.label = label;
        ligneFormulation.erreur = false;
        ligneFormulation.indice = indice;
        this.listenerReformulation(typeBox, champBox, ligneTextField, indice);
        return ligneFormulation;
    }

    private String getLibelleLigne(LigneFormulation l) {
        String libelle = this.getTranslation("publication.ligne", new Object[0]) + " " + l.indice;
        if (l.erreur) {
            libelle = libelle + " \n (" + l.valeur.getValue().length() + " > " + this.longueurMax + ")";
        }
        return libelle;
    }

    private void changeTextePublication(LigneFormulation l) {
        boolean erreur = this.estEnErreur(l);
        int nb = l.valeur.getValue().length();
        if (erreur) {
            if (!l.erreur) {
                this.ligneEnErreur(l);
            } else {
                UI.getCurrent().access((Command & Serializable)() -> l.label.setText(this.getLibelleLigne(l)));
            }
        } else if (!erreur && l.erreur) {
            this.ligneOk(l);
            UI.getCurrent().access((Command & Serializable)() -> l.label.setText(this.getLibelleLigne(l)));
        }
    }

    private void listenerReformulation(ComboBox typeBox, ComboBox champBox, TextField ligneTextField, int indice) {
        int type = ((ValeurLabelInt)typeBox.getValue()).valeur;
        switch (type) {
            case 0: {
                champBox.setVisible(false);
                ligneTextField.setEnabled(false);
                ligneTextField.setValue("");
                break;
            }
            case 1: {
                champBox.setVisible(false);
                ligneTextField.setEnabled(true);
                ligneTextField.setValue(this.nature.getLabel());
                break;
            }
            case 2: {
                champBox.setVisible(false);
                ligneTextField.setEnabled(true);
                ligneTextField.setValue(this.reformulation.getLibelle());
                break;
            }
            case 3: {
                champBox.setVisible(false);
                ligneTextField.setEnabled(true);
                ligneTextField.setValue(this.reformulation.getValeur(indice));
                break;
            }
            case 4: {
                champBox.setVisible(true);
                ligneTextField.setEnabled(true);
                if (champBox.getValue() != null) {
                    ligneTextField.setValue(this.getValeurChamp(((ValeurLabelString)champBox.getValue()).valeur));
                    break;
                }
                ligneTextField.setValue("");
                break;
            }
            case 5: {
                champBox.setVisible(false);
                ligneTextField.setEnabled(true);
                ligneTextField.setValue(this.service.getPublicationValeurPeriode(this.e));
                break;
            }
        }
    }

    protected String getValeurChamp(String nomChamp) {
        if (this.valeursChamps.containsKey(nomChamp)) {
            String valeur = (String)this.valeursChamps.get(nomChamp);
            return valeur == null ? "" : valeur;
        }
        Log.error((Object)("impossible de trouver le champ configur\u00e9 " + nomChamp));
        return "";
    }
}

