/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.vh;

import com.geolocsystems.prismcentral.beans.TronconSuivi;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.neogls.prism.central.vaadin.service.ConfigurationService;
import com.neogls.prism.central.vaadin.service.event.EventService;
import com.neogls.prism.central.vaadin.view.mct.common.event.filter.field.IVaadinEventFilterFieldFactory;
import com.neogls.prism.central.vaadin.view.mct.common.event.sort.EventSortService;
import com.neogls.prism.central.vaadin.view.mct.vh.MctVhEventMctListService;
import com.neogls.prism.central.vaadin.view.mct.vh.MctVhPatrolMctListService;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class MctVhService {
    private final MctVhEventMctListService eventMctListService;
    private final IVaadinEventFilterFieldFactory eventFilterFieldFactory;
    private final EventSortService eventSortService;
    private final EventService eventService;
    private final MctVhPatrolMctListService patrolMctListService;
    private final IBusinessService businessService;
    private final ConfigurationService configurationService;

    public Collection<TronconSuivi> getTronconsSuivis(Set<String> patrolIds) {
        Collection tronconsPatrouilles = CollectionUtils.emptyIfNull((Collection)this.businessService.getTronconsPatrouilles(patrolIds));
        if (this.vhCanSaltOrPlow()) {
            return Stream.concat(CollectionUtils.emptyIfNull((Collection)this.businessService.getTronconsSalageDeneigementActif(patrolIds)).stream(), tronconsPatrouilles.stream()).toList();
        }
        return tronconsPatrouilles;
    }

    private boolean vhCanSaltOrPlow() {
        List vhActions = this.configurationService.getList(ConfigurationService.ConfigurationType.DATABASE, "actionsVH").orElse(List.of());
        return this.patrolMctListService.getBusinessModuleCodes().contains(1000) || vhActions.contains("den") || vhActions.contains("SAL");
    }

    @Generated
    public MctVhService(MctVhEventMctListService eventMctListService, IVaadinEventFilterFieldFactory eventFilterFieldFactory, EventSortService eventSortService, EventService eventService, MctVhPatrolMctListService patrolMctListService, IBusinessService businessService, ConfigurationService configurationService) {
        this.eventMctListService = eventMctListService;
        this.eventFilterFieldFactory = eventFilterFieldFactory;
        this.eventSortService = eventSortService;
        this.eventService = eventService;
        this.patrolMctListService = patrolMctListService;
        this.businessService = businessService;
        this.configurationService = configurationService;
    }

    @Generated
    public MctVhEventMctListService getEventMctListService() {
        return this.eventMctListService;
    }

    @Generated
    public IVaadinEventFilterFieldFactory getEventFilterFieldFactory() {
        return this.eventFilterFieldFactory;
    }

    @Generated
    public EventSortService getEventSortService() {
        return this.eventSortService;
    }

    @Generated
    public EventService getEventService() {
        return this.eventService;
    }

    @Generated
    public MctVhPatrolMctListService getPatrolMctListService() {
        return this.patrolMctListService;
    }
}

