/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.vh;

import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismcentral.beans.TronconSuivi;
import com.geolocsystems.prismcentral.beans.VehiculeEnIntervention;
import com.neogls.prism.central.vaadin.layout.PrismLayout;
import com.neogls.prism.central.vaadin.service.ConfigurationService;
import com.neogls.prism.central.vaadin.service.NatureService;
import com.neogls.prism.central.vaadin.service.i18n.PrismI18NProvider;
import com.neogls.prism.central.vaadin.util.MctListUtil;
import com.neogls.prism.central.vaadin.view.mct.common.CommonMct;
import com.neogls.prism.central.vaadin.view.mct.common.ICartoPane;
import com.neogls.prism.central.vaadin.view.mct.common.LeftSidePane;
import com.neogls.prism.central.vaadin.view.mct.common.bottomsidepane.BottomSidePane;
import com.neogls.prism.central.vaadin.view.mct.common.bottomsidepane.Slot;
import com.neogls.prism.central.vaadin.view.mct.common.carto.cluster.ClusterCartoPaneFactory;
import com.neogls.prism.central.vaadin.view.mct.common.carto.layer.PrismLayerFactory;
import com.neogls.prism.central.vaadin.view.mct.common.carto.layer.TronconVhLayer;
import com.neogls.prism.central.vaadin.view.mct.common.event.EventCreationTab;
import com.neogls.prism.central.vaadin.view.mct.common.event.eventsheetdialog.EventSheetDialogFactory;
import com.neogls.prism.central.vaadin.view.mct.common.event.filter.field.IVaadinEventFilterFieldFactory;
import com.neogls.prism.central.vaadin.view.mct.common.event.list.EventActionListener;
import com.neogls.prism.central.vaadin.view.mct.common.event.list.EventMctListService;
import com.neogls.prism.central.vaadin.view.mct.common.event.list.MctEventList;
import com.neogls.prism.central.vaadin.view.mct.common.event.list.impl.CommonEventActionListener;
import com.neogls.prism.central.vaadin.view.mct.common.event.sort.EventSortService;
import com.neogls.prism.central.vaadin.view.mct.common.list.MctCartoComponent;
import com.neogls.prism.central.vaadin.view.mct.common.list.MctList;
import com.neogls.prism.central.vaadin.view.mct.common.list.MctListItemsClearEvent;
import com.neogls.prism.central.vaadin.view.mct.common.list.MctListItemsLoadEvent;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.list.MctPatrolList;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.list.PatrolActionListener;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.list.PatrolMctListService;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.list.impl.CommonPatrolActionListener;
import com.neogls.prism.central.vaadin.view.mct.vh.MctVhService;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.router.HasDynamicTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.Nullable;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RolesAllowed(value={"ACTION_VH_SUIVI"})
@Route(value="vh/suivi", layout=PrismLayout.class)
public class MctVh
extends CommonMct
implements HasDynamicTitle {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MctVh.class);
    private final LeftSidePane leftSidePane = new LeftSidePane();
    private final ICartoPane cartoPane;
    private final BottomSidePane bottomSidePane;
    private final MctVhService mctVhService;
    private final NatureService natureService;
    private final EventSheetDialogFactory eventSheetDialogFactory;
    private final MctEventList<?> eventList;
    private final MctPatrolList patrolList;
    private final boolean affichageMapServer;
    @Nullable
    private final TronconVhLayer tronconVhLayer;
    private Slot slotNbPatrouilles;
    private Slot slotConditionsDeCirculation;

    public MctVh(ConfigurationService configurationService, MctVhService mctVhService, CommonEventActionListener eventActionListener, CommonPatrolActionListener patrolActionListener, NatureService natureService, PrismLayerFactory prismLayerFactory, PrismI18NProvider i18NProvider, ClusterCartoPaneFactory clusterCartoPaneFactory, EventSheetDialogFactory eventSheetDialogFactory) {
        super(configurationService);
        this.mctVhService = mctVhService;
        this.natureService = natureService;
        this.eventSheetDialogFactory = eventSheetDialogFactory;
        this.cartoPane = clusterCartoPaneFactory.newClusterCartoPane(Integer.valueOf(mctVhService.getEventMctListService().getPrimaryBusinessModuleCode()));
        this.cartoPane.addCartoLayer();
        this.eventList = MctListUtil.addMctEventList((CommonMct)this, (String)i18NProvider.findTranslation("mct.visu.vh", new Object[0]).orElse(this.getTranslation("mct.visu", new Object[0])), (EventMctListService)mctVhService.getEventMctListService(), (IVaadinEventFilterFieldFactory)mctVhService.getEventFilterFieldFactory(), (EventSortService)mctVhService.getEventSortService(), (MctCartoComponent)this.getCartoPane().getSituationCartoComponent(), (EventActionListener)eventActionListener);
        this.patrolList = MctListUtil.addMctPatrolList((CommonMct)this, (String)this.getTranslation("vh.vehicles", new Object[0]), (PatrolMctListService)mctVhService.getPatrolMctListService(), (MctCartoComponent)this.getCartoPane().getPatrolCartoComponent(), (PatrolActionListener)patrolActionListener);
        this.bottomSidePane = BottomSidePane.create();
        this.affichageMapServer = configurationService.getBoolean(ConfigurationService.ConfigurationType.DATABASE, "vh.suivi.mapserver").orElse(false);
        this.tronconVhLayer = this.affichageMapServer ? null : prismLayerFactory.createTronconVhLayer((PatrolMctListService)mctVhService.getPatrolMctListService());
    }

    protected void init() {
        List naturesForCreation = this.natureService.getNaturesForCreation(this.mctVhService.getEventMctListService().getPrimaryBusinessModuleCode(), List.of("etatvh"));
        if (!naturesForCreation.isEmpty()) {
            EventCreationTab creation = new EventCreationTab(naturesForCreation, this.mctVhService.getEventService(), this.eventSheetDialogFactory, this.cartoPane);
            creation.addEventCreationListener((ComponentEventListener & Serializable)event -> this.requestRefresh());
            this.getLeftSidePane().addTab(this.getTranslation("mct.create", new Object[0]), (Component)creation);
        }
        this.getLeftSidePane().setSelectedIndex(1);
        this.slotConditionsDeCirculation = this.bottomSidePane.getTab(BottomSidePane.DefaultTab.INFORMATIONS).newSlot();
        this.slotNbPatrouilles = this.bottomSidePane.getTab(BottomSidePane.DefaultTab.INFORMATIONS).newSlot();
        this.patrolList.addItemsClearListener(arg_0 -> this.onPatrolListItemsCleared(arg_0));
        this.patrolList.addItemsLoadListener(arg_0 -> this.onPatrolListItemsLoaded(arg_0));
        if (this.tronconVhLayer != null) {
            this.tronconVhLayer.addTo(this.cartoPane, "Trac\u00e9s");
        }
    }

    protected CompletableFuture<Void> refresh() {
        return CompletableFuture.allOf(this.eventList.refreshItems(), this.patrolList.refreshItems());
    }

    private void onPatrolListItemsCleared(MctListItemsClearEvent<VehiculeEnIntervention> event) {
        event.registerUiAccess(ui -> {
            this.getBottomSidePane().getTab(BottomSidePane.DefaultTab.INFORMATIONS).clear();
            if (this.tronconVhLayer != null) {
                this.tronconVhLayer.clearLayer();
            }
        });
    }

    private void onPatrolListItemsLoaded(MctListItemsLoadEvent<VehiculeEnIntervention> event) {
        Set patrolIds = ((MctList)event.getSource()).getItems().stream().map(VehiculeEnIntervention::getIdPatrouille).collect(Collectors.toSet());
        Collection tronconsSuivis = this.mctVhService.getTronconsSuivis(patrolIds);
        event.registerUiAccess(ui -> {
            this.updateBottomSidePaneInfo((Collection)((MctList)event.getSource()).getItems(), tronconsSuivis);
            if (this.tronconVhLayer != null) {
                this.tronconVhLayer.setTronconsSuivis(tronconsSuivis);
            }
        });
    }

    private void updateBottomSidePaneInfo(Collection<VehiculeEnIntervention> patrols, Collection<TronconSuivi> tronconsSuivis) {
        this.slotNbPatrouilles.setMessage("Nb de patrouilles : " + patrols.size());
        if (!tronconsSuivis.isEmpty()) {
            Map<String, Integer> longueurTroncons = tronconsSuivis.stream().collect(Collectors.groupingBy(TronconSuivi::getCode, Collectors.summingInt(TronconSuivi::getLongueur)));
            String drivingCondition = longueurTroncons.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entry -> this.getTranslation("header.label." + (String)entry.getKey(), new Object[0]) + " : " + MetierCommun.getLongueurPourAffichage((int)((Integer)entry.getValue()))).collect(Collectors.joining(", "));
            this.slotConditionsDeCirculation.setMessage("Conditions de circulations : " + drivingCondition);
        }
    }

    public LeftSidePane getLeftSidePane() {
        return this.leftSidePane;
    }

    protected BottomSidePane getBottomSidePane() {
        return this.bottomSidePane;
    }

    protected ICartoPane getCartoPane() {
        return this.cartoPane;
    }

    public String getPageTitle() {
        return this.getTranslation("vh.suivi.title", new Object[0]);
    }
}

