/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.tableaudebord;

import com.geolocsystems.prismcentral.data.IBusinessService;
import com.neogls.prism.central.vaadin.service.BusinessModuleService;
import com.neogls.prism.central.vaadin.service.ConfigurationService;
import com.neogls.prism.central.vaadin.service.UserPermissionService;
import com.neogls.prism.central.vaadin.view.mct.common.event.filter.EventFilter;
import com.neogls.prism.central.vaadin.view.mct.common.event.filter.EventFilterFormService;
import com.neogls.prism.central.vaadin.view.mct.common.event.list.AbstractEventMctListService;
import com.neogls.prism.central.vaadin.view.mct.common.event.list.EventActionListener;
import com.neogls.prism.central.vaadin.view.mct.common.event.list.EventDetailsGeneratorService;
import com.neogls.prism.central.vaadin.view.mct.common.event.list.EventListItemGeneratorService;
import com.neogls.prism.central.vaadin.view.mct.common.event.list.EventRetrieverService;
import com.neogls.prism.central.vaadin.view.mct.common.event.list.EventSelectionActionGeneratorService;
import java.util.Arrays;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class MctTdbEventMctListService
extends AbstractEventMctListService<EventActionListener> {
    private final ConfigurationService configurationService;
    private static final List<Integer> DEFAULT_MODULE_CODES = List.of(Integer.valueOf(0), Integer.valueOf(5));

    public MctTdbEventMctListService(IBusinessService businessService, UserPermissionService userPermissionService, BusinessModuleService businessModuleService, ConfigurationService configurationService, EventRetrieverService eventRetrieverService, EventListItemGeneratorService eventListItemGeneratorService, EventDetailsGeneratorService<EventActionListener> eventDetailsGeneratorService, EventSelectionActionGeneratorService<EventActionListener> eventSelectionActionGeneratorService, EventFilterFormService eventFilterFormService) {
        super(businessService, userPermissionService, businessModuleService, configurationService, eventRetrieverService, eventListItemGeneratorService, eventDetailsGeneratorService, eventSelectionActionGeneratorService, eventFilterFormService);
        this.configurationService = configurationService;
    }

    public EventFilter editFilterBeforeItemRequest(EventFilter filter) {
        filter.getSqlFilter().statistiques = this.configurationService.getBoolean(ConfigurationService.ConfigurationType.DATABASE, "afficherEvenementsSansCentre").orElse(false) == false;
        filter.getSqlFilter().evenementAssocies = this.configurationService.isBusinessModuleActive(5) || this.configurationService.isProgrammationTravauxActive();
        return filter;
    }

    public List<Integer> getBusinessModuleCodes() {
        String configuredModules = this.configurationService.getString(ConfigurationService.ConfigurationType.DATABASE, "mct.tableauDeBord.modules").orElse(null);
        if (configuredModules == null) {
            return DEFAULT_MODULE_CODES;
        }
        return Arrays.stream(configuredModules.split(",")).map(Integer::parseInt).toList();
    }

    public int getPrimaryBusinessModuleCode() {
        return (Integer)this.getBusinessModuleCodes().get(0);
    }
}

