/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.recherchepatrouille;

import com.geolocsystems.prismandroid.model.Centre;
import com.geolocsystems.prismandroid.model.Delegation;
import com.geolocsystems.prismcentral.beans.LocalisationPr;
import com.geolocsystems.prismcentral.data.ICartoService;
import com.neogls.prism.central.vaadin.common.component.ErrorDialog;
import com.neogls.prism.central.vaadin.common.component.PrismFormItem;
import com.neogls.prism.central.vaadin.common.component.dateinterval.DateRangePicker;
import com.neogls.prism.central.vaadin.common.component.delegationandcenterfield.DelegationAndCenter;
import com.neogls.prism.central.vaadin.common.component.delegationandcenterfield.DelegationAndCenterField;
import com.neogls.prism.central.vaadin.common.service.LeafletRenderService;
import com.neogls.prism.central.vaadin.service.LocationSearchService;
import com.neogls.prism.central.vaadin.service.bean.DateRange;
import com.neogls.prism.central.vaadin.service.security.AuthenticatedUser;
import com.neogls.prism.central.vaadin.util.LeafletUtils;
import com.neogls.prism.central.vaadin.view.mct.recherchepatrouille.MctRecherchePatrouilleFilter;
import com.neogls.prism.central.vaadin.view.mct.recherchepatrouille.TabRecherche;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.html.H1;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.notification.NotificationVariant;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.radiobutton.RadioGroupVariant;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.textfield.IntegerField;
import com.vaadin.flow.component.textfield.NumberField;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vaadin.addons.componentfactory.leaflet.LeafletMap;
import org.vaadin.addons.componentfactory.leaflet.layer.Layer;
import org.vaadin.addons.componentfactory.leaflet.layer.events.MouseEvent;
import org.vaadin.addons.componentfactory.leaflet.layer.ui.marker.Marker;
import org.vaadin.addons.componentfactory.leaflet.layer.vectors.Polyline;
import org.vaadin.addons.componentfactory.leaflet.types.Icon;
import org.vaadin.addons.componentfactory.leaflet.types.LatLng;
import org.vaadin.addons.componentfactory.leaflet.types.Point;

/*
 * Exception performing whole class analysis ignored.
 */
public class TabRecherche
extends VerticalLayout {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TabRecherche.class);
    private final LeafletMap map;
    private final LocationSearchService locationSearchService;
    private final LeafletRenderService leafletRenderService;
    private final DelegationAndCenterField delegationAndCenterField;
    private final RadioButtonGroup<DateType> dateTypeSelector = new RadioButtonGroup();
    private final DatePicker dateBefore = new DatePicker();
    private final DateRangePicker dateBetween = new DateRangePicker();
    private final Checkbox cbEnablePatrols = new Checkbox(this.getTranslation("report.explorateur.select.patrouille", new Object[0]), true);
    private final ComboBox<PatrolNumber> patrolNumberSelector = new ComboBox();
    private final Checkbox cbEnableEvents = new Checkbox(this.getTranslation("report.explorateur.select.evenement", new Object[0]));
    private final ComboBox<String> cbDepartement = new ComboBox(this.getTranslation("recherche.departement.label", new Object[0]));
    private final ComboBox<String> cbCommune = new ComboBox(this.getTranslation("recherche.commune.label", new Object[0]));
    private final ComboBox<String> cbAxe = new ComboBox(this.getTranslation("recherche.axe.label", new Object[0]));
    private final ComboBox<String> cbPr = new ComboBox(this.getTranslation("recherche.pr.label", new Object[0]));
    private final IntegerField tfAbs = new IntegerField(this.getTranslation("report.explorateur.select.abscisse", new Object[0]));
    private final IntegerField tfMaxDistance = new IntegerField(this.getTranslation("report.explorateur.distance", new Object[0]));
    private final Button bSelectOnMap = new Button("S\u00e9lectionner sur la carte", (Component)VaadinIcon.FLAG.create(), arg_0 -> this.onSelectOnMapClick(arg_0));
    private final NumberField fieldLat = new NumberField(this.getTranslation("generic.latitude", new Object[0]));
    private final NumberField fieldLng = new NumberField(this.getTranslation("generic.longitude", new Object[0]));
    private final AtomicReference<Layer> refLayerAxe = new AtomicReference();
    private final AtomicReference<Layer> refLayerCommune = new AtomicReference();
    private final AtomicReference<Layer> refLayerPr = new AtomicReference();
    private final AtomicReference<Layer> refLayerLocalisation = new AtomicReference();
    private boolean selectOnMap = false;

    public TabRecherche(LeafletMap map, LocationSearchService locationSearchService, LeafletRenderService leafletRenderService, Collection<Delegation> delegationAndCenters, AuthenticatedUser currentUser) {
        this.map = map;
        this.locationSearchService = locationSearchService;
        this.leafletRenderService = leafletRenderService;
        this.delegationAndCenterField = new DelegationAndCenterField(delegationAndCenters);
        this.initCenterDelegation(currentUser);
        this.initDate();
        this.initItems();
        this.initLocation();
        this.initSearchButton();
        this.addClassName("tab-recherche");
    }

    private void initCenterDelegation(AuthenticatedUser currentUser) {
        this.delegationAndCenterField.setDelegationPlaceholder(this.getTranslation("mct.filtre.delegation.toutes", new Object[0]));
        this.delegationAndCenterField.setCenterPlaceholder(this.getTranslation("mct.filtre.centre.tous", new Object[0]));
        this.delegationAndCenterField.setValue((Object)DelegationAndCenter.of((Delegation)currentUser.getDelegation(), (Centre)currentUser.getCentre()));
        if (currentUser.getCentre() != null) {
            this.delegationAndCenterField.setReadOnly(true);
        } else if (currentUser.getDelegation() != null) {
            this.delegationAndCenterField.setDelegationReadOnly();
        }
        this.add(new Component[]{new H1(this.getTranslation("report.explorateur.select.infos", new Object[0])), this.delegationAndCenterField});
    }

    private void initDate() {
        this.dateTypeSelector.setItemLabelGenerator((ItemLabelGenerator & Serializable)item -> this.getTranslation(item.getLabel(), new Object[0]));
        this.dateTypeSelector.addThemeVariants((ThemeVariant[])new RadioGroupVariant[]{RadioGroupVariant.LUMO_VERTICAL});
        this.dateTypeSelector.setItems((Object[])DateType.values());
        this.dateTypeSelector.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            this.dateBefore.setVisible(event.getValue() == DateType.BEFORE);
            this.dateBetween.setVisible(event.getValue() == DateType.BETWEEN);
        });
        this.add(new Component[]{new H1(this.getTranslation("report.explorateur.select.periode", new Object[0])), this.dateTypeSelector, this.dateBefore, this.dateBetween});
        this.dateTypeSelector.setValue((Object)DateType.BEFORE);
        this.dateBefore.setValue(LocalDate.now());
        this.dateBetween.setValue((Object)new DateRange(LocalDate.now(), LocalDate.now()));
    }

    private void initItems() {
        this.patrolNumberSelector.setItemLabelGenerator(PatrolNumber::getLabel);
        this.patrolNumberSelector.setItems((Object[])PatrolNumber.values());
        this.add(new Component[]{new H1(this.getTranslation("report.explorateur.select.elements", new Object[0])), this.cbEnablePatrols, this.patrolNumberSelector, this.cbEnableEvents});
        this.patrolNumberSelector.setValue((Object)PatrolNumber.ONE);
    }

    private void initLocation() {
        Button bSearchPr = new Button((Component)VaadinIcon.SEARCH.create());
        this.cbCommune.setClearButtonVisible(true);
        this.cbAxe.setClearButtonVisible(true);
        this.cbDepartement.setClearButtonVisible(true);
        this.cbCommune.setItems((Collection)this.locationSearchService.getCommunes());
        this.cbAxe.setItems((Collection)this.locationSearchService.getAxes());
        this.cbCommune.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            this.cbAxe.clear();
            this.cbAxe.setItems((Collection)this.locationSearchService.getAxesCommune((String)event.getValue()));
            this.afficherCommune((String)event.getValue());
        });
        this.cbAxe.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            this.cbPr.clear();
            this.cbPr.setItems((Collection)this.locationSearchService.getPrAxeCommune((String)event.getValue(), (String)this.cbCommune.getValue()));
            this.afficherAxe((String)event.getValue(), event.isFromClient());
        });
        this.cbPr.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            this.tfAbs.clear();
            this.afficherPr((String)this.cbDepartement.getValue(), (String)this.cbAxe.getValue(), (String)this.cbPr.getValue(), event.isFromClient());
        });
        bSearchPr.addClickListener((ComponentEventListener & Serializable)e -> {
            LocalisationPr localisation = new LocalisationPr();
            localisation.setDepartement(this.cbDepartement.getOptionalValue().orElse("-1"));
            localisation.setAxe(this.cbAxe.getOptionalValue().orElse(""));
            localisation.setPr(this.cbPr.getOptionalValue().map(Integer::parseInt).orElse(-1).intValue());
            localisation.setAbscisse(this.tfAbs.getOptionalValue().orElse(0).intValue());
            this.applyLocalisation(null, localisation);
        });
        this.tfAbs.getStyle().setFlexGrow("1");
        this.fieldLat.setReadOnly(true);
        this.fieldLng.setReadOnly(true);
        PrismFormItem formItemDepartement = new PrismFormItem((Component)this.cbDepartement);
        formItemDepartement.setVisible(false);
        HorizontalLayout layoutAbs = new HorizontalLayout(new Component[]{this.tfAbs, bSearchPr});
        layoutAbs.setSpacing(false);
        layoutAbs.addClassName("gap-s");
        this.bSelectOnMap.getStyle().setBorder("2px dotted rgba(0, 0, 0, 0)");
        FormLayout form = new FormLayout(new Component[]{new PrismFormItem((Component)this.cbCommune), new PrismFormItem((Component)this.cbAxe), formItemDepartement, new PrismFormItem((Component)this.cbPr), new PrismFormItem(this.tfAbs.getLabel(), (Component)layoutAbs), new PrismFormItem((Component)this.bSelectOnMap), new PrismFormItem((Component)this.tfMaxDistance), new PrismFormItem((Component)this.fieldLat), new PrismFormItem((Component)this.fieldLng)});
        this.tfAbs.setLabel(null);
        form.getStyle().set("--vaadin-form-item-label-width", "12em");
        this.add(new Component[]{new H1(this.getTranslation("report.explorateur.select.localisation", new Object[0])), form});
        this.map.onClick(arg_0 -> this.onMapClick(arg_0));
        this.tfMaxDistance.setValue((Number)500);
    }

    private void onSelectOnMapClick(ClickEvent<Button> event) {
        this.selectOnMap = !this.selectOnMap;
        this.map.setThemeName("cursor-pointer", this.selectOnMap);
        this.bSelectOnMap.getStyle().set("border-color", this.selectOnMap ? "var(--lumo-contrast-50pct)" : "rgba(0, 0, 0, 0)").setBackground(this.selectOnMap ? "var(--lumo-base-color)" : null);
    }

    private void onMapClick(MouseEvent event) {
        if (this.selectOnMap) {
            LocalisationPr localisation;
            LatLng latLng = event.getLatLng();
            try {
                localisation = this.locationSearchService.getLocalisationInfo(LeafletUtils.latLngToPoint((LatLng)latLng));
            }
            catch (ICartoService.LocalisationException e) {
                ErrorDialog.builder().title(this.getTranslation("localisation.erreur.titre", new Object[0])).message(this.getTranslation(e.getErreurI18n(), new Object[0])).build().open();
                return;
            }
            catch (Exception e) {
                ErrorDialog.builder().title(this.getTranslation("global.erreur", new Object[0])).message(this.getTranslation("global.erreur.general", new Object[0])).build().open();
                return;
            }
            this.applyLocalisation(latLng, localisation);
        }
    }

    private void applyLocalisation(LatLng latLng, LocalisationPr localisation) {
        Marker markerLocalisation;
        this.cbCommune.clear();
        if (localisation == null) {
            this.cbDepartement.clear();
            this.cbAxe.clear();
            this.cbPr.clear();
        } else {
            Optional.ofNullable(localisation.getAxe()).filter(StringUtils::isNotBlank).ifPresentOrElse(arg_0 -> ((ComboBox)this.cbAxe).setValue(arg_0), () -> ((ComboBox)this.cbAxe).clear());
            if (localisation.getPr() == -1) {
                this.cbPr.clear();
                this.tfAbs.clear();
            } else {
                this.cbPr.setValue((Object)String.valueOf(localisation.getPr()));
                this.tfAbs.setValue((Number)localisation.getAbscisse());
                latLng = LeafletUtils.pointToLatLng((com.neogls.prism.central.vaadin.service.bean.Point)this.locationSearchService.getPositionOfLocalisationPr(localisation));
            }
        }
        if (latLng == null) {
            markerLocalisation = null;
            this.fieldLat.clear();
            this.fieldLng.clear();
        } else {
            Icon iconLocalisation = new Icon("images/ico/prdeb.png", 32);
            iconLocalisation.setShadowSize(null);
            iconLocalisation.setIconAnchor(Point.of((double)5.0, (double)32.0));
            markerLocalisation = new Marker(latLng);
            markerLocalisation.setIcon(iconLocalisation);
            markerLocalisation.addTo(this.map);
            this.fieldLat.setValue((Number)latLng.getLat());
            this.fieldLng.setValue((Number)latLng.getLng());
        }
        Layer oldMarker = this.refLayerLocalisation.getAndSet(markerLocalisation);
        if (oldMarker != null) {
            oldMarker.remove();
        }
    }

    private void afficherAxe(String axe, boolean flyTo) {
        Polyline layerAxe = this.leafletRenderService.createLayerAxe(this.locationSearchService.getGeometrieAxe(axe));
        this.afficherLayer(this.refLayerAxe, (Layer)layerAxe);
        if (flyTo && layerAxe != null && this.refLayerCommune.get() == null) {
            this.map.flyToBounds(layerAxe.getBounds());
        }
        Optional.ofNullable(this.refLayerPr.getAndSet(null)).ifPresent(Layer::remove);
    }

    private void afficherCommune(String commune) {
        Polyline layerCommune = this.leafletRenderService.createLayerCommune(this.locationSearchService.getGeometrieCommune(commune));
        this.afficherLayer(this.refLayerCommune, (Layer)layerCommune);
        if (layerCommune != null) {
            this.map.flyToBounds(layerCommune.getBounds());
        }
    }

    private void afficherPr(String dpt, String axe, String pr, boolean flyTo) {
        com.neogls.prism.central.vaadin.service.bean.Point localisationPr = this.locationSearchService.getLocalisationPr(dpt, axe, pr);
        this.afficherLayer(this.refLayerPr, this.leafletRenderService.createLayerPr(localisationPr));
        if (flyTo && localisationPr != null) {
            this.map.flyTo(LeafletUtils.pointToLatLng((com.neogls.prism.central.vaadin.service.bean.Point)localisationPr));
        }
    }

    private void afficherLayer(AtomicReference<Layer> layerReference, Layer newLayer) {
        Layer oldLayer = layerReference.getAndSet(newLayer);
        if (oldLayer != null) {
            oldLayer.remove();
        }
        if (newLayer != null) {
            newLayer.addTo(this.map);
        }
    }

    private void initSearchButton() {
        Button bSearch = new Button(this.getTranslation("report.explorateur.action.recherche", new Object[0]), arg_0 -> this.onSearchClick(arg_0));
        bSearch.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
        bSearch.addClassName("m-auto");
        bSearch.setEnabled(false);
        Runnable updateSearchButtonState = () -> bSearch.setEnabled(!this.fieldLat.isEmpty() && !this.fieldLng.isEmpty());
        this.fieldLat.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> updateSearchButtonState.run());
        this.fieldLng.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> updateSearchButtonState.run());
        this.add(new Component[]{new HorizontalLayout(new Component[]{bSearch})});
    }

    private boolean validate() {
        boolean isValid = true;
        if (this.dateTypeSelector.getValue() == DateType.BEFORE) {
            if (this.dateBefore.isEmpty()) {
                this.dateBefore.setErrorMessage("La date est obligatoire");
                this.dateBefore.setInvalid(true);
                isValid = false;
            } else {
                this.dateBefore.setInvalid(false);
            }
        } else if (this.dateTypeSelector.getValue() == DateType.BETWEEN) {
            if (this.dateBetween.isEmpty()) {
                this.dateBetween.setErrorMessage("La date est obligatoire");
                this.dateBetween.setInvalid(true);
                isValid = false;
            } else {
                this.dateBetween.setInvalid(false);
            }
        }
        if (((Boolean)this.cbEnablePatrols.getValue()).booleanValue()) {
            if (this.patrolNumberSelector.isEmpty()) {
                this.patrolNumberSelector.setErrorMessage("Le nombre de patrouille est obligatoire");
                this.patrolNumberSelector.setInvalid(true);
                isValid = false;
            } else {
                this.patrolNumberSelector.setInvalid(false);
            }
        }
        if (this.tfMaxDistance.isEmpty()) {
            this.tfMaxDistance.setErrorMessage("Le rayon de recherche est obligatoire");
            this.tfMaxDistance.setInvalid(true);
            isValid = false;
        } else {
            this.tfMaxDistance.setInvalid(false);
        }
        return isValid;
    }

    private void onSearchClick(ClickEvent<Button> event) {
        if (!this.validate()) {
            Notification.show((String)"Certains champs sont en erreur").addThemeVariants((ThemeVariant[])new NotificationVariant[]{NotificationVariant.LUMO_ERROR});
            return;
        }
        if (this.selectOnMap) {
            this.bSelectOnMap.click();
        }
        MctRecherchePatrouilleFilter filtre = MctRecherchePatrouilleFilter.builder().delegationAndCenter((DelegationAndCenter)this.delegationAndCenterField.getValue()).dateMin(this.dateTypeSelector.getValue() == DateType.BETWEEN ? ((DateRange)this.dateBetween.getValue()).getBeginning() : LocalDate.of(2000, 1, 1)).dateMax(this.dateTypeSelector.getValue() == DateType.BETWEEN ? ((DateRange)this.dateBetween.getValue()).getEnd() : (LocalDate)this.dateBefore.getValue()).nbMaxPatrouilles((Boolean)this.cbEnablePatrols.getValue() != false ? ((PatrolNumber)this.patrolNumberSelector.getValue()).getValue() : 0).events(((Boolean)this.cbEnableEvents.getValue()).booleanValue()).lat(((Double)this.fieldLat.getValue()).doubleValue()).lng(((Double)this.fieldLng.getValue()).doubleValue()).radius(((Integer)this.tfMaxDistance.getValue()).intValue()).axe((String)this.cbAxe.getValue()).build();
        this.fireEvent((ComponentEvent)new RechercheEvent(this, true, filtre));
    }

    public void addRechercheListener(ComponentEventListener<RechercheEvent> listener) {
        this.addListener(RechercheEvent.class, listener);
    }
}

