/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.recherchepatrouille;

import com.geolocsystems.prismandroid.model.Patrouille;
import com.geolocsystems.prismandroid.model.Position;
import com.geolocsystems.prismandroid.model.evenements.Situation;
import com.geolocsystems.prismcentral.beans.VehiculeEnIntervention;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.neogls.prism.central.vaadin.common.service.LeafletRenderService;
import com.neogls.prism.central.vaadin.rest.WMSController;
import com.neogls.prism.central.vaadin.service.ConfigurationService;
import com.neogls.prism.central.vaadin.service.LocationSearchService;
import com.neogls.prism.central.vaadin.service.UserPermissionService;
import com.neogls.prism.central.vaadin.view.mct.common.event.eventsheetdialog.EventSheetDialogFactory;
import com.neogls.prism.central.vaadin.view.mct.common.event.filter.EventFilter;
import com.neogls.prism.central.vaadin.view.mct.common.event.list.EventRetrieverService;
import com.neogls.prism.central.vaadin.view.mct.recherchepatrouille.MctRecherchePatrouilleEventListener;
import com.neogls.prism.central.vaadin.view.mct.recherchepatrouille.MctRecherchePatrouilleFilter;
import com.neogls.prism.central.vaadin.view.mct.recherchepatrouille.TabRecherche;
import java.sql.Timestamp;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.vaadin.addons.componentfactory.leaflet.LeafletMap;

@Service
public class MctRecherchePatrouilleService {
    private final LocationSearchService locationSearchService;
    private final LeafletRenderService leafletRenderService;
    private final EventRetrieverService eventRetrieverService;
    private final IBusinessService businessService;
    private final EventSheetDialogFactory eventSheetDialogFactory;
    private final UserPermissionService userPermissionService;
    private final ConfigurationService configurationService;

    public TabRecherche createTabRecherche(LeafletMap map) {
        return new TabRecherche(map, this.locationSearchService, this.leafletRenderService, (Collection)this.businessService.getDelegationsActives(), this.userPermissionService.getCurrentUser());
    }

    public List<Situation> findEvents(MctRecherchePatrouilleFilter filtre) {
        if (!filtre.isEvents()) {
            return List.of();
        }
        IBusinessService.EvenementFiltre sqlFilter = IBusinessService.EvenementFiltre.byDelegation((String)filtre.getDelegationAndCenter().getDelegation(), (String)filtre.getDelegationAndCenter().getCenter());
        sqlFilter.dateMin = new Timestamp(filtre.getDateMin() != null ? filtre.getDateMin().atStartOfDay().toInstant(ZoneOffset.UTC).toEpochMilli() : 0L);
        sqlFilter.dateMax = new Timestamp(filtre.getDateMax().atStartOfDay().toInstant(ZoneOffset.UTC).toEpochMilli());
        Position point = new Position();
        point.setX((float)filtre.getLng());
        point.setY((float)filtre.getLat());
        sqlFilter.point = point;
        sqlFilter.distance = filtre.getRadius();
        if (filtre.getAxe() != null) {
            sqlFilter.route = filtre.getAxe();
        }
        sqlFilter.termines = -1;
        EventFilter eventFilter = EventFilter.builder().unlocalizedName("").delegationAndCenter(filtre.getDelegationAndCenter()).mmCodes(List.of(Integer.valueOf(0))).sqlFilter(sqlFilter).build();
        return this.eventRetrieverService.getEvents(eventFilter);
    }

    public List<VehiculeEnIntervention> findPatrols(MctRecherchePatrouilleFilter filtre) {
        List patrouilles = this.businessService.getPatrouilles(filtre.getLat(), filtre.getLng(), filtre.getDelegationAndCenter().getDelegation(), filtre.getDelegationAndCenter().getCenter(), filtre.getNbMaxPatrouilles(), new Timestamp(filtre.getDateMin() != null ? filtre.getDateMin().atStartOfDay().toInstant(ZoneOffset.UTC).toEpochMilli() : 0L), new Timestamp(filtre.getDateMax().atStartOfDay(ZoneOffset.UTC).toInstant().toEpochMilli()));
        List<String> idsPatrouilles = patrouilles.stream().map(Patrouille::getId).toList();
        return this.businessService.getVehiculesEnIntervention(idsPatrouilles).stream().sorted(Comparator.comparingLong(VehiculeEnIntervention::getDatePosition).reversed()).collect(Collectors.toMap(VehiculeEnIntervention::getIdPatrouille, v -> v, (v1, v2) -> v1)).values().stream().toList();
    }

    public MctRecherchePatrouilleEventListener createEventListener() {
        return new MctRecherchePatrouilleEventListener(this.eventSheetDialogFactory);
    }

    public String createWmsLayerUrl(MctRecherchePatrouilleFilter filter) {
        return WMSController.Helper.createWMSLayerURL((String)((String)this.configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "carto.mci.url").orElseThrow()), (String)"patrouille_stats", (String)"PNG", Map.of("MAP", (String)this.configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "carto.mci.map").orElseThrow(), "LAT", String.valueOf(filter.getLat()), "LON", String.valueOf(filter.getLng()), "LIMIT", filter.getNbMaxPatrouilles() == -1 ? "1000" : String.valueOf(filter.getNbMaxPatrouilles()), "DATE_DEBUT", filter.getDateMin().format(DateTimeFormatter.ofPattern("yyyy/MM/dd")), "DATE_FIN", filter.getDateMax().format(DateTimeFormatter.ofPattern("yyyy/MM/dd"))));
    }

    @Generated
    public MctRecherchePatrouilleService(LocationSearchService locationSearchService, LeafletRenderService leafletRenderService, EventRetrieverService eventRetrieverService, IBusinessService businessService, EventSheetDialogFactory eventSheetDialogFactory, UserPermissionService userPermissionService, ConfigurationService configurationService) {
        this.locationSearchService = locationSearchService;
        this.leafletRenderService = leafletRenderService;
        this.eventRetrieverService = eventRetrieverService;
        this.businessService = businessService;
        this.eventSheetDialogFactory = eventSheetDialogFactory;
        this.userPermissionService = userPermissionService;
        this.configurationService = configurationService;
    }
}

