/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.recherchepatrouille;

import com.neogls.prism.central.vaadin.layout.PrismLayout;
import com.neogls.prism.central.vaadin.service.ConfigurationService;
import com.neogls.prism.central.vaadin.view.mct.common.CommonMct;
import com.neogls.prism.central.vaadin.view.mct.common.ICartoPane;
import com.neogls.prism.central.vaadin.view.mct.common.LeftSidePane;
import com.neogls.prism.central.vaadin.view.mct.common.bottomsidepane.BottomSidePane;
import com.neogls.prism.central.vaadin.view.mct.common.carto.cluster.ClusterCartoPaneFactory;
import com.neogls.prism.central.vaadin.view.mct.common.event.list.EventMctListService;
import com.neogls.prism.central.vaadin.view.mct.common.event.list.MctEventList;
import com.neogls.prism.central.vaadin.view.mct.common.list.ActionListener;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.list.MctPatrolList;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.list.PatrolActionListener;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.list.PatrolMctListService;
import com.neogls.prism.central.vaadin.view.mct.recherchepatrouille.MctRecherchePatrouilleEventMctListService;
import com.neogls.prism.central.vaadin.view.mct.recherchepatrouille.MctRecherchePatrouillePatrolMctListService;
import com.neogls.prism.central.vaadin.view.mct.recherchepatrouille.MctRecherchePatrouilleService;
import com.neogls.prism.central.vaadin.view.mct.recherchepatrouille.TabRecherche;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.dependency.StyleSheet;
import com.vaadin.flow.router.HasDynamicTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.Nullable;
import jakarta.annotation.security.RolesAllowed;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import org.vaadin.addons.componentfactory.leaflet.layer.Layer;
import org.vaadin.addons.componentfactory.leaflet.layer.raster.TileLayer;

@RolesAllowed(value={"ACTION_EXPLORATION_INFOS"})
@Route(value="mct/recherche-patrouille", layout=PrismLayout.class)
@StyleSheet(value="./style/mct-recherche-patrouille.css")
public class MctRecherchePatrouille
extends CommonMct
implements HasDynamicTitle {
    private final MctRecherchePatrouilleService service;
    private final MctRecherchePatrouilleEventMctListService eventMctListService;
    private final MctRecherchePatrouillePatrolMctListService patrolMctListService;
    private final LeftSidePane leftSidePane = new LeftSidePane();
    private final ICartoPane cartoPane;
    private final BottomSidePane bottomSidePane;
    private final MctEventList<?> eventList;
    private final MctPatrolList patrolList;
    @Nullable
    private Layer layerPatrouilleWMS = null;

    public MctRecherchePatrouille(ConfigurationService configurationService, ClusterCartoPaneFactory cartoPaneFactory, MctRecherchePatrouilleService service, MctRecherchePatrouilleEventMctListService eventMctListService, MctRecherchePatrouillePatrolMctListService patrolMctListService, PatrolActionListener patrolActionListener) {
        super(configurationService);
        this.service = service;
        this.eventMctListService = eventMctListService;
        this.patrolMctListService = patrolMctListService;
        this.cartoPane = cartoPaneFactory.newClusterCartoPane(Integer.valueOf(eventMctListService.getPrimaryBusinessModuleCode()));
        this.bottomSidePane = BottomSidePane.create();
        this.cartoPane.addCartoLayer();
        this.cartoPane.addPatrolTracksLayer(patrolActionListener);
        this.eventList = new MctEventList((EventMctListService)eventMctListService, null, null, this.getCartoPane().getSituationCartoComponent(), (ActionListener)service.createEventListener());
        this.patrolList = new MctPatrolList((PatrolMctListService)patrolMctListService, null, null, this.getCartoPane().getPatrolCartoComponent(), patrolActionListener);
        this.addClassName("mct-recherche-patrouille");
    }

    protected void init() {
        TabRecherche tabRecherche = this.service.createTabRecherche(this.getCartoPane().getMap());
        this.eventList.setHeightFull();
        this.patrolList.setHeightFull();
        tabRecherche.addRechercheListener(arg_0 -> this.onRecherche(arg_0));
        this.leftSidePane.addTab(this.getTranslation("report.explorateur.action.recherche", new Object[0]), (Component)tabRecherche);
        this.leftSidePane.addTab(this.getTranslation("mct.evts", new Object[0]), (Component)this.eventList);
        this.leftSidePane.addTab(this.getTranslation("mct.vehicles", new Object[0]), (Component)this.patrolList);
        this.bottomSidePane.removeFromParent();
        this.setAutoRefresh(false);
    }

    private void onRecherche(TabRecherche.RechercheEvent event) {
        this.eventMctListService.setEvents(this.service.findEvents(event.getFiltre()));
        this.patrolMctListService.setPatrols(this.service.findPatrols(event.getFiltre()));
        if (this.layerPatrouilleWMS != null) {
            this.cartoPane.removeLayer(this.layerPatrouilleWMS);
            this.layerPatrouilleWMS = null;
        }
        this.layerPatrouilleWMS = new TileLayer(this.service.createWmsLayerUrl(event.getFiltre()));
        this.cartoPane.addOverlayLayer(this.layerPatrouilleWMS, "patrouille_stats_" + Instant.now().toEpochMilli());
        this.requestRefresh();
        this.getLeftSidePane().setSelectedIndex(2);
    }

    protected CompletableFuture<Void> refresh() {
        return CompletableFuture.allOf(this.eventList.refreshItems(), this.patrolList.refreshItems());
    }

    public LeftSidePane getLeftSidePane() {
        return this.leftSidePane;
    }

    protected BottomSidePane getBottomSidePane() {
        return this.bottomSidePane;
    }

    protected ICartoPane getCartoPane() {
        return this.cartoPane;
    }

    public String getPageTitle() {
        return this.getTranslation("report.explorateur.infos_patrouille.title", new Object[0]);
    }
}

