/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.patrol;

import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.ModuleMetier;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.neogls.prism.central.vaadin.service.BusinessModuleService;
import com.neogls.prism.central.vaadin.service.ConfigurationService;
import com.neogls.prism.central.vaadin.service.UserPermissionService;
import com.neogls.prism.central.vaadin.service.i18n.PrismI18NProvider;
import com.neogls.prism.central.vaadin.service.security.AuthenticatedUser;
import com.neogls.prism.central.vaadin.service.util.AuthenticatedUserUtils;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.filter.PatrolFilter;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.list.AbstractPatrolMctListService;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.list.PatrolDetailsGeneratorService;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.list.PatrolListItemGeneratorService;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.list.PatrolRetrieverService;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.list.PatrolSelectionActionGeneratorService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class MctPatrouillagePatrolMctListService
extends AbstractPatrolMctListService {
    private final UserPermissionService userPermissionService;
    private final ConfigurationService configurationService;
    private final BusinessModuleService businessModuleService;

    public MctPatrouillagePatrolMctListService(IBusinessService businessService, UserPermissionService userPermissionService, BusinessModuleService businessModuleService, ConfigurationService configurationService, PatrolRetrieverService patrolRetrieverService, PatrolListItemGeneratorService patrolListItemGeneratorService, PatrolDetailsGeneratorService patrolDetailsGeneratorService, PatrolSelectionActionGeneratorService patrolSelectionActionGeneratorService, PrismI18NProvider i18NProvider) {
        super(businessService, userPermissionService, businessModuleService, configurationService, patrolRetrieverService, patrolListItemGeneratorService, patrolDetailsGeneratorService, patrolSelectionActionGeneratorService, i18NProvider);
        this.userPermissionService = userPermissionService;
        this.businessModuleService = businessModuleService;
        this.configurationService = configurationService;
    }

    public List<PatrolFilter> getFilters() {
        int id = 0;
        ArrayList<PatrolFilter> filters = new ArrayList<PatrolFilter>();
        AuthenticatedUser currentUser = this.getCurrentUser();
        String delegation = AuthenticatedUserUtils.getDeletationString((AuthenticatedUser)currentUser);
        String centre = AuthenticatedUserUtils.getCenterString((AuthenticatedUser)currentUser);
        List mmCodes = this.getBusinessModuleCodes();
        PatrolFilter fCustom = PatrolFilter.builder().unlocalizedName("mct.filtre.patrouillesvh.perso").vehicleFilter(new IBusinessService.VehiculeFiltre()).isCustom(true).build();
        fCustom.getVehicleFilter().codeModuleMetier = mmCodes;
        filters.add(fCustom);
        if (this.userPermissionService.canShowInProgressPatrols()) {
            PatrolFilter fEncours = PatrolFilter.builder().id(id++).unlocalizedName("mct.filtre.patrouilles.encours").vehicleFilter(IBusinessService.VehiculeFiltre.encours((String)delegation, (String)centre, (List)mmCodes)).build();
            filters.add(fEncours);
        }
        PatrolFilter fJournee = PatrolFilter.builder().id(id++).unlocalizedName("mct.filtre.patrouilles.journee").vehicleFilter(IBusinessService.VehiculeFiltre.deLaJournee((String)delegation, (String)centre, (List)mmCodes)).build();
        filters.add(fJournee);
        PatrolFilter fVeille = PatrolFilter.builder().id(id++).unlocalizedName("mct.filtre.patrouilles.veille").vehicleFilter(IBusinessService.VehiculeFiltre.deLaVeille((String)delegation, (String)centre, (List)mmCodes)).build();
        filters.add(fVeille);
        if (MetierCommun.aPlusDunElement((List)mmCodes)) {
            Iterator iterator = mmCodes.iterator();
            while (iterator.hasNext()) {
                int mmCode = (Integer)iterator.next();
                String mmName = this.businessModuleService.findBusinessModuleByCode(Integer.valueOf(mmCode)).map(ModuleMetier::getNom).orElseThrow();
                if (this.userPermissionService.canShowInProgressPatrols()) {
                    filters.add(PatrolFilter.builder().id(id++).unlocalizedName("mct.filtre.patrouilles.%s.encours".formatted(mmName)).vehicleFilter(IBusinessService.VehiculeFiltre.encours((String)delegation, (String)centre, List.of(Integer.valueOf(mmCode)))).build());
                }
                filters.add(PatrolFilter.builder().id(id++).unlocalizedName("mct.filtre.patrouilles.%s.journee".formatted(mmName)).vehicleFilter(IBusinessService.VehiculeFiltre.deLaJournee((String)delegation, (String)centre, List.of(Integer.valueOf(mmCode)))).build());
                filters.add(PatrolFilter.builder().id(id++).unlocalizedName("mct.filtre.patrouilles.%s.veille".formatted(mmName)).vehicleFilter(IBusinessService.VehiculeFiltre.deLaVeille((String)delegation, (String)centre, List.of(Integer.valueOf(mmCode)))).build());
            }
        }
        if (this.configurationService.isPatrolVisaActive() && this.userPermissionService.canVisaPatrols()) {
            filters.add(PatrolFilter.builder().id(id++).unlocalizedName("mct.filtre.patrouilles.aviser").vehicleFilter(IBusinessService.VehiculeFiltre.aViser((String)delegation, (String)centre, (List)mmCodes)).build());
        }
        return filters;
    }

    public int getPrimaryBusinessModuleCode() {
        return 0;
    }
}

