/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.patrol;

import com.geolocsystems.prismcentral.data.IBusinessService;
import com.neogls.prism.central.vaadin.layout.PrismLayout;
import com.neogls.prism.central.vaadin.service.ConfigurationService;
import com.neogls.prism.central.vaadin.service.NatureService;
import com.neogls.prism.central.vaadin.service.UserPermissionService;
import com.neogls.prism.central.vaadin.util.MctListUtil;
import com.neogls.prism.central.vaadin.view.mct.common.CommonBottomSideInformationProvider;
import com.neogls.prism.central.vaadin.view.mct.common.CommonMct;
import com.neogls.prism.central.vaadin.view.mct.common.ICartoPane;
import com.neogls.prism.central.vaadin.view.mct.common.LeftSidePane;
import com.neogls.prism.central.vaadin.view.mct.common.bottomsidepane.BottomSidePane;
import com.neogls.prism.central.vaadin.view.mct.common.bottomsidepane.Slot;
import com.neogls.prism.central.vaadin.view.mct.common.carto.cluster.ClusterCartoPaneFactory;
import com.neogls.prism.central.vaadin.view.mct.common.carto.layer.PrismLayerFactory;
import com.neogls.prism.central.vaadin.view.mct.common.event.EventCreationTab;
import com.neogls.prism.central.vaadin.view.mct.common.event.eventsheetdialog.EventSheetDialogFactory;
import com.neogls.prism.central.vaadin.view.mct.common.event.filter.field.IVaadinEventFilterFieldFactory;
import com.neogls.prism.central.vaadin.view.mct.common.event.list.EventActionListener;
import com.neogls.prism.central.vaadin.view.mct.common.event.list.EventMctListService;
import com.neogls.prism.central.vaadin.view.mct.common.event.list.MctEventList;
import com.neogls.prism.central.vaadin.view.mct.common.event.sort.EventSortService;
import com.neogls.prism.central.vaadin.view.mct.common.list.MctCartoComponent;
import com.neogls.prism.central.vaadin.view.mct.common.list.MctFilterComponent;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.filter.PatrolFilter;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.list.MctPatrolList;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.list.PatrolActionListener;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.list.PatrolMctListService;
import com.neogls.prism.central.vaadin.view.mct.patrol.MctPatrouillageService;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.router.HasDynamicTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.CompletableFuture;

@RolesAllowed(value={"ACTION_MCT_PATROUILLAGE"})
@Route(value="mct/patrouillage", layout=PrismLayout.class)
public class MctPatrouillage
extends CommonMct
implements HasDynamicTitle {
    private final MctPatrouillageService mctPatrouillageService;
    private final NatureService natureService;
    private final EventSheetDialogFactory eventSheetDialogFactory;
    private final ConfigurationService configurationService;
    private final UserPermissionService userPermissionService;
    private final LeftSidePane leftSidePane;
    private final BottomSidePane bottomSidePane;
    private final ICartoPane cartoPane;
    private final MctEventList<?> eventList;
    private final MctPatrolList patrolList;

    public MctPatrouillage(ConfigurationService configurationService, MctPatrouillageService mctPatrouillageService, EventActionListener eventActionListener, PatrolActionListener patrolActionListener, NatureService natureService, PrismLayerFactory prismLayerFactory, ClusterCartoPaneFactory clusterCartoPaneFactory, EventSheetDialogFactory eventSheetDialogFactory, UserPermissionService userPermissionService) {
        super(configurationService);
        this.mctPatrouillageService = mctPatrouillageService;
        this.natureService = natureService;
        this.eventSheetDialogFactory = eventSheetDialogFactory;
        this.configurationService = configurationService;
        this.userPermissionService = userPermissionService;
        this.leftSidePane = new LeftSidePane();
        this.cartoPane = clusterCartoPaneFactory.newClusterCartoPane(Integer.valueOf(mctPatrouillageService.getEventMctListService().getPrimaryBusinessModuleCode()));
        this.cartoPane.addCartoLayer();
        prismLayerFactory.tryCreateCartoLayerSupp(mctPatrouillageService.getEventMctListService().getPrimaryBusinessModuleCode()).ifPresent(cartoLayers -> cartoLayers.forEach((layerName, layer) -> layer.addTo(this.cartoPane, layerName)));
        prismLayerFactory.tryCreateCartoLayerSingleTile(mctPatrouillageService.getEventMctListService().getPrimaryBusinessModuleCode()).ifPresent(cartoLayers -> cartoLayers.forEach((layerName, layer) -> layer.addTo(this.cartoPane, layerName)));
        this.cartoPane.addPatrolTracksLayer(patrolActionListener);
        this.eventList = MctListUtil.addMctEventList((CommonMct)this, (String)this.getTranslation("mct.evts", new Object[0]), (EventMctListService)mctPatrouillageService.getEventMctListService(), (IVaadinEventFilterFieldFactory)mctPatrouillageService.getEventFilterFieldFactory(), (EventSortService)mctPatrouillageService.getEventSortService(), (MctCartoComponent)this.getCartoPane().getSituationCartoComponent(), (EventActionListener)eventActionListener);
        this.patrolList = MctListUtil.addMctPatrolList((CommonMct)this, (String)this.getTranslation("mct.vehicles", new Object[0]), (PatrolMctListService)mctPatrouillageService.getPatrolMctListService(), (MctCartoComponent)this.getCartoPane().getPatrolCartoComponent(), (PatrolActionListener)patrolActionListener);
        this.bottomSidePane = BottomSidePane.create();
    }

    protected void init() {
        EventCreationTab creation = new EventCreationTab(this.natureService.getNaturesForCreation(this.mctPatrouillageService.getEventMctListService().getPrimaryBusinessModuleCode()), this.mctPatrouillageService.getEventService(), this.eventSheetDialogFactory, this.cartoPane);
        creation.addEventCreationListener((ComponentEventListener & Serializable)event -> this.requestRefresh());
        this.leftSidePane.addTab(this.getTranslation("mct.create", new Object[0]), (Component)creation);
        new CommonBottomSideInformationProvider(this.getBottomSidePane(), this.eventList);
        Slot slotVoirPatrouilles = this.getBottomSidePane().getTab(BottomSidePane.DefaultTab.INFORMATIONS).newSlot();
        this.eventList.addItemsLoadListener((ComponentEventListener & Serializable)event -> {
            MctFilterComponent patrolFilterComponent = this.patrolList.getMctFilterComponent();
            if (patrolFilterComponent != null && this.configurationService.isPatrolVisaActive() && this.userPermissionService.canVisaPatrols()) {
                Button voir = new Button("Voir les patrouilles \u00e0 viser", (ComponentEventListener & Serializable)clickEvent -> {
                    this.getLeftSidePane().setSelectedIndex(1);
                    patrolFilterComponent.setFilter((Object)PatrolFilter.builder().unlocalizedName("mct.filtre.patrouilles.aviser").vehicleFilter(IBusinessService.VehiculeFiltre.aViser((String)this.userPermissionService.getCurrentUser().getPrismUser().getDelegation(), (String)this.userPermissionService.getCurrentUser().getPrismUser().getCentre(), List.of(Integer.valueOf(0)))).build());
                });
                voir.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_SMALL, ButtonVariant.LUMO_PRIMARY, ButtonVariant.LUMO_CONTRAST});
                event.registerUiAccess(ui -> slotVoirPatrouilles.setContent((Component)voir));
            }
        });
    }

    protected CompletableFuture<Void> refresh() {
        return CompletableFuture.allOf(this.eventList.refreshItems(), this.patrolList.refreshItems());
    }

    public LeftSidePane getLeftSidePane() {
        return this.leftSidePane;
    }

    protected ICartoPane getCartoPane() {
        return this.cartoPane;
    }

    protected BottomSidePane getBottomSidePane() {
        return this.bottomSidePane;
    }

    public String getPageTitle() {
        return this.getTranslation("mct.title", new Object[0]);
    }
}

