/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.intervention;

import com.geolocsystems.prismcentral.data.IBusinessService;
import com.neogls.prism.central.vaadin.service.BusinessModuleService;
import com.neogls.prism.central.vaadin.service.ConfigurationService;
import com.neogls.prism.central.vaadin.service.UserPermissionService;
import com.neogls.prism.central.vaadin.service.security.AuthenticatedUser;
import com.neogls.prism.central.vaadin.service.util.AuthenticatedUserUtils;
import com.neogls.prism.central.vaadin.view.mct.common.event.filter.EventFilter;
import com.neogls.prism.central.vaadin.view.mct.common.event.filter.EventFilterFormService;
import com.neogls.prism.central.vaadin.view.mct.common.event.list.AbstractEventMctListService;
import com.neogls.prism.central.vaadin.view.mct.common.event.list.EventActionListener;
import com.neogls.prism.central.vaadin.view.mct.common.event.list.EventDetailsGeneratorService;
import com.neogls.prism.central.vaadin.view.mct.common.event.list.EventListItemGeneratorService;
import com.neogls.prism.central.vaadin.view.mct.common.event.list.EventRetrieverService;
import com.neogls.prism.central.vaadin.view.mct.common.event.list.EventSelectionActionGeneratorService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class MctInterventionEventMctListService
extends AbstractEventMctListService<EventActionListener> {
    private final ConfigurationService configurationService;

    public MctInterventionEventMctListService(IBusinessService businessService, UserPermissionService userPermissionService, BusinessModuleService businessModuleService, ConfigurationService configurationService, EventRetrieverService eventRetrieverService, EventListItemGeneratorService eventListItemGeneratorService, EventDetailsGeneratorService<EventActionListener> eventDetailsGeneratorService, EventSelectionActionGeneratorService<EventActionListener> eventSelectionActionGeneratorService, EventFilterFormService eventFilterFormService) {
        super(businessService, userPermissionService, businessModuleService, configurationService, eventRetrieverService, eventListItemGeneratorService, eventDetailsGeneratorService, eventSelectionActionGeneratorService, eventFilterFormService);
        this.configurationService = configurationService;
    }

    public List<EventFilter> getFilters() {
        AuthenticatedUser currentUser = this.getCurrentUser();
        String delegation = AuthenticatedUserUtils.getDeletationString((AuthenticatedUser)currentUser);
        String center = AuthenticatedUserUtils.getCenterString((AuthenticatedUser)currentUser);
        List mmCodes = this.getBusinessModuleCodes();
        ArrayList<EventFilter> filters = new ArrayList<EventFilter>();
        filters.add(this.getEmptyCustomFilter());
        EventFilter fEnCours = EventFilter.builder().unlocalizedName("mct.filtre.evenements.encours").mmCodes(mmCodes).sqlFilter(this.getEmptyFilter()).build();
        filters.add(fEnCours);
        EventFilter fJournee = EventFilter.builder().unlocalizedName("mct.filtre.evenements.journee").mmCodes(mmCodes).sqlFilter(IBusinessService.EvenementFiltre.deLaJournee((String)delegation, (String)center)).build();
        filters.add(fJournee);
        EventFilter fVeille = EventFilter.builder().unlocalizedName("mct.filtre.evenements.veille").mmCodes(mmCodes).sqlFilter(IBusinessService.EvenementFiltre.deLaVeille((String)delegation, (String)center)).build();
        filters.add(fVeille);
        EventFilter fSemaine = EventFilter.builder().unlocalizedName("mct.filtre.evenements.semaine").mmCodes(mmCodes).sqlFilter(IBusinessService.EvenementFiltre.deLaSemaineEcoulee((String)delegation, (String)center)).build();
        filters.add(fSemaine);
        EventFilter fDdp = EventFilter.builder().unlocalizedName("mct.filtre.evenements.ddp").mmCodes(mmCodes).sqlFilter(IBusinessService.EvenementFiltre.ddp((String)delegation, (String)center)).build();
        filters.add(fDdp);
        if (this.configurationService.getPublication()) {
            EventFilter fPublie = EventFilter.builder().unlocalizedName("mct.filtre.evenements.publie").mmCodes(mmCodes).sqlFilter(this.getEmptyFilter()).build();
            fPublie.getSqlFilter().publies = 1;
            filters.add(fPublie);
        }
        return filters;
    }

    public EventFilter editFilterBeforeItemRequest(EventFilter filter) {
        filter.getSqlFilter().initCodeMm(5);
        filter.getSqlFilter().evenementAssocies = true;
        filter.getSqlFilter().statistiques = this.configurationService.getBoolean(ConfigurationService.ConfigurationType.DATABASE, "afficherEvenementsSansCentre").orElse(false) == false;
        return filter;
    }

    public int getPrimaryBusinessModuleCode() {
        return 5;
    }
}

