/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.fauchage.stats;

import com.geolocsystems.prismandroid.model.Troncon;
import com.geolocsystems.prismbirtbean.SyntheseTableauBordStatistiqueFauchageBean;
import com.geolocsystems.prismbirtbean.SyntheseTableauBordStatistiqueSchemaRoutierBean;
import com.neogls.prism.central.vaadin.service.fauchage.FauchageService;
import com.neogls.prism.central.vaadin.service.logbook.LogBookService;
import com.neogls.prism.central.vaadin.view.export.logbook.LogBookDialog;
import com.neogls.prism.central.vaadin.view.mct.common.event.eventsheetdialog.EventSheetDialogFactory;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridVariant;
import com.vaadin.flow.component.html.NativeLabel;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.data.selection.SelectionListener;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Optional;
import org.vaadin.addons.componentfactory.leaflet.LeafletMap;
import org.vaadin.addons.componentfactory.leaflet.types.LatLng;

public class FauchageExploitationSchemaViewer
extends Composite<VerticalLayout>
implements HasSize {
    private final FauchageService fauchageService;
    private final LogBookService logBookService;
    private final EventSheetDialogFactory eventSheetDialogFactory;
    private Grid<SyntheseTableauBordStatistiqueFauchageBean> grid;
    private LeafletMap map;

    public FauchageExploitationSchemaViewer(List<SyntheseTableauBordStatistiqueFauchageBean> syntheseFauchage, FauchageService fauchageService, LogBookService logBookService, EventSheetDialogFactory eventSheetDialogFactory) {
        this.fauchageService = fauchageService;
        this.logBookService = logBookService;
        this.eventSheetDialogFactory = eventSheetDialogFactory;
        this.createTable();
        if (syntheseFauchage != null) {
            this.grid.setItems(syntheseFauchage);
        }
        VerticalLayout layout = (VerticalLayout)this.getContent();
        layout.add(new Component[]{this.grid});
        layout.setPadding(false);
        layout.setAlignItems(FlexComponent.Alignment.CENTER);
    }

    private void createTable() {
        this.grid = new Grid();
        this.grid.addColumn(SyntheseTableauBordStatistiqueSchemaRoutierBean::getIdTroncon).setHeader("ID").setAutoWidth(true);
        this.grid.addComponentColumn((ValueProvider & Serializable)b -> {
            VerticalLayout v = new VerticalLayout();
            if (b.getDelegation() != null) {
                NativeLabel nativeLabelDelegation = new NativeLabel();
                nativeLabelDelegation.setText(b.getDelegation());
                v.add(new Component[]{nativeLabelDelegation});
            }
            if (b.getCentre() != null) {
                NativeLabel nativeLabelCentre = new NativeLabel();
                nativeLabelCentre.setText(b.getCentre());
                v.add(new Component[]{nativeLabelCentre});
            }
            return v;
        }).setHeader("D\u00e9l\u00e9gation/Centre").setSortable(true).setComparator((o1, o2) -> {
            if (o1.getDelegation() == null || o1.getDelegation().equals(o2.getDelegation())) {
                if (o1.getCentre() != null) {
                    if (o2.getCentre() != null) {
                        return o1.getCentre().compareTo(o2.getCentre());
                    }
                    return 0;
                }
                return 0;
            }
            return o1.getDelegation().compareTo(o2.getDelegation());
        }).setAutoWidth(true);
        this.grid.addColumn(SyntheseTableauBordStatistiqueSchemaRoutierBean::getNomCircuit).setHeader("Circuit").setAutoWidth(true);
        this.grid.addColumn(SyntheseTableauBordStatistiqueSchemaRoutierBean::getNomTroncon).setHeader("Tron\u00e7on").setAutoWidth(true);
        this.grid.addColumn(SyntheseTableauBordStatistiqueSchemaRoutierBean::getPrAbsDebut).setHeader("PR D\u00e9b").setAutoWidth(true);
        this.grid.addColumn(SyntheseTableauBordStatistiqueSchemaRoutierBean::getPrAbsFin).setHeader("PR Fin").setAutoWidth(true);
        this.grid.addColumn(SyntheseTableauBordStatistiqueSchemaRoutierBean::getNiveauExploitation).setHeader("Niv. Exploitation").setAutoWidth(true);
        this.grid.addColumn((ValueProvider & Serializable)b -> b.getPourcentage() + "%").setClassNameGenerator((SerializableFunction & Serializable)b -> {
            if (b.getPourcentage() >= 85) {
                return "green";
            }
            if (b.getPourcentage() >= 5 && b.getPourcentage() < 85) {
                return "orange";
            }
            return "red";
        }).setHeader("Pourcentage").setSortable(true).setAutoWidth(true);
        this.grid.addColumn((ValueProvider & Serializable)e -> {
            int distanceCumulee = e.getDistanceCumulee();
            int longueur = e.getLongueur();
            return distanceCumulee + " - (" + 100 * distanceCumulee / longueur + "%)";
        }).setHeader("Distance cumul\u00e9e paroucourue").setAutoWidth(true);
        this.grid.addComponentColumn((ValueProvider & Serializable)e -> this.createIdPatrouilles(e)).setHeader("Patrouilles ID").setAutoWidth(true);
        this.grid.addColumn((ValueProvider & Serializable)e -> {
            if (e.getDateDernierPassage() != null) {
                return new SimpleDateFormat("dd-MM-yyyy HH:mm:ss").format(e.getDateDernierPassage());
            }
            return null;
        }).setHeader("Dernier passage").setAutoWidth(true);
        this.grid.addColumn((ValueProvider & Serializable)e -> new SimpleDateFormat("dd-MM-yyyy HH:mm:ss").format(e.getDateMaj())).setHeader("Date g\u00e9n\u00e9ration").setAutoWidth(true);
        this.grid.setMultiSort(true, Grid.MultiSortPriority.APPEND);
        this.grid.setSelectionMode(Grid.SelectionMode.SINGLE);
        this.grid.addThemeVariants(new GridVariant[]{GridVariant.LUMO_ROW_STRIPES, GridVariant.LUMO_COMPACT, GridVariant.LUMO_WRAP_CELL_CONTENT});
        this.grid.addClassName("text-xs");
        this.grid.recalculateColumnWidths();
        this.grid.addSelectionListener((SelectionListener & Serializable)event -> {
            Optional item = event.getFirstSelectedItem();
            if (item.isPresent()) {
                Troncon tronconSelected = this.fauchageService.getSchemaTroncons(Integer.parseInt(((SyntheseTableauBordStatistiqueFauchageBean)item.get()).getIdTroncon()));
                LatLng latlng = new LatLng((double)tronconSelected.getPointDebut().getY(), (double)tronconSelected.getPointDebut().getX());
                this.map.flyTo(latlng, 12);
            }
        });
    }

    private VerticalLayout createIdPatrouilles(SyntheseTableauBordStatistiqueFauchageBean bean) {
        String[] patrouillesId = bean.getIdPatrouilles();
        VerticalLayout cellLayout = new VerticalLayout();
        if (patrouillesId != null) {
            for (String patrouilleId : patrouillesId) {
                Button b = new Button(patrouilleId);
                b.addClickListener((ComponentEventListener & Serializable)e -> this.logBookService.findMcigByPatrouilleId(this.fauchageService.getMCIGFromPatrouille(patrouilleId)).ifPresentOrElse(mcig -> new LogBookDialog(mcig, this.logBookService, this.eventSheetDialogFactory).open(), () -> {}));
                cellLayout.add(new Component[]{b});
            }
        }
        return cellLayout;
    }

    public void updateViewer(List<SyntheseTableauBordStatistiqueFauchageBean> syntheseSchemaRoutier) {
        if (syntheseSchemaRoutier != null && syntheseSchemaRoutier.size() > 0) {
            this.grid.setPageSize(syntheseSchemaRoutier.size());
            this.grid.setItems(syntheseSchemaRoutier);
        }
    }

    public void setMap(LeafletMap map) {
        this.map = map;
    }
}

