/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.fauchage.stats;

import com.geolocsystems.prismbirtbean.SyntheseTableauBordStatistiqueFauchageBean;
import com.neogls.prism.central.vaadin.layout.PrismLayout;
import com.neogls.prism.central.vaadin.rest.WMSController;
import com.neogls.prism.central.vaadin.service.ConfigurationService;
import com.neogls.prism.central.vaadin.service.fauchage.FauchageService;
import com.neogls.prism.central.vaadin.service.logbook.LogBookService;
import com.neogls.prism.central.vaadin.util.LeafletUtils;
import com.neogls.prism.central.vaadin.view.mct.common.CommonMct;
import com.neogls.prism.central.vaadin.view.mct.common.ICartoPane;
import com.neogls.prism.central.vaadin.view.mct.common.LeftSidePane;
import com.neogls.prism.central.vaadin.view.mct.common.bottomsidepane.BottomSidePane;
import com.neogls.prism.central.vaadin.view.mct.common.carto.SuiviStyleService;
import com.neogls.prism.central.vaadin.view.mct.common.carto.cluster.ClusterCartoPaneFactory;
import com.neogls.prism.central.vaadin.view.mct.common.carto.layer.SchemaFauchageTronconLayer;
import com.neogls.prism.central.vaadin.view.mct.common.event.eventsheetdialog.EventSheetDialogFactory;
import com.neogls.prism.central.vaadin.view.mct.fauchage.stats.FauchageExploitationSchemaForm;
import com.neogls.prism.central.vaadin.view.mct.fauchage.stats.FauchageExploitationSchemaViewer;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.details.Details;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.orderedlayout.Scroller;
import com.vaadin.flow.router.HasDynamicTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.vaadin.addons.componentfactory.leaflet.layer.Layer;
import org.vaadin.addons.componentfactory.leaflet.layer.groups.LayerGroup;
import org.vaadin.addons.componentfactory.leaflet.layer.raster.TileLayer;
import org.vaadin.addons.componentfactory.leaflet.types.LatLngBounds;

@RolesAllowed(value={"ACTION_FAUCHAGE_SCHEMA_EXPLOITATION"})
@Route(value="/fauchage-schema-search", layout=PrismLayout.class)
public class FauchageExploitationSchemaView
extends CommonMct
implements HasDynamicTitle {
    private final FauchageExploitationSchemaViewer viewer;
    private final FauchageService fauchageService;
    private final ConfigurationService configurationService;
    private final SuiviStyleService suiviStyleService;
    private final Details panelSearch;
    private List<SyntheseTableauBordStatistiqueFauchageBean> syntheseFauchage;
    private final LatLngBounds maxBounds;
    private final LeftSidePane leftSidePane;
    private final ICartoPane cartoPane;
    private final BottomSidePane bottomSidePane;
    private Map<String, LayerGroup> layersWMS;
    private SchemaFauchageTronconLayer layerSchemaFauchage;
    private final EventSheetDialogFactory eventSheetDialogFactory;

    public FauchageExploitationSchemaView(ConfigurationService configurationService, SuiviStyleService suiviStyleService, FauchageService fauchageService, LogBookService logBookService, EventSheetDialogFactory eventSheetDialogFactory, ClusterCartoPaneFactory clusterCartoPaneFactory) {
        super(configurationService);
        this.fauchageService = fauchageService;
        this.configurationService = configurationService;
        this.suiviStyleService = suiviStyleService;
        this.eventSheetDialogFactory = eventSheetDialogFactory;
        this.leftSidePane = new LeftSidePane();
        this.cartoPane = clusterCartoPaneFactory.newClusterCartoPane(Integer.valueOf(fauchageService.getMainCourante().getCodeModuleMetier()));
        this.bottomSidePane = BottomSidePane.create();
        FauchageExploitationSchemaForm form = new FauchageExploitationSchemaForm(fauchageService, null);
        form.setWidth(52.0f, Unit.EM);
        form.addClassName("mx-auto");
        this.maxBounds = LeafletUtils.getMaxBounds((ConfigurationService)configurationService);
        this.viewer = new FauchageExploitationSchemaViewer(this.syntheseFauchage, fauchageService, logBookService, eventSheetDialogFactory);
        this.viewer.setSizeFull();
        this.viewer.setMap(this.cartoPane.getMap());
        this.panelSearch = new Details("Crit\u00e8res de recherche", (Component)form);
        this.panelSearch.setOpened(true);
        Scroller scroller = new Scroller();
        scroller.setScrollDirection(Scroller.ScrollDirection.VERTICAL);
        this.leftSidePane.add(new Component[]{this.panelSearch});
        this.leftSidePane.add(new Component[]{this.viewer});
        form.addFormValidatedListener(arg_0 -> this.onFormValidated(arg_0));
        this.layersWMS = new HashMap();
    }

    private void onFormValidated(FauchageExploitationSchemaForm.FormValidatedEvent event) {
        List synthseseList;
        Notification notification = Notification.show((String)"Recherche en cours...");
        this.syntheseFauchage = synthseseList = this.fauchageService.getSyntheseFauchage(event.getSearchData());
        this.viewer.updateViewer(this.syntheseFauchage);
        this.panelSearch.setOpened(false);
        boolean tronconPreCalcules = true;
        if (this.layerSchemaFauchage == null) {
            this.layerSchemaFauchage = new SchemaFauchageTronconLayer(this.suiviStyleService);
            this.cartoPane.addLayer((Layer)this.layerSchemaFauchage.getLayer());
            this.cartoPane.addOverlayLayer((Layer)this.layerSchemaFauchage.getLayer(), "sections non patoruill\u00e9es");
        } else {
            this.layerSchemaFauchage.getLayer().clearLayers();
        }
        this.layerSchemaFauchage.showStatistiqueCircuit(this.syntheseFauchage, tronconPreCalcules);
        ArrayList niveauxExploitation = new ArrayList();
        this.setURLWMS((String)this.configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "carto.mci.url").get(), (String)this.configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "carto.mci.map").get(), (String)this.configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "carto.statistique.schema_routier.layers.troncon").get(), "PNG", true, (String)this.configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "carto.statistique.circuit.projection").get(), niveauxExploitation, "", "", (String)this.configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "carto.statistique.circuit.buffer.size").get(), this.syntheseFauchage);
        this.setURLWMS((String)this.configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "carto.mci.url").get(), (String)this.configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "carto.mci.map").get(), "schema_fauchage_pourcentage", "PNG", true, (String)this.configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "carto.statistique.circuit.projection").get(), niveauxExploitation, "", "", (String)this.configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "carto.statistique.circuit.buffer.size").get(), this.syntheseFauchage);
        notification.close();
    }

    public String getPageTitle() {
        return this.getTranslation("stats.schema_routier.title", new Object[0]);
    }

    public void setURLWMS(String urlCarto, String mapfile, String layers, String formatImage, boolean noCache, String srs, List<String> niveaux, String dateMin, String dateMax, String bufferSize, List<SyntheseTableauBordStatistiqueFauchageBean> syntheseTableauBordStatistiqueFauchage) {
        LayerGroup wmsGroupLayer = (LayerGroup)this.layersWMS.get(layers);
        if (wmsGroupLayer == null) {
            wmsGroupLayer = new LayerGroup(new Layer[0]);
            this.layersWMS.put(layers, wmsGroupLayer);
            this.cartoPane.addLayer((Layer)wmsGroupLayer);
            this.cartoPane.addOverlayLayer((Layer)wmsGroupLayer, layers);
        } else {
            wmsGroupLayer.clearLayers();
        }
        int i = 0;
        while (i < syntheseTableauBordStatistiqueFauchage.size()) {
            Object tronconID = "";
            int j = i;
            while (i < syntheseTableauBordStatistiqueFauchage.size() && ((String)tronconID).length() <= 1250) {
                tronconID = (String)tronconID + (((String)tronconID).equals("") ? "" : ",") + "'" + syntheseTableauBordStatistiqueFauchage.get(i).getIdTroncon() + "'";
                ++i;
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("LAYERS", layers);
            params.put("FORMAT", formatImage);
            params.put("TRANSPARENT", "true");
            params.put("MAP", mapfile);
            params.put("TIMESTAMP", "" + System.currentTimeMillis());
            params.put("SRS", srs);
            Object niveauxExploitation = "";
            for (String niveau : niveaux) {
                niveauxExploitation = (String)niveauxExploitation + (((String)niveauxExploitation).equals("") ? "" : ",") + "'" + niveau + "'";
            }
            params.put("niveauxExploitation", niveauxExploitation);
            params.put("date_debut", dateMin);
            params.put("date_fin", dateMax);
            params.put("buffer", bufferSize);
            params.put("troncon_id", tronconID);
            TileLayer tileLayer = new TileLayer(WMSController.Helper.createWMSLayerURL((String)urlCarto, (String)layers, (String)this.configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "carto.formatImage").orElse(null), params));
            wmsGroupLayer.addLayer((Layer)tileLayer);
        }
    }

    protected void init() {
        this.leftSidePane.setMinWidth(70.0f, Unit.PERCENTAGE);
    }

    protected CompletableFuture<Void> refresh() {
        return CompletableFuture.completedFuture(null);
    }

    public LeftSidePane getLeftSidePane() {
        return this.leftSidePane;
    }

    protected ICartoPane getCartoPane() {
        return this.cartoPane;
    }

    protected BottomSidePane getBottomSidePane() {
        return this.bottomSidePane;
    }
}

