/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.fauchage.historique;

import com.geolocsystems.prismandroid.model.Centre;
import com.geolocsystems.prismandroid.model.Circuit;
import com.geolocsystems.prismandroid.model.Delegation;
import com.geolocsystems.prismandroid.model.FauchagePasse;
import com.geolocsystems.prismbirtbean.SynthesePatrouilleBean;
import com.geolocsystems.prismbirtbean.SynthesePatrouillesBean;
import com.geolocsystems.prismbirtbean.SyntheseTableauBordStatistiqueSchemaRoutierBean;
import com.geolocsystems.prismcentral.beans.PrismCentralUser;
import com.geolocsystems.prismcentral.beans.TronconSuivi;
import com.neogls.prism.central.vaadin.layout.PrismLayout;
import com.neogls.prism.central.vaadin.rest.WMSController;
import com.neogls.prism.central.vaadin.service.ConfigurationService;
import com.neogls.prism.central.vaadin.service.fauchage.historique.HistoriqueFauchageService;
import com.neogls.prism.central.vaadin.service.security.AuthenticatedUser;
import com.neogls.prism.central.vaadin.util.LeafletUtils;
import com.neogls.prism.central.vaadin.util.vaadin.DatePickerI18nUtils;
import com.neogls.prism.central.vaadin.view.mct.common.ICartoPane;
import com.neogls.prism.central.vaadin.view.mct.common.carto.SuiviStyleService;
import com.neogls.prism.central.vaadin.view.mct.common.carto.cluster.ClusterCartoPaneFactory;
import com.neogls.prism.central.vaadin.view.mct.common.carto.layer.PrismLayerFactory;
import com.neogls.prism.central.vaadin.view.mct.common.carto.layer.TronconVhLayer;
import com.neogls.prism.central.vaadin.view.mct.fauchage.historique.ExportButtonFauchageHistorique;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.accordion.Accordion;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.NativeLabel;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.router.HasDynamicTitle;
import com.vaadin.flow.router.Route;
import gls.outils.GLS;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vaadin.addons.componentfactory.leaflet.controls.LeafletControl;
import org.vaadin.addons.componentfactory.leaflet.controls.ScaleControl;
import org.vaadin.addons.componentfactory.leaflet.layer.Layer;
import org.vaadin.addons.componentfactory.leaflet.layer.groups.LayerGroup;
import org.vaadin.addons.componentfactory.leaflet.layer.raster.TileLayer;
import org.vaadin.addons.componentfactory.leaflet.types.LatLngBounds;

@RolesAllowed(value={"ACTION_FAUCHAGE_CONSULTATION_HISTORIQUE"})
@Route(value="fauchage/visualisation-fauchage-historique", layout=PrismLayout.class)
public class FauchageHistorique
extends VerticalLayout
implements HasDynamicTitle {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FauchageHistorique.class);
    public static int TAILLE_BOUTTON = 150;
    private final ConfigurationService configurationService;
    protected ICartoPane cartoPane = null;
    private LatLngBounds maxBounds;
    private TronconVhLayer tronconFauchageLayer;
    protected PrismCentralUser user;
    protected HorizontalLayout headerInfoComponent;
    private HorizontalLayout hlButtons;
    private HorizontalLayout hlCombo;
    protected Button btVisualiser;
    private RadioButtonGroup<String> rbChoixDate;
    protected DatePicker dateDebutHistorique;
    protected DatePicker dateFinHistorique;
    private ComboBox<String> cbPasseFauchage;
    private ComboBox<Delegation> delegationsBox;
    private ComboBox<Centre> centresBox;
    private ComboBox<Circuit> circuitsBox;
    private Delegation delegationNull;
    private Centre centreNull;
    private Circuit circuitNull;
    protected Span labelHistorique;
    private Map<String, LayerGroup> layersWMS;
    private HistoriqueFauchageService historiqueFauchageService;
    private Grid<SyntheseTableauBordStatistiqueSchemaRoutierBean> table;
    private Grid<SynthesePatrouilleBean> table2;
    private ExportButtonFauchageHistorique buttonExporter;
    private int typeGestionPasse;

    public FauchageHistorique(ConfigurationService configurationService, SuiviStyleService suiviStyleService, HistoriqueFauchageService fauchageService, PrismLayerFactory prismLayerFactory, ClusterCartoPaneFactory clusterCartoPaneFactory, ConfigurationService configurationService1) {
        this.historiqueFauchageService = fauchageService;
        this.configurationService = configurationService;
        Optional valTtpe = configurationService.getInt(ConfigurationService.ConfigurationType.DATABASE, "fauchage.type.gestion.passe");
        if (valTtpe.isPresent()) {
            this.typeGestionPasse = (Integer)valTtpe.get();
        }
        this.delegationNull = new Delegation();
        this.delegationNull.setNom("");
        this.centreNull = new Centre();
        this.centreNull.setNom("");
        this.circuitNull = new Circuit();
        this.circuitNull.setId("");
        this.layersWMS = new HashMap();
        this.user = fauchageService.getUserLogedIn();
        this.createIHM(configurationService, suiviStyleService, fauchageService, prismLayerFactory, clusterCartoPaneFactory);
    }

    protected void createIHM(ConfigurationService configurationService, SuiviStyleService suiviStyleService, HistoriqueFauchageService fauchageService, PrismLayerFactory prismLayerFactory, ClusterCartoPaneFactory clusterCartoPaneFactory) {
        AuthenticatedUser currentUser;
        Span titre = new Span(this.getTranslation("fauchage.historique.title", new Object[0]));
        titre.addClassNames(new String[]{"text-header", "p-s", "bg-base", "shadow-xs", "rounded-l"});
        this.add(new Component[]{titre});
        this.hlButtons = new HorizontalLayout();
        this.hlButtons.setSizeUndefined();
        this.hlButtons.setSpacing(true);
        this.hlButtons.setAlignItems(FlexComponent.Alignment.CENTER);
        this.hlCombo = new HorizontalLayout();
        this.hlCombo.setSizeUndefined();
        this.hlCombo.setSpacing(true);
        this.hlCombo.setMargin(true);
        this.hlCombo.setAlignItems(FlexComponent.Alignment.CENTER);
        this.delegationsBox = new ComboBox(this.getTranslation("global.delegation", new Object[0]));
        this.delegationsBox.setPlaceholder(this.getTranslation("mct.filtre.delegation.toutes", new Object[0]));
        this.delegationsBox.setClearButtonVisible(true);
        this.centresBox = new ComboBox(this.getTranslation("global.centre", new Object[0]));
        this.centresBox.setPlaceholder(this.getTranslation("mct.filtre.centre.tous", new Object[0]));
        this.centresBox.setClearButtonVisible(true);
        List delegations = this.historiqueFauchageService.getDelegations();
        this.delegationsBox.setItems((Collection)delegations);
        this.delegationsBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            for (Delegation d : delegations) {
                if (event.getValue() == null || !d.getNom().equals(((Delegation)event.getValue()).getNom())) continue;
                this.centresBox.clear();
                this.centresBox.setItems((Collection)(((ComboBox)event.getSource()).isEmpty() ? List.of() : d.getCentres()));
                this.centresBox.setReadOnly(((ComboBox)event.getSource()).isEmpty());
            }
        });
        if (fauchageService.getPasseTypeGestion() == 1) {
            List circuits = this.historiqueFauchageService.getCircuits();
            this.circuitsBox = new ComboBox(this.getTranslation("global.circuit", new Object[0]));
            this.circuitsBox.setPlaceholder(this.getTranslation("mct.filtre.circuit.tous", new Object[0]));
            this.circuitsBox.setClearButtonVisible(true);
            this.centresBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
                List circuitsFiltres = circuits.stream().filter(c -> event.getValue() != null && c.getCentre() != null && c.getCentre().equals(((Centre)event.getValue()).getNom())).collect(Collectors.toUnmodifiableList());
                this.circuitsBox.clear();
                this.circuitsBox.setItems(circuitsFiltres);
                this.circuitsBox.setReadOnly(((ComboBox)event.getSource()).isEmpty());
            });
        }
        if ((currentUser = this.historiqueFauchageService.getCurrentUser()).getDelegation() != null) {
            this.delegationsBox.setReadOnly(true);
            this.delegationsBox.setValue((Object)currentUser.getDelegation());
        }
        if (currentUser.getCentre() != null) {
            this.centresBox.setReadOnly(true);
            this.centresBox.setValue((Object)currentUser.getCentre());
        }
        this.dateDebutHistorique = new DatePicker(this.getTranslation("fauchage.historique.datefiled.name.debut", new Object[0]));
        this.dateDebutHistorique.setAllowedCharPattern("dd/MM/yyyy HH:mm");
        this.dateDebutHistorique.setWidth(150.0f, Unit.PIXELS);
        this.dateDebutHistorique.setI18n(DatePickerI18nUtils.getDatePickerI18n());
        this.dateFinHistorique = new DatePicker(this.getTranslation("fauchage.historique.datefiled.name.fin", new Object[0]));
        this.dateFinHistorique.setAllowedCharPattern("dd/MM/yyyy HH:mm");
        this.dateFinHistorique.setWidth(150.0f, Unit.PIXELS);
        this.dateFinHistorique.setI18n(DatePickerI18nUtils.getDatePickerI18n());
        this.cbPasseFauchage = new ComboBox(this.getTranslation("global.passe_fauchage", new Object[0]));
        List passeTypes = fauchageService.listeTypePasse();
        if (fauchageService.getPasseTypeGestion() == 0) {
            this.cbPasseFauchage.setItems(passeTypes.stream().map(passeType -> passeType.getLibelle()).toList());
        } else if (fauchageService.getPasseTypeGestion() == 1) {
            passesCentre = fauchageService.listePasseParCircuit();
            if (passesCentre != null) {
                mPassesCentre = passesCentre.stream().collect(Collectors.groupingBy(FauchagePasse::getType));
                this.cbPasseFauchage.setItems(passeTypes.stream().map(passeType -> passeType.getLibelle() + " (" + this.getIntervalleDate((List)mPassesCentre.get(passeType.getTypeId())) + ")").toList());
            } else {
                this.cbPasseFauchage.setItems(passeTypes.stream().map(passeType -> passeType.getLibelle()).toList());
            }
        } else {
            passesCentre = fauchageService.listePasseParCampagne();
            mPassesCentre = passesCentre.stream().collect(Collectors.groupingBy(FauchagePasse::getType));
            this.cbPasseFauchage.setItems(passeTypes.stream().map(passeType -> passeType.getLibelle() + " (" + this.getIntervalleDate((List)mPassesCentre.get(passeType.getTypeId())) + ")").toList());
        }
        this.cbPasseFauchage.setVisible(true);
        this.cbPasseFauchage.setMinWidth("300px");
        this.labelHistorique = new Span();
        VerticalLayout vlDelegationCentre = new VerticalLayout();
        vlDelegationCentre.setSizeUndefined();
        vlDelegationCentre.setSpacing(true);
        vlDelegationCentre.setMargin(true);
        vlDelegationCentre.setAlignItems(FlexComponent.Alignment.CENTER);
        vlDelegationCentre.add(new Component[]{this.delegationsBox});
        vlDelegationCentre.add(new Component[]{this.centresBox});
        if (fauchageService.getPasseTypeGestion() == 1) {
            vlDelegationCentre.add(new Component[]{this.circuitsBox});
        }
        this.hlCombo.add(new Component[]{vlDelegationCentre});
        this.hlCombo.setClassName("prism-custom-field");
        HorizontalLayout vlDates = new HorizontalLayout();
        vlDates.add(new Component[]{this.dateDebutHistorique});
        vlDates.add(new Component[]{this.dateFinHistorique});
        vlDates.setVisible(false);
        this.rbChoixDate = new RadioButtonGroup();
        this.rbChoixDate.setLabel(this.getTranslation("report.stats.mode_calcul", new Object[0]));
        Object[] modeOptions = new String[]{"Par passes", "Par dates"};
        this.rbChoixDate.setItems(modeOptions);
        this.rbChoixDate.setValue((Object)"Par passes");
        this.rbChoixDate.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            this.cbPasseFauchage.setVisible("Par passes".equals(e.getValue()));
            vlDates.setVisible("Par dates".equals(e.getValue()));
        });
        VerticalLayout layout = new VerticalLayout();
        layout.add(new Component[]{this.rbChoixDate, vlDates, this.cbPasseFauchage});
        this.add(new Component[]{layout});
        this.hlCombo.add(new Component[]{layout});
        Button btAppliquer = new Button(this.getTranslation("fauchage.historique.apply", new Object[0]));
        btAppliquer.setWidth((float)TAILLE_BOUTTON, Unit.PIXELS);
        btAppliquer.addClickListener((ComponentEventListener & Serializable)e -> {
            Date dateDebut = null;
            Date dateFin = null;
            String delegation = this.delegationsBox.getValue() == null ? null : ((Delegation)this.delegationsBox.getValue()).toString();
            String centre = this.centresBox.getValue() == null ? null : ((Centre)this.centresBox.getValue()).toString();
            String circuit = null;
            if (fauchageService.getPasseTypeGestion() == 1) {
                String string = circuit = this.circuitsBox.getValue() == null ? null : ((Circuit)this.circuitsBox.getValue()).getId();
            }
            if (((String)this.rbChoixDate.getValue()).equals("Par dates")) {
                dateDebut = Date.from(((LocalDate)this.dateDebutHistorique.getValue()).atStartOfDay(ZoneId.systemDefault()).toInstant().plusSeconds(86400L));
                dateFin = this.dateFinHistorique.getValue() == null ? new Date(dateDebut.getTime() + 86400000L) : Date.from(((LocalDate)this.dateFinHistorique.getValue()).atStartOfDay(ZoneId.systemDefault()).toInstant().plusSeconds(86400L));
                Timestamp dateDebutValue = new Timestamp(dateDebut.getTime());
                Timestamp dateFinValue = new Timestamp(dateFin.getTime());
                List synthesePatrouilleBean = this.historiqueFauchageService.getStatistiqueSchemaFauchageHistorique(this.typeGestionPasse, dateDebutValue, dateFinValue, delegation, centre, circuit);
                SimpleDateFormat sdfDate = new SimpleDateFormat("dd/MM/yyyy");
                SynthesePatrouillesBean synthese = new SynthesePatrouillesBean();
                synthese.setDateDebut(sdfDate.format(dateDebut));
                if (dateFin != null) {
                    synthese.setDateFin(sdfDate.format(dateFin));
                } else {
                    synthese.setDateFin("-");
                }
                if (this.delegationsBox.getValue() != null) {
                    synthese.setArrondissement(((Delegation)this.delegationsBox.getValue()).toString());
                } else {
                    synthese.setArrondissement("Tous");
                }
                if (this.centresBox.getValue() != null) {
                    synthese.setCerd(((Centre)this.centresBox.getValue()).toString());
                } else {
                    synthese.setCerd("Tous");
                }
                this.updateTable(synthesePatrouilleBean);
                this.setURLWMS((String)configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "carto.mci.url").get(), (String)configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "carto.fauchage.historique.map").get(), (String)configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "carto.fauchage.historique.layers").get(), "PNG", true, (String)configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "carto.fauchage.historique.projection").get(), delegation, centre, null, sdfDate.format(dateDebut), sdfDate.format(dateFin), (String)configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "carto.statistique.circuit.buffer.size").get());
                this.buttonExporter.setEnabled(true);
                this.buttonExporter.setDelegation(this.getDelegationPourSelection());
                this.buttonExporter.setCentre(this.getCentrePourSelection());
                this.buttonExporter.setCircuit(this.getCircuitPourSelection());
                this.buttonExporter.setDateDebut(dateDebut);
                this.buttonExporter.setDateFin(dateFin);
                this.buttonExporter.updateHref();
            } else {
                String passeLibelle = ((String)this.cbPasseFauchage.getValue()).split(" \\(")[0];
                List synthesePatrouilleBean = this.historiqueFauchageService.getStatistiqueSchemaFauchageHistorique(this.typeGestionPasse, passeLibelle, delegation, centre, circuit);
                SimpleDateFormat sdfDate = new SimpleDateFormat("dd/MM/yyyy");
                SynthesePatrouillesBean synthese = new SynthesePatrouillesBean();
                if (this.delegationsBox.getValue() != null) {
                    synthese.setArrondissement(((Delegation)this.delegationsBox.getValue()).toString());
                } else {
                    synthese.setArrondissement("Tous");
                }
                if (this.centresBox.getValue() != null) {
                    synthese.setCerd(((Centre)this.centresBox.getValue()).toString());
                } else {
                    synthese.setCerd("Tous");
                }
                this.updateTable(synthesePatrouilleBean);
                this.setURLWMS((String)configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "carto.mci.url").get(), (String)configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "carto.fauchage.historique.map").get(), (String)configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "carto.fauchage.historique.layers").get(), "PNG", true, (String)configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "carto.fauchage.historique.projection").get(), delegation, centre, passeLibelle, null, null, (String)configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "carto.statistique.circuit.buffer.size").get());
            }
            this.buttonExporter.setEnabled(true);
            this.buttonExporter.setDelegation(this.getDelegationPourSelection());
            this.buttonExporter.setCentre(this.getCentrePourSelection());
            this.buttonExporter.setCircuit(this.getCircuitPourSelection());
            this.buttonExporter.setDateDebut(dateDebut);
            this.buttonExporter.setDateFin(dateFin);
            this.buttonExporter.update();
        });
        this.hlButtons.add(new Component[]{btAppliquer});
        this.buttonExporter = new ExportButtonFauchageHistorique(this, fauchageService.getExportFormats());
        this.buttonExporter.setEnabled(false);
        this.hlButtons.add(new Component[]{this.buttonExporter});
        this.hlCombo.add(new Component[]{this.hlButtons});
        this.hlCombo.setVerticalComponentAlignment(FlexComponent.Alignment.CENTER, new Component[]{this.hlButtons});
        this.add(new Component[]{this.hlCombo});
        this.cartoPane = clusterCartoPaneFactory.newClusterCartoPane(Integer.valueOf(this.historiqueFauchageService.getCodeModuleMetier()));
        this.tronconFauchageLayer = prismLayerFactory.createTronconVhLayer(this.historiqueFauchageService.getCodeModuleMetier());
        if (this.tronconFauchageLayer != null) {
            this.tronconFauchageLayer.addTo(this.cartoPane, "Barreaux Fauchage");
        }
        this.cartoPane.addCartoLayer();
        prismLayerFactory.tryCreateCartoLayerSupp(this.historiqueFauchageService.getCodeModuleMetier()).ifPresent(cartoLayers -> cartoLayers.forEach((layerName, layer) -> layer.addTo(this.cartoPane, layerName)));
        this.maxBounds = LeafletUtils.getMaxBounds((ConfigurationService)configurationService);
        if (this.cartoPane != null) {
            ScaleControl scaleControl = new ScaleControl();
            scaleControl.setMaxWidth(100);
            scaleControl.setPosition(LeafletControl.ControlPosition.bottomleft);
            scaleControl.addTo(this.cartoPane.getMap());
            this.cartoPane.setSizeFull();
            this.cartoPane.setWidthFull();
            this.cartoPane.setHeightFull();
            this.cartoPane.setHeight(95.0f, Unit.PERCENTAGE);
            this.cartoPane.setWidth(100.0f, Unit.PERCENTAGE);
            VerticalLayout layoutCarto = new VerticalLayout();
            layoutCarto.setMinWidth(500.0f, Unit.PIXELS);
            layoutCarto.setMinHeight(500.0f, Unit.PIXELS);
            ICartoPane iCartoPane = this.cartoPane;
            if (!(iCartoPane instanceof Component)) {
                throw new IllegalStateException("CartoPane should extends Component but %s does not".formatted(this.cartoPane.getClass().getSimpleName()));
            }
            Component cartoPaneComponent = (Component)iCartoPane;
            layoutCarto.setSizeFull();
            layoutCarto.add(new Component[]{cartoPaneComponent});
            this.add(new Component[]{layoutCarto});
            this.setAlignItems(FlexComponent.Alignment.CENTER);
            this.setSizeFull();
            this.addClassNames(new String[]{"p-m", "box-border"});
        }
    }

    private String getIntervalleDate(List<FauchagePasse> fauchagePasses) {
        long passeDebutMin = Long.MAX_VALUE;
        long passeFinMax = Long.MIN_VALUE;
        if (fauchagePasses != null) {
            for (FauchagePasse fauchagePasse : fauchagePasses) {
                if (passeDebutMin > fauchagePasse.getPasseDebut()) {
                    passeDebutMin = fauchagePasse.getPasseDebut();
                }
                if (passeFinMax >= fauchagePasse.getPasseFin()) continue;
                passeFinMax = fauchagePasse.getPasseFin();
            }
            SimpleDateFormat sdf = new SimpleDateFormat("MM/yyyy");
            return sdf.format(new Date(passeDebutMin)) + "->" + (passeFinMax != -1L ? sdf.format(new Date(passeFinMax)) : "NC");
        }
        return "";
    }

    private String getDelegationPourSelection() {
        if (this.delegationsBox.getValue() != null) {
            return ((Delegation)this.delegationsBox.getValue()).toString();
        }
        return null;
    }

    private String getCentrePourSelection() {
        if (this.centresBox.getValue() != null) {
            return GLS.estVide((String)((Centre)this.centresBox.getValue()).toString()) ? null : ((Centre)this.centresBox.getValue()).toString();
        }
        return null;
    }

    private String getCircuitPourSelection() {
        if (this.typeGestionPasse == 1 && this.circuitsBox.getValue() != null) {
            return ((Circuit)this.circuitsBox.getValue()).getId();
        }
        return null;
    }

    protected void visualisationHistorique() {
        Date dateDebut = Date.from(((LocalDate)this.dateDebutHistorique.getValue()).atStartOfDay(ZoneId.systemDefault()).toInstant());
        Date dateFin = null;
        dateFin = this.dateFinHistorique.getValue() == null ? new Date(dateDebut.getTime() + 86400000L) : Date.from(((LocalDate)this.dateFinHistorique.getValue()).atStartOfDay(ZoneId.systemDefault()).toInstant());
        this.labelHistorique.setText(this.getTranslation("fauchage.historique.date_recherche", new Object[0]) + new SimpleDateFormat("dd/MM/yyyy HH:mm").format(dateDebut) + " - " + new SimpleDateFormat("dd/MM/yyyy HH:mm").format(dateFin));
    }

    private void updateCarto(List<TronconSuivi> barreaux) {
        Set troncon = barreaux.stream().map(b -> {
            TronconSuivi suivi = new TronconSuivi();
            suivi.setCode("FA");
            suivi.setX(b.getX());
            suivi.setY(b.getY());
            return suivi;
        }).collect(Collectors.toSet());
        this.tronconFauchageLayer.clearLayer();
        this.tronconFauchageLayer.setTronconsSuivis(troncon);
        LatLngBounds boundsLayer = this.tronconFauchageLayer.getLayerBounds();
        this.cartoPane.getMap().flyToBounds(boundsLayer);
    }

    public int getActionId() {
        return 30010;
    }

    public String getPath() {
        return this.getTranslation("vh.title", new Object[0]) + " > " + this.getTranslation("vh.historiqueTronconVH.title", new Object[0]);
    }

    public String getPageTitle() {
        return "";
    }

    public void setURLWMS(String urlCarto, String mapfile, String layers, String formatImage, boolean noCache, String srs, String delegation, String centre, String passe, String dateMin, String dateMax, String bufferSize) {
        LayerGroup wmsGroupLayer = (LayerGroup)this.layersWMS.get(layers);
        if (wmsGroupLayer == null) {
            wmsGroupLayer = new LayerGroup(new Layer[0]);
            this.layersWMS.put(layers, wmsGroupLayer);
            this.cartoPane.addLayer((Layer)wmsGroupLayer);
            this.cartoPane.addOverlayLayer((Layer)wmsGroupLayer, (String)layers);
        } else {
            wmsGroupLayer.clearLayers();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("FORMAT", formatImage);
        params.put("TRANSPARENT", "true");
        params.put("MAP", mapfile);
        params.put("TIMESTAMP", "" + System.currentTimeMillis());
        params.put("SRS", srs);
        if (delegation != null) {
            params.put("delegation", delegation);
        }
        if (centre != null) {
            params.put("centre", centre);
        }
        if (passe != null) {
            params.put("passe", passe);
            layers = (String)layers + "_passe";
        } else {
            params.put("date_debut", dateMin);
            params.put("date_fin", dateMax);
            layers = (String)layers + "_date";
        }
        params.put("buffer", bufferSize);
        params.put("LAYERS", layers);
        TileLayer tileLayer = new TileLayer(WMSController.Helper.createWMSLayerURL((String)urlCarto, (String)layers, (String)this.configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "carto.formatImage").orElse(null), params));
        wmsGroupLayer.addLayer((Layer)tileLayer);
    }

    private void updateTable(List<SyntheseTableauBordStatistiqueSchemaRoutierBean> synthese) {
        if (this.table != null) {
            this.remove(new Component[]{this.table});
        }
        this.table = new Grid();
        this.table.setWidth(100.0f, Unit.PERCENTAGE);
        this.table.setHeight(800.0f, Unit.PIXELS);
        this.table.addColumn(SyntheseTableauBordStatistiqueSchemaRoutierBean::getIdTroncon).setHeader(this.getTranslation("fauchage.historique.id_troncon", new Object[0])).setVisible(true);
        this.table.addColumn(SyntheseTableauBordStatistiqueSchemaRoutierBean::getDelegation).setHeader(this.getTranslation("fauchage.historique.delegation", new Object[0])).setVisible(true);
        this.table.addColumn(SyntheseTableauBordStatistiqueSchemaRoutierBean::getCentre).setHeader(this.getTranslation("fauchage.historique.centre", new Object[0])).setVisible(true);
        this.table.addColumn(SyntheseTableauBordStatistiqueSchemaRoutierBean::getLongueur).setHeader(this.getTranslation("fauchage.historique.longueur", new Object[0])).setVisible(true);
        this.table.addColumn((ValueProvider & Serializable)spb -> {
            int longueurCumulle = (Integer)spb.getParametres((Object)"distance_cumulee");
            return longueurCumulle;
        }).setHeader(this.getTranslation("fauchage.historique.distance_cumulee", new Object[0])).setVisible(true);
        this.table.addColumn((Renderer)new ComponentRenderer((SerializableFunction & Serializable)stbs -> {
            Timestamp[] datesPassage;
            Accordion acc = new Accordion();
            VerticalLayout v = new VerticalLayout();
            for (Timestamp datePassage : datesPassage = (Timestamp[])stbs.getParametres((Object)"dates_passage")) {
                NativeLabel nativeLabel = new NativeLabel();
                nativeLabel.setText(datePassage + "\n");
                v.add(new Component[]{nativeLabel});
            }
            acc.add(String.valueOf(datesPassage.length), (Component)v);
            acc.close();
            return acc;
        })).setHeader(this.getTranslation("fauchage.historique.dates_passage", new Object[0])).setFlexGrow(0).setAutoWidth(true);
        if (this.typeGestionPasse != 2) {
            this.table.addColumn((ValueProvider & Serializable)spb -> {
                String passe = (String)spb.getParametres((Object)"passe_libelle");
                return passe;
            }).setHeader(this.getTranslation("fauchage.historique.passe_libelle", new Object[0])).setVisible(true);
        } else {
            this.table.addColumn((ValueProvider & Serializable)spb -> {
                Integer passeTypeId = (Integer)spb.getParametres((Object)"passe_type_id");
                if (passeTypeId == null) {
                    return "NR";
                }
                return this.historiqueFauchageService.listeTypePasse().stream().filter(passe -> passe.getTypeId() == passeTypeId.intValue()).findFirst().get().getLibelle();
            }).setHeader(this.getTranslation("fauchage.historique.passe_libelle", new Object[0])).setVisible(true);
        }
        this.table.setItems(synthese);
        this.add(new Component[]{this.table});
        this.setHeight(1200.0f, Unit.PIXELS);
    }

    private void updateTableSynthesePatrouilleBean(List<SynthesePatrouilleBean> synthesePatrouilleBean) {
        if (this.table2 != null) {
            this.remove(new Component[]{this.table2});
        }
        this.table2 = new Grid();
        this.table2.setWidth(100.0f, Unit.PERCENTAGE);
        this.table2.setHeight(800.0f, Unit.PIXELS);
        this.table2.addColumn(SynthesePatrouilleBean::getDateDebut).setHeader(this.getTranslation("rapport.synthese.date_debut", new Object[0])).setVisible(true);
        this.table2.addColumn(SynthesePatrouilleBean::getDateFin).setHeader(this.getTranslation("rapport.synthese.date_fin", new Object[0])).setVisible(true);
        this.table2.addColumn(SynthesePatrouilleBean::getPatrouilleur).setHeader(this.getTranslation("rapport.synthese.patrouilleur", new Object[0])).setVisible(true);
        this.table2.addColumn(SynthesePatrouilleBean::getLongueurPatrouille).setHeader(this.getTranslation("rapport.synthese.longueur_totale", new Object[0])).setVisible(true);
        this.table2.addComponentColumn((ValueProvider & Serializable)spb -> {
            VerticalLayout v = new VerticalLayout();
            Map detailsRoute = spb.getLongueurStatus();
            for (String route : detailsRoute.keySet()) {
                NativeLabel nativeLabel = new NativeLabel();
                nativeLabel.setText(route + ": " + detailsRoute.get(route) + "m");
                v.add(new Component[]{nativeLabel});
            }
            return v;
        }).setHeader(this.getTranslation("rapport.synthese.details_route", new Object[0])).setVisible(true);
        this.table2.setItems(synthesePatrouilleBean);
        this.add(new Component[]{this.table2});
    }
}

