/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.fauchage;

import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismcentral.beans.TronconSuivi;
import com.geolocsystems.prismcentral.beans.VehiculeEnIntervention;
import com.neogls.prism.central.vaadin.layout.PrismLayout;
import com.neogls.prism.central.vaadin.service.ConfigurationService;
import com.neogls.prism.central.vaadin.service.UserPermissionService;
import com.neogls.prism.central.vaadin.util.MctListUtil;
import com.neogls.prism.central.vaadin.view.mct.common.CommonMct;
import com.neogls.prism.central.vaadin.view.mct.common.ICartoPane;
import com.neogls.prism.central.vaadin.view.mct.common.LeftSidePane;
import com.neogls.prism.central.vaadin.view.mct.common.bottomsidepane.BottomSidePane;
import com.neogls.prism.central.vaadin.view.mct.common.bottomsidepane.Slot;
import com.neogls.prism.central.vaadin.view.mct.common.carto.cluster.ClusterCartoPaneFactory;
import com.neogls.prism.central.vaadin.view.mct.common.carto.layer.PrismLayerFactory;
import com.neogls.prism.central.vaadin.view.mct.common.event.list.EventActionListener;
import com.neogls.prism.central.vaadin.view.mct.common.list.MctCartoComponent;
import com.neogls.prism.central.vaadin.view.mct.common.list.MctList;
import com.neogls.prism.central.vaadin.view.mct.common.list.MctListItemsClearEvent;
import com.neogls.prism.central.vaadin.view.mct.common.list.MctListItemsLoadEvent;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.list.MctPatrolList;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.list.PatrolActionListener;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.list.PatrolMctListService;
import com.neogls.prism.central.vaadin.view.mct.fauchage.MctFauchageService;
import com.vaadin.flow.router.HasDynamicTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@RolesAllowed(value={"ACTION_FAUCHAGE"})
@Route(value="mct/fauchage", layout=PrismLayout.class)
public class MctFauchage
extends CommonMct
implements HasDynamicTitle {
    private final MctFauchageService mctFauchageService;
    private final UserPermissionService userPermissionService;
    private final LeftSidePane leftSidePane;
    private final BottomSidePane bottomSidePane;
    private final ICartoPane cartoPane;
    private final MctPatrolList patrolList;
    private Slot slotNbPatrouilles;
    private Slot slotConditionsDeCirculation;

    public MctFauchage(ConfigurationService configurationService, MctFauchageService mctFauchageService, EventActionListener eventActionListener, PatrolActionListener patrolActionListener, ClusterCartoPaneFactory clusterCartoPaneFactory, PrismLayerFactory prismLayerFactory, UserPermissionService userPermissionService) {
        super(configurationService);
        this.mctFauchageService = mctFauchageService;
        this.userPermissionService = userPermissionService;
        this.leftSidePane = new LeftSidePane();
        this.cartoPane = clusterCartoPaneFactory.newClusterCartoPane(Integer.valueOf(mctFauchageService.getPatrolMctListService().getPrimaryBusinessModuleCode()));
        this.cartoPane.addCartoLayer();
        prismLayerFactory.tryCreateCartoLayerSupp(mctFauchageService.getPatrolMctListService().getPrimaryBusinessModuleCode()).ifPresent(cartoLayers -> cartoLayers.forEach((layerName, layer) -> layer.addTo(this.cartoPane, layerName)));
        this.cartoPane.addPatrolTracksLayer(patrolActionListener);
        this.patrolList = MctListUtil.addMctPatrolList((CommonMct)this, (String)this.getTranslation("mct.vehicles", new Object[0]), (PatrolMctListService)mctFauchageService.getPatrolMctListService(), (MctCartoComponent)this.getCartoPane().getPatrolCartoComponent(), (PatrolActionListener)patrolActionListener);
        this.patrolList.addItemsClearListener(arg_0 -> this.onPatrolListItemsCleared(arg_0));
        this.patrolList.addItemsLoadListener(arg_0 -> this.onPatrolListItemsLoaded(arg_0));
        this.bottomSidePane = BottomSidePane.create();
    }

    protected void init() {
        this.slotConditionsDeCirculation = this.bottomSidePane.getTab(BottomSidePane.DefaultTab.INFORMATIONS).newSlot();
        this.slotNbPatrouilles = this.bottomSidePane.getTab(BottomSidePane.DefaultTab.INFORMATIONS).newSlot();
    }

    protected CompletableFuture<Void> refresh() {
        if (this.userPermissionService.canShowPatrols()) {
            return this.patrolList.refreshItems();
        }
        return CompletableFuture.completedFuture(null);
    }

    private void onPatrolListItemsCleared(MctListItemsClearEvent<VehiculeEnIntervention> event) {
        event.registerUiAccess(ui -> this.getBottomSidePane().getTab(BottomSidePane.DefaultTab.INFORMATIONS).clear());
    }

    private void onPatrolListItemsLoaded(MctListItemsLoadEvent<VehiculeEnIntervention> event) {
        Set patrolIds = ((MctList)event.getSource()).getItems().stream().map(VehiculeEnIntervention::getIdPatrouille).collect(Collectors.toSet());
        Collection tronconsSuivis = this.mctFauchageService.getTronconsSuivis(patrolIds);
        event.registerUiAccess(ui -> this.updateBottomSidePaneInfo((Collection)((MctList)event.getSource()).getItems(), tronconsSuivis));
    }

    private void updateBottomSidePaneInfo(Collection<VehiculeEnIntervention> patrols, Collection<TronconSuivi> tronconsSuivis) {
        this.slotNbPatrouilles.setMessage("Nb de patrouilles : " + patrols.size());
        if (!tronconsSuivis.isEmpty()) {
            Map<String, Integer> longueurTroncons = tronconsSuivis.stream().collect(Collectors.groupingBy(TronconSuivi::getCode, Collectors.summingInt(TronconSuivi::getLongueur)));
            String drivingCondition = longueurTroncons.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entry -> this.getTranslation("header.label." + (String)entry.getKey(), new Object[0]) + " : " + MetierCommun.getLongueurPourAffichage((int)((Integer)entry.getValue()))).collect(Collectors.joining(", "));
            this.slotConditionsDeCirculation.setMessage("Lin\u00e9aire fauch\u00e9 : " + drivingCondition);
        }
    }

    public LeftSidePane getLeftSidePane() {
        return this.leftSidePane;
    }

    protected BottomSidePane getBottomSidePane() {
        return this.bottomSidePane;
    }

    protected ICartoPane getCartoPane() {
        return this.cartoPane;
    }

    public String getPageTitle() {
        return this.getTranslation("fauchage.title", new Object[0]);
    }
}

