/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.entretien;

import com.geolocsystems.prismcentral.data.IBusinessService;
import com.neogls.prism.central.vaadin.service.BusinessModuleService;
import com.neogls.prism.central.vaadin.service.ConfigurationService;
import com.neogls.prism.central.vaadin.service.UserPermissionService;
import com.neogls.prism.central.vaadin.service.security.AuthenticatedUser;
import com.neogls.prism.central.vaadin.service.util.AuthenticatedUserUtils;
import com.neogls.prism.central.vaadin.view.mct.common.event.filter.EventFilter;
import com.neogls.prism.central.vaadin.view.mct.common.event.filter.EventFilterFormService;
import com.neogls.prism.central.vaadin.view.mct.common.event.list.AbstractEventMctListService;
import com.neogls.prism.central.vaadin.view.mct.common.event.list.EventActionListener;
import com.neogls.prism.central.vaadin.view.mct.common.event.list.EventDetailsGeneratorService;
import com.neogls.prism.central.vaadin.view.mct.common.event.list.EventListItemGeneratorService;
import com.neogls.prism.central.vaadin.view.mct.common.event.list.EventRetrieverService;
import com.neogls.prism.central.vaadin.view.mct.common.event.list.EventSelectionActionGeneratorService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class MctEntretienEventMctListService
extends AbstractEventMctListService<EventActionListener> {
    private final ConfigurationService configurationService;

    public MctEntretienEventMctListService(IBusinessService businessService, UserPermissionService userPermissionService, BusinessModuleService businessModuleService, ConfigurationService configurationService, EventRetrieverService eventRetrieverService, EventListItemGeneratorService eventListItemGeneratorService, EventDetailsGeneratorService<EventActionListener> eventDetailsGeneratorService, EventSelectionActionGeneratorService<EventActionListener> eventSelectionActionGeneratorService, EventFilterFormService eventFilterFormService) {
        super(businessService, userPermissionService, businessModuleService, configurationService, eventRetrieverService, eventListItemGeneratorService, eventDetailsGeneratorService, eventSelectionActionGeneratorService, eventFilterFormService);
        this.configurationService = configurationService;
    }

    public List<EventFilter> getFilters() {
        AuthenticatedUser currentUser = this.getCurrentUser();
        String delegation = AuthenticatedUserUtils.getDeletationString((AuthenticatedUser)currentUser);
        String center = AuthenticatedUserUtils.getCenterString((AuthenticatedUser)currentUser);
        List mmCodes = this.getBusinessModuleCodes();
        ArrayList<EventFilter> filters = new ArrayList<EventFilter>();
        filters.add(this.getEmptyCustomFilter());
        EventFilter fEnCours = EventFilter.builder().unlocalizedName("mct.filtre.travaux.encours").mmCodes(mmCodes).sqlFilter(this.getEmptyFilter()).build();
        filters.add(fEnCours);
        EventFilter fSemaine = EventFilter.builder().unlocalizedName("mct.filtre.travaux.semaine").mmCodes(mmCodes).sqlFilter(IBusinessService.EvenementFiltre.programmeCetteSemaine((String)delegation, (String)center)).build();
        filters.add(fSemaine);
        if (this.configurationService.getProgrammation()) {
            EventFilter fProg = EventFilter.builder().unlocalizedName("mct.filtre.travaux.prog").mmCodes(mmCodes).sqlFilter(IBusinessService.EvenementFiltre.programmes((String)delegation, (String)center)).build();
            EventFilter fNonProg = EventFilter.builder().unlocalizedName("mct.filtre.travaux.nonprog").mmCodes(mmCodes).sqlFilter(IBusinessService.EvenementFiltre.nonProgrammes((String)delegation, (String)center)).build();
            filters.add(fProg);
            filters.add(fNonProg);
        }
        if (this.configurationService.getBoolean(ConfigurationService.ConfigurationType.DATABASE, "gestionPrevisionnel").orElse(false).booleanValue()) {
            EventFilter fPrev = EventFilter.builder().unlocalizedName("mct.filtre.travaux.prev").mmCodes(mmCodes).sqlFilter(this.getEmptyFilter()).build();
            fPrev.getSqlFilter().previsionnels = 1;
            filters.add(fPrev);
        }
        return filters;
    }

    public EventFilter getDefaultFilter() {
        return EventFilter.builder().unlocalizedName("mct.filtre.travaux.encours").mmCodes(this.getBusinessModuleCodes()).sqlFilter(this.getEmptyFilter()).build();
    }

    public EventFilter editFilterBeforeItemRequest(EventFilter filter) {
        filter.getSqlFilter().initCodeMm(2);
        filter.getSqlFilter().evenementAssocies = false;
        filter.getSqlFilter().statistiques = this.configurationService.getBoolean(ConfigurationService.ConfigurationType.DATABASE, "afficherEvenementsSansCentre").orElse(false) == false;
        return filter;
    }

    public int getPrimaryBusinessModuleCode() {
        return 2;
    }
}

