/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.entretien;

import com.neogls.prism.central.vaadin.layout.PrismLayout;
import com.neogls.prism.central.vaadin.service.ConfigurationService;
import com.neogls.prism.central.vaadin.service.NatureService;
import com.neogls.prism.central.vaadin.service.UserPermissionService;
import com.neogls.prism.central.vaadin.util.MctListUtil;
import com.neogls.prism.central.vaadin.view.mct.common.CommonBottomSideInformationProvider;
import com.neogls.prism.central.vaadin.view.mct.common.CommonMct;
import com.neogls.prism.central.vaadin.view.mct.common.ICartoPane;
import com.neogls.prism.central.vaadin.view.mct.common.LeftSidePane;
import com.neogls.prism.central.vaadin.view.mct.common.bottomsidepane.BottomSidePane;
import com.neogls.prism.central.vaadin.view.mct.common.carto.cluster.ClusterCartoPaneFactory;
import com.neogls.prism.central.vaadin.view.mct.common.event.EventCreationTab;
import com.neogls.prism.central.vaadin.view.mct.common.event.eventsheetdialog.EventSheetDialogFactory;
import com.neogls.prism.central.vaadin.view.mct.common.event.filter.field.IVaadinEventFilterFieldFactory;
import com.neogls.prism.central.vaadin.view.mct.common.event.list.EventActionListener;
import com.neogls.prism.central.vaadin.view.mct.common.event.list.EventMctListService;
import com.neogls.prism.central.vaadin.view.mct.common.event.list.MctEventList;
import com.neogls.prism.central.vaadin.view.mct.common.event.sort.EventSortService;
import com.neogls.prism.central.vaadin.view.mct.common.list.MctCartoComponent;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.list.MctPatrolList;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.list.PatrolActionListener;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.list.PatrolMctListService;
import com.neogls.prism.central.vaadin.view.mct.entretien.MctEntretienService;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.router.HasDynamicTitle;
import com.vaadin.flow.router.Route;
import jakarta.annotation.security.RolesAllowed;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;

@RolesAllowed(value={"ACTION_MCT_ACTIVITE_ENTRETIEN"})
@Route(value="mct/entretien", layout=PrismLayout.class)
public class MctEntretien
extends CommonMct
implements HasDynamicTitle {
    private final MctEntretienService mctEntretienService;
    private final UserPermissionService userPermissionService;
    private final NatureService natureService;
    private final EventSheetDialogFactory eventSheetDialogFactory;
    private final LeftSidePane leftSidePane;
    private final BottomSidePane bottomSidePane;
    private final ICartoPane cartoPane;
    private final MctEventList<?> eventList;
    private final MctPatrolList patrolList;

    public MctEntretien(ConfigurationService configurationService, MctEntretienService mctEntretienService, EventActionListener eventActionListener, PatrolActionListener patrolActionListener, ClusterCartoPaneFactory clusterCartoPaneFactory, NatureService natureService, UserPermissionService userPermissionService, EventSheetDialogFactory eventSheetDialogFactory) {
        super(configurationService);
        this.mctEntretienService = mctEntretienService;
        this.natureService = natureService;
        this.userPermissionService = userPermissionService;
        this.eventSheetDialogFactory = eventSheetDialogFactory;
        this.leftSidePane = new LeftSidePane();
        this.cartoPane = clusterCartoPaneFactory.newClusterCartoPane(Integer.valueOf(mctEntretienService.getEventMctListService().getPrimaryBusinessModuleCode()));
        this.cartoPane.addCartoLayer();
        this.cartoPane.addPatrolTracksLayer(patrolActionListener);
        this.eventList = MctListUtil.addMctEventList((CommonMct)this, (String)this.getTranslation("mct.visu.travaux", new Object[0]), (EventMctListService)mctEntretienService.getEventMctListService(), (IVaadinEventFilterFieldFactory)mctEntretienService.getEventFilterFieldFactory(), (EventSortService)mctEntretienService.getEventSortService(), (MctCartoComponent)this.getCartoPane().getSituationCartoComponent(), (EventActionListener)eventActionListener);
        this.patrolList = MctListUtil.addMctPatrolList((CommonMct)this, (String)this.getTranslation("mct.vehicles", new Object[0]), (PatrolMctListService)mctEntretienService.getPatrolMctListService(), (MctCartoComponent)this.getCartoPane().getPatrolCartoComponent(), (PatrolActionListener)patrolActionListener);
        this.bottomSidePane = BottomSidePane.create();
    }

    protected void init() {
        EventCreationTab creation = new EventCreationTab(this.natureService.getNaturesForCreation(this.mctEntretienService.getEventMctListService().getPrimaryBusinessModuleCode()), this.mctEntretienService.getEventService(), this.eventSheetDialogFactory, this.cartoPane);
        creation.addEventCreationListener((ComponentEventListener & Serializable)event -> this.requestRefresh());
        this.leftSidePane.addTab(this.getTranslation("mct.create", new Object[0]), (Component)creation);
        new CommonBottomSideInformationProvider(this.bottomSidePane, this.eventList);
    }

    protected CompletableFuture<Void> refresh() {
        CompletableFuture eventFuture = this.eventList.refreshItems();
        if (this.userPermissionService.canShowPatrols()) {
            CompletableFuture patrolFuture = this.patrolList.refreshItems();
            return CompletableFuture.allOf(eventFuture, patrolFuture);
        }
        return eventFuture;
    }

    public LeftSidePane getLeftSidePane() {
        return this.leftSidePane;
    }

    protected BottomSidePane getBottomSidePane() {
        return this.bottomSidePane;
    }

    protected ICartoPane getCartoPane() {
        return this.cartoPane;
    }

    public String getPageTitle() {
        return this.getTranslation("entretien.title", new Object[0]);
    }
}

