/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.patrol.visaconfirmdialog;

import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.Situation;
import com.geolocsystems.prismcentral.beans.VehiculeEnIntervention;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.neogls.prism.central.vaadin.service.ConfigurationService;
import com.neogls.prism.central.vaadin.service.PatrolService;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class VisaConfirmDialogService {
    private final IBusinessService businessService;
    private final ConfigurationService configurationService;
    private final PatrolService patrolService;

    public List<Evenement> getEventsOfPatrol(VehiculeEnIntervention patrol) {
        IBusinessService.EvenementFiltre filter = IBusinessService.EvenementFiltre.byMcigId((String)patrol.getMcigId());
        List situations = this.businessService.getEvenements(filter, null);
        return situations.stream().map(Situation::getEvenements).filter(Objects::nonNull).flatMap(Collection::stream).filter(Predicate.not(Evenement::isEvenementPrincipalHorsFiltre)).toList();
    }

    public boolean isShowPR() {
        return this.configurationService.getBoolean(ConfigurationService.ConfigurationType.DATABASE, "recherchePr").orElse(true);
    }

    public boolean visaPatrol(VehiculeEnIntervention patrol) {
        return this.patrolService.visaPatrol(patrol);
    }

    @Generated
    public VisaConfirmDialogService(IBusinessService businessService, ConfigurationService configurationService, PatrolService patrolService) {
        this.businessService = businessService;
        this.configurationService = configurationService;
        this.patrolService = patrolService;
    }
}

