/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.patrol.visaconfirmdialog;

import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampLocalisation;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampTexte;
import com.geolocsystems.prismcentral.beans.VehiculeEnIntervention;
import com.neogls.prism.central.vaadin.common.component.confirmdialog.ButtonConfig;
import com.neogls.prism.central.vaadin.common.component.confirmdialog.ConfirmDialog;
import com.neogls.prism.central.vaadin.common.component.tabsheet.PrismTabSheet;
import com.neogls.prism.central.vaadin.util.DateTimeFormatterUtils;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.visaconfirmdialog.VisaConfirmDialogService;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.Text;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridVariant;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.notification.NotificationVariant;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.time.Instant;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

public class VisaConfirmDialog
extends Dialog {
    private final VisaConfirmDialogService service;
    private final VehiculeEnIntervention patrol;
    private static final Comparator<ValeurChampLocalisation> LOCALISATION_COMPARATOR = Comparator.comparing(ValeurChampLocalisation::getAxe).thenComparingInt(ValeurChampLocalisation::getPrDebut).thenComparingInt(ValeurChampLocalisation::getAbsPrDebut).thenComparingInt(ValeurChampLocalisation::getPrFin).thenComparingInt(ValeurChampLocalisation::getAbsPrFin);

    public VisaConfirmDialog(VisaConfirmDialogService service, VehiculeEnIntervention patrol) {
        this.service = service;
        this.patrol = patrol;
        this.setHeaderTitle(this.getTranslation("mct.visa.confirm.title", new Object[0]));
        Button bCancel = new Button(this.getTranslation("generic.cancel", new Object[0]), (ComponentEventListener & Serializable)event -> this.close());
        Button bVisa = new Button(this.getTranslation("mct.patrouille.viser.bouton", new Object[0]), arg_0 -> this.onVisaClick(arg_0));
        this.getFooter().add(new Component[]{bCancel, bVisa});
        VerticalLayout info = new VerticalLayout(new Component[]{this.createPatrolDetails(), this.createEventGrid()});
        info.setPadding(false);
        info.addClassName("pt-s");
        PrismTabSheet content = new PrismTabSheet();
        content.setSizeFull();
        content.add("Infos", (Component)info);
        this.add(new Component[]{content});
        this.setCloseOnOutsideClick(false);
        this.setCloseOnEsc(false);
        bCancel.addClickShortcut(Key.ESCAPE, new KeyModifier[0]);
        this.addClassName("visa-confirm-dialog");
    }

    private Component createPatrolDetails() {
        FormLayout patrolDetails = new FormLayout();
        patrolDetails.setResponsiveSteps(List.of(new FormLayout.ResponsiveStep("0px", 1)));
        patrolDetails.addFormItem((Component)new Text(this.patrol.getChauffeur()), this.getTranslation("report.patrouilleur", new Object[0]));
        patrolDetails.addFormItem((Component)new Text(Objects.requireNonNullElse(this.patrol.getEquipier(), "-")), this.getTranslation("report.equipiers", new Object[0]));
        patrolDetails.addFormItem((Component)new Text(DateTimeFormatterUtils.getDateTimeFormatter().format(Instant.ofEpochMilli(this.patrol.getDebutPatrouille()))), this.getTranslation("report.dateDebut", new Object[0]));
        patrolDetails.addFormItem((Component)new Text(DateTimeFormatterUtils.getDateTimeFormatter().format(Instant.ofEpochMilli(this.patrol.getFinPatrouille()))), this.getTranslation("report.dateFin", new Object[0]));
        return patrolDetails;
    }

    private Component createEventGrid() {
        Grid grid = new Grid();
        grid.addThemeVariants(new GridVariant[]{GridVariant.LUMO_COMPACT, GridVariant.LUMO_ROW_STRIPES});
        grid.setSelectionMode(Grid.SelectionMode.NONE);
        grid.addClassName("flex-grow");
        grid.addColumn((ValueProvider & Serializable)event -> event.getValeurNature().getDescription().getValeur()).setHeader(this.getTranslation("report.description", new Object[0]));
        grid.addColumn((ValueProvider & Serializable)event -> DateTimeFormatterUtils.getTimeFormatter().format(Instant.ofEpochMilli(event.getDateCreation()))).setHeader(this.getTranslation("report.heureDebut", new Object[0])).setComparator(Comparator.comparingLong(Evenement::getDateCreation));
        grid.addColumn((ValueProvider & Serializable)event -> event.getLocalisation().getCommune()).setHeader(this.getTranslation("report.commune", new Object[0]));
        grid.addColumn((ValueProvider & Serializable)event -> event.getLocalisation().getAxe()).setHeader(this.getTranslation("report.axe", new Object[0]));
        if (this.service.isShowPR()) {
            grid.addColumn(arg_0 -> this.getLabelPR(arg_0)).setHeader(this.getTranslation("report.libellePr", new Object[0])).setComparator((e1, e2) -> LOCALISATION_COMPARATOR.compare(e1.getLocalisation(), e2.getLocalisation()));
        }
        grid.addColumn((ValueProvider & Serializable)event -> event.getValeurNature().getValeurs().stream().filter(valeurChamp -> "commentaire".equals(valeurChamp.getChamp())).findFirst().map(ValeurChampTexte.class::cast).map(ValeurChampTexte::getValeur).orElse("")).setHeader(this.getTranslation("report.commentaires", new Object[0]));
        grid.addColumn((ValueProvider & Serializable)event -> event.isTraite() ? "Oui" : "Non").setHeader(this.getTranslation("report.traite", new Object[0])).setPartNameGenerator((SerializableFunction & Serializable)event -> event.isTraite() ? "traite" : null);
        grid.getColumns().forEach(column -> {
            column.setResizable(true);
            column.setSortable(true);
            column.setFlexGrow(0);
            column.setAutoWidth(true);
        });
        ((Grid.Column)grid.getColumns().get(0)).setFlexGrow(1);
        grid.setWidth(1000.0f, Unit.PIXELS);
        grid.setItems((Collection)this.service.getEventsOfPatrol(this.patrol));
        return grid;
    }

    private String getLabelPR(Evenement event) {
        int prDeb = event.getLocalisation().getPrDebut();
        int absPrDebut = event.getLocalisation().getAbsPrDebut();
        int prFin = event.getLocalisation().getPrFin();
        int absPrFin = event.getLocalisation().getAbsPrFin();
        if (prDeb == -1) {
            return this.getTranslation("localisation.aucunpr", new Object[0]);
        }
        if (prFin == -1 || prDeb == prFin && absPrDebut == absPrFin) {
            return "Au PR " + prDeb + "+" + absPrDebut;
        }
        return "Du PR " + prDeb + "+" + absPrDebut + " au PR " + prFin + "+" + absPrFin;
    }

    private void onVisaClick(ClickEvent<Button> event) {
        ConfirmDialog.builder().title(this.getTranslation("Global.Confirmation", new Object[0])).text(this.getTranslation("mct.patrouille.viser.bouton.confirmer", new Object[0])).confirm(ButtonConfig.builder().text(this.getTranslation("generic.yes", new Object[0])).listener(arg_0 -> this.onVisaConfirmed(arg_0)).build()).cancel(ButtonConfig.builder().text(this.getTranslation("generic.no", new Object[0])).build()).build().open();
    }

    private void onVisaConfirmed(ClickEvent<Button> event) {
        if (this.service.visaPatrol(this.patrol)) {
            Notification.show((String)"Patrouille vis\u00e9e").addThemeVariants((ThemeVariant[])new NotificationVariant[]{NotificationVariant.LUMO_SUCCESS});
            this.close();
        } else {
            Notification.show((String)"Erreur sur la vis\u00e9e de la patrouille !").addThemeVariants((ThemeVariant[])new NotificationVariant[]{NotificationVariant.LUMO_ERROR});
        }
    }
}

