/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.patrol.list.impl;

import com.geolocsystems.prismcentral.beans.VehiculeEnIntervention;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.neogls.prism.central.vaadin.service.ConfigurationService;
import com.neogls.prism.central.vaadin.service.UserPermissionService;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.filter.PatrolFilter;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.list.PatrolRetrieverService;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Service
@Primary
public class CommonPatrolRetrieverService
implements PatrolRetrieverService {
    private final IBusinessService businessService;
    private final ConfigurationService configurationService;
    private final UserPermissionService userPermissionService;

    public List<VehiculeEnIntervention> getPatrols(PatrolFilter filter) {
        if (!this.userPermissionService.canShowInProgressPatrols()) {
            filter.getVehicleFilter().termine = 1;
        }
        List patrols = this.getPatrolsFromDatabase(filter).stream().filter(patrol -> this.testPatrolStateFilter(filter, patrol)).toList();
        return this.configurationService.isAggregationPatrouilles() ? this.aggregatePatrols(patrols, (IBusinessService.VehiculeFiltre)filter.getVehicleFilter()) : patrols;
    }

    private List<VehiculeEnIntervention> getPatrolsFromDatabase(PatrolFilter filter) {
        boolean regroupementPatrouille = this.configurationService.getBoolean(ConfigurationService.ConfigurationType.DATABASE, "CONFIG_REGROUPEMENT_PATROUILLE").orElse(false);
        if (filter.getVehicleFilter().termine != 1) {
            return this.businessService.getVehiculesEnIntervention((IBusinessService.VehiculeFiltre)filter.getVehicleFilter(), regroupementPatrouille);
        }
        return this.businessService.getVehiculesEnInterventionHistorique((IBusinessService.VehiculeFiltre)filter.getVehicleFilter(), regroupementPatrouille);
    }

    private boolean testPatrolStateFilter(PatrolFilter filter, VehiculeEnIntervention patrol) {
        int stateFilter = filter.getVehicleFilter().termine;
        int patrolState = patrol.getEtat();
        if (stateFilter == -1 || stateFilter == 0 && patrolState >= 0 && patrolState <= 2 || stateFilter == 1 && patrolState == 9) {
            if (filter.getVehicleFilter().diffusionWaze) {
                return patrol.isWazeFluxESH() || patrol.isWazeFluxIncidents();
            }
            return true;
        }
        return false;
    }

    private List<VehiculeEnIntervention> aggregatePatrols(List<VehiculeEnIntervention> vehicules, IBusinessService.VehiculeFiltre filtreVehicules) {
        HashMap map = new HashMap();
        for (VehiculeEnIntervention v : vehicules) {
            if (filtreVehicules.patrouillesVisees != null && (filtreVehicules.patrouillesVisees.booleanValue() || v.getDatePatrouilleVisee() != null) && (!filtreVehicules.patrouillesVisees.booleanValue() || v.getDatePatrouilleVisee() == null)) continue;
            if (!map.containsKey(v.getCode())) {
                map.put(v.getCode(), new HashMap());
            }
            if (!((Map)map.get(v.getCode())).containsKey(v.getChauffeur())) {
                ((Map)map.get(v.getCode())).put(v.getChauffeur(), new ArrayList());
            }
            if (((List)((Map)map.get(v.getCode())).get(v.getChauffeur())).isEmpty()) {
                ((List)((Map)map.get(v.getCode())).get(v.getChauffeur())).add(v);
                continue;
            }
            boolean isAggreg = false;
            for (int i = 0; i < ((List)((Map)map.get(v.getCode())).get(v.getChauffeur())).size(); ++i) {
                boolean sameDay;
                VehiculeEnIntervention last = (VehiculeEnIntervention)((List)((Map)map.get(v.getCode())).get(v.getChauffeur())).get(i);
                Calendar cal1 = Calendar.getInstance();
                Calendar cal2 = Calendar.getInstance();
                cal1.setTimeInMillis(v.getDebutPatrouille());
                cal2.setTimeInMillis(last.getDebutPatrouille());
                boolean bl = sameDay = cal1.get(6) == cal2.get(6) && cal1.get(1) == cal2.get(1);
                if (sameDay) {
                    if (v.getDebutPatrouille() < last.getDebutPatrouille()) {
                        ((VehiculeEnIntervention)((List)((Map)map.get(v.getCode())).get(v.getChauffeur())).get(i)).setDebutPatrouille(v.getDebutPatrouille());
                        ((VehiculeEnIntervention)((List)((Map)map.get(v.getCode())).get(v.getChauffeur())).get(i)).getIdsPatrouillesAgreg().addAll(0, v.getIdsPatrouillesAgreg());
                        if (((VehiculeEnIntervention)((List)((Map)map.get(v.getCode())).get(v.getChauffeur())).get(i)).getFinPatrouille() != -1L && (v.getFinPatrouille() > last.getFinPatrouille() || v.getFinPatrouille() == -1L)) {
                            ((VehiculeEnIntervention)((List)((Map)map.get(v.getCode())).get(v.getChauffeur())).get(i)).setFinPatrouille(v.getFinPatrouille());
                        }
                    } else {
                        v.getIdsPatrouillesAgreg().addAll(0, last.getIdsPatrouillesAgreg());
                        v.setDebutPatrouille(((VehiculeEnIntervention)((List)((Map)map.get(v.getCode())).get(v.getChauffeur())).get(i)).getDebutPatrouille());
                        if (((VehiculeEnIntervention)((List)((Map)map.get(v.getCode())).get(v.getChauffeur())).get(i)).getFinPatrouille() == -1L) {
                            v.setFinPatrouille(((VehiculeEnIntervention)((List)((Map)map.get(v.getCode())).get(v.getChauffeur())).get(i)).getFinPatrouille());
                        } else if (((VehiculeEnIntervention)((List)((Map)map.get(v.getCode())).get(v.getChauffeur())).get(i)).getFinPatrouille() != -1L && v.getFinPatrouille() < last.getFinPatrouille()) {
                            v.setFinPatrouille(((VehiculeEnIntervention)((List)((Map)map.get(v.getCode())).get(v.getChauffeur())).get(i)).getFinPatrouille());
                        }
                        ((List)((Map)map.get(v.getCode())).get(v.getChauffeur())).remove(i);
                        ((List)((Map)map.get(v.getCode())).get(v.getChauffeur())).add(i, v);
                    }
                    isAggreg = true;
                }
                if (isAggreg) break;
            }
            if (isAggreg) continue;
            ((List)((Map)map.get(v.getCode())).get(v.getChauffeur())).add(v);
        }
        return map.values().stream().map(Map::values).flatMap(Collection::stream).flatMap(Collection::stream).toList();
    }

    @Generated
    public CommonPatrolRetrieverService(IBusinessService businessService, ConfigurationService configurationService, UserPermissionService userPermissionService) {
        this.businessService = businessService;
        this.configurationService = configurationService;
        this.userPermissionService = userPermissionService;
    }
}

