/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.patrol.list.impl;

import com.geolocsystems.prismandroid.model.Circuit;
import com.geolocsystems.prismcentral.beans.PrismCentralUser;
import com.geolocsystems.prismcentral.beans.VehiculeEnIntervention;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.neogls.prism.central.vaadin.rest.patrolicon.PatrolIconController;
import com.neogls.prism.central.vaadin.rest.patrouilleviseeicon.PatrouilleViseeIconController;
import com.neogls.prism.central.vaadin.service.ConfigurationService;
import com.neogls.prism.central.vaadin.util.DateTimeFormatterUtils;
import com.neogls.prism.central.vaadin.view.mct.common.list.MctListItem;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.list.PatrolListItemGeneratorService;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.component.shared.Tooltip;
import gls.localisation.LocalisationInfo;
import gls.outils.ConstantesGLS;
import java.time.Instant;
import lombok.Generated;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Primary
public class CommonPatrolListItemGeneratorService
implements PatrolListItemGeneratorService {
    private final IBusinessService businessService;
    private final ConfigurationService configurationService;
    private static final String ICON_VISA = PatrouilleViseeIconController.Helper.createPatrouilleViseeIconURL((boolean)true);
    private static final String ICON_NO_VISA = PatrouilleViseeIconController.Helper.createPatrouilleViseeIconURL((boolean)false);

    public Component createPatrolListItem(VehiculeEnIntervention patrol) {
        return new MctListItem((Component)this.createPatrolIcon(patrol), new Component[]{this.firstLine(patrol), this.secondLine(patrol), this.startDate(patrol), this.endDate(patrol), this.lastLocationDate(patrol)});
    }

    private Image createPatrolIcon(VehiculeEnIntervention patrol) {
        Image icon = new Image(PatrolIconController.Helper.createPatrolIconURL((VehiculeEnIntervention)patrol), null);
        icon.setWidth(3.0f, Unit.EM);
        icon.addClassName("block");
        return icon;
    }

    private Component firstLine(VehiculeEnIntervention patrol) {
        Span label = new Span(this.getCircuitText(patrol) + this.getVehicleId(patrol) + " (" + patrol.getChauffeur() + ")");
        label.addClassNames(new String[]{"whitespace-normal", "text-xs"});
        FlexLayout layout = new FlexLayout(new Component[]{label});
        layout.setWidthFull();
        layout.setAlignItems(FlexComponent.Alignment.CENTER);
        layout.setFlexGrow(1.0, new HasElement[]{label});
        if (patrol.isPublie()) {
            layout.add(new Component[]{CommonPatrolListItemGeneratorService.createIcon((String)"images/ico/publish.png", (String)CommonPatrolListItemGeneratorService.getTranslation((Object)"mct.published", (Object[])new Object[0]))});
        }
        if (this.configurationService.isPatrolVisaActive()) {
            if (patrol.estVisee()) {
                PrismCentralUser user;
                StringBuilder tooltip = new StringBuilder(CommonPatrolListItemGeneratorService.getTranslation((Object)"mct.patrouille.visee.ok", (Object[])new Object[0]));
                if (patrol.getDatePatrouilleVisee() != null) {
                    tooltip.append(" ").append(CommonPatrolListItemGeneratorService.getTranslation((Object)"mct.patrouille.visee.ok.le", (Object[])new Object[0])).append(" ").append(DateTimeFormatterUtils.getDateTimeFormatter().format(Instant.ofEpochMilli(patrol.getDatePatrouilleVisee())));
                }
                if (patrol.getViseePar() != null && (user = this.businessService.getUtilisateur(patrol.getViseePar())) != null) {
                    tooltip.append(" ").append(CommonPatrolListItemGeneratorService.getTranslation((Object)"mct.patrouille.visee.ok.par", (Object[])new Object[0])).append(" ").append(user.getNom());
                }
                layout.add(new Component[]{CommonPatrolListItemGeneratorService.createIcon((String)ICON_VISA, (String)tooltip.toString())});
            } else {
                layout.add(new Component[]{CommonPatrolListItemGeneratorService.createIcon((String)ICON_NO_VISA, (String)CommonPatrolListItemGeneratorService.getTranslation((Object)"mct.patrouille.visee.ko", (Object[])new Object[0]))});
            }
        }
        return layout;
    }

    private String getVehicleId(VehiculeEnIntervention patrol) {
        return patrol.getCode() != null && patrol.getCode().length() < 15 ? patrol.getCode() : patrol.getImmatriculation();
    }

    private String getCircuitText(VehiculeEnIntervention patrol) {
        Circuit circuit;
        String idCircuit = patrol.getIdCircuit();
        if (!ConstantesGLS.estVide((String)idCircuit) && ConstantesGLS.getInt((String)idCircuit) > 0 && (circuit = (Circuit)this.businessService.getListeCircuit().get(idCircuit)) != null) {
            return CommonPatrolListItemGeneratorService.getTranslation((Object)"mct.description.circuit", (Object[])new Object[0]) + " " + circuit.getNom() + " / ";
        }
        return "";
    }

    private Component secondLine(VehiculeEnIntervention patrol) {
        Span label = new Span(this.getSecondLineText(patrol));
        label.addClassNames(new String[]{"whitespace-normal", "text-xs"});
        return label;
    }

    private String getSecondLineText(VehiculeEnIntervention patrol) {
        StringBuilder lineText = new StringBuilder();
        if (!ConstantesGLS.estVide((String)patrol.getAxe())) {
            lineText.append(CommonPatrolListItemGeneratorService.getTranslation((Object)"mct.description.sur", (Object[])new Object[0])).append(" ").append(patrol.getAxe());
        }
        if (LocalisationInfo.estLocalisableParAdresse && !ConstantesGLS.estVide((String)patrol.getAdresse())) {
            lineText.append(" ").append(CommonPatrolListItemGeneratorService.getTranslation((Object)"mct.description.adresse", (Object[])new Object[0])).append(patrol.getAdresse());
        }
        if (LocalisationInfo.estLocalisableParPrpk && patrol.getPr() > -1) {
            lineText.append(" - ").append(CommonPatrolListItemGeneratorService.getTranslation((Object)"mct.description.atpr", (Object[])new Object[0])).append(patrol.getPr()).append("+").append(patrol.getAbspr());
        }
        if (!ConstantesGLS.estVide((String)patrol.getCommune())) {
            if (lineText.length() == 0) {
                lineText.append(CommonPatrolListItemGeneratorService.getTranslation((Object)"mct.description.surcommune", (Object[])new Object[0])).append(" ").append(patrol.getCommune());
            } else {
                lineText.append("(").append(patrol.getCommune()).append(")");
            }
        }
        return lineText.toString();
    }

    private Component startDate(VehiculeEnIntervention patrol) {
        Span label = new Span(CommonPatrolListItemGeneratorService.getTranslation((Object)"vehicule.debutpat", (Object[])new Object[0]) + " " + DateTimeFormatterUtils.getDateTimeFormatter().format(Instant.ofEpochMilli(patrol.getDebutPatrouille())));
        label.addClassNames(new String[]{"whitespace-normal", "text-xs"});
        return label;
    }

    private Component endDate(VehiculeEnIntervention patrol) {
        if (patrol.getFinPatrouille() == 1L) {
            return null;
        }
        Span label = new Span(CommonPatrolListItemGeneratorService.getTranslation((Object)"vehicule.finpat", (Object[])new Object[0]) + " " + DateTimeFormatterUtils.getDateTimeFormatter().format(Instant.ofEpochMilli(patrol.getDebutPatrouille())));
        label.addClassNames(new String[]{"whitespace-normal", "text-xs"});
        return label;
    }

    private Component lastLocationDate(VehiculeEnIntervention patrol) {
        Span label = new Span(CommonPatrolListItemGeneratorService.getTranslation((Object)"vehicule.dernierepos", (Object[])new Object[0]) + " " + DateTimeFormatterUtils.getDateTimeFormatter().format(Instant.ofEpochMilli(patrol.getDatePosition())));
        label.addClassNames(new String[]{"whitespace-normal", "text-xs"});
        return label;
    }

    private static String getTranslation(Object key, Object ... params) {
        return UI.getCurrent().getTranslation(key, params);
    }

    private static Image createIcon(String href, String tooltip) {
        Image icon = new Image(href, null);
        icon.setWidth(1.0f, Unit.EM);
        icon.setHeight(1.0f, Unit.EM);
        icon.addClassName("px-xs");
        if (tooltip != null) {
            Tooltip.forComponent((Component)icon).withText(tooltip);
        }
        return icon;
    }

    @Generated
    public CommonPatrolListItemGeneratorService(IBusinessService businessService, ConfigurationService configurationService) {
        this.businessService = businessService;
        this.configurationService = configurationService;
    }
}

