/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.patrol.list.impl;

import com.geolocsystems.prismandroid.model.ModuleMetier;
import com.geolocsystems.prismcentral.beans.VehiculeEnIntervention;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.neogls.prism.central.vaadin.service.BusinessModuleService;
import com.neogls.prism.central.vaadin.service.ConfigurationService;
import com.neogls.prism.central.vaadin.service.UserPermissionService;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.list.PatrolActionListener;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.list.PatrolDetailsGeneratorService;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.list.impl.PatrolExportButton;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import gls.outils.ConstantesGLS;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import lombok.Generated;
import org.springframework.context.annotation.Primary;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Primary
public class CommonPatrolDetailsGeneratorService
implements PatrolDetailsGeneratorService {
    private final IBusinessService businessService;
    private final BusinessModuleService businessModuleService;
    private final ConfigurationService configurationService;
    private final UserPermissionService userPermissionService;
    private static final String FORM_LAYOUT_COLUMN_SPACING = "var(--lumo-space-s)";
    private static final int COLUMN_MIN_WIDTH = 16;
    private static final Unit COLUMN_WIDTH_UNIT = Unit.EM;
    private static final int MAX_COLUMNS = 5;
    private static final List<FormLayout.ResponsiveStep> RESPONSIVE_STEPS = IntStream.range(0, 5).mapToObj(i -> new FormLayout.ResponsiveStep(i * 16 + COLUMN_WIDTH_UNIT.getSymbol(), i + 1)).toList();

    public Component createPatrolDetails(VehiculeEnIntervention patrol, Collection<Integer> businessModuleCodes, PatrolActionListener patrolActionListener) {
        VerticalLayout details = new VerticalLayout(new Component[]{this.getActionButtons(patrol, businessModuleCodes, patrolActionListener), this.getDetailsTextComponent(patrol)});
        details.setSpacing(false);
        details.setPadding(false);
        return details;
    }

    private Component getActionButtons(VehiculeEnIntervention patrol, Collection<Integer> businessModuleCodes, PatrolActionListener patrolActionListener) {
        FormLayout layout = new FormLayout();
        layout.getStyle().set("--vaadin-form-layout-column-spacing", "var(--lumo-space-s)");
        layout.setResponsiveSteps(RESPONSIVE_STEPS);
        if (this.configurationService.getBoolean(ConfigurationService.ConfigurationType.DATABASE, "vh.afficherDonneesSaleuse").orElse(true).booleanValue()) {
            layout.add(new Component[]{this.createButton(CommonPatrolDetailsGeneratorService.getTranslation((Object)"mct.action.view.donnees", (Object[])new Object[0]), (ComponentEventListener & Serializable)e -> patrolActionListener.showSaltSpreaderData(patrol, businessModuleCodes))});
        }
        this.configurePatrolExportButton(patrol, layout);
        if (this.configurationService.isPatrolVisaActive() && this.userPermissionService.canVisaPatrols() && this.configurationService.isPatrolVisaActiveForBusinessModule(patrol.getModuleMetier()) && !patrol.estVisee() && patrol.getFinPatrouille() != -1L) {
            layout.add(new Component[]{this.createButton(CommonPatrolDetailsGeneratorService.getTranslation((Object)"mct.patrouille.viser.bouton", (Object[])new Object[0]), (ComponentEventListener & Serializable)e -> patrolActionListener.visaPatrol(patrol))});
        }
        if (this.userPermissionService.canDo(315)) {
            layout.add(new Component[]{this.createButton("Point d'appel", (ComponentEventListener & Serializable)e -> patrolActionListener.callPoint(patrol))});
        }
        if (this.userPermissionService.canDo(316)) {
            layout.add(new Component[]{this.createButton("Fiche de synth\u00e8se", (ComponentEventListener & Serializable)e -> patrolActionListener.summarySheet(patrol))});
        }
        layout.add(new Component[]{this.createButton("D\u00e9tail", (ComponentEventListener & Serializable)e -> patrolActionListener.showDetails(patrol, businessModuleCodes))});
        return layout;
    }

    private void configurePatrolExportButton(VehiculeEnIntervention patrol, FormLayout layout) {
        if (patrol.getModuleMetier() != 8) {
            if (this.configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "synthese.patrouille.design").filter(Predicate.not(String::isBlank)).isPresent() && (patrol.getModuleMetier() == 1 || patrol.getModuleMetier() == 1000 || patrol.getModuleMetier() == 101)) {
                layout.add(new Component[]{new PatrolExportButton(patrol, "patrouille")});
            } else if (this.configurationService.getString(ConfigurationService.ConfigurationType.PROPERTY, "synthese.tournee.design").filter(Predicate.not(String::isBlank)).isPresent()) {
                layout.add(new Component[]{new PatrolExportButton(patrol, "tournee")});
            }
        }
    }

    private Button createButton(String text, @Nullable ComponentEventListener<ClickEvent<Button>> clickListener) {
        Button button = new Button(text);
        if (clickListener != null) {
            button.addClickListener(clickListener);
        }
        button.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_SMALL});
        button.addClassName("text-2xs");
        return button;
    }

    private Component getDetailsTextComponent(VehiculeEnIntervention patrol) {
        FlexLayout layout = new FlexLayout();
        layout.setFlexDirection(FlexLayout.FlexDirection.COLUMN);
        if (!ConstantesGLS.estVide((String)patrol.getTelephone())) {
            layout.add(new Component[]{this.createLabel("vehicule.tel", (Object)patrol.getTelephone())});
        }
        if (!ConstantesGLS.estVide((String)patrol.getImmatriculation())) {
            layout.add(new Component[]{this.createLabel("vehicule.immat", (Object)patrol.getImmatriculation())});
        }
        if (!ConstantesGLS.estVide((String)patrol.getNomMarque())) {
            layout.add(new Component[]{this.createLabel("vehicule.type", (Object)patrol.getNomMarque())});
        }
        if (patrol.getDelegation() != null) {
            layout.add(new Component[]{this.createLabel("global.delegation", (Object)patrol.getDelegation())});
        }
        if (patrol.getCentre() != null) {
            layout.add(new Component[]{this.createLabel("global.centre", (Object)patrol.getCentre())});
        }
        if (patrol.getAltitude() != 0.0) {
            layout.add(new Component[]{this.createLabel("vehicule.altitude", (Object)(patrol.getAltitude() + "m"))});
        }
        if (this.businessModuleService.isInheritedModule(patrol.getModuleMetier(), 1000) || this.businessModuleService.isInheritedModule(patrol.getModuleMetier(), 1)) {
            this.addVhEshTexts(layout, patrol);
        }
        layout.add(new Component[]{this.createLabel("vehicule.modulemetier", (Object)((ModuleMetier)this.businessService.getModulesMetiers().get(patrol.getModuleMetier())).getLibelle())});
        layout.add(new Component[]{this.createLabel("vehicule.etat", (Object)CommonPatrolDetailsGeneratorService.getTranslation((Object)("vehicule.etat." + patrol.getEtat()), (Object[])new Object[0]))});
        if (!"".equals(this.configurationService.getString(ConfigurationService.ConfigurationType.DATABASE, "publication.waze.polyline.vitesse").orElse(""))) {
            if (patrol.isWazeFluxIncidents() || patrol.isWazeFluxESH()) {
                layout.add(new Component[]{this.createLabel("vehicule.fluxWazeIncidents", (Object)CommonPatrolDetailsGeneratorService.getTranslation((Object)"publication.oui", (Object[])new Object[0]))});
            } else {
                layout.add(new Component[]{this.createLabel("vehicule.fluxWazeIncidents", (Object)CommonPatrolDetailsGeneratorService.getTranslation((Object)"publication.non", (Object[])new Object[0]))});
            }
        }
        return layout;
    }

    private void addVhEshTexts(FlexLayout layout, VehiculeEnIntervention patrol) {
        if (patrol.getDebitSel() != -1000) {
            layout.add(new Component[]{this.createLabel("vehicule.debitsel", (Object)CommonPatrolDetailsGeneratorService.getDebitSel((int)patrol.getDebitSel()))});
        }
        if (patrol.getDebitSaumure() != -1000) {
            layout.add(new Component[]{this.createLabel("vehicule.debitsaumure", (Object)patrol.getDebitSaumure())});
        }
        if (patrol.getEmbrayageSaleuse() != -1000.0) {
            layout.add(new Component[]{this.createLabel("vehicule.embsal", (Object)patrol.getEmbrayageSaleuse())});
        }
        if (patrol.getEmbrayageSaumure() != -1000.0) {
            layout.add(new Component[]{this.createLabel("vehicule.embsau", (Object)patrol.getEmbrayageSaumure())});
        }
        if (patrol.getLargeurTravail() != -1000.0) {
            layout.add(new Component[]{this.createLabel("vehicule.largeurtravail", (Object)patrol.getLargeurTravail())});
        }
        if (patrol.getVitesse() != -1000) {
            layout.add(new Component[]{this.createLabel("vehicule.vitesse", (Object)patrol.getVitesse())});
        }
        if (patrol.getKmParcouru() != -1000.0) {
            layout.add(new Component[]{this.createLabel("vehicule.kmparcouru", (Object)patrol.getKmParcouru())});
        }
        if (patrol.getKmSale() != -1000.0) {
            layout.add(new Component[]{this.createLabel("vehicule.kmsale", (Object)patrol.getKmSale())});
        }
        if ((float)patrol.getLameBaissee() != -1000.0f) {
            layout.add(new Component[]{this.createLabel("vehicule.lamebaisse", (Object)(patrol.getLameBaissee() == 0 ? CommonPatrolDetailsGeneratorService.getTranslation((Object)"vehicule.lamebaisse.non", (Object[])new Object[0]) : CommonPatrolDetailsGeneratorService.getTranslation((Object)"vehicule.lamebaisse.oui", (Object[])new Object[0])))});
        }
        if (patrol.getTemperatureSol() != -1000.0) {
            layout.add(new Component[]{this.createLabel("vehicule.tsol", (Object)("" + patrol.getTemperatureSol()))});
        }
        if (patrol.getTemperatureAir() != -1000.0) {
            layout.add(new Component[]{this.createLabel("vehicule.tair", (Object)("" + patrol.getTemperatureAir()))});
        }
        if (patrol.getTemperatureRose() != -1000.0) {
            layout.add(new Component[]{this.createLabel("vehicule.trose", (Object)("" + patrol.getTemperatureRose()))});
        }
        if (patrol.getHumiditeAir() != -1000.0) {
            layout.add(new Component[]{this.createLabel("vehicule.hair", (Object)("" + patrol.getHumiditeAir()))});
        }
    }

    private Span createLabel(String labelI18nName, Object value) {
        return this.createLine(CommonPatrolDetailsGeneratorService.getTranslation((Object)labelI18nName, (Object[])new Object[0]) + " : " + value.toString());
    }

    private Span createLine(String text) {
        Span line = new Span(text);
        line.addClassNames(new String[]{"whitespace-normal", "text-xs"});
        return line;
    }

    private static String getDebitSel(int debitSel) {
        switch (debitSel) {
            case -1000: {
                return "NC";
            }
            case 0: {
                return CommonPatrolDetailsGeneratorService.getTranslation((Object)"vehicule.salagemanuel.non", (Object[])new Object[0]);
            }
            case 1000: {
                return CommonPatrolDetailsGeneratorService.getTranslation((Object)"vehicule.salagemanuel.oui", (Object[])new Object[0]);
            }
        }
        return String.valueOf(debitSel);
    }

    private static String getTranslation(Object key, Object ... params) {
        return UI.getCurrent().getTranslation(key, params);
    }

    @Generated
    public CommonPatrolDetailsGeneratorService(IBusinessService businessService, BusinessModuleService businessModuleService, ConfigurationService configurationService, UserPermissionService userPermissionService) {
        this.businessService = businessService;
        this.businessModuleService = businessModuleService;
        this.configurationService = configurationService;
        this.userPermissionService = userPermissionService;
    }
}

