/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.patrol.list.impl;

import com.geolocsystems.prismcentral.beans.VehiculeEnIntervention;
import com.neogls.prism.central.vaadin.common.component.confirmdialog.ButtonConfig;
import com.neogls.prism.central.vaadin.common.component.confirmdialog.ConfirmDialog;
import com.neogls.prism.central.vaadin.service.ConfigurationService;
import com.neogls.prism.central.vaadin.service.PatrolService;
import com.neogls.prism.central.vaadin.view.mct.common.carto.layer.PatrolTracksLayer;
import com.neogls.prism.central.vaadin.view.mct.common.list.AbstractActionListener;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.PatrolDetailsDialog;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.PatrolDetailsDialogService;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.SaltSpreaderDataDialog;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.list.PatrolActionListener;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.visaconfirmdialog.VisaConfirmDialog;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.visaconfirmdialog.VisaConfirmDialogService;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.notification.NotificationVariant;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.server.VaadinSession;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.Collection;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@Primary
@Scope(value="prototype")
public class CommonPatrolActionListener
extends AbstractActionListener<VehiculeEnIntervention>
implements PatrolActionListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CommonPatrolActionListener.class);
    private final PatrolService patrolService;
    private final PatrolDetailsDialogService patrolDetailsDialogService;
    private final ConfigurationService configurationService;
    private final VisaConfirmDialogService visaConfirmDialogService;
    @Nullable
    private PatrolTracksLayer patrolTracksLayer = null;

    public void showSaltSpreaderData(VehiculeEnIntervention patrol, Collection<Integer> businessModuleCodes) {
        new SaltSpreaderDataDialog(patrol.getIdPatrouille(), businessModuleCodes, (Collection)this.patrolService.getSaltSpreaderLocationData(patrol.getIdPatrouille(), VaadinSession.getCurrent().getLocale())).open();
    }

    public void visaPatrol(VehiculeEnIntervention patrol) {
        if (this.configurationService.getString(ConfigurationService.ConfigurationType.DATABASE, "mct.patrouille.visa.mode").map("fiche"::equalsIgnoreCase).orElse(false).booleanValue()) {
            VisaConfirmDialog visaDialog = new VisaConfirmDialog(this.visaConfirmDialogService, patrol);
            visaDialog.addOpenedChangeListener((ComponentEventListener & Serializable)event -> {
                if (!event.isOpened()) {
                    this.refreshAll();
                }
            });
            visaDialog.open();
        } else {
            ConfirmDialog.builder().title(CommonPatrolActionListener.getTranslation((Object)"Global.Confirmation", (Object[])new Object[0])).text(CommonPatrolActionListener.getTranslation((Object)"mct.patrouille.viser.bouton.confirmer", (Object[])new Object[0])).confirm(ButtonConfig.builder().text(CommonPatrolActionListener.getTranslation((Object)"Global.Yes", (Object[])new Object[0])).listener((ComponentEventListener & Serializable)event -> {
                if (this.patrolService.visaPatrol(patrol)) {
                    Notification.show((String)"Patrouille vis\u00e9e").addThemeVariants((ThemeVariant[])new NotificationVariant[]{NotificationVariant.LUMO_SUCCESS});
                    this.refreshAll();
                } else {
                    Notification.show((String)"Erreur sur la vis\u00e9e de la patrouille !").addThemeVariants((ThemeVariant[])new NotificationVariant[]{NotificationVariant.LUMO_ERROR});
                }
            }).build()).cancel(ButtonConfig.builder().text(CommonPatrolActionListener.getTranslation((Object)"Global.No", (Object[])new Object[0])).build()).build().open();
        }
    }

    public void callPoint(VehiculeEnIntervention patrol) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void summarySheet(VehiculeEnIntervention patrol) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void showDetails(VehiculeEnIntervention patrol, Collection<Integer> businessModuleCodes) {
        new PatrolDetailsDialog(patrol, businessModuleCodes, this.patrolDetailsDialogService).open();
    }

    public void showFocusedPatrolTracks(@Nullable VehiculeEnIntervention patrol) {
        if (this.patrolTracksLayer == null) {
            log.warn("No patrol tracks layer configured, can't show focused patrol tracks");
            return;
        }
        this.patrolTracksLayer.setFocusedPatrol(patrol);
    }

    public void showSelectedPatrolsTracks(@Nonnull Collection<VehiculeEnIntervention> patrols) {
        if (this.patrolTracksLayer == null) {
            log.warn("No patrol tracks layer configured, can't show selected patrol tracks");
            return;
        }
        this.patrolTracksLayer.setSelectedPatrols(patrols);
    }

    public void setPatrolTracksLayer(@Nonnull PatrolTracksLayer patrolTracksLayer) {
        this.patrolTracksLayer = patrolTracksLayer;
    }

    private static String getTranslation(Object key, Object ... params) {
        return UI.getCurrent().getTranslation(key, params);
    }

    @Generated
    public CommonPatrolActionListener(PatrolService patrolService, PatrolDetailsDialogService patrolDetailsDialogService, ConfigurationService configurationService, VisaConfirmDialogService visaConfirmDialogService) {
        this.patrolService = patrolService;
        this.patrolDetailsDialogService = patrolDetailsDialogService;
        this.configurationService = configurationService;
        this.visaConfirmDialogService = visaConfirmDialogService;
    }
}

